/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.objects.sll;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cpa.smg.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionCandidate;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionFinder;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.objects.sll.SMGSingleLinkedListCandidate;

public class SMGSingleLinkedListFinder
implements SMGAbstractionFinder {
    private CLangSMG smg;
    private Map<SMGObject, Map<Integer, SMGSingleLinkedListCandidate>> candidates = new HashMap<SMGObject, Map<Integer, SMGSingleLinkedListCandidate>>();
    private Map<Integer, Integer> inboundPointers = new HashMap<Integer, Integer>();
    private final int seqLengthThreshold;

    public SMGSingleLinkedListFinder() {
        this.seqLengthThreshold = 10;
    }

    public SMGSingleLinkedListFinder(int pSeqLengthThreshold) {
        this.seqLengthThreshold = pSeqLengthThreshold;
    }

    @Override
    public Set<SMGAbstractionCandidate> traverse(CLangSMG pSmg) {
        this.smg = pSmg;
        this.buildInboundPointers();
        for (SMGObject object : this.smg.getHeapObjects()) {
            this.startTraversal(object);
        }
        HashSet<SMGSingleLinkedListCandidate> returnSet = new HashSet<SMGSingleLinkedListCandidate>();
        for (Map<Integer, SMGSingleLinkedListCandidate> objCandidates : this.candidates.values()) {
            for (SMGSingleLinkedListCandidate candidate : objCandidates.values()) {
                if (candidate.getLength() <= this.seqLengthThreshold) continue;
                returnSet.add(candidate);
            }
        }
        return Collections.unmodifiableSet(returnSet);
    }

    private void buildInboundPointers() {
        for (Integer pointer : this.smg.getPTEdges().keySet()) {
            this.inboundPointers.put(pointer, this.smg.getHVEdges(new SMGEdgeHasValueFilter().filterHavingValue(pointer)).size());
        }
    }

    private void startTraversal(SMGObject pObject) {
        if (this.candidates.containsKey(pObject)) {
            return;
        }
        this.candidates.put(pObject, new HashMap());
        for (SMGEdgeHasValue hv : this.smg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObject))) {
            if (!this.smg.isPointer(hv.getValue())) continue;
            SMGSingleLinkedListCandidate candidate = new SMGSingleLinkedListCandidate(pObject, hv.getOffset(), 1);
            this.candidates.get(pObject).put(hv.getOffset(), candidate);
            this.continueTraversal(hv.getValue(), candidate);
        }
    }

    private void continueTraversal(int pValue, SMGSingleLinkedListCandidate pCandidate) {
        SMGSingleLinkedListCandidate myCandidate;
        Integer offset;
        SMGEdgePointsTo pt = this.smg.getPointer(pValue);
        SMGObject object = pt.getObject();
        if (!this.candidates.containsKey(object)) {
            this.startTraversal(object);
        }
        if (this.inboundPointers.get(pValue) > 1) {
            return;
        }
        Map<Integer, SMGSingleLinkedListCandidate> objectCandidates = this.candidates.get(object);
        if (!objectCandidates.containsKey(offset = Integer.valueOf(pCandidate.getOffset())) && this.smg.isCoveredByNullifiedBlocks(object, offset, CPointerType.POINTER_TO_VOID)) {
            objectCandidates.put(offset, new SMGSingleLinkedListCandidate(object, offset, 1));
        }
        if (objectCandidates.containsKey(offset) && pCandidate.isCompatibleWith(myCandidate = objectCandidates.get(offset))) {
            objectCandidates.remove(offset);
            pCandidate.addLength(myCandidate.getLength());
        }
    }
}

