/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smgfork;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cpa.smgfork.AnonymousTypes;
import org.sosy_lab.cpachecker.cpa.smgfork.CLangStackFrame;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGRegion;

public class CLangStackFrameTest {
    private static final CFunctionType functionType = AnonymousTypes.createSimpleFunctionType(AnonymousTypes.dummyInt);
    private static final CFunctionDeclaration functionDeclaration = new CFunctionDeclaration(FileLocation.DUMMY, functionType, "foo", (List<CParameterDeclaration>)ImmutableList.of());
    private static final MachineModel usedMachineModel = MachineModel.LINUX64;
    private CLangStackFrame sf;

    @Before
    public void setUp() throws Exception {
        this.sf = new CLangStackFrame(functionDeclaration, usedMachineModel);
    }

    @Test
    public void CLangStackFrameConstructorTest() {
        Map<String, SMGRegion> variables = this.sf.getVariables();
        Assert.assertEquals((String)"CLangStackFrame contains no variables after creation", (long)variables.size(), (long)0L);
        Assert.assertFalse((boolean)this.sf.containsVariable("foo"));
        CLangStackFrame sf_copy = new CLangStackFrame(this.sf);
        variables = sf_copy.getVariables();
        Assert.assertEquals((String)"Empty CLangStackFrame contains no variables after copying", (long)variables.size(), (long)0L);
        Assert.assertFalse((boolean)sf_copy.containsVariable("foo"));
    }

    @Test
    public void CLangStackFrameAddVariableTest() {
        this.sf.addStackVariable("fooVar", new SMGRegion(8, "fooVarObject"));
        Assert.assertTrue((String)"Added variable is present", (boolean)this.sf.containsVariable("fooVar"));
        Map<String, SMGRegion> variables = this.sf.getVariables();
        Assert.assertEquals((String)"Variables set is nonempty after variable addition", (long)variables.size(), (long)1L);
        SMGObject smg_object = variables.get("fooVar");
        Assert.assertEquals((String)"Added variable present in variable map", (Object)smg_object.getLabel(), (Object)"fooVarObject");
        Assert.assertEquals((String)"Added variable present in variable map", (long)smg_object.getSize(), (long)8L);
        smg_object = null;
        smg_object = this.sf.getVariable("fooVar");
        Assert.assertEquals((String)"Correct variable is returned: label", (Object)smg_object.getLabel(), (Object)"fooVarObject");
        Assert.assertEquals((String)"Correct variable is returned: size", (long)smg_object.getSize(), (long)8L);
    }

    @Test
    public void CLangFrameGetObjectsTest() {
        Set<SMGObject> objects = this.sf.getAllObjects();
        Assert.assertEquals((long)1L, (long)objects.size());
        this.sf.addStackVariable("fooVar", new SMGRegion(8, "fooVarObject"));
        objects = this.sf.getAllObjects();
        Assert.assertEquals((long)2L, (long)objects.size());
    }

    @Test
    public void CLangFrameReturnValueTest() {
        SMGRegion retval = this.sf.getReturnObject();
        Assert.assertEquals((long)usedMachineModel.getSizeof(AnonymousTypes.dummyInt), (long)retval.getSize());
    }

    @Test(expected=IllegalArgumentException.class)
    public void CLangStackFrameAddVariableTwiceTest() {
        this.sf.addStackVariable("fooVar", new SMGRegion(8, "fooVarObject"));
        this.sf.addStackVariable("fooVar", new SMGRegion(16, "newFooVarObject"));
    }

    @Test(expected=NoSuchElementException.class)
    public void CLangStackFrameMissingVariableTest() {
        Assert.assertFalse((String)"Non-added variable is not present", (boolean)this.sf.containsVariable("fooVaz"));
        SMGRegion smg_object = this.sf.getVariable("fooVaz");
        smg_object.getLabel();
    }

    @Test
    public void CLangStackFrameFunctionTest() {
        CFunctionDeclaration fd = this.sf.getFunctionDeclaration();
        Assert.assertNotNull((Object)fd);
        Assert.assertEquals((String)"Correct function is returned", (Object)"foo", (Object)fd.getName());
    }
}

