/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smgfork;

import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smgfork.AnonymousTypes;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGEdge;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGObject;

public class SMGEdgeHasValue
extends SMGEdge {
    private final CType type;
    private final int offset;

    public SMGEdgeHasValue(CType pType, int pOffset, SMGObject pObject, int pValue) {
        super(pValue, pObject);
        this.type = pType;
        this.offset = pOffset;
    }

    public SMGEdgeHasValue(int pSizeInBytes, int pOffset, SMGObject pObject, int pValue) {
        super(pValue, pObject);
        this.type = AnonymousTypes.createTypeWithLength(pSizeInBytes);
        this.offset = pOffset;
    }

    public String toString() {
        return "sizeof(" + this.type.toASTString("foo") + ")b @ " + this.object.getLabel() + "+" + this.offset + "b has value " + this.value;
    }

    public int getOffset() {
        return this.offset;
    }

    public CType getType() {
        return this.type;
    }

    public int getSizeInBytes(MachineModel pMachineModel) {
        return pMachineModel.getSizeof(this.type);
    }

    @Override
    public boolean isConsistentWith(SMGEdge other) {
        if (!(other instanceof SMGEdgeHasValue)) {
            return false;
        }
        if (this.object == other.object && this.offset == ((SMGEdgeHasValue)other).offset && this.type == ((SMGEdgeHasValue)other).type) {
            return this.value == other.value;
        }
        return true;
    }

    public boolean overlapsWith(SMGEdgeHasValue other, MachineModel pModel) {
        if (this.object != other.object) {
            throw new IllegalArgumentException("Call of overlapsWith() on Has-Value edges pair not originating from the same object");
        }
        int otStart = other.getOffset();
        int otEnd = otStart + pModel.getSizeof(other.getType());
        return this.overlapsWith(otStart, otEnd, pModel);
    }

    public boolean overlapsWith(int pOtStart, int pOtEnd, MachineModel pModel) {
        int myStart = this.offset;
        int myEnd = myStart + pModel.getSizeof(this.type);
        if (myStart < pOtStart) {
            return myEnd > pOtStart;
        }
        if (pOtStart < myStart) {
            return pOtEnd > myStart;
        }
        return true;
    }

    public boolean isCompatibleField(SMGEdgeHasValue other, MachineModel pModel) {
        return this.type.equals(other.type) && this.offset == other.offset;
    }

    public boolean isCompatibleFieldOnSameObject(SMGEdgeHasValue other, MachineModel pModel) {
        return pModel.getSizeof(this.type) == pModel.getSizeof(other.type) && this.offset == other.offset && this.object == other.object;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.offset;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SMGEdgeHasValue other = (SMGEdgeHasValue)obj;
        if (this.offset != other.offset) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.getCanonicalType().equals(other.type.getCanonicalType()));
    }
}

