/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smgfork;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JIdExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGState;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGTransferRelation;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGValueFactory;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.value.AbstractExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;

public class SMGExpressionEvaluator {
    private final LogManagerWithoutDuplicates logger;
    private final MachineModel machineModel;

    public SMGExpressionEvaluator(LogManagerWithoutDuplicates pLogger, MachineModel pMachineModel) {
        this.logger = pLogger;
        this.machineModel = pMachineModel;
    }

    public int getSizeof(CFAEdge edge, CType pType) throws UnrecognizedCCodeException {
        try {
            return this.machineModel.getSizeof(pType);
        }
        catch (IllegalArgumentException e) {
            this.logger.logDebugException((Throwable)e);
            throw new UnrecognizedCCodeException("Could not resolve type.", edge);
        }
    }

    private SMGTransferRelation.SMGAddress getAddressOfField(SMGState smgState, CFAEdge cfaEdge, CFieldReference fieldReference) throws CPATransferException {
        CExpression fieldOwner = fieldReference.getFieldOwner();
        CType ownerType = this.getRealExpressionType(fieldOwner);
        SMGTransferRelation.SMGAddressValue fieldOwnerAddress = this.evaluateAddress(smgState, cfaEdge, fieldOwner);
        if (fieldOwnerAddress.isUnknown()) {
            return SMGTransferRelation.SMGAddress.UNKNOWN;
        }
        String fieldName = fieldReference.getFieldName();
        SMGTransferRelation.SMGField field = this.getField(cfaEdge, ownerType, fieldName);
        if (field.isUnknown()) {
            return SMGTransferRelation.SMGAddress.UNKNOWN;
        }
        SMGTransferRelation.SMGAddress addressOfFieldOwner = fieldOwnerAddress.getAddress();
        SMGTransferRelation.SMGExplicitValue fieldOffset = addressOfFieldOwner.add(field.getOffset()).getOffset();
        SMGObject fieldObject = addressOfFieldOwner.getObject();
        return SMGTransferRelation.SMGAddress.valueOf(fieldObject, fieldOffset);
    }

    public SMGTransferRelation.SMGSymbolicValue readValue(SMGState pSmgState, SMGObject pObject, SMGTransferRelation.SMGExplicitValue pOffset, CType pType, CFAEdge pEdge) throws SMGInconsistentException, UnrecognizedCCodeException {
        boolean doesNotFitIntoObject;
        if (pOffset.isUnknown() || pObject == null) {
            return SMGTransferRelation.SMGUnknownValue.getInstance();
        }
        int fieldOffset = pOffset.getAsInt();
        boolean bl = doesNotFitIntoObject = fieldOffset < 0 || fieldOffset + this.getSizeof(pEdge, pType) > pObject.getSize();
        if (doesNotFitIntoObject) {
            this.logger.log(Level.WARNING, new Object[]{pEdge.getFileLocation() + ":", "Field (" + fieldOffset + ", " + pType.toASTString("") + ")" + " does not fit object " + pObject.toString() + "."});
            pSmgState.setInvalidRead();
            return SMGTransferRelation.SMGUnknownValue.getInstance();
        }
        Integer value = pSmgState.readValue(pObject, fieldOffset, pType);
        if (value == null) {
            return SMGTransferRelation.SMGUnknownValue.getInstance();
        }
        return SMGTransferRelation.SMGKnownSymValue.valueOf(value);
    }

    private SMGTransferRelation.SMGField getField(CFAEdge edge, CType ownerType, String fieldName) throws UnrecognizedCCodeException {
        if (ownerType instanceof CElaboratedType) {
            CComplexType realType = ((CElaboratedType)ownerType).getRealType();
            if (realType == null) {
                return SMGTransferRelation.SMGField.getUnknownInstance();
            }
            return this.getField(edge, realType, fieldName);
        }
        if (ownerType instanceof CCompositeType) {
            return this.getField(edge, (CCompositeType)ownerType, fieldName);
        }
        if (ownerType instanceof CPointerType) {
            CType type = ((CPointerType)ownerType).getType();
            type = this.getRealExpressionType(type);
            return this.getField(edge, type, fieldName);
        }
        throw new AssertionError();
    }

    private SMGTransferRelation.SMGField getField(CFAEdge pEdge, CCompositeType ownerType, String fieldName) throws UnrecognizedCCodeException {
        List<CCompositeType.CCompositeTypeMemberDeclaration> membersOfType = ownerType.getMembers();
        int offset = 0;
        for (CCompositeType.CCompositeTypeMemberDeclaration typeMember : membersOfType) {
            String memberName = typeMember.getName();
            if (memberName.equals(fieldName)) {
                return new SMGTransferRelation.SMGField(SMGTransferRelation.SMGKnownExpValue.valueOf(offset), this.getRealExpressionType(typeMember.getType()));
            }
            if (ownerType.getKind() == CComplexType.ComplexTypeKind.UNION) continue;
            offset += this.getSizeof(pEdge, this.getRealExpressionType(typeMember.getType()));
        }
        return new SMGTransferRelation.SMGField(SMGTransferRelation.SMGUnknownValue.getInstance(), ownerType);
    }

    boolean isStructOrUnionType(CType rValueType) {
        if (rValueType instanceof CElaboratedType) {
            CElaboratedType type = (CElaboratedType)rValueType;
            return type.getKind() != CComplexType.ComplexTypeKind.ENUM;
        }
        if (rValueType instanceof CCompositeType) {
            CCompositeType type = (CCompositeType)rValueType;
            return type.getKind() != CComplexType.ComplexTypeKind.ENUM;
        }
        return false;
    }

    public SMGTransferRelation.SMGExplicitValue evaluateExplicitValue(SMGState smgState, CFAEdge cfaEdge, CRightHandSide rValue) throws CPATransferException {
        ExplicitValueVisitor visitor = new ExplicitValueVisitor(smgState, null, this.machineModel, this.logger, cfaEdge);
        Value value = rValue.accept(visitor);
        if (!value.isExplicitlyKnown() || !value.isNumericValue()) {
            SMGTransferRelation.SMGSymbolicValue symbolicValue = this.evaluateExpressionValue(smgState, cfaEdge, rValue);
            if (!symbolicValue.isUnknown()) {
                SMGTransferRelation.SMGAddressValue address;
                if (symbolicValue == SMGTransferRelation.SMGKnownSymValue.ZERO) {
                    return SMGTransferRelation.SMGKnownExpValue.ZERO;
                }
                if (symbolicValue instanceof SMGTransferRelation.SMGAddressValue && (address = (SMGTransferRelation.SMGAddressValue)symbolicValue).getObject() == SMGObject.getNullObject()) {
                    return SMGTransferRelation.SMGKnownExpValue.valueOf(address.getOffset().getAsLong());
                }
            }
            return SMGTransferRelation.SMGUnknownValue.getInstance();
        }
        Long longValue = value.asNumericValue().longValue();
        if (longValue != null) {
            return SMGTransferRelation.SMGKnownExpValue.valueOf(longValue);
        }
        return SMGTransferRelation.SMGUnknownValue.getInstance();
    }

    public SMGTransferRelation.SMGSymbolicValue evaluateExpressionValue(SMGState smgState, CFAEdge cfaEdge, CRightHandSide rValue) throws CPATransferException {
        CType expressionType = this.getRealExpressionType(rValue);
        if (expressionType instanceof CPointerType || expressionType instanceof CArrayType || this.isStructOrUnionType(expressionType)) {
            return this.evaluateAddress(smgState, cfaEdge, rValue);
        }
        return this.evaluateNonAddressValue(smgState, cfaEdge, rValue);
    }

    private SMGTransferRelation.SMGSymbolicValue evaluateNonAddressValue(SMGState newState, CFAEdge cfaEdge, CRightHandSide rValue) throws CPATransferException {
        ExpressionValueVisitor visitor = this.getExpressionValueVisitor(cfaEdge, newState);
        SMGTransferRelation.SMGSymbolicValue symbolicValue = rValue.accept(visitor);
        return symbolicValue;
    }

    public SMGTransferRelation.SMGSymbolicValue evaluateAssumptionValue(SMGState newState, CFAEdge cfaEdge, CExpression rValue) throws CPATransferException {
        AssumeVisitor visitor = this.getAssumeVisitor(cfaEdge, newState);
        return rValue.accept(visitor);
    }

    public SMGTransferRelation.SMGAddressValue evaluateAddress(SMGState newState, CFAEdge cfaEdge, CRightHandSide rValue) throws CPATransferException {
        CType expressionType = this.getRealExpressionType(rValue);
        if (expressionType instanceof CPointerType) {
            PointerVisitor visitor = this.getPointerVisitor(cfaEdge, newState);
            SMGTransferRelation.SMGSymbolicValue address = rValue.accept(visitor);
            return this.getAddressFromSymbolicValue(newState, address);
        }
        if (this.isStructOrUnionType(expressionType)) {
            StructAndUnionVisitor visitor = this.getStructAndUnionVisitor(cfaEdge, newState);
            SMGTransferRelation.SMGAddress structAddress = rValue.accept(visitor);
            return this.createAddress(newState, structAddress);
        }
        if (expressionType instanceof CArrayType) {
            ArrayVisitor visitor = this.getArrayVisitor(cfaEdge, newState);
            SMGTransferRelation.SMGAddress arrayAddress = rValue.accept(visitor);
            return this.createAddress(newState, arrayAddress);
        }
        throw new AssertionError((Object)("The method evaluateAddress may not be calledwith the type " + expressionType.toASTString("")));
    }

    public CType getRealExpressionType(CType type) {
        while (type instanceof CTypedefType) {
            type = ((CTypedefType)type).getRealType();
        }
        return type;
    }

    public CType getRealExpressionType(CSimpleDeclaration decl) {
        return this.getRealExpressionType(decl.getType());
    }

    public CType getRealExpressionType(CRightHandSide exp) {
        return this.getRealExpressionType(exp.getExpressionType());
    }

    private SMGTransferRelation.SMGAddressValue handlePointerArithmetic(SMGState smgState, CFAEdge cfaEdge, CExpression address, CExpression pointerOffset, CType typeOfPointer, boolean lVarIsAddress, CBinaryExpression binaryExp) throws CPATransferException {
        CBinaryExpression.BinaryOperator binaryOperator = binaryExp.getOperator();
        switch (binaryOperator) {
            case PLUS: 
            case MINUS: {
                SMGTransferRelation.SMGAddressValue addressValue = this.evaluateAddress(smgState, cfaEdge, address);
                SMGTransferRelation.SMGExplicitValue offsetValue = this.evaluateExplicitValue(smgState, cfaEdge, pointerOffset);
                if (addressValue.isUnknown() || offsetValue.isUnknown()) {
                    return SMGTransferRelation.SMGUnknownValue.getInstance();
                }
                SMGTransferRelation.SMGKnownExpValue typeSize = SMGTransferRelation.SMGKnownExpValue.valueOf(this.getSizeof(cfaEdge, typeOfPointer));
                SMGTransferRelation.SMGExplicitValue pointerOffsetValue = offsetValue.multiply(typeSize);
                SMGObject target = addressValue.getObject();
                SMGTransferRelation.SMGExplicitValue addressOffset = addressValue.getOffset();
                switch (binaryOperator) {
                    case PLUS: {
                        return this.createAddress(smgState, target, addressOffset.add(pointerOffsetValue));
                    }
                    case MINUS: {
                        if (lVarIsAddress) {
                            return this.createAddress(smgState, target, addressOffset.subtract(pointerOffsetValue));
                        }
                        throw new UnrecognizedCCodeException("Expected pointer arithmetic  with + or - but found " + binaryExp.toASTString(), binaryExp);
                    }
                }
                throw new AssertionError();
            }
            case EQUALS: 
            case NOT_EQUALS: 
            case GREATER_THAN: 
            case GREATER_EQUAL: 
            case LESS_THAN: 
            case LESS_EQUAL: {
                throw new UnrecognizedCCodeException("Misinterpreted the expression type of " + binaryExp + " as pointer type", cfaEdge, binaryExp);
            }
            case DIVIDE: 
            case MULTIPLY: 
            case MODULO: 
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: 
            case BINARY_AND: 
            case BINARY_OR: 
            case BINARY_XOR: {
                throw new UnrecognizedCCodeException("The operands of binary Expression " + binaryExp.toASTString() + " must have arithmetic types. " + address.toASTString() + " has a non arithmetic type", cfaEdge, binaryExp);
            }
        }
        return SMGTransferRelation.SMGUnknownValue.getInstance();
    }

    private SMGTransferRelation.SMGAddress evaluateArraySubscriptAddress(SMGState smgState, CFAEdge cfaEdge, CArraySubscriptExpression exp) throws CPATransferException {
        SMGTransferRelation.SMGAddressValue arrayAddress = this.evaluateAddress(smgState, cfaEdge, exp.getArrayExpression());
        if (arrayAddress.isUnknown()) {
            return SMGTransferRelation.SMGAddress.UNKNOWN;
        }
        SMGTransferRelation.SMGExplicitValue subscriptValue = this.evaluateExplicitValue(smgState, cfaEdge, exp.getSubscriptExpression());
        if (subscriptValue.isUnknown()) {
            return SMGTransferRelation.SMGAddress.UNKNOWN;
        }
        SMGTransferRelation.SMGKnownExpValue typeSize = SMGTransferRelation.SMGKnownExpValue.valueOf(this.getSizeof(cfaEdge, exp.getExpressionType()));
        SMGTransferRelation.SMGExplicitValue subscriptOffset = subscriptValue.multiply(typeSize);
        return arrayAddress.getAddress().add(subscriptOffset);
    }

    SMGTransferRelation.SMGAddressValue createAddress(SMGEdgePointsTo pEdge) {
        if (pEdge == null) {
            return SMGTransferRelation.SMGUnknownValue.getInstance();
        }
        return SMGTransferRelation.SMGKnownAddVal.valueOf(pEdge.getValue(), pEdge.getObject(), pEdge.getOffset());
    }

    private SMGTransferRelation.SMGAddressValue createAddress(SMGState pNewState, SMGTransferRelation.SMGAddress pAddress) throws SMGInconsistentException {
        if (pAddress.isUnknown()) {
            return SMGTransferRelation.SMGUnknownValue.getInstance();
        }
        return this.createAddress(pNewState, pAddress.getObject(), pAddress.getOffset());
    }

    SMGTransferRelation.SMGAddressValue getAddressFromSymbolicValue(SMGState pSmgState, SMGTransferRelation.SMGSymbolicValue pAddressValue) throws SMGInconsistentException {
        if (pAddressValue instanceof SMGTransferRelation.SMGAddressValue) {
            return (SMGTransferRelation.SMGAddressValue)pAddressValue;
        }
        if (pAddressValue.isUnknown()) {
            return SMGTransferRelation.SMGUnknownValue.getInstance();
        }
        if (!pSmgState.isPointer(pAddressValue.getAsInt())) {
            return SMGTransferRelation.SMGUnknownValue.getInstance();
        }
        SMGEdgePointsTo edge = pSmgState.getPointerFromValue(pAddressValue.getAsInt());
        return this.createAddress(edge);
    }

    SMGTransferRelation.SMGAddressValue createAddress(SMGState pSmgState, SMGObject pTarget, SMGTransferRelation.SMGExplicitValue pOffset) throws SMGInconsistentException {
        SMGTransferRelation.SMGAddressValue addressValue = this.getAddress(pSmgState, pTarget, pOffset);
        if (addressValue.isUnknown()) {
            SMGTransferRelation.SMGKnownSymValue value = SMGTransferRelation.SMGKnownSymValue.valueOf(SMGValueFactory.getNewValue());
            addressValue = SMGTransferRelation.SMGKnownAddVal.valueOf(pTarget, (SMGTransferRelation.SMGKnownExpValue)pOffset, value);
        }
        return addressValue;
    }

    SMGTransferRelation.SMGAddressValue getAddress(SMGState pSmgState, SMGObject pTarget, SMGTransferRelation.SMGExplicitValue pOffset) throws SMGInconsistentException {
        if (pTarget == null || pOffset.isUnknown()) {
            return SMGTransferRelation.SMGUnknownValue.getInstance();
        }
        Integer address = pSmgState.getAddress(pTarget, pOffset.getAsInt());
        if (address == null) {
            return SMGTransferRelation.SMGUnknownValue.getInstance();
        }
        return this.createAddress(pSmgState.getPointerFromValue(address));
    }

    protected SMGTransferRelation.SMGSymbolicValue handleUnknownDereference(SMGState smgState, CFAEdge edge) {
        return SMGTransferRelation.SMGUnknownValue.getInstance();
    }

    protected StructAndUnionVisitor getStructAndUnionVisitor(CFAEdge pCfaEdge, SMGState pNewState) {
        return new StructAndUnionVisitor(pCfaEdge, pNewState);
    }

    protected ArrayVisitor getArrayVisitor(CFAEdge pCfaEdge, SMGState pSmgState) {
        return new ArrayVisitor(pCfaEdge, pSmgState);
    }

    protected PointerVisitor getPointerVisitor(CFAEdge pCfaEdge, SMGState pNewState) {
        return new PointerVisitor(pCfaEdge, pNewState);
    }

    protected AssumeVisitor getAssumeVisitor(CFAEdge pCfaEdge, SMGState pNewState) {
        return new AssumeVisitor(pCfaEdge, pNewState);
    }

    protected ExpressionValueVisitor getExpressionValueVisitor(CFAEdge pCfaEdge, SMGState pNewState) {
        return new ExpressionValueVisitor(pCfaEdge, pNewState);
    }

    public LValueAssignmentVisitor getLValueAssignmentVisitor(CFAEdge pCfaEdge, SMGState pNewState) {
        return new LValueAssignmentVisitor(pCfaEdge, pNewState);
    }

    class ExplicitValueVisitor
    extends AbstractExpressionValueVisitor {
        private final CFAEdge edge;
        private final SMGState smgState;

        public ExplicitValueVisitor(SMGState pSmgState, String pFunctionName, MachineModel pMachineModel, LogManagerWithoutDuplicates pLogger, CFAEdge pEdge) {
            super(pFunctionName, pMachineModel, pLogger);
            this.smgState = pSmgState;
            this.edge = pEdge;
        }

        private SMGTransferRelation.SMGExplicitValue getExplicitValue(SMGTransferRelation.SMGSymbolicValue pValue) {
            if (pValue.isUnknown()) {
                return SMGTransferRelation.SMGUnknownValue.getInstance();
            }
            SMGTransferRelation.SMGExplicitValue explicitValue = this.smgState.getExplicit((SMGTransferRelation.SMGKnownSymValue)pValue);
            return explicitValue;
        }

        @Override
        public Value visit(CBinaryExpression binaryExp) throws UnrecognizedCCodeException {
            Value value = super.visit(binaryExp);
            if (value.isUnknown() && this.isPointerComparison(binaryExp)) {
                SMGTransferRelation.SMGSymbolicValue symValue;
                try {
                    symValue = SMGExpressionEvaluator.this.evaluateAssumptionValue(this.smgState, this.edge, binaryExp);
                }
                catch (CPATransferException e) {
                    UnrecognizedCCodeException e2 = new UnrecognizedCCodeException("SMG cannot be evaluated", binaryExp);
                    e2.initCause(e);
                    throw e2;
                }
                if (symValue.equals(SMGTransferRelation.SMGKnownSymValue.TRUE)) {
                    return new NumericValue(1);
                }
                if (symValue.equals(SMGTransferRelation.SMGKnownSymValue.FALSE)) {
                    return new NumericValue(0);
                }
            }
            return value;
        }

        private boolean isPointerComparison(CBinaryExpression pE) {
            switch (pE.getOperator()) {
                case EQUALS: 
                case GREATER_THAN: 
                case GREATER_EQUAL: 
                case LESS_THAN: 
                case LESS_EQUAL: {
                    return true;
                }
            }
            return false;
        }

        @Override
        protected Value evaluateCPointerExpression(CPointerExpression pCPointerExpression) throws UnrecognizedCCodeException {
            return this.evaluateLeftHandSideExpression(pCPointerExpression);
        }

        private Value evaluateLeftHandSideExpression(CLeftHandSide leftHandSide) throws UnrecognizedCCodeException {
            SMGTransferRelation.SMGSymbolicValue value = SMGTransferRelation.SMGUnknownValue.getInstance();
            try {
                value = SMGExpressionEvaluator.this.evaluateExpressionValue(this.smgState, this.edge, leftHandSide);
            }
            catch (CPATransferException e) {
                UnrecognizedCCodeException e2 = new UnrecognizedCCodeException("SMG cannot be evaluated", leftHandSide);
                e2.initCause(e);
                throw e2;
            }
            SMGTransferRelation.SMGExplicitValue expValue = this.getExplicitValue(value);
            if (expValue.isUnknown()) {
                return Value.UnknownValue.getInstance();
            }
            return new NumericValue(expValue.getAsLong());
        }

        @Override
        protected Value evaluateCIdExpression(CIdExpression pCIdExpression) throws UnrecognizedCCodeException {
            return this.evaluateLeftHandSideExpression(pCIdExpression);
        }

        @Override
        protected Value evaluateJIdExpression(JIdExpression pVarName) {
            return null;
        }

        @Override
        protected Value evaluateCFieldReference(CFieldReference pLValue) throws UnrecognizedCCodeException {
            return this.evaluateLeftHandSideExpression(pLValue);
        }

        @Override
        protected Value evaluateCArraySubscriptExpression(CArraySubscriptExpression pLValue) throws UnrecognizedCCodeException {
            return this.evaluateLeftHandSideExpression(pLValue);
        }
    }

    class ExpressionValueVisitor
    extends DefaultCExpressionVisitor<SMGTransferRelation.SMGSymbolicValue, CPATransferException>
    implements CRightHandSideVisitor<SMGTransferRelation.SMGSymbolicValue, CPATransferException> {
        protected final CFAEdge cfaEdge;
        protected final SMGState smgState;

        public ExpressionValueVisitor(CFAEdge pEdge, SMGState pSmgState) {
            this.cfaEdge = pEdge;
            this.smgState = pSmgState;
        }

        @Override
        protected SMGTransferRelation.SMGSymbolicValue visitDefault(CExpression pExp) {
            return SMGTransferRelation.SMGUnknownValue.getInstance();
        }

        @Override
        public SMGTransferRelation.SMGSymbolicValue visit(CArraySubscriptExpression exp) throws CPATransferException {
            SMGTransferRelation.SMGAddress address = SMGExpressionEvaluator.this.evaluateArraySubscriptAddress(this.smgState, this.cfaEdge, exp);
            if (address.isUnknown()) {
                return SMGTransferRelation.SMGUnknownValue.getInstance();
            }
            SMGTransferRelation.SMGSymbolicValue value = SMGExpressionEvaluator.this.readValue(this.smgState, address.getObject(), address.getOffset(), SMGExpressionEvaluator.this.getRealExpressionType(exp), this.cfaEdge);
            return value;
        }

        @Override
        public SMGTransferRelation.SMGSymbolicValue visit(CIntegerLiteralExpression exp) throws CPATransferException {
            BigInteger value = exp.getValue();
            boolean isZero = value.equals(BigInteger.ZERO);
            return isZero ? SMGTransferRelation.SMGKnownSymValue.ZERO : SMGTransferRelation.SMGUnknownValue.getInstance();
        }

        @Override
        public SMGTransferRelation.SMGSymbolicValue visit(CCharLiteralExpression exp) throws CPATransferException {
            char value = exp.getCharacter();
            return value == '\u0000' ? SMGTransferRelation.SMGKnownSymValue.ZERO : SMGTransferRelation.SMGUnknownValue.getInstance();
        }

        @Override
        public SMGTransferRelation.SMGSymbolicValue visit(CFieldReference fieldReference) throws CPATransferException {
            SMGTransferRelation.SMGAddress addressOfField = SMGExpressionEvaluator.this.getAddressOfField(this.smgState, this.cfaEdge, fieldReference);
            if (addressOfField.isUnknown()) {
                return SMGTransferRelation.SMGUnknownValue.getInstance();
            }
            CType fieldType = fieldReference.getExpressionType().getCanonicalType();
            return SMGExpressionEvaluator.this.readValue(this.smgState, addressOfField.getObject(), addressOfField.getOffset(), fieldType, this.cfaEdge);
        }

        @Override
        public SMGTransferRelation.SMGSymbolicValue visit(CFloatLiteralExpression exp) throws CPATransferException {
            boolean isZero = exp.getValue().equals(BigDecimal.ZERO);
            return isZero ? SMGTransferRelation.SMGKnownSymValue.ZERO : SMGTransferRelation.SMGUnknownValue.getInstance();
        }

        @Override
        public SMGTransferRelation.SMGSymbolicValue visit(CIdExpression idExpression) throws CPATransferException {
            CSimpleDeclaration decl = idExpression.getDeclaration();
            if (decl instanceof CEnumType.CEnumerator) {
                long enumValue = ((CEnumType.CEnumerator)decl).getValue();
                return enumValue == 0L ? SMGTransferRelation.SMGKnownSymValue.ZERO : SMGTransferRelation.SMGUnknownValue.getInstance();
            }
            if (decl instanceof CVariableDeclaration || decl instanceof CParameterDeclaration) {
                SMGObject variableObject = this.smgState.getObjectForVisibleVariable(idExpression.getName());
                return SMGExpressionEvaluator.this.readValue(this.smgState, variableObject, SMGTransferRelation.SMGKnownExpValue.ZERO, SMGExpressionEvaluator.this.getRealExpressionType(idExpression), this.cfaEdge);
            }
            return SMGTransferRelation.SMGUnknownValue.getInstance();
        }

        @Override
        public SMGTransferRelation.SMGSymbolicValue visit(CUnaryExpression unaryExpression) throws CPATransferException {
            CUnaryExpression.UnaryOperator unaryOperator = unaryExpression.getOperator();
            CExpression unaryOperand = unaryExpression.getOperand();
            switch (unaryOperator) {
                case AMPER: {
                    throw new UnrecognizedCCodeException("Can't use & of expression " + unaryOperand.toASTString(), this.cfaEdge, unaryExpression);
                }
                case MINUS: {
                    SMGTransferRelation.SMGSymbolicValue value = unaryOperand.accept(this);
                    return value.equals(SMGTransferRelation.SMGKnownSymValue.ZERO) ? value : SMGTransferRelation.SMGUnknownValue.getInstance();
                }
                case SIZEOF: {
                    int size = SMGExpressionEvaluator.this.getSizeof(this.cfaEdge, SMGExpressionEvaluator.this.getRealExpressionType(unaryOperand));
                    return size == 0 ? SMGTransferRelation.SMGKnownSymValue.ZERO : SMGTransferRelation.SMGUnknownValue.getInstance();
                }
            }
            return SMGTransferRelation.SMGUnknownValue.getInstance();
        }

        @Override
        public SMGTransferRelation.SMGSymbolicValue visit(CPointerExpression pointerExpression) throws CPATransferException {
            CExpression operand = pointerExpression.getOperand();
            CType operandType = SMGExpressionEvaluator.this.getRealExpressionType(operand);
            CType expType = SMGExpressionEvaluator.this.getRealExpressionType(pointerExpression);
            if (operandType instanceof CPointerType) {
                return this.dereferencePointer(operand, expType);
            }
            if (operandType instanceof CArrayType) {
                return this.dereferenceArray(operand, expType);
            }
            throw new UnrecognizedCCodeException("on pointer expression", this.cfaEdge, pointerExpression);
        }

        @Override
        public SMGTransferRelation.SMGSymbolicValue visit(CTypeIdExpression typeIdExp) throws UnrecognizedCCodeException {
            CTypeIdExpression.TypeIdOperator typeOperator = typeIdExp.getOperator();
            CType type = typeIdExp.getType();
            switch (typeOperator) {
                case SIZEOF: {
                    return SMGExpressionEvaluator.this.getSizeof(this.cfaEdge, type) == 0 ? SMGTransferRelation.SMGKnownSymValue.ZERO : SMGTransferRelation.SMGUnknownValue.getInstance();
                }
            }
            return SMGTransferRelation.SMGUnknownValue.getInstance();
        }

        @Override
        public SMGTransferRelation.SMGSymbolicValue visit(CBinaryExpression exp) throws CPATransferException {
            CBinaryExpression.BinaryOperator binaryOperator = exp.getOperator();
            CExpression lVarInBinaryExp = exp.getOperand1();
            CExpression rVarInBinaryExp = exp.getOperand2();
            switch (binaryOperator) {
                case PLUS: 
                case MINUS: 
                case DIVIDE: 
                case MULTIPLY: 
                case MODULO: 
                case SHIFT_LEFT: 
                case SHIFT_RIGHT: 
                case BINARY_AND: 
                case BINARY_OR: 
                case BINARY_XOR: {
                    SMGTransferRelation.SMGSymbolicValue lVal = lVarInBinaryExp.accept(this);
                    if (lVal.equals(SMGTransferRelation.SMGUnknownValue.getInstance())) {
                        return SMGTransferRelation.SMGUnknownValue.getInstance();
                    }
                    SMGTransferRelation.SMGSymbolicValue rVal = rVarInBinaryExp.accept(this);
                    if (rVal.equals(SMGTransferRelation.SMGUnknownValue.getInstance())) {
                        return SMGTransferRelation.SMGUnknownValue.getInstance();
                    }
                    switch (binaryOperator) {
                        case PLUS: 
                        case SHIFT_LEFT: 
                        case SHIFT_RIGHT: 
                        case BINARY_OR: 
                        case BINARY_XOR: {
                            boolean isZero = lVal.equals(SMGTransferRelation.SMGKnownSymValue.ZERO) && lVal.equals(SMGTransferRelation.SMGKnownSymValue.ZERO);
                            return isZero ? SMGTransferRelation.SMGKnownSymValue.ZERO : SMGTransferRelation.SMGUnknownValue.getInstance();
                        }
                        case MINUS: 
                        case MODULO: {
                            boolean isZero = lVal.equals(rVal);
                            return isZero ? SMGTransferRelation.SMGKnownSymValue.ZERO : SMGTransferRelation.SMGUnknownValue.getInstance();
                        }
                        case DIVIDE: {
                            if (rVal.equals(SMGTransferRelation.SMGKnownSymValue.ZERO)) {
                                return SMGTransferRelation.SMGUnknownValue.getInstance();
                            }
                            boolean isZero = lVal.equals(SMGTransferRelation.SMGKnownSymValue.ZERO);
                            return isZero ? SMGTransferRelation.SMGKnownSymValue.ZERO : SMGTransferRelation.SMGUnknownValue.getInstance();
                        }
                        case MULTIPLY: 
                        case BINARY_AND: {
                            boolean isZero = lVal.equals(SMGTransferRelation.SMGKnownSymValue.ZERO) || rVal.equals(SMGTransferRelation.SMGKnownSymValue.ZERO);
                            return isZero ? SMGTransferRelation.SMGKnownSymValue.ZERO : SMGTransferRelation.SMGUnknownValue.getInstance();
                        }
                    }
                    throw new AssertionError();
                }
                case EQUALS: 
                case NOT_EQUALS: 
                case GREATER_THAN: 
                case GREATER_EQUAL: 
                case LESS_THAN: 
                case LESS_EQUAL: {
                    boolean isZero;
                    SMGTransferRelation.SMGSymbolicValue lVal = lVarInBinaryExp.accept(this);
                    if (lVal.equals(SMGTransferRelation.SMGUnknownValue.getInstance())) {
                        return SMGTransferRelation.SMGUnknownValue.getInstance();
                    }
                    SMGTransferRelation.SMGSymbolicValue rVal = rVarInBinaryExp.accept(this);
                    if (rVal.equals(SMGTransferRelation.SMGUnknownValue.getInstance())) {
                        return SMGTransferRelation.SMGUnknownValue.getInstance();
                    }
                    switch (binaryOperator) {
                        case NOT_EQUALS: {
                            isZero = lVal.equals(rVal);
                            break;
                        }
                        case EQUALS: {
                            isZero = this.isUnequal(this.smgState, lVal, rVal);
                            break;
                        }
                        case GREATER_THAN: 
                        case GREATER_EQUAL: 
                        case LESS_THAN: 
                        case LESS_EQUAL: {
                            isZero = false;
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    if (isZero) {
                        return SMGTransferRelation.SMGKnownSymValue.ZERO;
                    }
                    return SMGTransferRelation.SMGUnknownValue.getInstance();
                }
            }
            return SMGTransferRelation.SMGUnknownValue.getInstance();
        }

        private boolean isUnequal(SMGState pSmgState, SMGTransferRelation.SMGSymbolicValue pLVal, SMGTransferRelation.SMGSymbolicValue pRVal) throws SMGInconsistentException {
            if (pLVal.isUnknown() || pRVal.isUnknown()) {
                return false;
            }
            return pSmgState.isUnequal(pLVal.getAsInt(), pRVal.getAsInt());
        }

        @Override
        public SMGTransferRelation.SMGSymbolicValue visit(CCastExpression cast) throws CPATransferException {
            return SMGExpressionEvaluator.this.evaluateExpressionValue(this.getSmgState(), this.getCfaEdge(), cast.getOperand());
        }

        protected SMGTransferRelation.SMGSymbolicValue dereferenceArray(CExpression exp, CType derefType) throws CPATransferException {
            ArrayVisitor v = SMGExpressionEvaluator.this.getArrayVisitor(this.cfaEdge, this.smgState);
            SMGTransferRelation.SMGAddress address = exp.accept(v);
            if (address.isUnknown()) {
                return SMGExpressionEvaluator.this.handleUnknownDereference(this.smgState, this.cfaEdge);
            }
            if (derefType instanceof CArrayType) {
                return SMGExpressionEvaluator.this.createAddress(this.smgState, address.getObject(), address.getOffset());
            }
            return SMGExpressionEvaluator.this.readValue(this.smgState, address.getObject(), address.getOffset(), derefType, this.cfaEdge);
        }

        protected final SMGTransferRelation.SMGSymbolicValue dereferencePointer(CExpression exp, CType derefType) throws CPATransferException {
            SMGTransferRelation.SMGAddressValue address = SMGExpressionEvaluator.this.evaluateAddress(this.smgState, this.cfaEdge, exp);
            if (address.isUnknown()) {
                return SMGExpressionEvaluator.this.handleUnknownDereference(this.smgState, this.cfaEdge);
            }
            if (derefType instanceof CArrayType) {
                return SMGExpressionEvaluator.this.createAddress(this.smgState, address.getObject(), address.getOffset());
            }
            return SMGExpressionEvaluator.this.readValue(this.smgState, address.getObject(), address.getOffset(), derefType, this.cfaEdge);
        }

        @Override
        public SMGTransferRelation.SMGSymbolicValue visit(CFunctionCallExpression pIastFunctionCallExpression) throws CPATransferException {
            return SMGTransferRelation.SMGUnknownValue.getInstance();
        }

        public SMGState getSmgState() {
            return this.smgState;
        }

        public CFAEdge getCfaEdge() {
            return this.cfaEdge;
        }
    }

    class StructAndUnionVisitor
    extends AddressVisitor
    implements CRightHandSideVisitor<SMGTransferRelation.SMGAddress, CPATransferException> {
        public StructAndUnionVisitor(CFAEdge pCfaEdge, SMGState pNewState) {
            super(pCfaEdge, pNewState);
        }

        @Override
        public SMGTransferRelation.SMGAddress visit(CFunctionCallExpression pIastFunctionCallExpression) throws CPATransferException {
            return SMGTransferRelation.SMGAddress.UNKNOWN;
        }

        @Override
        public SMGTransferRelation.SMGAddress visit(CCastExpression cast) throws CPATransferException {
            CExpression op = cast.getOperand();
            if (SMGExpressionEvaluator.this.isStructOrUnionType(op.getExpressionType())) {
                return cast.getOperand().accept(this);
            }
            return SMGTransferRelation.SMGAddress.UNKNOWN;
        }
    }

    class AssumeVisitor
    extends ExpressionValueVisitor {
        private BinaryRelationEvaluator relation;

        public AssumeVisitor(CFAEdge pEdge, SMGState pSmgState) {
            super(pEdge, pSmgState);
            this.relation = null;
        }

        @Override
        public SMGTransferRelation.SMGSymbolicValue visit(CBinaryExpression pExp) throws CPATransferException {
            CBinaryExpression.BinaryOperator binaryOperator = pExp.getOperator();
            switch (binaryOperator) {
                case EQUALS: 
                case NOT_EQUALS: 
                case GREATER_THAN: 
                case GREATER_EQUAL: 
                case LESS_THAN: 
                case LESS_EQUAL: {
                    CExpression leftSideExpression = pExp.getOperand1();
                    CExpression rightSideExpression = pExp.getOperand2();
                    CFAEdge cfaEdge = this.getCfaEdge();
                    SMGTransferRelation.SMGSymbolicValue leftSideVal = SMGExpressionEvaluator.this.evaluateExpressionValue(this.smgState, cfaEdge, leftSideExpression);
                    if (leftSideVal.isUnknown()) {
                        return SMGTransferRelation.SMGUnknownValue.getInstance();
                    }
                    SMGTransferRelation.SMGSymbolicValue rightSideVal = SMGExpressionEvaluator.this.evaluateExpressionValue(this.smgState, cfaEdge, rightSideExpression);
                    if (rightSideVal.isUnknown()) {
                        return SMGTransferRelation.SMGUnknownValue.getInstance();
                    }
                    SMGTransferRelation.SMGKnownSymValue knownRightSideVal = SMGTransferRelation.SMGKnownSymValue.valueOf(rightSideVal.getAsInt());
                    SMGTransferRelation.SMGKnownSymValue knownLeftSideVal = SMGTransferRelation.SMGKnownSymValue.valueOf(leftSideVal.getAsInt());
                    return this.evaluateBinaryAssumption(binaryOperator, knownLeftSideVal, knownRightSideVal);
                }
            }
            return super.visit(pExp);
        }

        private SMGTransferRelation.SMGSymbolicValue evaluateBinaryAssumption(CBinaryExpression.BinaryOperator pOp, SMGTransferRelation.SMGKnownSymValue v1, SMGTransferRelation.SMGKnownSymValue v2) throws SMGInconsistentException {
            this.relation = new BinaryRelationEvaluator(pOp, v1, v2);
            if (this.relation.isFalse()) {
                return SMGTransferRelation.SMGKnownSymValue.FALSE;
            }
            if (this.relation.isTrue()) {
                return SMGTransferRelation.SMGKnownSymValue.TRUE;
            }
            return SMGTransferRelation.SMGUnknownValue.getInstance();
        }

        public boolean impliesEqOn(boolean pTruth) {
            if (this.relation == null) {
                return false;
            }
            return this.relation.impliesEq(pTruth);
        }

        public boolean impliesNeqOn(boolean pTruth) {
            if (this.relation == null) {
                return false;
            }
            return this.relation.impliesNeq(pTruth);
        }

        private class BinaryRelationEvaluator {
            private boolean isTrue = false;
            private boolean isFalse = false;
            private boolean impliesEqWhenTrue = false;
            private boolean impliesNeqWhenTrue = false;
            private boolean impliesEqWhenFalse = false;
            private boolean impliesNeqWhenFalse = false;

            public BinaryRelationEvaluator(CBinaryExpression.BinaryOperator pOp, SMGTransferRelation.SMGSymbolicValue pV1, SMGTransferRelation.SMGSymbolicValue pV2) throws SMGInconsistentException {
                int v1 = pV1.getAsInt();
                int v2 = pV2.getAsInt();
                boolean areEqual = v1 == v2;
                boolean areNonEqual = AssumeVisitor.this.smgState.isUnequal(v1, v2);
                switch (pOp) {
                    case NOT_EQUALS: {
                        this.isTrue = areNonEqual;
                        this.isFalse = areEqual;
                        this.impliesEqWhenFalse = true;
                        this.impliesNeqWhenTrue = true;
                        break;
                    }
                    case EQUALS: {
                        this.isTrue = areEqual;
                        this.isFalse = areNonEqual;
                        this.impliesEqWhenTrue = true;
                        this.impliesNeqWhenFalse = true;
                        break;
                    }
                    case GREATER_EQUAL: 
                    case LESS_EQUAL: {
                        if (v1 == v2) {
                            this.isTrue = true;
                            this.impliesEqWhenTrue = true;
                            this.impliesNeqWhenFalse = true;
                            break;
                        }
                        this.impliesNeqWhenFalse = true;
                        this.compareAsAddresses(pV1, pV2, pOp);
                        break;
                    }
                    case GREATER_THAN: 
                    case LESS_THAN: {
                        this.compareAsAddresses(pV1, pV2, pOp);
                        this.impliesNeqWhenTrue = true;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Binary Relation with non-relational operator: " + pOp.toString()));
                    }
                }
            }

            private void compareAsAddresses(SMGTransferRelation.SMGSymbolicValue lVal, SMGTransferRelation.SMGSymbolicValue rVal, CBinaryExpression.BinaryOperator binaryOperator) throws SMGInconsistentException {
                SMGObject rObject;
                SMGTransferRelation.SMGAddressValue lAddress = SMGExpressionEvaluator.this.getAddressFromSymbolicValue(AssumeVisitor.this.getSmgState(), lVal);
                SMGTransferRelation.SMGAddressValue rAddress = SMGExpressionEvaluator.this.getAddressFromSymbolicValue(AssumeVisitor.this.getSmgState(), rVal);
                if (rAddress.isUnknown() || lAddress.isUnknown()) {
                    return;
                }
                SMGObject lObject = lAddress.getObject();
                if (!lObject.equals(rObject = rAddress.getObject())) {
                    return;
                }
                long rOffset = rAddress.getOffset().getAsLong();
                long lOffset = lAddress.getOffset().getAsLong();
                switch (binaryOperator) {
                    case LESS_THAN: {
                        this.isTrue = lOffset < rOffset;
                        this.isFalse = !this.isTrue;
                        break;
                    }
                    case LESS_EQUAL: {
                        this.isTrue = lOffset <= rOffset;
                        this.isFalse = !this.isTrue;
                        break;
                    }
                    case GREATER_EQUAL: {
                        this.isTrue = lOffset > rOffset;
                        this.isFalse = !this.isTrue;
                        break;
                    }
                    case GREATER_THAN: {
                        this.isTrue = lOffset > rOffset;
                        this.isFalse = !this.isTrue;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"compareAsAddresses shouldn't be called for operators not being LE/LT/GE/GT");
                    }
                }
            }

            public boolean isTrue() {
                return this.isTrue;
            }

            public boolean isFalse() {
                return this.isFalse;
            }

            public boolean impliesEq(boolean pTruth) {
                return pTruth ? this.impliesEqWhenTrue : this.impliesEqWhenFalse;
            }

            public boolean impliesNeq(boolean pTruth) {
                return pTruth ? this.impliesNeqWhenTrue : this.impliesNeqWhenFalse;
            }
        }
    }

    class ArrayVisitor
    extends AddressVisitor
    implements CRightHandSideVisitor<SMGTransferRelation.SMGAddress, CPATransferException> {
        public ArrayVisitor(CFAEdge pEdge, SMGState pSmgState) {
            super(pEdge, pSmgState);
        }

        @Override
        protected SMGTransferRelation.SMGAddress visitDefault(CExpression exp) {
            return SMGTransferRelation.SMGAddress.UNKNOWN;
        }

        @Override
        public SMGTransferRelation.SMGAddress visit(CUnaryExpression unaryExpression) throws CPATransferException {
            throw new AssertionError((Object)"The result of any unary expression cannot be an array type.");
        }

        @Override
        public SMGTransferRelation.SMGAddress visit(CBinaryExpression binaryExp) throws CPATransferException {
            CExpression lVarInBinaryExp = binaryExp.getOperand1();
            CExpression rVarInBinaryExp = binaryExp.getOperand2();
            CType lVarInBinaryExpType = SMGExpressionEvaluator.this.getRealExpressionType(lVarInBinaryExp);
            CType rVarInBinaryExpType = SMGExpressionEvaluator.this.getRealExpressionType(rVarInBinaryExp);
            boolean lVarIsAddress = lVarInBinaryExpType instanceof CArrayType;
            boolean rVarIsAddress = rVarInBinaryExpType instanceof CArrayType;
            CExpression address = null;
            CExpression arrayOffset = null;
            CType addressType = null;
            if (lVarIsAddress == rVarIsAddress) {
                return SMGTransferRelation.SMGAddress.UNKNOWN;
            }
            if (lVarIsAddress) {
                address = lVarInBinaryExp;
                arrayOffset = rVarInBinaryExp;
                addressType = lVarInBinaryExpType;
            } else if (rVarIsAddress) {
                address = rVarInBinaryExp;
                arrayOffset = lVarInBinaryExp;
                addressType = rVarInBinaryExpType;
            } else {
                throw new UnrecognizedCCodeException("Expected either " + lVarInBinaryExp.toASTString() + " or " + rVarInBinaryExp.toASTString() + "to be a pointer to an array.", binaryExp);
            }
            SMGTransferRelation.SMGAddressValue result = SMGExpressionEvaluator.this.handlePointerArithmetic(this.getSmgState(), this.getCfaEdge(), address, arrayOffset, addressType, lVarIsAddress, binaryExp);
            return result.getAddress();
        }

        @Override
        public SMGTransferRelation.SMGAddress visit(CCastExpression cast) throws CPATransferException {
            CExpression op = cast.getOperand();
            if (op.getExpressionType() instanceof CArrayType) {
                return cast.getOperand().accept(this);
            }
            return SMGTransferRelation.SMGAddress.UNKNOWN;
        }

        @Override
        public SMGTransferRelation.SMGAddress visit(CFunctionCallExpression pIastFunctionCallExpression) throws CPATransferException {
            return SMGTransferRelation.SMGAddress.UNKNOWN;
        }
    }

    class PointerVisitor
    extends ExpressionValueVisitor {
        public PointerVisitor(CFAEdge pEdge, SMGState pSmgState) {
            super(pEdge, pSmgState);
        }

        @Override
        public SMGTransferRelation.SMGAddressValue visit(CIntegerLiteralExpression exp) throws CPATransferException {
            return SMGExpressionEvaluator.this.getAddressFromSymbolicValue(this.smgState, super.visit(exp));
        }

        @Override
        public SMGTransferRelation.SMGAddressValue visit(CCharLiteralExpression exp) throws CPATransferException {
            return SMGExpressionEvaluator.this.getAddressFromSymbolicValue(this.smgState, super.visit(exp));
        }

        @Override
        public SMGTransferRelation.SMGAddressValue visit(CFloatLiteralExpression pExp) throws CPATransferException {
            return SMGExpressionEvaluator.this.getAddressFromSymbolicValue(this.smgState, super.visit(pExp));
        }

        @Override
        public SMGTransferRelation.SMGAddressValue visit(CIdExpression exp) throws CPATransferException {
            CType c = SMGExpressionEvaluator.this.getRealExpressionType(exp);
            if (c instanceof CArrayType) {
                return this.createAddressOfVariable(exp);
            }
            return SMGExpressionEvaluator.this.getAddressFromSymbolicValue(this.smgState, super.visit(exp));
        }

        @Override
        public SMGTransferRelation.SMGAddressValue visit(CUnaryExpression unaryExpression) throws CPATransferException {
            CUnaryExpression.UnaryOperator unaryOperator = unaryExpression.getOperator();
            CExpression unaryOperand = unaryExpression.getOperand();
            switch (unaryOperator) {
                case AMPER: {
                    return this.handleAmper(unaryOperand);
                }
                case SIZEOF: {
                    throw new UnrecognizedCCodeException("Misinterpreted the expression type of " + unaryOperand.toASTString() + " as pointer type", this.cfaEdge, unaryExpression);
                }
            }
            return SMGTransferRelation.SMGUnknownValue.getInstance();
        }

        private SMGTransferRelation.SMGAddressValue handleAmper(CRightHandSide amperOperand) throws CPATransferException {
            if (amperOperand instanceof CIdExpression) {
                return this.createAddressOfVariable((CIdExpression)amperOperand);
            }
            if (amperOperand instanceof CPointerExpression) {
                CExpression rValue = ((CPointerExpression)amperOperand).getOperand();
                return SMGExpressionEvaluator.this.evaluateAddress(this.smgState, this.cfaEdge, rValue);
            }
            if (amperOperand instanceof CFieldReference) {
                return this.createAddressOfField((CFieldReference)amperOperand);
            }
            if (amperOperand instanceof CArraySubscriptExpression) {
                return this.createAddressOfArraySubscript((CArraySubscriptExpression)amperOperand);
            }
            return SMGTransferRelation.SMGUnknownValue.getInstance();
        }

        private SMGTransferRelation.SMGAddressValue createAddressOfArraySubscript(CArraySubscriptExpression lValue) throws CPATransferException {
            CExpression arrayExpression = lValue.getArrayExpression();
            SMGTransferRelation.SMGAddressValue arrayAddress = SMGExpressionEvaluator.this.evaluateAddress(this.smgState, this.cfaEdge, arrayExpression);
            if (arrayAddress.isUnknown()) {
                return SMGTransferRelation.SMGUnknownValue.getInstance();
            }
            CExpression subscriptExpr = lValue.getSubscriptExpression();
            SMGTransferRelation.SMGExplicitValue subscriptValue = SMGExpressionEvaluator.this.evaluateExplicitValue(this.smgState, this.cfaEdge, subscriptExpr);
            if (subscriptValue.isUnknown()) {
                return SMGTransferRelation.SMGUnknownValue.getInstance();
            }
            SMGTransferRelation.SMGExplicitValue arrayOffset = arrayAddress.getOffset();
            int typeSize = SMGExpressionEvaluator.this.getSizeof(this.cfaEdge, SMGExpressionEvaluator.this.getRealExpressionType(lValue));
            SMGTransferRelation.SMGKnownExpValue sizeOfType = SMGTransferRelation.SMGKnownExpValue.valueOf(typeSize);
            SMGTransferRelation.SMGExplicitValue offset = arrayOffset.add(subscriptValue).multiply(sizeOfType);
            return SMGExpressionEvaluator.this.createAddress(this.smgState, arrayAddress.getObject(), offset);
        }

        private SMGTransferRelation.SMGAddressValue createAddressOfField(CFieldReference lValue) throws CPATransferException {
            SMGTransferRelation.SMGAddress addressOfField = SMGExpressionEvaluator.this.getAddressOfField(this.smgState, this.cfaEdge, lValue);
            if (addressOfField.isUnknown()) {
                return SMGTransferRelation.SMGUnknownValue.getInstance();
            }
            return SMGExpressionEvaluator.this.createAddress(this.smgState, addressOfField.getObject(), addressOfField.getOffset());
        }

        private SMGTransferRelation.SMGAddressValue createAddressOfVariable(CIdExpression idExpression) throws SMGInconsistentException {
            SMGObject variableObject = this.smgState.getObjectForVisibleVariable(idExpression.getName());
            if (variableObject == null) {
                return SMGTransferRelation.SMGUnknownValue.getInstance();
            }
            return SMGExpressionEvaluator.this.createAddress(this.smgState, variableObject, SMGTransferRelation.SMGKnownExpValue.ZERO);
        }

        @Override
        public SMGTransferRelation.SMGAddressValue visit(CPointerExpression pointerExpression) throws CPATransferException {
            return SMGExpressionEvaluator.this.getAddressFromSymbolicValue(this.smgState, super.visit(pointerExpression));
        }

        @Override
        public SMGTransferRelation.SMGAddressValue visit(CBinaryExpression binaryExp) throws CPATransferException {
            CExpression lVarInBinaryExp = binaryExp.getOperand1();
            CExpression rVarInBinaryExp = binaryExp.getOperand2();
            CType lVarInBinaryExpType = SMGExpressionEvaluator.this.getRealExpressionType(lVarInBinaryExp);
            CType rVarInBinaryExpType = SMGExpressionEvaluator.this.getRealExpressionType(rVarInBinaryExp);
            boolean lVarIsAddress = lVarInBinaryExpType instanceof CPointerType;
            boolean rVarIsAddress = rVarInBinaryExpType instanceof CPointerType;
            CExpression address = null;
            CExpression pointerOffset = null;
            CPointerType addressType = null;
            if (lVarIsAddress == rVarIsAddress) {
                return SMGTransferRelation.SMGUnknownValue.getInstance();
            }
            if (lVarIsAddress) {
                address = lVarInBinaryExp;
                pointerOffset = rVarInBinaryExp;
                addressType = (CPointerType)lVarInBinaryExpType;
            } else if (rVarIsAddress) {
                address = rVarInBinaryExp;
                pointerOffset = lVarInBinaryExp;
                addressType = (CPointerType)rVarInBinaryExpType;
            } else {
                throw new UnrecognizedCCodeException("Expected either " + lVarInBinaryExp.toASTString() + " or " + rVarInBinaryExp.toASTString() + "to be a pointer.", binaryExp);
            }
            CType typeOfPointer = addressType.getType().getCanonicalType();
            return SMGExpressionEvaluator.this.handlePointerArithmetic(this.getSmgState(), this.getCfaEdge(), address, pointerOffset, typeOfPointer, lVarIsAddress, binaryExp);
        }

        @Override
        public SMGTransferRelation.SMGAddressValue visit(CArraySubscriptExpression exp) throws CPATransferException {
            return SMGExpressionEvaluator.this.getAddressFromSymbolicValue(this.smgState, super.visit(exp));
        }

        @Override
        public SMGTransferRelation.SMGAddressValue visit(CFieldReference exp) throws CPATransferException {
            return SMGExpressionEvaluator.this.getAddressFromSymbolicValue(this.smgState, super.visit(exp));
        }

        @Override
        public SMGTransferRelation.SMGAddressValue visit(CCastExpression pCast) throws CPATransferException {
            return SMGExpressionEvaluator.this.getAddressFromSymbolicValue(this.smgState, super.visit(pCast));
        }
    }

    private abstract class AddressVisitor
    extends DefaultCExpressionVisitor<SMGTransferRelation.SMGAddress, CPATransferException>
    implements CRightHandSideVisitor<SMGTransferRelation.SMGAddress, CPATransferException> {
        private final CFAEdge cfaEdge;
        private final SMGState smgState;

        public AddressVisitor(CFAEdge pEdge, SMGState pSmgState) {
            this.cfaEdge = pEdge;
            this.smgState = pSmgState;
        }

        @Override
        protected SMGTransferRelation.SMGAddress visitDefault(CExpression pExp) throws CPATransferException {
            return SMGTransferRelation.SMGAddress.UNKNOWN;
        }

        @Override
        public SMGTransferRelation.SMGAddress visit(CIdExpression variableName) throws CPATransferException {
            SMGObject object = this.smgState.getObjectForVisibleVariable(variableName.getName());
            return SMGTransferRelation.SMGAddress.valueOf(object, SMGTransferRelation.SMGKnownExpValue.ZERO);
        }

        @Override
        public SMGTransferRelation.SMGAddress visit(CArraySubscriptExpression exp) throws CPATransferException {
            return SMGExpressionEvaluator.this.evaluateArraySubscriptAddress(this.smgState, this.cfaEdge, exp);
        }

        @Override
        public SMGTransferRelation.SMGAddress visit(CFieldReference pE) throws CPATransferException {
            return SMGExpressionEvaluator.this.getAddressOfField(this.smgState, this.cfaEdge, pE);
        }

        @Override
        public SMGTransferRelation.SMGAddress visit(CPointerExpression pointerExpression) throws CPATransferException {
            CExpression operand = pointerExpression.getOperand();
            assert (operand.getExpressionType().getCanonicalType() instanceof CPointerType);
            SMGTransferRelation.SMGAddressValue addressValue = SMGExpressionEvaluator.this.evaluateAddress(this.getSmgState(), this.getCfaEdge(), operand);
            if (addressValue.isUnknown()) {
                return SMGTransferRelation.SMGAddress.UNKNOWN;
            }
            return addressValue.getAddress();
        }

        public final CFAEdge getCfaEdge() {
            return this.cfaEdge;
        }

        public final SMGState getSmgState() {
            return this.smgState;
        }
    }

    public class LValueAssignmentVisitor
    extends AddressVisitor {
        public LValueAssignmentVisitor(CFAEdge pEdge, SMGState pSmgState) {
            super(pEdge, pSmgState);
        }

        @Override
        public SMGTransferRelation.SMGAddress visit(CUnaryExpression lValue) throws CPATransferException {
            throw new UnrecognizedCCodeException(lValue.toASTString() + " is not an lValue", this.getCfaEdge(), lValue);
        }

        @Override
        public SMGTransferRelation.SMGAddress visit(CFunctionCallExpression pIastFunctionCallExpression) throws CPATransferException {
            throw new AssertionError((Object)"This expression is not a lValue expression.");
        }
    }
}

