/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smgfork;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGExplicitPlotter;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGPlotter;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGRuntimeCheck;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGTransferRelation;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGValueFactory;
import org.sosy_lab.cpachecker.cpa.smgfork.graphs.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smgfork.graphs.CLangSMGConsistencyVerifier;
import org.sosy_lab.cpachecker.cpa.smgfork.join.SMGJoin;
import org.sosy_lab.cpachecker.cpa.smgfork.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGRegion;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;

public class SMGState
implements AbstractQueryableState,
LatticeAbstractState<SMGState> {
    static boolean targetMemoryErrors = true;
    static boolean unknownOnUndefined = true;
    private static final AtomicInteger id_counter = new AtomicInteger(0);
    private final Map<SMGTransferRelation.SMGKnownSymValue, SMGTransferRelation.SMGKnownExpValue> explicitValues = new HashMap<SMGTransferRelation.SMGKnownSymValue, SMGTransferRelation.SMGKnownExpValue>();
    private final CLangSMG heap;
    private final LogManager logger;
    private SMGState predecessor;
    private final int id;
    private static SMGRuntimeCheck runtimeCheckLevel = SMGRuntimeCheck.NONE;
    private boolean invalidWrite = false;
    private boolean invalidRead = false;
    private boolean invalidFree = false;

    private void issueMemoryLeakMessage() {
        this.issueMemoryError("Memory leak found", false);
    }

    private void issueInvalidReadMessage() {
        this.issueMemoryError("Invalid read found", true);
    }

    private void issueInvalidWriteMessage() {
        this.issueMemoryError("Invalid write found", true);
    }

    private void issueInvalidFreeMessage() {
        this.issueMemoryError("Invalid free found", true);
    }

    private void issueMemoryError(String pMessage, boolean pUndefinedBehavior) {
        if (targetMemoryErrors) {
            this.logger.log(Level.WARNING, new Object[]{pMessage});
        } else if (pUndefinedBehavior) {
            this.logger.log(Level.WARNING, new Object[]{pMessage});
            this.logger.log(Level.WARNING, new Object[]{"Non-target undefined behavior detected. The verification result is unreliable."});
        }
    }

    public static void setTargetMemoryErrors(boolean pV) {
        targetMemoryErrors = pV;
    }

    public static void setUnknownOnUndefined(boolean pV) {
        unknownOnUndefined = pV;
    }

    public SMGState(LogManager pLogger, MachineModel pMachineModel) {
        this.heap = new CLangSMG(pMachineModel);
        this.logger = pLogger;
        this.predecessor = null;
        this.id = id_counter.getAndIncrement();
    }

    public SMGState(SMGState pOriginalState) {
        this.heap = new CLangSMG(pOriginalState.heap);
        this.logger = pOriginalState.logger;
        this.predecessor = pOriginalState.predecessor;
        this.id = id_counter.getAndIncrement();
        this.explicitValues.putAll(pOriginalState.explicitValues);
    }

    public static final void setRuntimeCheck(SMGRuntimeCheck pLevel) {
        runtimeCheckLevel = pLevel;
    }

    public final void setPredecessor(SMGState pSMGState) throws SMGInconsistentException {
        this.predecessor = pSMGState;
        this.performConsistencyCheck(SMGRuntimeCheck.FULL);
    }

    public SMGObject addGlobalVariable(CType pType, String pVarName) throws SMGInconsistentException {
        int size = this.heap.getMachineModel().getSizeof(pType);
        SMGRegion new_object = new SMGRegion(size, pVarName);
        this.heap.addGlobalObject(new_object);
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
        return new_object;
    }

    public SMGObject addLocalVariable(CType pType, String pVarName) throws SMGInconsistentException {
        int size = this.heap.getMachineModel().getSizeof(pType);
        SMGRegion new_object = new SMGRegion(size, pVarName);
        this.heap.addStackObject(new_object);
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
        return new_object;
    }

    public void addStackFrame(CFunctionDeclaration pFunctionDefinition) throws SMGInconsistentException {
        this.heap.addStackFrame(pFunctionDefinition);
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
    }

    public final int getId() {
        return this.id;
    }

    public final SMGState getPredecessor() {
        return this.predecessor;
    }

    public final SMGObject getFunctionReturnObject() {
        return this.heap.getFunctionReturnObject();
    }

    public SMGObject getObjectForVisibleVariable(String pVariableName) {
        return this.heap.getObjectForVisibleVariable(pVariableName);
    }

    public final void performConsistencyCheck(SMGRuntimeCheck pLevel) throws SMGInconsistentException {
        if (runtimeCheckLevel.isFinerOrEqualThan(pLevel) && !CLangSMGConsistencyVerifier.verifyCLangSMG(this.logger, this.heap)) {
            throw new SMGInconsistentException("SMG was found inconsistent during a check");
        }
    }

    public String toDot(String pName, String pLocation) {
        SMGPlotter plotter = new SMGPlotter();
        return plotter.smgAsDot(this.heap, pName, pLocation, this.explicitValues);
    }

    public String toDot(String pName, String pLocation, ValueAnalysisState pExplicitState) {
        SMGExplicitPlotter plotter = new SMGExplicitPlotter(pExplicitState, this);
        return plotter.smgAsDot(this.heap, "Explicit_" + pName, pLocation);
    }

    public String toString() {
        if (this.getPredecessor() != null) {
            return "SMGState [" + this.getId() + "] <-- parent [" + this.getPredecessor().getId() + "]\n" + this.heap.toString();
        }
        return "SMGState [" + this.getId() + "] <-- no parent, initial state\n" + this.heap.toString();
    }

    public SMGEdgePointsTo getPointerFromValue(Integer pValue) throws SMGInconsistentException {
        if (this.heap.isPointer(pValue)) {
            return this.heap.getPointer(pValue);
        }
        throw new SMGInconsistentException("Asked for a Points-To edge for a non-pointer value");
    }

    public boolean isPointer(Integer pValue) {
        return this.heap.isPointer(pValue);
    }

    public Integer readValue(SMGObject pObject, int pOffset, CType pType) throws SMGInconsistentException {
        if (!this.heap.isObjectValid(pObject)) {
            this.setInvalidRead();
            return null;
        }
        SMGEdgeHasValue edge = new SMGEdgeHasValue(pType, pOffset, pObject, 0);
        SMGEdgeHasValueFilter filter = new SMGEdgeHasValueFilter();
        filter.filterByObject(pObject);
        filter.filterAtOffset(pOffset);
        Set<SMGEdgeHasValue> edges = this.heap.getHVEdges(filter);
        for (SMGEdgeHasValue object_edge : edges) {
            if (!edge.isCompatibleFieldOnSameObject(object_edge, this.heap.getMachineModel())) continue;
            this.performConsistencyCheck(SMGRuntimeCheck.HALF);
            return object_edge.getValue();
        }
        if (this.heap.isCoveredByNullifiedBlocks(edge)) {
            return 0;
        }
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
        return null;
    }

    public void setInvalidRead() {
        this.invalidRead = true;
    }

    public SMGEdgeHasValue writeValue(SMGObject pObject, int pOffset, CType pType, SMGTransferRelation.SMGSymbolicValue pValue) throws SMGInconsistentException {
        SMGTransferRelation.SMGAddress address;
        int value = pValue.isUnknown() ? SMGValueFactory.getNewValue().intValue() : pValue.getAsInt();
        if (pValue instanceof SMGTransferRelation.SMGAddressValue && !this.containsValue(value) && !(address = ((SMGTransferRelation.SMGAddressValue)pValue).getAddress()).isUnknown()) {
            this.addPointsToEdge(address.getObject(), address.getOffset().getAsInt(), value);
        }
        return this.writeValue(pObject, pOffset, pType, value);
    }

    private void addPointsToEdge(SMGObject pObject, int pOffset, int pValue) {
        if (!this.containsValue(pValue)) {
            this.heap.addValue(pValue);
        }
        SMGEdgePointsTo pointsToEdge = new SMGEdgePointsTo(pValue, pObject, pOffset);
        this.heap.addPointsToEdge(pointsToEdge);
    }

    private SMGEdgeHasValue writeValue(SMGObject pObject, int pOffset, CType pType, Integer pValue) throws SMGInconsistentException {
        if (!this.heap.isObjectValid(pObject)) {
            this.setInvalidWrite();
            return null;
        }
        SMGEdgeHasValue new_edge = new SMGEdgeHasValue(pType, pOffset, pObject, (int)pValue);
        SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(pObject);
        Set<SMGEdgeHasValue> edges = this.heap.getHVEdges(filter);
        if (edges.contains(new_edge)) {
            this.performConsistencyCheck(SMGRuntimeCheck.HALF);
            return new_edge;
        }
        if (!this.heap.getValues().contains(pValue)) {
            this.heap.addValue(pValue);
        }
        HashSet<SMGEdgeHasValue> overlappingZeroEdges = new HashSet<SMGEdgeHasValue>();
        for (SMGEdgeHasValue hv : edges) {
            boolean hvEdgeIsZero;
            boolean hvEdgeOverlaps = new_edge.overlapsWith(hv, this.heap.getMachineModel());
            boolean bl = hvEdgeIsZero = hv.getValue() == this.heap.getNullValue();
            if (!hvEdgeOverlaps) continue;
            if (hvEdgeIsZero) {
                overlappingZeroEdges.add(hv);
                continue;
            }
            this.heap.removeHasValueEdge(hv);
        }
        this.shrinkOverlappingZeroEdges(new_edge, overlappingZeroEdges);
        this.heap.addHasValueEdge(new_edge);
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
        return new_edge;
    }

    private void shrinkOverlappingZeroEdges(SMGEdgeHasValue pNew_edge, Set<SMGEdgeHasValue> pOverlappingZeroEdges) {
        SMGObject object = pNew_edge.getObject();
        int offset = pNew_edge.getOffset();
        boolean newEdgePointsToZero = pNew_edge.getValue() == 0;
        MachineModel maModel = this.heap.getMachineModel();
        int sizeOfType = pNew_edge.getSizeInBytes(maModel);
        for (SMGEdgeHasValue zeroEdge : pOverlappingZeroEdges) {
            SMGEdgeHasValue newZeroEdge;
            this.heap.removeHasValueEdge(zeroEdge);
            if (newEdgePointsToZero) continue;
            int zeroEdgeOffset = zeroEdge.getOffset();
            int offset2 = offset + sizeOfType;
            int zeroEdgeOffset2 = zeroEdgeOffset + zeroEdge.getSizeInBytes(maModel);
            if (zeroEdgeOffset < offset) {
                newZeroEdge = new SMGEdgeHasValue(offset - zeroEdgeOffset, zeroEdgeOffset, object, 0);
                this.heap.addHasValueEdge(newZeroEdge);
            }
            if (offset2 >= zeroEdgeOffset2) continue;
            newZeroEdge = new SMGEdgeHasValue(zeroEdgeOffset2 - offset2, offset2, object, 0);
            this.heap.addHasValueEdge(newZeroEdge);
        }
    }

    public void setInvalidWrite() {
        this.invalidWrite = true;
    }

    @Override
    public SMGState join(SMGState reachedState) {
        return null;
    }

    @Override
    public boolean isLessOrEqual(SMGState reachedState) throws SMGInconsistentException {
        SMGJoin join = new SMGJoin(reachedState.heap, this.heap);
        return join.isDefined() && (join.getStatus() == SMGJoinStatus.LEFT_ENTAIL || join.getStatus() == SMGJoinStatus.EQUAL);
    }

    @Override
    public String getCPAName() {
        return "SMGCPA";
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        switch (pProperty) {
            case "has-leaks": {
                if (this.heap.hasMemoryLeaks()) {
                    this.issueMemoryLeakMessage();
                    return true;
                }
                return false;
            }
            case "has-invalid-writes": {
                if (this.invalidWrite) {
                    this.issueInvalidWriteMessage();
                    return true;
                }
                return false;
            }
            case "has-invalid-reads": {
                if (this.invalidRead) {
                    this.issueInvalidReadMessage();
                    return true;
                }
                return false;
            }
            case "has-invalid-frees": {
                if (this.invalidFree) {
                    this.issueInvalidFreeMessage();
                    return true;
                }
                return false;
            }
        }
        throw new InvalidQueryException("Query '" + pProperty + "' is invalid.");
    }

    @Override
    public Object evaluateProperty(String pProperty) throws InvalidQueryException {
        return this.checkProperty(pProperty);
    }

    @Override
    public void modifyProperty(String pModification) throws InvalidQueryException {
    }

    public void addGlobalObject(SMGRegion newObject) {
        this.heap.addGlobalObject(newObject);
    }

    public boolean isGlobal(String variable) {
        return this.heap.getGlobalObjects().containsValue(this.heap.getObjectForVisibleVariable(variable));
    }

    public boolean isGlobal(SMGObject object) {
        return this.heap.getGlobalObjects().containsValue(object);
    }

    public boolean isHeapObject(SMGObject object) {
        return this.heap.getHeapObjects().contains(object);
    }

    public SMGEdgePointsTo addNewHeapAllocation(int pSize, String pLabel) throws SMGInconsistentException {
        SMGRegion new_object = new SMGRegion(pSize, pLabel);
        int new_value = SMGValueFactory.getNewValue();
        SMGEdgePointsTo points_to = new SMGEdgePointsTo(new_value, new_object, 0);
        this.heap.addHeapObject(new_object);
        this.heap.addValue(new_value);
        this.heap.addPointsToEdge(points_to);
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
        return points_to;
    }

    public void setMemLeak() {
        this.heap.setMemoryLeak();
    }

    public boolean containsValue(int value) {
        return this.heap.getValues().contains(value);
    }

    @Nullable
    public Integer getAddress(SMGObject memory, int offset) {
        Map<Integer, SMGEdgePointsTo> pointsToEdges = this.heap.getPTEdges();
        for (SMGEdgePointsTo edge : pointsToEdges.values()) {
            if (!edge.getObject().equals(memory) || edge.getOffset() != offset) continue;
            return edge.getValue();
        }
        return null;
    }

    public void free(Integer address, Integer offset, SMGObject smgObject) throws SMGInconsistentException {
        if (!this.heap.isHeapObject(smgObject)) {
            this.setInvalidFree();
            return;
        }
        if (offset != 0) {
            this.setInvalidFree();
            return;
        }
        if (!this.heap.isObjectValid(smgObject)) {
            this.setInvalidFree();
            return;
        }
        if (!(smgObject instanceof SMGRegion)) {
            this.setInvalidFree();
            return;
        }
        this.heap.setValidity((SMGRegion)smgObject, false);
        SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(smgObject);
        ArrayList<SMGEdgeHasValue> to_remove = new ArrayList<SMGEdgeHasValue>();
        for (SMGEdgeHasValue edge : this.heap.getHVEdges(filter)) {
            to_remove.add(edge);
        }
        for (SMGEdgeHasValue edge : to_remove) {
            this.heap.removeHasValueEdge(edge);
        }
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
    }

    public boolean isUnequal(int value1, int value2) {
        if (this.isPointer(value1) && this.isPointer(value2)) {
            if (value1 != value2) {
                SMGEdgePointsTo edge2;
                SMGEdgePointsTo edge1;
                try {
                    edge1 = this.getPointerFromValue(value1);
                    edge2 = this.getPointerFromValue(value2);
                }
                catch (SMGInconsistentException e) {
                    throw new AssertionError((Object)e.getMessage());
                }
                return edge1.getObject() != edge2.getObject() || edge1.getOffset() != edge2.getOffset();
            }
            return false;
        }
        return this.heap.haveNeqRelation(value1, value2);
    }

    public void dropStackFrame() throws SMGInconsistentException {
        this.heap.dropStackFrame();
        this.performConsistencyCheck(SMGRuntimeCheck.FULL);
    }

    public void pruneUnreachable() throws SMGInconsistentException {
        this.heap.pruneUnreachable();
        this.performConsistencyCheck(SMGRuntimeCheck.HALF);
    }

    public void setInvalidFree() {
        this.invalidFree = true;
    }

    public Set<SMGEdgeHasValue> getHVEdges(SMGEdgeHasValueFilter pFilter) {
        return this.heap.getHVEdges(pFilter);
    }

    @Nullable
    public ValueAnalysisState.MemoryLocation resolveMemLoc(SMGTransferRelation.SMGAddress pValue, String pFunctionName) {
        SMGObject object = pValue.getObject();
        long offset = pValue.getOffset().getAsLong();
        if (this.isGlobal(object) || this.isHeapObject(object)) {
            return ValueAnalysisState.MemoryLocation.valueOf(object.getLabel(), offset);
        }
        return ValueAnalysisState.MemoryLocation.valueOf(pFunctionName, object.getLabel(), offset);
    }

    public void copy(SMGObject pSource, SMGObject pTarget, int pSourceRangeOffset, int pSourceRangeSize, int pTargetRangeOffset) throws SMGInconsistentException {
        int copyRange = pSourceRangeSize - pSourceRangeOffset;
        assert (pSource.getSize() >= pSourceRangeSize);
        assert (pSourceRangeOffset >= 0);
        assert (pTargetRangeOffset >= 0);
        assert (copyRange >= 0);
        assert (copyRange <= pTarget.getSize());
        if (copyRange == 0) {
            return;
        }
        int targetRangeSize = pTargetRangeOffset + copyRange;
        SMGEdgeHasValueFilter filterSource = new SMGEdgeHasValueFilter();
        filterSource.filterByObject(pSource);
        SMGEdgeHasValueFilter filterTarget = new SMGEdgeHasValueFilter();
        filterTarget.filterByObject(pTarget);
        Set<SMGEdgeHasValue> targetEdges = this.getHVEdges(filterTarget);
        for (SMGEdgeHasValue edge : targetEdges) {
            if (!edge.overlapsWith(pTargetRangeOffset, targetRangeSize, this.heap.getMachineModel())) continue;
            this.heap.removeHasValueEdge(edge);
        }
        Set<SMGEdgeHasValue> sourceEdges = this.getHVEdges(filterSource);
        int copyShift = pTargetRangeOffset - pSourceRangeOffset;
        for (SMGEdgeHasValue edge : sourceEdges) {
            if (!edge.overlapsWith(pSourceRangeOffset, pSourceRangeSize, this.heap.getMachineModel())) continue;
            int offset = edge.getOffset() + copyShift;
            this.writeValue(pTarget, offset, edge.getType(), edge.getValue());
        }
        this.performConsistencyCheck(SMGRuntimeCheck.FULL);
        this.heap.pruneUnreachable();
        this.performConsistencyCheck(SMGRuntimeCheck.FULL);
    }

    public void setUnknownDereference() {
        this.invalidWrite = true;
    }

    public SMGObject getNullObject() {
        return this.heap.getNullObject();
    }

    public void identifyEqualValues(SMGTransferRelation.SMGKnownSymValue pKnownVal1, SMGTransferRelation.SMGKnownSymValue pKnownVal2) {
        this.heap.mergeValues(pKnownVal1.getAsInt(), pKnownVal2.getAsInt());
    }

    public void identifyNonEqualValues(SMGTransferRelation.SMGKnownSymValue pKnownVal1, SMGTransferRelation.SMGKnownSymValue pKnownVal2) {
        this.heap.addNeqRelation(pKnownVal1.getAsInt(), pKnownVal2.getAsInt());
    }

    public void putExplicit(SMGTransferRelation.SMGKnownSymValue pKey, SMGTransferRelation.SMGKnownExpValue pValue) {
        this.explicitValues.put(pKey, pValue);
    }

    public void clearExplicit(SMGTransferRelation.SMGKnownSymValue pKey) {
        this.explicitValues.remove(pKey);
    }

    public SMGTransferRelation.SMGExplicitValue getExplicit(SMGTransferRelation.SMGKnownSymValue pKey) {
        if (this.explicitValues.containsKey(pKey)) {
            return this.explicitValues.get(pKey);
        }
        return SMGTransferRelation.SMGUnknownValue.getInstance();
    }
}

