/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smgfork;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.smgfork.AnonymousTypes;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGExpressionEvaluator;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGState;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGValueFactory;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGObject;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;

@Options(prefix="cpa.smgfork")
public class SMGTransferRelation
extends SingleEdgeTransferRelation {
    @Option(secure=true, name="exportSMG.file", description="Filename format for SMG graph dumps")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path exportSMGFilePattern = Paths.get((String)"smg-%s.dot", (String[])new String[0]);
    @Option(secure=true, description="with this option enabled, a check for unreachable memory occurs whenever a function returns, and not only at the end of the main function")
    private boolean checkForMemLeaksAtEveryFrameDrop = true;
    @Option(secure=true, description="with this option enabled, memory that is not freed before the end of main is reported as memleak even if it is reachable from local variables in main")
    private boolean handleNonFreedMemoryInMainAsMemLeak = false;
    @Option(secure=true, name="exportSMGwhen", description="Describes when SMG graphs should be dumped. One of: {never, leaf, interesting, every}")
    private String exportSMG = "never";
    @Option(secure=true, name="enableMallocFail", description="If this Option is enabled, failure of mallocis simulated")
    private boolean enableMallocFailure = true;
    @Option(secure=true, name="handleUnknownFunctions", description="Sets how unknown functions are handled. One of: {strict, assume_safe}")
    private String handleUnknownFunctions = "strict";
    private final LogManagerWithoutDuplicates logger;
    private final MachineModel machineModel;
    private final SMGRightHandSideEvaluator expressionEvaluator;
    private boolean possibleMallocFail;
    private SMGState mallocFailState;
    public static final String FUNCTION_RETURN_VAR = "___cpa_temp_result_var_";
    private final SMGBuiltins builtins = new SMGBuiltins();

    private void plotWhenConfigured(String pConfig, String pName, SMGState pState, String pLocation) {
        if (pConfig.equals(this.exportSMG)) {
            this.builtins.dumpSMGPlot(pName, pState, pLocation);
        }
    }

    public SMGTransferRelation(Configuration config, LogManager pLogger, MachineModel pMachineModel) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = new LogManagerWithoutDuplicates(pLogger);
        this.machineModel = pMachineModel;
        this.expressionEvaluator = new SMGRightHandSideEvaluator(this.logger, this.machineModel);
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState state, Precision precision, CFAEdge cfaEdge) throws CPATransferException, InterruptedException {
        ImmutableSet result;
        SMGState successor;
        this.logger.log(Level.FINEST, new Object[]{"SMG GetSuccessor >>"});
        this.logger.log(Level.FINEST, new Object[]{"Edge:", cfaEdge.getEdgeType()});
        this.logger.log(Level.FINEST, new Object[]{"Code:", cfaEdge.getCode()});
        SMGState smgState = (SMGState)state;
        switch (cfaEdge.getEdgeType()) {
            case DeclarationEdge: {
                successor = this.handleDeclaration(smgState, (CDeclarationEdge)cfaEdge);
                break;
            }
            case StatementEdge: {
                successor = this.handleStatement(smgState, (CStatementEdge)cfaEdge);
                this.plotWhenConfigured("interesting", null, successor, cfaEdge.getDescription());
                break;
            }
            case AssumeEdge: {
                CAssumeEdge assumeEdge = (CAssumeEdge)cfaEdge;
                successor = this.handleAssumption(smgState, assumeEdge.getExpression(), cfaEdge, assumeEdge.getTruthAssumption());
                this.plotWhenConfigured("interesting", null, successor, cfaEdge.getDescription());
                break;
            }
            case FunctionCallEdge: {
                CFunctionCallEdge functionCallEdge = (CFunctionCallEdge)cfaEdge;
                successor = this.handleFunctionCall(smgState, functionCallEdge);
                this.plotWhenConfigured("interesting", null, successor, cfaEdge.getDescription());
                break;
            }
            case FunctionReturnEdge: {
                CFunctionReturnEdge functionReturnEdge = (CFunctionReturnEdge)cfaEdge;
                successor = this.handleFunctionReturn(smgState, functionReturnEdge);
                successor.dropStackFrame();
                if (this.checkForMemLeaksAtEveryFrameDrop) {
                    successor.pruneUnreachable();
                }
                this.plotWhenConfigured("interesting", null, successor, cfaEdge.getDescription());
                break;
            }
            case ReturnStatementEdge: {
                CReturnStatementEdge returnEdge = (CReturnStatementEdge)cfaEdge;
                successor = this.handleExitFromFunction(smgState, returnEdge);
                if (returnEdge.getSuccessor().getNumLeavingEdges() == 0) {
                    if (this.handleNonFreedMemoryInMainAsMemLeak) {
                        successor.dropStackFrame();
                    }
                    successor.pruneUnreachable();
                }
                this.plotWhenConfigured("interesting", null, successor, cfaEdge.getDescription());
                break;
            }
            default: {
                successor = smgState;
            }
        }
        if (successor == null) {
            result = Collections.emptySet();
        } else if (this.mallocFailState != null && this.enableMallocFailure) {
            successor.setPredecessor(smgState);
            this.mallocFailState.setPredecessor(smgState);
            result = ImmutableSet.of((Object)successor, (Object)this.mallocFailState);
            this.mallocFailState = null;
        } else {
            successor.setPredecessor(smgState);
            result = Collections.singleton(successor);
        }
        for (SMGState smg : result) {
            this.plotWhenConfigured("every", null, smg, cfaEdge.getDescription());
        }
        return result;
    }

    private SMGState handleExitFromFunction(SMGState smgState, CReturnStatementEdge returnEdge) throws CPATransferException {
        CExpression returnExp = (CExpression)returnEdge.getExpression().or((Object)CIntegerLiteralExpression.ZERO);
        this.logger.log(Level.FINEST, new Object[]{"Handling return Statement: ", returnExp});
        CType expType = this.expressionEvaluator.getRealExpressionType(returnExp);
        SMGObject tmpFieldMemory = smgState.getFunctionReturnObject();
        if (tmpFieldMemory != null) {
            return this.handleAssignmentToField(smgState, returnEdge, tmpFieldMemory, 0, expType, returnExp);
        }
        return smgState;
    }

    private SMGState handleFunctionReturn(SMGState smgState, CFunctionReturnEdge functionReturnEdge) throws CPATransferException {
        this.logger.log(Level.FINEST, new Object[]{"Handling function return"});
        CFunctionSummaryEdge summaryEdge = functionReturnEdge.getSummaryEdge();
        CFunctionCall exprOnSummary = summaryEdge.getExpression();
        SMGState newState = new SMGState(smgState);
        SMGState tmpState = new SMGState(smgState);
        tmpState.dropStackFrame();
        tmpState.pruneUnreachable();
        if (exprOnSummary instanceof CFunctionCallAssignmentStatement) {
            CLeftHandSide lValue = ((CFunctionCallAssignmentStatement)exprOnSummary).getLeftHandSide();
            CType lValueType = this.expressionEvaluator.getRealExpressionType(lValue);
            CType rValueType = this.expressionEvaluator.getRealExpressionType(((CFunctionCallAssignmentStatement)exprOnSummary).getRightHandSide());
            SMGSymbolicValue rValue = this.getFunctionReturnValue(newState, rValueType, functionReturnEdge);
            SMGAddress address = null;
            SMGExpressionEvaluator.LValueAssignmentVisitor visitor = this.expressionEvaluator.getLValueAssignmentVisitor(functionReturnEdge, tmpState);
            address = lValue.accept(visitor);
            if (!address.isUnknown()) {
                if (rValue.isUnknown()) {
                    rValue = SMGKnownSymValue.valueOf(SMGValueFactory.getNewValue());
                }
                SMGObject object = address.getObject();
                int offset = address.getOffset().getAsInt();
                this.assignFieldToState(newState, functionReturnEdge, object, offset, lValueType, rValue, rValueType);
            }
        }
        return newState;
    }

    private SMGSymbolicValue getFunctionReturnValue(SMGState smgState, CType type, CFAEdge pCFAEdge) throws SMGInconsistentException, UnrecognizedCCodeException {
        SMGObject tmpMemory = smgState.getFunctionReturnObject();
        return this.expressionEvaluator.readValue(smgState, tmpMemory, SMGKnownExpValue.ZERO, type, pCFAEdge);
    }

    private SMGState handleFunctionCall(SMGState smgState, CFunctionCallEdge callEdge) throws CPATransferException, SMGInconsistentException {
        CFunctionEntryNode functionEntryNode = callEdge.getSuccessor();
        this.logger.log(Level.FINEST, new Object[]{"Handling function call: ", functionEntryNode.getFunctionName()});
        SMGState newState = new SMGState(smgState);
        CFunctionDeclaration functionDeclaration = functionEntryNode.getFunctionDefinition();
        newState.addStackFrame(functionDeclaration);
        List<CParameterDeclaration> paramDecl = functionEntryNode.getFunctionParameters();
        List<CExpression> arguments = callEdge.getArguments();
        if (!callEdge.getSuccessor().getFunctionDefinition().getType().takesVarArgs()) assert (paramDecl.size() == arguments.size());
        for (int i = 0; i < paramDecl.size(); ++i) {
            CExpression exp = arguments.get(i);
            String varName = paramDecl.get(i).getName();
            CType cType = this.expressionEvaluator.getRealExpressionType(paramDecl.get(i));
            SMGObject newObject = newState.addLocalVariable(cType, varName);
            this.assignFieldToState(newState, smgState, callEdge, newObject, 0, cType, exp);
        }
        return newState;
    }

    private SMGState handleAssumption(SMGState smgState, CExpression expression, CFAEdge cfaEdge, boolean truthValue) throws CPATransferException {
        SMGExpressionEvaluator.AssumeVisitor visitor = this.expressionEvaluator.getAssumeVisitor(cfaEdge, smgState);
        SMGSymbolicValue value = expression.accept(visitor);
        if (!value.isUnknown()) {
            if (truthValue && value.equals(SMGKnownSymValue.TRUE) || !truthValue && value.equals(SMGKnownSymValue.FALSE)) {
                return smgState;
            }
            return null;
        }
        SMGExplicitValue explicitValue = this.expressionEvaluator.evaluateExplicitValue(smgState, cfaEdge, expression);
        if (explicitValue.isUnknown()) {
            SMGState newState = new SMGState(smgState);
            this.expressionEvaluator.deriveFurtherInformation(newState, truthValue, cfaEdge, expression);
            return newState;
        }
        if (truthValue && explicitValue.equals(SMGKnownExpValue.ONE) || !truthValue && explicitValue.equals(SMGKnownExpValue.ZERO)) {
            return smgState;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SMGState handleStatement(SMGState pState, CStatementEdge pCfaEdge) throws CPATransferException {
        this.logger.log(Level.FINEST, new Object[]{">>> Handling statement"});
        CStatement cStmt = pCfaEdge.getStatement();
        if (cStmt instanceof CAssignment) {
            CAssignment cAssignment = (CAssignment)cStmt;
            CLeftHandSide lValue = cAssignment.getLeftHandSide();
            CRightHandSide rValue = cAssignment.getRightHandSide();
            return this.handleAssignment(pState, pCfaEdge, lValue, rValue);
        }
        if (!(cStmt instanceof CFunctionCallStatement)) return new SMGState(pState);
        CFunctionCallStatement cFCall = (CFunctionCallStatement)cStmt;
        CFunctionCallExpression cFCExpression = cFCall.getFunctionCallExpression();
        CExpression fileNameExpression = cFCExpression.getFunctionNameExpression();
        String functionName = fileNameExpression.toASTString();
        if (this.builtins.isABuiltIn(functionName)) {
            SMGState newState = new SMGState(pState);
            switch (functionName) {
                case "__VERIFIER_BUILTIN_PLOT": {
                    this.builtins.evaluateVBPlot(cFCExpression, newState);
                    return newState;
                }
                case "free": {
                    this.builtins.evaluateFree(cFCExpression, newState, pCfaEdge);
                    return newState;
                }
                case "malloc": {
                    this.logger.log(Level.WARNING, new Object[]{pCfaEdge.getFileLocation() + ":", "Calling malloc and not using the result, resulting in memory leak."});
                    newState.setMemLeak();
                    return newState;
                }
                case "calloc": {
                    this.logger.log(Level.WARNING, new Object[]{pCfaEdge.getFileLocation() + ":", "Calling calloc and not using the result, resulting in memory leak."});
                    newState.setMemLeak();
                    return newState;
                }
                case "memset": {
                    this.builtins.evaluateMemset(cFCExpression, newState, pCfaEdge);
                    return newState;
                }
                case "printf": {
                    return new SMGState(pState);
                }
            }
            return newState;
        } else {
            switch (this.handleUnknownFunctions) {
                case "strict": {
                    throw new CPATransferException("Unknown function '" + functionName + "' may be unsafe. See the cpa.smg.handleUnknownFunction option.");
                }
                case "assume_safe": {
                    return new SMGState(pState);
                }
            }
            throw new AssertionError();
        }
    }

    private SMGState handleAssignment(SMGState state, CFAEdge cfaEdge, CExpression lValue, CRightHandSide rValue) throws CPATransferException {
        this.logger.log(Level.FINEST, new Object[]{"Handling assignment:", lValue, "=", rValue});
        SMGExpressionEvaluator.LValueAssignmentVisitor visitor = this.expressionEvaluator.getLValueAssignmentVisitor(cfaEdge, state);
        SMGAddress addressOfField = lValue.accept(visitor);
        CType fieldType = this.expressionEvaluator.getRealExpressionType(lValue);
        if (addressOfField.isUnknown()) {
            return new SMGState(state);
        }
        SMGState newState = this.handleAssignmentToField(state, cfaEdge, addressOfField.getObject(), addressOfField.getOffset().getAsInt(), fieldType, rValue);
        return newState;
    }

    private void assignFieldToState(SMGState newState, CFAEdge cfaEdge, SMGObject memoryOfField, int fieldOffset, CType pFieldType, CRightHandSide rValue) throws CPATransferException {
        this.assignFieldToState(newState, newState, cfaEdge, memoryOfField, fieldOffset, pFieldType, rValue);
    }

    private void assignFieldToState(SMGState newState, SMGState readState, CFAEdge cfaEdge, SMGObject memoryOfField, int fieldOffset, CType pFieldType, CRightHandSide rValue) throws CPATransferException {
        CType rValueType = this.expressionEvaluator.getRealExpressionType(rValue);
        SMGSymbolicValue value = this.expressionEvaluator.evaluateExpressionValue(readState, cfaEdge, rValue);
        if (value.isUnknown()) {
            if (this.expressionEvaluator.isMissingExplicitInformation()) {
                this.expressionEvaluator.reset();
            }
            value = SMGKnownSymValue.valueOf(SMGValueFactory.getNewValue());
        }
        SMGExpressionEvaluator expEvaluator = new SMGExpressionEvaluator(this.logger, this.machineModel);
        SMGExplicitValue expValue = expEvaluator.evaluateExplicitValue(newState, cfaEdge, rValue);
        this.assignFieldToState(newState, cfaEdge, memoryOfField, fieldOffset, pFieldType, value, rValueType);
        if (!expValue.isUnknown()) {
            newState.putExplicit((SMGKnownSymValue)value, (SMGKnownExpValue)expValue);
        }
    }

    private void assignFieldToState(SMGState newState, CFAEdge cfaEdge, SMGObject memoryOfField, int fieldOffset, CType pFieldType, SMGSymbolicValue value, CType rValueType) throws UnrecognizedCCodeException, SMGInconsistentException {
        if (memoryOfField.getSize() < this.expressionEvaluator.getSizeof(cfaEdge, rValueType)) {
            this.logger.log(Level.WARNING, new Object[]{cfaEdge.getFileLocation() + ":", "Attempting to write " + this.expressionEvaluator.getSizeof(cfaEdge, rValueType) + " bytes into a field with size " + memoryOfField.getSize() + "bytes:", cfaEdge.getRawStatement()});
        }
        if (this.expressionEvaluator.isStructOrUnionType(rValueType)) {
            this.assignStruct(newState, memoryOfField, fieldOffset, rValueType, value, cfaEdge);
        } else {
            this.writeValue(newState, memoryOfField, fieldOffset, rValueType, value, cfaEdge);
        }
    }

    private void assignStruct(SMGState pNewState, SMGObject pMemoryOfField, int pFieldOffset, CType pRValueType, SMGSymbolicValue pValue, CFAEdge pCfaEdge) throws SMGInconsistentException, UnrecognizedCCodeException {
        if (pValue instanceof SMGKnownAddVal) {
            SMGKnownAddVal structAddress = (SMGKnownAddVal)pValue;
            SMGObject source = structAddress.getObject();
            int structOffset = structAddress.getOffset().getAsInt();
            int structSize = structOffset + this.expressionEvaluator.getSizeof(pCfaEdge, pRValueType);
            pNewState.copy(source, pMemoryOfField, structOffset, structSize, pFieldOffset);
        }
    }

    private void writeValue(SMGState pNewState, SMGObject pMemoryOfField, int pFieldOffset, long pSizeType, SMGSymbolicValue pValue, CFAEdge pEdge) throws UnrecognizedCCodeException, SMGInconsistentException {
        this.writeValue(pNewState, pMemoryOfField, pFieldOffset, AnonymousTypes.createTypeWithLength(pSizeType), pValue, pEdge);
    }

    private void writeValue(SMGState pNewState, SMGObject pMemoryOfField, int pFieldOffset, CType pRValueType, SMGSymbolicValue pValue, CFAEdge pEdge) throws SMGInconsistentException, UnrecognizedCCodeException {
        boolean doesNotFitIntoObject;
        boolean bl = doesNotFitIntoObject = pFieldOffset < 0 || pFieldOffset + this.expressionEvaluator.getSizeof(pEdge, pRValueType) > pMemoryOfField.getSize();
        if (doesNotFitIntoObject) {
            this.logger.log(Level.WARNING, new Object[]{pEdge.getFileLocation() + ":", "Field (" + pFieldOffset + ", " + pRValueType.toASTString("") + ")" + " does not fit object " + pMemoryOfField.toString() + "."});
            pNewState.setInvalidWrite();
            return;
        }
        if (pValue.isUnknown() || pNewState == null) {
            return;
        }
        pNewState.writeValue(pMemoryOfField, pFieldOffset, pRValueType, pValue);
    }

    private SMGState handleAssignmentToField(SMGState state, CFAEdge cfaEdge, SMGObject memoryOfField, int fieldOffset, CType pFieldType, CRightHandSide rValue) throws CPATransferException {
        SMGState newState = new SMGState(state);
        this.assignFieldToState(newState, cfaEdge, memoryOfField, fieldOffset, pFieldType, rValue);
        if (this.possibleMallocFail) {
            this.possibleMallocFail = false;
            SMGState otherState = new SMGState(state);
            CType rValueType = this.expressionEvaluator.getRealExpressionType(rValue);
            this.writeValue(otherState, memoryOfField, fieldOffset, rValueType, (SMGSymbolicValue)SMGKnownSymValue.ZERO, cfaEdge);
            this.mallocFailState = otherState;
        }
        return newState;
    }

    private SMGState handleVariableDeclaration(SMGState pState, CVariableDeclaration pVarDecl, CDeclarationEdge pEdge) throws CPATransferException {
        SMGObject newObject;
        this.logger.log(Level.FINEST, new Object[]{"Handling variable declaration:", pVarDecl});
        String varName = pVarDecl.getName();
        CType cType = this.expressionEvaluator.getRealExpressionType(pVarDecl);
        if (pVarDecl.isGlobal()) {
            newObject = pState.addGlobalVariable(cType, varName);
        } else {
            newObject = pState.getObjectForVisibleVariable(varName);
            if (newObject == null) {
                newObject = pState.addLocalVariable(cType, varName);
            }
        }
        pState = this.handleInitializerForDeclaration(pState, newObject, pVarDecl, pEdge);
        return pState;
    }

    private SMGState handleDeclaration(SMGState smgState, CDeclarationEdge edge) throws CPATransferException {
        this.logger.log(Level.FINEST, new Object[]{">>> Handling declaration"});
        SMGState newState = new SMGState(smgState);
        CDeclaration cDecl = edge.getDeclaration();
        if (cDecl instanceof CVariableDeclaration) {
            newState = this.handleVariableDeclaration(newState, (CVariableDeclaration)cDecl, edge);
        }
        return newState;
    }

    private SMGState handleInitializerForDeclaration(SMGState pState, SMGObject pObject, CVariableDeclaration pVarDecl, CDeclarationEdge pEdge) throws CPATransferException {
        CInitializer newInitializer = pVarDecl.getInitializer();
        CType cType = this.expressionEvaluator.getRealExpressionType(pVarDecl);
        if (newInitializer != null) {
            this.logger.log(Level.FINEST, new Object[]{"Handling variable declaration: handling initializer"});
            return this.handleInitializer(pState, pVarDecl, pEdge, pObject, 0, cType, newInitializer);
        }
        if (pVarDecl.isGlobal()) {
            pState.writeValue(pObject, 0, cType, SMGKnownSymValue.ZERO);
        }
        return pState;
    }

    private SMGState handleInitializer(SMGState pNewState, CVariableDeclaration pVarDecl, CFAEdge pEdge, SMGObject pNewObject, int pOffset, CType pLValueType, CInitializer pInitializer) throws UnrecognizedCCodeException, CPATransferException {
        if (pInitializer instanceof CInitializerExpression) {
            return this.handleAssignmentToField(pNewState, pEdge, pNewObject, pOffset, pLValueType, ((CInitializerExpression)pInitializer).getExpression());
        }
        if (pInitializer instanceof CInitializerList) {
            return this.handleInitializerList(pNewState, pVarDecl, pEdge, pNewObject, pOffset, pLValueType, (CInitializerList)pInitializer);
        }
        if (pInitializer instanceof CDesignatedInitializer) {
            return pNewState;
        }
        throw new UnrecognizedCCodeException("Did not recognize Initializer", pInitializer);
    }

    private SMGState handleInitializerList(SMGState pNewState, CVariableDeclaration pVarDecl, CFAEdge pEdge, SMGObject pNewObject, int pOffset, CType pLValueType, CInitializerList pNewInitializer) throws UnrecognizedCCodeException, CPATransferException {
        CType realCType = pLValueType.getCanonicalType();
        if (realCType instanceof CArrayType) {
            CArrayType arrayType = (CArrayType)realCType;
            return this.handleInitializerList(pNewState, pVarDecl, pEdge, pNewObject, pOffset, arrayType, pNewInitializer);
        }
        if (realCType instanceof CCompositeType) {
            CCompositeType structType = (CCompositeType)realCType;
            return this.handleInitializerList(pNewState, pVarDecl, pEdge, pNewObject, pOffset, structType, pNewInitializer);
        }
        this.logger.log(Level.WARNING, new Object[]{"Type " + realCType.toASTString("") + "cannot be resolved sufficiently to handle initializer " + pNewInitializer.toASTString()});
        return pNewState;
    }

    private SMGState handleInitializerList(SMGState pNewState, CVariableDeclaration pVarDecl, CFAEdge pEdge, SMGObject pNewObject, int pOffset, CCompositeType pLValueType, CInitializerList pNewInitializer) throws UnrecognizedCCodeException, CPATransferException {
        int sizeOfType;
        int listCounter = 0;
        List<CCompositeType.CCompositeTypeMemberDeclaration> memberTypes = pLValueType.getMembers();
        int offset = pOffset;
        for (CInitializer initializer : pNewInitializer.getInitializers()) {
            if (listCounter >= memberTypes.size()) {
                throw new UnrecognizedCCodeException("More Initializer in initializer list " + pNewInitializer.toASTString() + " than fit in type " + pLValueType.toASTString(""), pEdge);
            }
            CType memberType = memberTypes.get(listCounter).getType();
            pNewState = this.handleInitializer(pNewState, pVarDecl, pEdge, pNewObject, offset, memberType, initializer);
            offset += this.expressionEvaluator.getSizeof(pEdge, memberType);
            ++listCounter;
        }
        if (pVarDecl.isGlobal() && offset < (sizeOfType = this.expressionEvaluator.getSizeof(pEdge, pLValueType))) {
            pNewState.writeValue(pNewObject, offset, AnonymousTypes.createTypeWithLength(sizeOfType), SMGKnownSymValue.ZERO);
        }
        return pNewState;
    }

    private SMGState handleInitializerList(SMGState pNewState, CVariableDeclaration pVarDecl, CFAEdge pEdge, SMGObject pNewObject, int pOffset, CArrayType pLValueType, CInitializerList pNewInitializer) throws UnrecognizedCCodeException, CPATransferException {
        int sizeOfType;
        int offset;
        int listCounter = 0;
        CType elementType = pLValueType.getType();
        int sizeOfElementType = this.expressionEvaluator.getSizeof(pEdge, elementType);
        for (CInitializer initializer : pNewInitializer.getInitializers()) {
            int offset2 = pOffset + listCounter * sizeOfElementType;
            pNewState = this.handleInitializer(pNewState, pVarDecl, pEdge, pNewObject, offset2, pLValueType.getType(), initializer);
            ++listCounter;
        }
        if (pVarDecl.isGlobal() && (offset = pOffset + listCounter * sizeOfElementType) < (sizeOfType = this.expressionEvaluator.getSizeof(pEdge, pLValueType))) {
            pNewState.writeValue(pNewObject, offset, AnonymousTypes.createTypeWithLength(sizeOfType - offset), SMGKnownSymValue.ZERO);
        }
        return pNewState;
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState element, List<AbstractState> elements, CFAEdge cfaEdge, Precision pPrecision) throws CPATransferException, InterruptedException {
        Collection<? extends AbstractState> retVal = null;
        for (AbstractState ae : elements) {
            if (!(ae instanceof AutomatonState)) continue;
            this.strengthen((AutomatonState)ae, (SMGState)element, cfaEdge);
        }
        this.possibleMallocFail = false;
        return retVal;
    }

    private Collection<? extends AbstractState> strengthen(AutomatonState pAutomatonState, SMGState pElement, CFAEdge pCfaEdge) throws CPATransferException {
        List<AssumeEdge> assumptions = pAutomatonState.getAsAssumeEdges(pCfaEdge.getPredecessor().getFunctionName());
        SMGState newElement = new SMGState(pElement);
        for (AssumeEdge assume : assumptions) {
            if (assume instanceof CAssumeEdge && (newElement = this.handleAssumption(newElement, ((CAssumeEdge)assume).getExpression(), pCfaEdge, assume.getTruthAssumption())) == null) break;
        }
        if (newElement == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(newElement);
    }

    public static class SMGAddress {
        public static final SMGAddress UNKNOWN = new SMGAddress(null, SMGUnknownValue.getInstance());
        private final SMGObject object;
        private final SMGExplicitValue offset;

        private SMGAddress(SMGObject pObject, SMGExplicitValue pOffset) {
            Preconditions.checkNotNull((Object)pOffset);
            this.object = pObject;
            this.offset = pOffset;
        }

        public final boolean isUnknown() {
            return this.object == null || this.offset.isUnknown();
        }

        public final SMGAddress add(SMGExplicitValue pAddedOffset) {
            if (this.object == null || this.offset.isUnknown() || pAddedOffset.isUnknown()) {
                return UNKNOWN;
            }
            return SMGAddress.valueOf(this.object, this.offset.add(pAddedOffset));
        }

        public SMGExplicitValue getOffset() {
            return this.offset;
        }

        public SMGObject getObject() {
            return this.object;
        }

        public static final SMGAddress valueOf(SMGObject object, SMGExplicitValue offset) {
            return new SMGAddress(object, offset);
        }

        public final String toString() {
            if (this.isUnknown()) {
                return "Unkown";
            }
            return "Object: " + this.object.toString() + " Offset: " + this.offset.toString();
        }

        public static SMGAddress valueOf(SMGObject pObj, int pOffset) {
            return new SMGAddress(pObj, SMGKnownExpValue.valueOf(pOffset));
        }
    }

    public static final class SMGKnownAddVal
    extends SMGKnownSymValue
    implements SMGAddressValue {
        private final SMGKnownAddress address;

        private SMGKnownAddVal(BigInteger pValue, SMGKnownAddress pAddress) {
            super(pValue);
            Preconditions.checkNotNull((Object)pAddress);
            this.address = pAddress;
        }

        public static SMGKnownAddVal valueOf(SMGObject pObject, SMGKnownExpValue pOffset, SMGKnownSymValue pAddress) {
            return new SMGKnownAddVal(pAddress.getValue(), SMGKnownAddress.valueOf(pObject, pOffset));
        }

        @Override
        public SMGKnownAddress getAddress() {
            return this.address;
        }

        public static SMGKnownAddVal valueOf(BigInteger pValue, SMGKnownAddress pAddress) {
            return new SMGKnownAddVal(pValue, pAddress);
        }

        public static SMGKnownAddVal valueOf(SMGKnownSymValue pValue, SMGKnownAddress pAddress) {
            return new SMGKnownAddVal(pValue.getValue(), pAddress);
        }

        public static SMGKnownAddVal valueOf(int pValue, SMGKnownAddress pAddress) {
            return new SMGKnownAddVal(BigInteger.valueOf(pValue), pAddress);
        }

        public static SMGKnownAddVal valueOf(long pValue, SMGKnownAddress pAddress) {
            return new SMGKnownAddVal(BigInteger.valueOf(pValue), pAddress);
        }

        public static SMGKnownAddVal valueOf(int pValue, SMGObject object, int offset) {
            return new SMGKnownAddVal(BigInteger.valueOf(pValue), SMGKnownAddress.valueOf(object, offset));
        }

        @Override
        public String toString() {
            return "Value: " + super.toString() + " " + this.address.toString();
        }

        @Override
        public SMGKnownExpValue getOffset() {
            return this.address.getOffset();
        }

        @Override
        public SMGObject getObject() {
            return this.address.getObject();
        }

        private static class SMGKnownAddress
        extends SMGAddress {
            private SMGKnownAddress(SMGObject pObject, SMGKnownExpValue pOffset) {
                super(pObject, pOffset);
            }

            public static SMGKnownAddress valueOf(SMGObject pObject, int pOffset) {
                return new SMGKnownAddress(pObject, SMGKnownExpValue.valueOf(pOffset));
            }

            public static final SMGKnownAddress valueOf(SMGObject object, SMGKnownExpValue offset) {
                return new SMGKnownAddress(object, offset);
            }

            @Override
            public SMGKnownExpValue getOffset() {
                return (SMGKnownExpValue)super.getOffset();
            }

            @Override
            public SMGObject getObject() {
                return super.getObject();
            }
        }
    }

    public static final class SMGField {
        private static final SMGField UNKNOWN = new SMGField(SMGUnknownValue.getInstance(), new CProblemType("unknown"));
        private final SMGExplicitValue offset;
        private final CType type;

        public SMGField(SMGExplicitValue pOffset, CType pType) {
            Preconditions.checkNotNull((Object)pOffset);
            Preconditions.checkNotNull((Object)pType);
            this.offset = pOffset;
            this.type = pType;
        }

        public SMGExplicitValue getOffset() {
            return this.offset;
        }

        public CType getType() {
            return this.type;
        }

        public boolean isUnknown() {
            return this.offset.isUnknown() || this.type instanceof CProblemType;
        }

        public String toString() {
            return "offset: " + this.offset + "Type:" + this.type.toASTString("");
        }

        public static SMGField getUnknownInstance() {
            return UNKNOWN;
        }
    }

    public static final class SMGUnknownValue
    implements SMGSymbolicValue,
    SMGExplicitValue,
    SMGAddressValue {
        private static final SMGUnknownValue instance = new SMGUnknownValue();

        public String toString() {
            return "UNKNOWN";
        }

        public static SMGUnknownValue getInstance() {
            return instance;
        }

        @Override
        public boolean isUnknown() {
            return true;
        }

        @Override
        public SMGAddress getAddress() {
            return SMGAddress.UNKNOWN;
        }

        @Override
        public BigInteger getValue() {
            throw new IllegalStateException("Can't get Value of an Unknown Value.");
        }

        @Override
        public int getAsInt() {
            throw new IllegalStateException("Can't get Value of an Unknown Value.");
        }

        @Override
        public long getAsLong() {
            throw new IllegalStateException("Can't get Value of an Unknown Value.");
        }

        @Override
        public SMGExplicitValue negate() {
            return instance;
        }

        @Override
        public SMGExplicitValue xor(SMGExplicitValue pRVal) {
            return instance;
        }

        @Override
        public SMGExplicitValue or(SMGExplicitValue pRVal) {
            return instance;
        }

        @Override
        public SMGExplicitValue and(SMGExplicitValue pRVal) {
            return instance;
        }

        @Override
        public SMGExplicitValue shiftLeft(SMGExplicitValue pRVal) {
            return instance;
        }

        @Override
        public SMGExplicitValue multiply(SMGExplicitValue pRVal) {
            return instance;
        }

        @Override
        public SMGExplicitValue divide(SMGExplicitValue pRVal) {
            return instance;
        }

        @Override
        public SMGExplicitValue subtract(SMGExplicitValue pRVal) {
            return instance;
        }

        @Override
        public SMGExplicitValue add(SMGExplicitValue pRVal) {
            return instance;
        }

        @Override
        public SMGExplicitValue getOffset() {
            return instance;
        }

        @Override
        public SMGObject getObject() {
            return null;
        }
    }

    public static final class SMGKnownExpValue
    extends SMGKnownValue
    implements SMGExplicitValue {
        public static final SMGKnownExpValue ONE = new SMGKnownExpValue(BigInteger.ONE);
        public static final SMGKnownExpValue ZERO = new SMGKnownExpValue(BigInteger.ZERO);

        private SMGKnownExpValue(BigInteger pValue) {
            super(pValue);
        }

        @Override
        public boolean equals(Object pObj) {
            if (!(pObj instanceof SMGKnownExpValue)) {
                return false;
            }
            return super.equals(pObj);
        }

        @Override
        public int hashCode() {
            int result = 5;
            result = 31 * result + super.hashCode();
            return result;
        }

        @Override
        public SMGExplicitValue negate() {
            return SMGKnownExpValue.valueOf(this.getValue().negate());
        }

        @Override
        public SMGExplicitValue xor(SMGExplicitValue pRVal) {
            if (pRVal.isUnknown()) {
                return SMGUnknownValue.getInstance();
            }
            return SMGKnownExpValue.valueOf(this.getValue().xor(pRVal.getValue()));
        }

        @Override
        public SMGExplicitValue or(SMGExplicitValue pRVal) {
            if (pRVal.isUnknown()) {
                return SMGUnknownValue.getInstance();
            }
            return SMGKnownExpValue.valueOf(this.getValue().or(pRVal.getValue()));
        }

        @Override
        public SMGExplicitValue and(SMGExplicitValue pRVal) {
            if (pRVal.isUnknown()) {
                return SMGUnknownValue.getInstance();
            }
            return SMGKnownExpValue.valueOf(this.getValue().and(pRVal.getValue()));
        }

        @Override
        public SMGExplicitValue shiftLeft(SMGExplicitValue pRVal) {
            if (pRVal.isUnknown()) {
                return SMGUnknownValue.getInstance();
            }
            return SMGKnownExpValue.valueOf(this.getValue().shiftLeft(pRVal.getAsInt()));
        }

        @Override
        public SMGExplicitValue multiply(SMGExplicitValue pRVal) {
            if (pRVal.isUnknown()) {
                return SMGUnknownValue.getInstance();
            }
            return SMGKnownExpValue.valueOf(this.getValue().multiply(pRVal.getValue()));
        }

        @Override
        public SMGExplicitValue divide(SMGExplicitValue pRVal) {
            if (pRVal.isUnknown()) {
                return SMGUnknownValue.getInstance();
            }
            return SMGKnownExpValue.valueOf(this.getValue().divide(pRVal.getValue()));
        }

        @Override
        public SMGExplicitValue subtract(SMGExplicitValue pRVal) {
            if (pRVal.isUnknown()) {
                return SMGUnknownValue.getInstance();
            }
            return SMGKnownExpValue.valueOf(this.getValue().subtract(pRVal.getValue()));
        }

        @Override
        public SMGExplicitValue add(SMGExplicitValue pRVal) {
            if (pRVal.isUnknown()) {
                return SMGUnknownValue.getInstance();
            }
            return SMGKnownExpValue.valueOf(this.getValue().add(pRVal.getValue()));
        }

        public static final SMGKnownExpValue valueOf(int pValue) {
            if (pValue == 0) {
                return ZERO;
            }
            if (pValue == 1) {
                return ONE;
            }
            return new SMGKnownExpValue(BigInteger.valueOf(pValue));
        }

        public static final SMGKnownExpValue valueOf(long pValue) {
            if (pValue == 0L) {
                return ZERO;
            }
            if (pValue == 1L) {
                return ONE;
            }
            return new SMGKnownExpValue(BigInteger.valueOf(pValue));
        }

        public static final SMGKnownExpValue valueOf(BigInteger pValue) {
            Preconditions.checkNotNull((Object)pValue);
            if (pValue.equals(BigInteger.ZERO)) {
                return ZERO;
            }
            if (pValue.equals(BigInteger.ONE)) {
                return ONE;
            }
            return new SMGKnownExpValue(pValue);
        }
    }

    public static class SMGKnownSymValue
    extends SMGKnownValue
    implements SMGSymbolicValue {
        public static final SMGKnownSymValue ZERO = new SMGKnownSymValue(BigInteger.ZERO);
        public static final SMGKnownSymValue ONE = new SMGKnownSymValue(BigInteger.ONE);
        public static final SMGKnownSymValue TRUE = new SMGKnownSymValue(BigInteger.valueOf(-1L));
        public static final SMGKnownSymValue FALSE = ZERO;

        private SMGKnownSymValue(BigInteger pValue) {
            super(pValue);
        }

        public static final SMGKnownSymValue valueOf(int pValue) {
            if (pValue == 0) {
                return ZERO;
            }
            if (pValue == 1) {
                return ONE;
            }
            return new SMGKnownSymValue(BigInteger.valueOf(pValue));
        }

        public static final SMGKnownSymValue valueOf(long pValue) {
            if (pValue == 0L) {
                return ZERO;
            }
            if (pValue == 1L) {
                return ONE;
            }
            return new SMGKnownSymValue(BigInteger.valueOf(pValue));
        }

        public static final SMGKnownSymValue valueOf(BigInteger pValue) {
            Preconditions.checkNotNull((Object)pValue);
            if (pValue.equals(BigInteger.ZERO)) {
                return ZERO;
            }
            if (pValue.equals(BigInteger.ONE)) {
                return ONE;
            }
            return new SMGKnownSymValue(pValue);
        }

        @Override
        public final boolean equals(Object pObj) {
            if (!(pObj instanceof SMGKnownSymValue)) {
                return false;
            }
            return super.equals(pObj);
        }

        @Override
        public final int hashCode() {
            int result = 17;
            result = 31 * result + super.hashCode();
            return result;
        }
    }

    public static abstract class SMGKnownValue {
        private final BigInteger value;

        private SMGKnownValue(BigInteger pValue) {
            Preconditions.checkNotNull((Object)pValue);
            this.value = pValue;
        }

        private SMGKnownValue(long pValue) {
            Preconditions.checkNotNull((Object)pValue);
            this.value = BigInteger.valueOf(pValue);
        }

        private SMGKnownValue(int pValue) {
            Preconditions.checkNotNull((Object)pValue);
            this.value = BigInteger.valueOf(pValue);
        }

        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (!(pObj instanceof SMGKnownValue)) {
                return false;
            }
            SMGKnownValue otherValue = (SMGKnownValue)pObj;
            return this.value.equals(otherValue.value);
        }

        public int hashCode() {
            int result = 5;
            int c = this.value.hashCode();
            return result * 31 + c;
        }

        public final BigInteger getValue() {
            return this.value;
        }

        public final int getAsInt() {
            return this.value.intValue();
        }

        public final long getAsLong() {
            return this.value.longValue();
        }

        public String toString() {
            return this.value.toString();
        }

        public boolean isUnknown() {
            return false;
        }
    }

    public static interface SMGExplicitValue
    extends SMGValue {
        public SMGExplicitValue negate();

        public SMGExplicitValue xor(SMGExplicitValue var1);

        public SMGExplicitValue or(SMGExplicitValue var1);

        public SMGExplicitValue and(SMGExplicitValue var1);

        public SMGExplicitValue shiftLeft(SMGExplicitValue var1);

        public SMGExplicitValue multiply(SMGExplicitValue var1);

        public SMGExplicitValue divide(SMGExplicitValue var1);

        public SMGExplicitValue subtract(SMGExplicitValue var1);

        public SMGExplicitValue add(SMGExplicitValue var1);
    }

    public static interface SMGAddressValue
    extends SMGSymbolicValue {
        @Override
        public boolean isUnknown();

        public SMGAddress getAddress();

        public SMGExplicitValue getOffset();

        public SMGObject getObject();
    }

    public static interface SMGValue {
        public boolean isUnknown();

        public BigInteger getValue();

        public int getAsInt();

        public long getAsLong();
    }

    public static interface SMGSymbolicValue
    extends SMGValue {
    }

    private class SMGRightHandSideEvaluator
    extends SMGExpressionEvaluator {
        private boolean missingExplicitInformation;

        public SMGRightHandSideEvaluator(LogManagerWithoutDuplicates pLogger, MachineModel pMachineModel) {
            super(pLogger, pMachineModel);
        }

        public void deriveFurtherInformation(SMGState pNewState, boolean pTruthValue, CFAEdge pCfaEdge, CExpression rValue) throws CPATransferException {
            rValue.accept(new AssigningValueVisitor(pNewState, pTruthValue, pCfaEdge));
        }

        @Override
        protected SMGExpressionEvaluator.PointerVisitor getPointerVisitor(CFAEdge pCfaEdge, SMGState pNewState) {
            return new PointerAddressVisitor(pCfaEdge, pNewState);
        }

        @Override
        protected SMGExpressionEvaluator.ExpressionValueVisitor getExpressionValueVisitor(CFAEdge pCfaEdge, SMGState pNewState) {
            return new ExpressionValueVisitor(pCfaEdge, pNewState);
        }

        @Override
        public SMGExpressionEvaluator.LValueAssignmentVisitor getLValueAssignmentVisitor(CFAEdge pCfaEdge, SMGState pNewState) {
            return new LValueAssignmentVisitor(pCfaEdge, pNewState);
        }

        @Override
        public SMGExplicitValue evaluateExplicitValue(SMGState pSmgState, CFAEdge pCfaEdge, CRightHandSide pRValue) throws CPATransferException {
            SMGExplicitValue explicitValue = super.evaluateExplicitValue(pSmgState, pCfaEdge, pRValue);
            if (explicitValue.isUnknown()) {
                this.missingExplicitInformation = true;
            }
            return explicitValue;
        }

        public boolean isMissingExplicitInformation() {
            return this.missingExplicitInformation;
        }

        @Override
        protected SMGSymbolicValue handleUnknownDereference(SMGState pSmgState, CFAEdge pEdge) {
            pSmgState.setUnknownDereference();
            return super.handleUnknownDereference(pSmgState, pEdge);
        }

        public void reset() {
            this.missingExplicitInformation = false;
        }

        private class PointerAddressVisitor
        extends SMGExpressionEvaluator.PointerVisitor {
            public PointerAddressVisitor(CFAEdge pEdge, SMGState pSmgState) {
                super(pEdge, pSmgState);
            }

            @Override
            public SMGAddressValue visit(CFunctionCallExpression pIastFunctionCallExpression) throws CPATransferException {
                CExpression fileNameExpression = pIastFunctionCallExpression.getFunctionNameExpression();
                String functionName = fileNameExpression.toASTString();
                if (SMGTransferRelation.this.builtins.isABuiltIn(functionName)) {
                    switch (functionName) {
                        case "malloc": {
                            SMGTransferRelation.this.possibleMallocFail = true;
                            SMGEdgePointsTo mallocEdge = SMGTransferRelation.this.builtins.evaluateMalloc(pIastFunctionCallExpression, this.getSmgState(), this.getCfaEdge());
                            return SMGRightHandSideEvaluator.this.createAddress(mallocEdge);
                        }
                        case "calloc": {
                            SMGTransferRelation.this.possibleMallocFail = true;
                            SMGEdgePointsTo callocEdge = SMGTransferRelation.this.builtins.evaluateCalloc(pIastFunctionCallExpression, this.getSmgState(), this.getCfaEdge());
                            return SMGRightHandSideEvaluator.this.createAddress(callocEdge);
                        }
                        case "memset": {
                            SMGEdgePointsTo memsetTargetEdge = SMGTransferRelation.this.builtins.evaluateMemset(pIastFunctionCallExpression, this.getSmgState(), this.getCfaEdge());
                            return SMGRightHandSideEvaluator.this.createAddress(memsetTargetEdge);
                        }
                        case "printf": {
                            return SMGUnknownValue.getInstance();
                        }
                    }
                    if (SMGTransferRelation.this.builtins.isNondetBuiltin(functionName)) {
                        return SMGUnknownValue.getInstance();
                    }
                    throw new AssertionError((Object)("Unexpected function handled as a builtin: " + functionName));
                }
                switch (SMGTransferRelation.this.handleUnknownFunctions) {
                    case "strict": {
                        throw new CPATransferException("Unknown function '" + functionName + "' may be unsafe. See the cpa.smg.handleUnknownFunction option.");
                    }
                    case "assume_safe": {
                        return SMGUnknownValue.getInstance();
                    }
                }
                throw new AssertionError();
            }
        }

        private class ExpressionValueVisitor
        extends SMGExpressionEvaluator.ExpressionValueVisitor {
            public ExpressionValueVisitor(CFAEdge pEdge, SMGState pSmgState) {
                super(pEdge, pSmgState);
            }

            @Override
            public SMGSymbolicValue visit(CFunctionCallExpression pIastFunctionCallExpression) throws CPATransferException {
                CExpression fileNameExpression = pIastFunctionCallExpression.getFunctionNameExpression();
                String functionName = fileNameExpression.toASTString();
                if (SMGTransferRelation.this.builtins.isABuiltIn(functionName)) {
                    switch (functionName) {
                        case "__VERIFIER_BUILTIN_PLOT": {
                            SMGTransferRelation.this.builtins.evaluateVBPlot(pIastFunctionCallExpression, this.getSmgState());
                            break;
                        }
                        case "malloc": {
                            SMGTransferRelation.this.possibleMallocFail = true;
                            SMGEdgePointsTo mallocEdge = SMGTransferRelation.this.builtins.evaluateMalloc(pIastFunctionCallExpression, this.getSmgState(), this.getCfaEdge());
                            return SMGRightHandSideEvaluator.this.createAddress(mallocEdge);
                        }
                        case "calloc": {
                            SMGTransferRelation.this.possibleMallocFail = true;
                            SMGEdgePointsTo callocEdge = SMGTransferRelation.this.builtins.evaluateCalloc(pIastFunctionCallExpression, this.getSmgState(), this.getCfaEdge());
                            return SMGRightHandSideEvaluator.this.createAddress(callocEdge);
                        }
                        case "printf": {
                            return SMGUnknownValue.getInstance();
                        }
                        default: {
                            if (SMGTransferRelation.this.builtins.isNondetBuiltin(functionName)) {
                                return SMGUnknownValue.getInstance();
                            }
                            throw new AssertionError((Object)("Unexpected function handled as a builtin: " + functionName));
                        }
                    }
                } else {
                    switch (SMGTransferRelation.this.handleUnknownFunctions) {
                        case "strict": {
                            throw new CPATransferException("Unknown function '" + functionName + "' may be unsafe. See the cpa.smg.handleUnknownFunction option.");
                        }
                        case "assume_safe": {
                            return SMGUnknownValue.getInstance();
                        }
                    }
                    throw new AssertionError();
                }
                return SMGUnknownValue.getInstance();
            }
        }

        private class LValueAssignmentVisitor
        extends SMGExpressionEvaluator.LValueAssignmentVisitor {
            public LValueAssignmentVisitor(CFAEdge pEdge, SMGState pSmgState) {
                super(pEdge, pSmgState);
            }

            @Override
            public SMGAddress visit(CIdExpression variableName) throws CPATransferException {
                SMGTransferRelation.this.logger.log(Level.FINEST, new Object[]{">>> Handling statement: variable assignment"});
                return super.visit(variableName);
            }

            @Override
            public SMGAddress visit(CPointerExpression pLValue) throws CPATransferException {
                SMGTransferRelation.this.logger.log(Level.FINEST, new Object[]{">>> Handling statement: assignment to dereferenced pointer"});
                SMGAddress address = super.visit(pLValue);
                if (address.isUnknown()) {
                    this.getSmgState().setUnknownDereference();
                }
                return address;
            }

            @Override
            public SMGAddress visit(CFieldReference lValue) throws CPATransferException {
                SMGTransferRelation.this.logger.log(Level.FINEST, new Object[]{">>> Handling statement: assignment to field reference"});
                return super.visit(lValue);
            }

            @Override
            public SMGAddress visit(CArraySubscriptExpression lValue) throws CPATransferException {
                SMGTransferRelation.this.logger.log(Level.FINEST, new Object[]{">>> Handling statement: assignment to array Cell"});
                return super.visit(lValue);
            }
        }

        private class AssigningValueVisitor
        extends DefaultCExpressionVisitor<Void, CPATransferException> {
            private SMGState assignableState;
            private boolean truthValue = false;
            private CFAEdge edge;

            public AssigningValueVisitor(SMGState pSMGState, boolean pTruthvalue, CFAEdge pEdge) {
                this.assignableState = pSMGState;
                this.truthValue = pTruthvalue;
                this.edge = pEdge;
            }

            @Override
            protected Void visitDefault(CExpression pExp) throws CPATransferException {
                return null;
            }

            @Override
            public Void visit(CPointerExpression pointerExpression) throws CPATransferException {
                this.deriveFurtherInformation(pointerExpression);
                return null;
            }

            @Override
            public Void visit(CIdExpression pExp) throws CPATransferException {
                this.deriveFurtherInformation(pExp);
                return null;
            }

            @Override
            public Void visit(CArraySubscriptExpression pExp) throws CPATransferException {
                this.deriveFurtherInformation(pExp);
                return null;
            }

            @Override
            public Void visit(CFieldReference pExp) throws CPATransferException {
                this.deriveFurtherInformation(pExp);
                return null;
            }

            @Override
            public Void visit(CCastExpression pE) throws CPATransferException {
                return pE.getOperand().accept(this);
            }

            @Override
            public Void visit(CCharLiteralExpression pE) throws CPATransferException {
                assert (false);
                return null;
            }

            @Override
            public Void visit(CFloatLiteralExpression pE) throws CPATransferException {
                assert (false);
                return null;
            }

            @Override
            public Void visit(CIntegerLiteralExpression pE) throws CPATransferException {
                assert (false);
                return null;
            }

            @Override
            public Void visit(CBinaryExpression binExp) throws CPATransferException {
                CExpression operand1 = this.unwrap(binExp.getOperand1());
                CExpression operand2 = this.unwrap(binExp.getOperand2());
                CBinaryExpression.BinaryOperator op = binExp.getOperator();
                if (operand1 instanceof CLeftHandSide) {
                    this.deriveFurtherInformation((CLeftHandSide)operand1, operand2, op);
                }
                if (operand2 instanceof CLeftHandSide) {
                    this.deriveFurtherInformation((CLeftHandSide)operand2, operand1, op);
                }
                return null;
            }

            private void deriveFurtherInformation(CLeftHandSide lValue, CExpression exp, CBinaryExpression.BinaryOperator op) throws CPATransferException {
                SMGExplicitValue rValue = SMGRightHandSideEvaluator.this.evaluateExplicitValue(this.assignableState, this.edge, exp);
                if (rValue.isUnknown()) {
                    return;
                }
                SMGSymbolicValue rSymValue = SMGRightHandSideEvaluator.this.evaluateExpressionValue(this.assignableState, this.edge, exp);
                if (rSymValue.isUnknown()) {
                    return;
                }
                SMGExpressionEvaluator.LValueAssignmentVisitor visitor = SMGRightHandSideEvaluator.this.getLValueAssignmentVisitor(this.edge, this.assignableState);
                SMGAddress addressOfField = lValue.accept(visitor);
                if (addressOfField.isUnknown()) {
                    return;
                }
                if (this.truthValue) {
                    if (op == CBinaryExpression.BinaryOperator.EQUALS) {
                        this.assignableState.putExplicit((SMGKnownSymValue)rSymValue, (SMGKnownExpValue)rValue);
                    }
                } else if (op == CBinaryExpression.BinaryOperator.NOT_EQUALS) {
                    this.assignableState.putExplicit((SMGKnownSymValue)rSymValue, (SMGKnownExpValue)rValue);
                }
            }

            @Override
            public Void visit(CUnaryExpression pE) throws CPATransferException {
                CUnaryExpression.UnaryOperator op = pE.getOperator();
                CExpression operand = pE.getOperand();
                switch (op) {
                    case AMPER: {
                        assert (false) : "In this case, the assume should be able to be calculated";
                        return null;
                    }
                    case MINUS: 
                    case TILDE: {
                        return operand.accept(this);
                    }
                    case SIZEOF: {
                        assert (false) : "At the moment, this cae should be able to be calculated";
                        break;
                    }
                }
                return null;
            }

            private void deriveFurtherInformation(CLeftHandSide lValue) throws CPATransferException {
                if (this.truthValue) {
                    return;
                }
                SMGExpressionEvaluator.LValueAssignmentVisitor visitor = SMGRightHandSideEvaluator.this.getLValueAssignmentVisitor(this.edge, this.assignableState);
                SMGAddress addressOfField = lValue.accept(visitor);
                if (addressOfField.isUnknown()) {
                    return;
                }
                assert (SMGRightHandSideEvaluator.this.evaluateExplicitValue(this.assignableState, this.edge, lValue).isUnknown());
                SMGSymbolicValue value = SMGRightHandSideEvaluator.this.evaluateExpressionValue(this.assignableState, this.edge, lValue);
                assert (!value.isUnknown());
                this.assignableState.putExplicit((SMGKnownSymValue)value, SMGKnownExpValue.ZERO);
            }

            private CExpression unwrap(CExpression expression) {
                if (expression instanceof CCastExpression) {
                    CCastExpression exp = (CCastExpression)expression;
                    expression = exp.getOperand();
                    expression = this.unwrap(expression);
                }
                return expression;
            }
        }
    }

    private class SMGBuiltins {
        private static final int MEMSET_BUFFER_PARAMETER = 0;
        private static final int MEMSET_CHAR_PARAMETER = 1;
        private static final int MEMSET_COUNT_PARAMETER = 2;
        private static final int CALLOC_NUM_PARAMETER = 0;
        private static final int CALLOC_SIZE_PARAMETER = 1;
        private static final int MALLOC_PARAMETER = 0;
        private final Set<String> BUILTINS = new HashSet<String>(Arrays.asList("__VERIFIER_BUILTIN_PLOT", "malloc", "free", "memset", "calloc", "printf"));
        private static final String NONDET_PREFIX = "__VERIFIER_nondet_";

        private SMGBuiltins() {
        }

        private void dumpSMGPlot(String name, SMGState currentState, String location) {
            if (SMGTransferRelation.this.exportSMGFilePattern != null && currentState != null) {
                if (name == null) {
                    name = currentState.getPredecessor() == null ? String.format("initial-%03d", currentState.getId()) : String.format("%03d-%03d", currentState.getPredecessor().getId(), currentState.getId());
                }
                name = name.replace("\"", "");
                Path outputFile = this.getOutputFile(SMGTransferRelation.this.exportSMGFilePattern, name);
                try {
                    String dot = this.getDot(currentState, name, location);
                    Files.writeFile((Path)outputFile, (Object)dot);
                }
                catch (IOException e) {
                    SMGTransferRelation.this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write SMG " + name + " to file");
                }
            }
        }

        protected Path getOutputFile(Path pExportSMGFilePattern, String pName) {
            return Paths.get((String)String.format(pExportSMGFilePattern.toAbsolutePath().getPath(), pName), (String[])new String[0]);
        }

        protected String getDot(SMGState pCurrentState, String pName, String pLocation) {
            return pCurrentState.toDot(pName, pLocation);
        }

        public final void evaluateVBPlot(CFunctionCallExpression functionCall, SMGState currentState) {
            String name = functionCall.getParameterExpressions().get(0).toASTString();
            this.dumpSMGPlot(name, currentState, functionCall.toString());
        }

        public final SMGEdgePointsTo evaluateMalloc(CFunctionCallExpression functionCall, SMGState currentState, CFAEdge cfaEdge) throws CPATransferException {
            CRightHandSide sizeExpr;
            try {
                sizeExpr = functionCall.getParameterExpressions().get(0);
            }
            catch (IndexOutOfBoundsException e) {
                SMGTransferRelation.this.logger.logDebugException((Throwable)e);
                throw new UnrecognizedCCodeException("Malloc argument not found.", cfaEdge, functionCall);
            }
            SMGExplicitValue value = this.evaluateExplicitValue(currentState, cfaEdge, sizeExpr);
            if (value.isUnknown()) {
                return null;
            }
            String allocation_label = "malloc_ID" + SMGValueFactory.getNewValue() + "_Line:" + functionCall.getFileLocation().getStartingLineNumber();
            SMGEdgePointsTo new_pointer = currentState.addNewHeapAllocation(value.getAsInt(), allocation_label);
            SMGTransferRelation.this.possibleMallocFail = true;
            return new_pointer;
        }

        public final SMGEdgePointsTo evaluateMemset(CFunctionCallExpression functionCall, SMGState currentState, CFAEdge cfaEdge) throws CPATransferException {
            CExpression countExpr;
            CExpression chExpr;
            CExpression bufferExpr;
            try {
                bufferExpr = functionCall.getParameterExpressions().get(0);
            }
            catch (IndexOutOfBoundsException e) {
                SMGTransferRelation.this.logger.logDebugException((Throwable)e);
                throw new UnrecognizedCCodeException("Memset buffer argument not found.", cfaEdge, functionCall);
            }
            try {
                chExpr = functionCall.getParameterExpressions().get(1);
            }
            catch (IndexOutOfBoundsException e) {
                SMGTransferRelation.this.logger.logDebugException((Throwable)e);
                throw new UnrecognizedCCodeException("Memset ch argument not found.", cfaEdge, functionCall);
            }
            try {
                countExpr = functionCall.getParameterExpressions().get(2);
            }
            catch (IndexOutOfBoundsException e) {
                SMGTransferRelation.this.logger.logDebugException((Throwable)e);
                throw new UnrecognizedCCodeException("Memset count argument not found.", cfaEdge, functionCall);
            }
            SMGAddressValue bufferAddress = this.evaluateAddress(currentState, cfaEdge, bufferExpr);
            SMGExplicitValue countValue = this.evaluateExplicitValue(currentState, cfaEdge, countExpr);
            if (bufferAddress.isUnknown() || countValue.isUnknown()) {
                return null;
            }
            SMGEdgePointsTo pointer = currentState.getPointerFromValue(bufferAddress.getAsInt());
            long count = countValue.getAsLong();
            SMGObject bufferMemory = bufferAddress.getObject();
            int offset = bufferAddress.getOffset().getAsInt();
            SMGSymbolicValue ch = this.evaluateExpressionValue(currentState, cfaEdge, chExpr);
            if (ch.isUnknown()) {
                throw new UnrecognizedCCodeException("Can't simulate memset", cfaEdge, functionCall);
            }
            SMGExpressionEvaluator expEvaluator = new SMGExpressionEvaluator(SMGTransferRelation.this.logger, SMGTransferRelation.this.machineModel);
            SMGExplicitValue expValue = expEvaluator.evaluateExplicitValue(currentState, cfaEdge, chExpr);
            if (ch.equals(SMGKnownSymValue.ZERO)) {
                SMGTransferRelation.this.writeValue(currentState, bufferMemory, offset, count, ch, cfaEdge);
            } else {
                int c = 0;
                while ((long)c < count) {
                    SMGTransferRelation.this.writeValue(currentState, bufferMemory, offset + c, AnonymousTypes.dummyChar, ch, cfaEdge);
                    ++c;
                }
                if (!expValue.isUnknown()) {
                    currentState.putExplicit((SMGKnownSymValue)ch, (SMGKnownExpValue)expValue);
                }
            }
            return pointer;
        }

        protected SMGSymbolicValue evaluateExpressionValue(SMGState smgState, CFAEdge cfaEdge, CExpression rValue) throws CPATransferException {
            return SMGTransferRelation.this.expressionEvaluator.evaluateExpressionValue(smgState, cfaEdge, rValue);
        }

        protected SMGExplicitValue evaluateExplicitValue(SMGState pState, CFAEdge pCfaEdge, CRightHandSide pRValue) throws CPATransferException {
            return SMGTransferRelation.this.expressionEvaluator.evaluateExplicitValue(pState, pCfaEdge, pRValue);
        }

        protected SMGAddressValue evaluateAddress(SMGState pState, CFAEdge pCfaEdge, CRightHandSide pRvalue) throws CPATransferException {
            return SMGTransferRelation.this.expressionEvaluator.evaluateAddress(pState, pCfaEdge, pRvalue);
        }

        public final SMGEdgePointsTo evaluateCalloc(CFunctionCallExpression functionCall, SMGState currentState, CFAEdge cfaEdge) throws CPATransferException {
            CExpression sizeExpr;
            CExpression numExpr;
            try {
                numExpr = functionCall.getParameterExpressions().get(0);
            }
            catch (IndexOutOfBoundsException e) {
                SMGTransferRelation.this.logger.logDebugException((Throwable)e);
                throw new UnrecognizedCCodeException("Calloc num argument not found.", cfaEdge, functionCall);
            }
            try {
                sizeExpr = functionCall.getParameterExpressions().get(1);
            }
            catch (IndexOutOfBoundsException e) {
                SMGTransferRelation.this.logger.logDebugException((Throwable)e);
                throw new UnrecognizedCCodeException("Calloc size argument not found.", cfaEdge, functionCall);
            }
            SMGExplicitValue numValue = SMGTransferRelation.this.expressionEvaluator.evaluateExplicitValue(currentState, cfaEdge, numExpr);
            SMGExplicitValue sizeValue = SMGTransferRelation.this.expressionEvaluator.evaluateExplicitValue(currentState, cfaEdge, sizeExpr);
            if (numValue.isUnknown() || sizeValue.isUnknown()) {
                return null;
            }
            int num = numValue.getAsInt();
            int size = sizeValue.getAsInt();
            String allocation_label = "Calloc_ID" + SMGValueFactory.getNewValue() + "_Line:" + functionCall.getFileLocation().getStartingLineNumber();
            SMGEdgePointsTo new_pointer = currentState.addNewHeapAllocation(num * size, allocation_label);
            currentState.writeValue(new_pointer.getObject(), 0, AnonymousTypes.createTypeWithLength(size), SMGKnownSymValue.ZERO);
            SMGTransferRelation.this.possibleMallocFail = true;
            return new_pointer;
        }

        public final void evaluateFree(CFunctionCallExpression pFunctionCall, SMGState currentState, CFAEdge cfaEdge) throws CPATransferException {
            CExpression pointerExp;
            try {
                pointerExp = pFunctionCall.getParameterExpressions().get(0);
            }
            catch (IndexOutOfBoundsException e) {
                SMGTransferRelation.this.logger.logDebugException((Throwable)e);
                throw new UnrecognizedCCodeException("Built-in free(): No parameter passed", cfaEdge, pFunctionCall);
            }
            SMGAddressValue address = SMGTransferRelation.this.expressionEvaluator.evaluateAddress(currentState, cfaEdge, pointerExp);
            if (address.isUnknown()) {
                currentState.setInvalidFree();
                return;
            }
            SMGEdgePointsTo pointer = currentState.isPointer(address.getAsInt()) ? currentState.getPointerFromValue(address.getAsInt()) : new SMGEdgePointsTo(address.getAsInt(), address.getObject(), address.getOffset().getAsInt());
            if (address.getAsInt() == 0) {
                SMGTransferRelation.this.logger.log(Level.WARNING, new Object[]{pFunctionCall.getFileLocation() + ":", "The argument of a free invocation:", cfaEdge.getRawStatement(), "is 0"});
            } else {
                currentState.free(pointer.getValue(), pointer.getOffset(), pointer.getObject());
            }
        }

        public final boolean isABuiltIn(String functionName) {
            return this.BUILTINS.contains(functionName) || this.isNondetBuiltin(functionName);
        }

        private boolean isNondetBuiltin(String pFunctionName) {
            return pFunctionName.startsWith(NONDET_PREFIX) || pFunctionName.equals("nondet_int");
        }
    }
}

