/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smgfork;

import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.DelegateAbstractDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGRuntimeCheck;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGState;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGTransferRelation;

@Options(prefix="cpa.smgfork")
public class SplittingSMGCPA
implements ConfigurableProgramAnalysis {
    @Option(secure=true, name="runtimeCheck", description="Sets the level of runtime checking: NONE, HALF, FULL")
    private SMGRuntimeCheck runtimeCheck = SMGRuntimeCheck.NONE;
    @Option(secure=true, name="memoryErrors", description="Determines if memory errors are target states")
    private boolean memoryErrors = true;
    @Option(secure=true, name="unknownOnUndefined", description="Emit messages when we encounter non-target undefined behavior")
    private boolean unknownOnUndefined = true;
    private final AbstractDomain abstractDomain;
    private final MergeOperator mergeOperator;
    private final StopOperator stopOperator;
    private final TransferRelation transferRelation;
    private final MachineModel machineModel;
    private final LogManager logger;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(SplittingSMGCPA.class);
    }

    private SplittingSMGCPA(Configuration config, LogManager pLogger, CFA cfa) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.machineModel = cfa.getMachineModel();
        this.logger = pLogger;
        this.abstractDomain = DelegateAbstractDomain.getInstance();
        this.mergeOperator = MergeSepOperator.getInstance();
        this.stopOperator = new StopSepOperator(this.abstractDomain);
        this.transferRelation = new SMGTransferRelation(config, this.logger, this.machineModel);
        SMGState.setRuntimeCheck(this.runtimeCheck);
        SMGState.setTargetMemoryErrors(this.memoryErrors);
        SMGState.setUnknownOnUndefined(this.unknownOnUndefined);
    }

    public MachineModel getMachineModel() {
        return this.machineModel;
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return StaticPrecisionAdjustment.getInstance();
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        SMGState initState = new SMGState(this.logger, this.machineModel);
        try {
            initState.performConsistencyCheck(SMGRuntimeCheck.FULL);
        }
        catch (SMGInconsistentException exc) {
            this.logger.log(Level.SEVERE, new Object[]{exc.getMessage()});
        }
        if (pNode instanceof CFunctionEntryNode) {
            CFunctionEntryNode functionNode = (CFunctionEntryNode)pNode;
            try {
                initState.addStackFrame(functionNode.getFunctionDefinition());
                initState.performConsistencyCheck(SMGRuntimeCheck.FULL);
            }
            catch (SMGInconsistentException exc) {
                this.logger.log(Level.SEVERE, new Object[]{exc.getMessage()});
            }
        }
        return initState;
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) {
        return SingletonPrecision.getInstance();
    }
}

