/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smgfork.graphs;

import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.smgfork.CLangStackFrame;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smgfork.graphs.CLangSMGConsistencyVerifier;
import org.sosy_lab.cpachecker.cpa.smgfork.graphs.ReadableSMG;
import org.sosy_lab.cpachecker.cpa.smgfork.graphs.SMG;
import org.sosy_lab.cpachecker.cpa.smgfork.graphs.WritableSMG;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGRegion;

public class CLangSMG
extends SMG
implements WritableSMG,
ReadableSMG {
    private final ArrayDeque<CLangStackFrame> stack_objects = new ArrayDeque();
    private final HashSet<SMGObject> heap_objects = new HashSet();
    private final HashMap<String, SMGRegion> global_objects = new HashMap();
    private boolean has_leaks = false;
    private static LogManager logger = null;
    private static boolean perform_checks = false;

    public static void setPerformChecks(boolean pSetting, LogManager logger) {
        perform_checks = pSetting;
        CLangSMG.logger = logger;
    }

    public static boolean performChecks() {
        return perform_checks;
    }

    public CLangSMG(MachineModel pMachineModel) {
        super(pMachineModel);
        this.heap_objects.add(this.getNullObject());
    }

    public CLangSMG(CLangSMG pHeap) {
        super(pHeap);
        for (CLangStackFrame stack_frame : pHeap.stack_objects) {
            CLangStackFrame new_frame = new CLangStackFrame(stack_frame);
            this.stack_objects.add(new_frame);
        }
        this.heap_objects.addAll(pHeap.heap_objects);
        this.global_objects.putAll(pHeap.global_objects);
        this.has_leaks = pHeap.has_leaks;
    }

    public void addHeapObject(SMGObject pObject) {
        if (CLangSMG.performChecks() && this.heap_objects.contains(pObject)) {
            throw new IllegalArgumentException("Heap object already in the SMG: [" + pObject + "]");
        }
        this.heap_objects.add(pObject);
        this.addObject(pObject);
    }

    @Override
    public void addGlobalObject(SMGRegion pObject) {
        if (CLangSMG.performChecks() && this.global_objects.values().contains(pObject)) {
            throw new IllegalArgumentException("Global object already in the SMG: [" + pObject + "]");
        }
        if (CLangSMG.performChecks() && this.global_objects.containsKey(pObject.getLabel())) {
            throw new IllegalArgumentException("Global object with label [" + pObject.getLabel() + "] already in the SMG");
        }
        this.global_objects.put(pObject.getLabel(), pObject);
        super.addObject(pObject);
    }

    @Override
    public void addStackObject(SMGRegion pObject) {
        super.addObject(pObject);
        this.stack_objects.peek().addStackVariable(pObject.getLabel(), pObject);
    }

    @Override
    public void addStackFrame(CFunctionDeclaration pFunctionDeclaration) {
        CLangStackFrame newFrame = new CLangStackFrame(pFunctionDeclaration, this.getMachineModel());
        SMGRegion returnObject = newFrame.getReturnObject();
        if (returnObject != null) {
            super.addObject(newFrame.getReturnObject());
        }
        this.stack_objects.push(newFrame);
    }

    public void setMemoryLeak() {
        this.has_leaks = true;
    }

    public void dropStackFrame() {
        CLangStackFrame frame = this.stack_objects.pop();
        for (SMGObject object : frame.getAllObjects()) {
            this.removeObjectAndEdges(object);
        }
        if (CLangSMG.performChecks()) {
            CLangSMGConsistencyVerifier.verifyCLangSMG(logger, this);
        }
    }

    public void pruneUnreachable() {
        HashSet<SMGObject> seen = new HashSet<SMGObject>();
        HashSet<Integer> seen_values = new HashSet<Integer>();
        ArrayDeque<SMGObject> workqueue = new ArrayDeque<SMGObject>();
        for (CLangStackFrame frame : this.getStackFrames()) {
            for (SMGObject stack_object : frame.getAllObjects()) {
                workqueue.add(stack_object);
            }
        }
        workqueue.addAll(this.getGlobalObjects().values());
        SMGEdgeHasValueFilter filter = new SMGEdgeHasValueFilter();
        while (!workqueue.isEmpty()) {
            SMGObject processed = (SMGObject)workqueue.remove();
            if (seen.contains(processed)) continue;
            seen.add(processed);
            filter.filterByObject(processed);
            for (SMGEdgeHasValue outbound : this.getHVEdges(filter)) {
                SMGObject pointedObject = this.getObjectPointedBy(outbound.getValue());
                if (pointedObject != null && !seen.contains(pointedObject)) {
                    workqueue.add(pointedObject);
                }
                if (seen_values.contains(outbound.getValue())) continue;
                seen_values.add(outbound.getValue());
            }
        }
        HashSet stray_objects = new HashSet(Sets.difference(this.getObjects(), seen));
        for (SMGObject stray_object : stray_objects) {
            if (!stray_object.notNull()) continue;
            if (this.isObjectValid(stray_object)) {
                this.setMemoryLeak();
            }
            this.removeObjectAndEdges(stray_object);
            this.heap_objects.remove(stray_object);
        }
        HashSet stray_values = new HashSet(Sets.difference(this.getValues(), seen_values));
        for (Integer stray_value : stray_values) {
            if (stray_value.intValue() == this.getNullValue()) continue;
            if (this.isPointer(stray_value)) {
                this.removePointsToEdge(stray_value);
            }
            this.removeValue(stray_value);
        }
        if (CLangSMG.performChecks()) {
            CLangSMGConsistencyVerifier.verifyCLangSMG(logger, this);
        }
    }

    public String toString() {
        return "CLangSMG [\n stack_objects=" + this.stack_objects + "\n heap_objects=" + this.heap_objects + "\n global_objects=" + this.global_objects + "\n " + this.valuesToString() + "\n " + this.ptToString() + "\n " + this.hvToString() + "\n]";
    }

    public SMGRegion getObjectForVisibleVariable(String pVariableName) {
        if (this.stack_objects.size() != 0 && this.stack_objects.peek().containsVariable(pVariableName)) {
            return this.stack_objects.peek().getVariable(pVariableName);
        }
        if (this.global_objects.containsKey(pVariableName)) {
            return this.global_objects.get(pVariableName);
        }
        return null;
    }

    @Override
    public ArrayDeque<CLangStackFrame> getStackFrames() {
        return this.stack_objects;
    }

    @Override
    public Set<SMGObject> getHeapObjects() {
        return Collections.unmodifiableSet(this.heap_objects);
    }

    public boolean isHeapObject(SMGObject object) {
        return this.heap_objects.contains(object);
    }

    @Override
    public Map<String, SMGRegion> getGlobalObjects() {
        return Collections.unmodifiableMap(this.global_objects);
    }

    public boolean hasMemoryLeaks() {
        return this.has_leaks;
    }

    public SMGObject getFunctionReturnObject() {
        return this.stack_objects.peek().getReturnObject();
    }

    @Nullable
    public String getFunctionName(SMGObject pObject) {
        for (CLangStackFrame cLangStack : this.stack_objects) {
            if (!cLangStack.getAllObjects().contains(pObject)) continue;
            return cLangStack.getFunctionDeclaration().getName();
        }
        return null;
    }

    @Override
    public void mergeValues(int v1, int v2) {
        super.mergeValues(v1, v2);
        if (CLangSMG.performChecks()) {
            CLangSMGConsistencyVerifier.verifyCLangSMG(logger, this);
        }
    }

    public final void removeHeapObjectAndEdges(SMGObject pObject) {
        this.heap_objects.remove(pObject);
        this.removeObjectAndEdges(pObject);
    }
}

