/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smgfork.graphs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGEdge;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smgfork.graphs.SMG;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGObject;

final class SMGConsistencyVerifier {
    private SMGConsistencyVerifier() {
    }

    private static boolean verifySMGProperty(boolean pResult, LogManager pLogger, String pMessage) {
        pLogger.log(Level.FINEST, new Object[]{"Checking SMG consistency: ", pMessage, ":", pResult});
        return pResult;
    }

    private static boolean verifyNullObject(LogManager pLogger, SMG pSmg) {
        Integer null_value = null;
        for (Integer value : pSmg.getValues()) {
            if (pSmg.getObjectPointedBy(value) != pSmg.getNullObject()) continue;
            null_value = value;
            break;
        }
        if (null_value == null) {
            pLogger.log(Level.SEVERE, new Object[]{"SMG inconsistent: no value pointing to null object"});
            return false;
        }
        if (pSmg.getObjectPointedBy(pSmg.getNullValue()) != pSmg.getNullObject()) {
            pLogger.log(Level.SEVERE, new Object[]{"SMG inconsistent: null value not pointing to null object"});
            return false;
        }
        if (pSmg.getNullValue() != null_value.intValue()) {
            pLogger.log(Level.SEVERE, new Object[]{"SMG inconsistent: null value in values set not returned by getNullValue()"});
            return false;
        }
        SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(pSmg.getNullObject());
        if (!pSmg.getHVEdges(filter).isEmpty()) {
            pLogger.log(Level.SEVERE, new Object[]{"SMG inconsistent: null object has some value"});
            return false;
        }
        if (pSmg.isObjectValid(pSmg.getNullObject())) {
            pLogger.log(Level.SEVERE, new Object[]{"SMG inconsistent: null object is not invalid"});
            return false;
        }
        if (pSmg.getNullObject().getSize() != 0) {
            pLogger.log(Level.SEVERE, new Object[]{"SMG inconsistent: null object does not have zero size"});
            return false;
        }
        return true;
    }

    private static boolean verifyInvalidRegionsHaveNoHVEdges(LogManager pLogger, SMG pSmg) {
        for (SMGObject obj : pSmg.getObjects()) {
            SMGEdgeHasValueFilter filter;
            if (pSmg.isObjectValid(obj) || pSmg.getHVEdges(filter = SMGEdgeHasValueFilter.objectFilter(obj)).size() <= 0) continue;
            pLogger.log(Level.SEVERE, new Object[]{"SMG inconsistent: invalid object has a HVEdge"});
            return false;
        }
        return true;
    }

    private static boolean checkSingleFieldConsistency(LogManager pLogger, SMGObject pObject, SMG pSmg) {
        SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(pObject);
        for (SMGEdgeHasValue hvEdge : pSmg.getHVEdges(filter)) {
            if (hvEdge.getOffset() + hvEdge.getSizeInBytes(pSmg.getMachineModel()) <= pObject.getSize()) continue;
            pLogger.log(Level.SEVERE, new Object[]{"SMG inconistent: field exceedes boundary of the object"});
            pLogger.log(Level.SEVERE, new Object[]{"Object: ", pObject});
            pLogger.log(Level.SEVERE, new Object[]{"Field: ", hvEdge});
            return false;
        }
        return true;
    }

    private static boolean verifyFieldConsistency(LogManager pLogger, SMG pSmg) {
        for (SMGObject obj : pSmg.getObjects()) {
            if (SMGConsistencyVerifier.checkSingleFieldConsistency(pLogger, obj, pSmg)) continue;
            return false;
        }
        return true;
    }

    private static boolean verifyEdgeConsistency(LogManager pLogger, SMG pSmg, Collection<? extends SMGEdge> pEdges) {
        ArrayList<? extends SMGEdge> to_verify = new ArrayList<SMGEdge>();
        to_verify.addAll(pEdges);
        while (to_verify.size() > 0) {
            SMGEdge edge = (SMGEdge)to_verify.get(0);
            to_verify.remove(0);
            if (!pSmg.getObjects().contains(edge.getObject())) {
                pLogger.log(Level.SEVERE, new Object[]{"SMG inconsistent: Edge from a nonexistent object"});
                pLogger.log(Level.SEVERE, new Object[]{"Edge :", edge});
                return false;
            }
            if (!pSmg.getValues().contains(edge.getValue())) {
                pLogger.log(Level.SEVERE, new Object[]{"SMG inconsistent: Edge to a nonexistent value"});
                pLogger.log(Level.SEVERE, new Object[]{"Edge :", edge});
                return false;
            }
            for (SMGEdge sMGEdge : to_verify) {
                if (edge.isConsistentWith(sMGEdge)) continue;
                pLogger.log(Level.SEVERE, new Object[]{"SMG inconsistent: inconsistent edges"});
                pLogger.log(Level.SEVERE, new Object[]{"First edge:  ", edge});
                pLogger.log(Level.SEVERE, new Object[]{"Second edge: ", sMGEdge});
                return false;
            }
        }
        return true;
    }

    private static boolean verifyObjectConsistency(LogManager pLogger, SMG pSmg) {
        for (SMGObject obj : pSmg.getObjects()) {
            try {
                pSmg.isObjectValid(obj);
            }
            catch (IllegalArgumentException e) {
                pLogger.log(Level.SEVERE, new Object[]{"SMG inconsistent: object does not have validity"});
                return false;
            }
            if (obj.getSize() >= 0) continue;
            pLogger.log(Level.SEVERE, new Object[]{"SMG inconsistent: object with size lower than 0"});
            return false;
        }
        return true;
    }

    public static boolean verifySMG(LogManager pLogger, SMG pSmg) {
        boolean toReturn = true;
        pLogger.log(Level.FINEST, new Object[]{"Starting constistency check of a SMG"});
        toReturn = toReturn && SMGConsistencyVerifier.verifySMGProperty(SMGConsistencyVerifier.verifyNullObject(pLogger, pSmg), pLogger, "null object invariants hold");
        toReturn = toReturn && SMGConsistencyVerifier.verifySMGProperty(SMGConsistencyVerifier.verifyInvalidRegionsHaveNoHVEdges(pLogger, pSmg), pLogger, "invalid regions have no outgoing edges");
        toReturn = toReturn && SMGConsistencyVerifier.verifySMGProperty(SMGConsistencyVerifier.verifyFieldConsistency(pLogger, pSmg), pLogger, "field consistency");
        toReturn = toReturn && SMGConsistencyVerifier.verifySMGProperty(SMGConsistencyVerifier.verifyEdgeConsistency(pLogger, pSmg, pSmg.getHVEdges()), pLogger, "Has Value edge consistency");
        toReturn = toReturn && SMGConsistencyVerifier.verifySMGProperty(SMGConsistencyVerifier.verifyEdgeConsistency(pLogger, pSmg, pSmg.getPTEdges().values()), pLogger, "Points To edge consistency");
        toReturn = toReturn && SMGConsistencyVerifier.verifySMGProperty(SMGConsistencyVerifier.verifyObjectConsistency(pLogger, pSmg), pLogger, "Validity consistency");
        pLogger.log(Level.FINEST, new Object[]{"Ending consistency check of a SMG"});
        return toReturn;
    }
}

