/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smgfork.graphs;

import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.TestLogManager;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smgfork.AnonymousTypes;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGValueFactory;
import org.sosy_lab.cpachecker.cpa.smgfork.graphs.NeqRelation;
import org.sosy_lab.cpachecker.cpa.smgfork.graphs.SMG;
import org.sosy_lab.cpachecker.cpa.smgfork.graphs.SMGConsistencyVerifier;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGRegion;

public class SMGTest {
    private LogManager logger = TestLogManager.getInstance();
    private SMG smg;
    CType mockType = AnonymousTypes.createTypeWithLength(4L);
    SMGRegion obj1 = new SMGRegion(8, "object-1");
    SMGRegion obj2 = new SMGRegion(8, "object-2");
    Integer val1 = 1;
    Integer val2 = 2;
    SMGEdgePointsTo pt1to1 = new SMGEdgePointsTo(this.val1, this.obj1, 0);
    SMGEdgeHasValue hv2has2at0 = new SMGEdgeHasValue(this.mockType, 0, (SMGObject)this.obj2, (int)this.val2);
    SMGEdgeHasValue hv2has1at4 = new SMGEdgeHasValue(this.mockType, 4, (SMGObject)this.obj2, (int)this.val1);

    private static SMG getNewSMG64() {
        return new SMG(MachineModel.LINUX64);
    }

    @Before
    public void setUp() {
        this.smg = SMGTest.getNewSMG64();
        this.smg.addObject(this.obj1);
        this.smg.addObject(this.obj2);
        this.smg.addValue(this.val1);
        this.smg.addValue(this.val2);
        this.smg.addPointsToEdge(this.pt1to1);
        this.smg.addHasValueEdge(this.hv2has2at0);
        this.smg.addHasValueEdge(this.hv2has1at4);
    }

    @Test
    public void getNullBytesForObjectTest() {
        SMG smg = SMGTest.getNewSMG64();
        smg.addObject(this.obj1);
        SMGEdgeHasValue hv = new SMGEdgeHasValue(this.mockType, 4, (SMGObject)this.obj1, smg.getNullValue());
        smg.addHasValueEdge(hv);
        BitSet bs = smg.getNullBytesForObject(this.obj1);
        Assert.assertFalse((boolean)bs.get(0));
        Assert.assertFalse((boolean)bs.get(3));
        Assert.assertTrue((boolean)bs.get(4));
        Assert.assertTrue((boolean)bs.get(7));
    }

    @Test
    public void replaceHVSetTest() {
        SMGEdgeHasValue hv = new SMGEdgeHasValue(this.mockType, 2, (SMGObject)this.obj1, (int)this.val1);
        HashSet<SMGEdgeHasValue> hvSet = new HashSet<SMGEdgeHasValue>();
        hvSet.add(hv);
        this.smg.replaceHVSet(hvSet);
        Set<SMGEdgeHasValue> newHVSet = this.smg.getHVEdges();
        Assert.assertTrue((boolean)hvSet.equals(newHVSet));
    }

    @Test
    public void SMGConstructorTest() {
        SMG smg = SMGTest.getNewSMG64();
        Assert.assertTrue((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg));
        SMGObject nullObject = smg.getNullObject();
        int nullAddress = smg.getNullValue();
        Assert.assertNotNull((Object)nullObject);
        Assert.assertFalse((boolean)nullObject.notNull());
        Assert.assertEquals((long)1L, (long)smg.getObjects().size());
        Assert.assertTrue((boolean)smg.getObjects().contains(nullObject));
        Assert.assertEquals((long)1L, (long)smg.getValues().size());
        Assert.assertTrue((boolean)smg.getValues().contains(nullAddress));
        Assert.assertEquals((long)1L, (long)smg.getPTEdges().size());
        SMGObject target_object = smg.getObjectPointedBy(nullAddress);
        Assert.assertEquals((Object)nullObject, (Object)target_object);
        Assert.assertEquals((long)0L, (long)smg.getHVEdges().size());
        SMG smg_copy = new SMG(smg);
        Assert.assertTrue((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg));
        Assert.assertTrue((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg_copy));
        SMGRegion third_object = new SMGRegion(16, "object-3");
        Integer third_value = 3;
        smg_copy.addObject(third_object);
        smg_copy.addValue(third_value);
        smg_copy.addHasValueEdge(new SMGEdgeHasValue(this.mockType, 0, (SMGObject)third_object, (int)third_value));
        smg_copy.addPointsToEdge(new SMGEdgePointsTo(third_value, third_object, 0));
        Assert.assertTrue((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg));
        Assert.assertTrue((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg_copy));
        Assert.assertEquals((long)1L, (long)smg.getObjects().size());
        Assert.assertEquals((long)2L, (long)smg_copy.getObjects().size());
        Assert.assertTrue((boolean)smg_copy.getObjects().contains(third_object));
        Assert.assertEquals((long)1L, (long)smg.getValues().size());
        Assert.assertEquals((long)2L, (long)smg_copy.getValues().size());
        Assert.assertTrue((boolean)smg_copy.getValues().contains(third_value));
        Assert.assertEquals((long)1L, (long)smg.getPTEdges().size());
        Assert.assertEquals((long)2L, (long)smg_copy.getPTEdges().size());
        SMGObject target_object_for_third = smg_copy.getObjectPointedBy(third_value);
        Assert.assertEquals((Object)third_object, (Object)target_object_for_third);
        Assert.assertEquals((long)0L, (long)smg.getHVEdges().size());
        Assert.assertEquals((long)1L, (long)smg_copy.getHVEdges().size());
    }

    @Test
    public void addRemoveHasValueEdgeTest() {
        SMG smg = SMGTest.getNewSMG64();
        SMGRegion object = new SMGRegion(4, "object");
        SMGEdgeHasValue hv = new SMGEdgeHasValue(this.mockType, 0, (SMGObject)object, smg.getNullValue());
        smg.addHasValueEdge(hv);
        Assert.assertTrue((boolean)smg.getHVEdges().contains(hv));
        smg.removeHasValueEdge(hv);
        Assert.assertFalse((boolean)smg.getHVEdges().contains(hv));
    }

    @Test
    public void removeObjectTest() {
        SMG smg = SMGTest.getNewSMG64();
        Integer newValue = SMGValueFactory.getNewValue();
        SMGRegion object = new SMGRegion(8, "object");
        SMGEdgeHasValue hv0 = new SMGEdgeHasValue(this.mockType, 0, (SMGObject)object, 0);
        SMGEdgeHasValue hv4 = new SMGEdgeHasValue(this.mockType, 4, (SMGObject)object, 0);
        SMGEdgePointsTo pt = new SMGEdgePointsTo(newValue, object, 0);
        smg.addValue(newValue);
        smg.addObject(object);
        smg.addPointsToEdge(pt);
        smg.addHasValueEdge(hv0);
        smg.addHasValueEdge(hv4);
        Assert.assertTrue((boolean)smg.getObjects().contains(object));
        smg.removeObject(object);
        Assert.assertFalse((boolean)smg.getObjects().contains(object));
        Assert.assertTrue((boolean)smg.getHVEdges().contains(hv0));
        Assert.assertTrue((boolean)smg.getHVEdges().contains(hv4));
        Assert.assertTrue((boolean)smg.getPTEdges().values().contains(pt));
    }

    @Test
    public void removeObjectAndEdgesTest() {
        SMG smg = SMGTest.getNewSMG64();
        Integer newValue = SMGValueFactory.getNewValue();
        SMGRegion object = new SMGRegion(8, "object");
        SMGEdgeHasValue hv0 = new SMGEdgeHasValue(this.mockType, 0, (SMGObject)object, 0);
        SMGEdgeHasValue hv4 = new SMGEdgeHasValue(this.mockType, 4, (SMGObject)object, 0);
        SMGEdgePointsTo pt = new SMGEdgePointsTo(newValue, object, 0);
        smg.addValue(newValue);
        smg.addObject(object);
        smg.addPointsToEdge(pt);
        smg.addHasValueEdge(hv0);
        smg.addHasValueEdge(hv4);
        Assert.assertTrue((boolean)smg.getObjects().contains(object));
        smg.removeObjectAndEdges(object);
        Assert.assertFalse((boolean)smg.getObjects().contains(object));
        Assert.assertFalse((boolean)smg.getHVEdges().contains(hv0));
        Assert.assertFalse((boolean)smg.getHVEdges().contains(hv4));
        Assert.assertFalse((boolean)smg.getPTEdges().values().contains(pt));
    }

    @Test
    public void validityTest() {
        Assert.assertFalse((boolean)this.smg.isObjectValid(this.smg.getNullObject()));
        Assert.assertTrue((boolean)this.smg.isObjectValid(this.obj1));
        Assert.assertTrue((boolean)this.smg.isObjectValid(this.obj2));
        SMG smg_copy = new SMG(this.smg);
        Assert.assertTrue((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg_copy));
        Assert.assertTrue((boolean)SMGConsistencyVerifier.verifySMG(this.logger, this.smg));
        this.smg.setValidity(this.obj1, false);
        Assert.assertTrue((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg_copy));
        Assert.assertTrue((boolean)SMGConsistencyVerifier.verifySMG(this.logger, this.smg));
        Assert.assertFalse((boolean)this.smg.isObjectValid(this.smg.getNullObject()));
        Assert.assertFalse((boolean)this.smg.isObjectValid(this.obj1));
        Assert.assertTrue((boolean)this.smg.isObjectValid(this.obj2));
        Assert.assertFalse((boolean)smg_copy.isObjectValid(smg_copy.getNullObject()));
        Assert.assertTrue((boolean)smg_copy.isObjectValid(this.obj1));
        Assert.assertTrue((boolean)smg_copy.isObjectValid(this.obj2));
        this.smg.setValidity(this.obj2, false);
        Assert.assertTrue((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg_copy));
        Assert.assertFalse((boolean)smg_copy.isObjectValid(smg_copy.getNullObject()));
        Assert.assertTrue((boolean)smg_copy.isObjectValid(this.obj1));
        Assert.assertTrue((boolean)smg_copy.isObjectValid(this.obj2));
    }

    @Test
    public void consistencyViolationInvalidRegionHasValueTest() {
        this.smg.setValidity(this.obj1, false);
        Assert.assertTrue((boolean)SMGConsistencyVerifier.verifySMG(this.logger, this.smg));
        this.smg.setValidity(this.obj2, false);
        Assert.assertFalse((boolean)SMGConsistencyVerifier.verifySMG(this.logger, this.smg));
    }

    @Test
    public void consistencyViolationFieldConsistency() {
        SMG smg1 = SMGTest.getNewSMG64();
        SMG smg2 = SMGTest.getNewSMG64();
        SMGRegion object_2b = new SMGRegion(2, "object_2b");
        SMGRegion object_4b = new SMGRegion(4, "object_4b");
        Integer random_value = 6;
        smg1.addObject(object_2b);
        smg2.addObject(object_4b);
        smg1.addValue(random_value);
        smg2.addValue(random_value);
        SMGEdgeHasValue invalidHV1 = new SMGEdgeHasValue(this.mockType, 0, (SMGObject)object_2b, (int)random_value);
        SMGEdgeHasValue invalidHV2 = new SMGEdgeHasValue(this.mockType, 8, (SMGObject)object_4b, (int)random_value);
        smg1.addHasValueEdge(invalidHV1);
        smg2.addHasValueEdge(invalidHV2);
        Assert.assertFalse((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg1));
        Assert.assertFalse((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg2));
    }

    @Test
    public void consistencyViolationHVConsistency() {
        SMG smg = SMGTest.getNewSMG64();
        SMGRegion object_8b = new SMGRegion(8, "object_8b");
        SMGRegion object_16b = new SMGRegion(10, "object_10b");
        Integer first_value = 6;
        Integer second_value = 8;
        SMGEdgeHasValue hv_edge1 = new SMGEdgeHasValue(this.mockType, 0, (SMGObject)object_8b, (int)first_value);
        SMGEdgeHasValue hv_edge2 = new SMGEdgeHasValue(this.mockType, 0, (SMGObject)object_8b, (int)second_value);
        SMGEdgeHasValue hv_edge3 = new SMGEdgeHasValue(this.mockType, 4, (SMGObject)object_8b, (int)second_value);
        SMGEdgeHasValue hv_edge4 = new SMGEdgeHasValue(this.mockType, 0, (SMGObject)object_16b, (int)second_value);
        Assert.assertTrue((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg));
        smg.addHasValueEdge(hv_edge1);
        Assert.assertFalse((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg));
        smg.addObject(object_8b);
        Assert.assertFalse((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg));
        smg.addValue(first_value);
        Assert.assertTrue((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg));
        smg.addHasValueEdge(hv_edge3);
        Assert.assertFalse((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg));
        smg.addValue(second_value);
        Assert.assertTrue((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg));
        smg.addHasValueEdge(hv_edge4);
        Assert.assertFalse((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg));
        smg.addObject(object_16b);
        Assert.assertTrue((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg));
        smg.addHasValueEdge(hv_edge2);
        Assert.assertFalse((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg));
    }

    @Test
    public void consistencyViolationPTConsistency() {
        SMG smg = SMGTest.getNewSMG64();
        SMGRegion object_8b = new SMGRegion(8, "object_8b");
        SMGRegion object_16b = new SMGRegion(10, "object_10b");
        Integer first_value = 6;
        Integer second_value = 8;
        Integer third_value = 10;
        SMGEdgePointsTo edge1 = new SMGEdgePointsTo(first_value, object_8b, 0);
        SMGEdgePointsTo edge2 = new SMGEdgePointsTo(third_value, object_8b, 4);
        SMGEdgePointsTo edge3 = new SMGEdgePointsTo(second_value, object_16b, 0);
        SMGEdgePointsTo edge4 = new SMGEdgePointsTo(first_value, object_16b, 0);
        Assert.assertTrue((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg));
        smg.addPointsToEdge(edge1);
        Assert.assertFalse((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg));
        smg.addValue(first_value);
        Assert.assertFalse((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg));
        smg.addObject(object_8b);
        Assert.assertTrue((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg));
        smg.addPointsToEdge(edge2);
        Assert.assertFalse((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg));
        smg.addValue(third_value);
        Assert.assertTrue((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg));
        smg.addPointsToEdge(edge3);
        Assert.assertFalse((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg));
        smg.addObject(object_16b);
        Assert.assertFalse((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg));
        smg.addValue(second_value);
        Assert.assertTrue((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg));
        smg.addPointsToEdge(edge4);
        Assert.assertFalse((boolean)SMGConsistencyVerifier.verifySMG(this.logger, smg));
    }

    @Test(expected=IllegalArgumentException.class)
    public void isObjectValidBadCallTest() {
        this.smg.isObjectValid(new SMGRegion(24, "wee"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void setValidityBadCallTest() {
        this.smg.setValidity(new SMGRegion(24, "wee"), true);
    }

    @Test
    public void getObjectsTest() {
        HashSet<SMGObject> set = new HashSet<SMGObject>();
        set.add(this.obj1);
        set.add(this.obj2);
        set.add(this.smg.getNullObject());
        Assert.assertTrue((boolean)this.smg.getObjects().containsAll(set));
    }

    @Test
    public void getNullObjectTest() {
        SMGObject nullObject = this.smg.getNullObject();
        Assert.assertFalse((boolean)this.smg.isObjectValid(nullObject));
        Assert.assertEquals((long)nullObject.getSize(), (long)0L);
    }

    @Test
    public void getValuesTest() {
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(this.val1);
        set.add(this.val2);
        set.add(this.smg.getNullValue());
        Assert.assertTrue((boolean)this.smg.getValues().containsAll(set));
    }

    @Test
    public void getHVEdgesTest() {
        HashSet<SMGEdgeHasValue> set = new HashSet<SMGEdgeHasValue>();
        set.add(this.hv2has2at0);
        set.add(this.hv2has1at4);
        Assert.assertTrue((boolean)this.smg.getHVEdges().containsAll(set));
    }

    @Test
    public void getPTEdgesTest() {
        HashSet<SMGEdgePointsTo> set = new HashSet<SMGEdgePointsTo>();
        set.add(this.pt1to1);
        Assert.assertTrue((boolean)this.smg.getPTEdges().values().containsAll(set));
    }

    @Test
    public void getObjectPointedByTest() {
        Assert.assertEquals((Object)this.obj1, (Object)this.smg.getObjectPointedBy(this.val1));
        Assert.assertNull((Object)this.smg.getObjectPointedBy(this.val2));
    }

    @Test
    public void neqBasicTest() {
        NeqRelation nr = new NeqRelation();
        Integer one = 1;
        Integer two = 2;
        Integer three = 3;
        Assert.assertFalse((boolean)nr.neq_exists(one, two));
        Assert.assertFalse((boolean)nr.neq_exists(one, three));
        Assert.assertFalse((boolean)nr.neq_exists(two, three));
        Assert.assertFalse((boolean)nr.neq_exists(two, one));
        Assert.assertFalse((boolean)nr.neq_exists(three, one));
        Assert.assertFalse((boolean)nr.neq_exists(three, two));
        nr.add_relation(one, three);
        Assert.assertFalse((boolean)nr.neq_exists(one, two));
        Assert.assertTrue((boolean)nr.neq_exists(one, three));
        Assert.assertFalse((boolean)nr.neq_exists(two, three));
        Assert.assertFalse((boolean)nr.neq_exists(two, one));
        Assert.assertTrue((boolean)nr.neq_exists(three, one));
        Assert.assertFalse((boolean)nr.neq_exists(three, two));
        nr.add_relation(one, three);
        Assert.assertFalse((boolean)nr.neq_exists(one, two));
        Assert.assertTrue((boolean)nr.neq_exists(one, three));
        Assert.assertFalse((boolean)nr.neq_exists(two, three));
        Assert.assertFalse((boolean)nr.neq_exists(two, one));
        Assert.assertTrue((boolean)nr.neq_exists(three, one));
        Assert.assertFalse((boolean)nr.neq_exists(three, two));
        nr.add_relation(two, three);
        Assert.assertFalse((boolean)nr.neq_exists(one, two));
        Assert.assertTrue((boolean)nr.neq_exists(one, three));
        Assert.assertTrue((boolean)nr.neq_exists(two, three));
        Assert.assertFalse((boolean)nr.neq_exists(two, one));
        Assert.assertTrue((boolean)nr.neq_exists(three, one));
        Assert.assertTrue((boolean)nr.neq_exists(three, two));
        nr.remove_relation(one, three);
        Assert.assertFalse((boolean)nr.neq_exists(one, two));
        Assert.assertFalse((boolean)nr.neq_exists(one, three));
        Assert.assertTrue((boolean)nr.neq_exists(two, three));
        Assert.assertFalse((boolean)nr.neq_exists(two, one));
        Assert.assertFalse((boolean)nr.neq_exists(three, one));
        Assert.assertTrue((boolean)nr.neq_exists(three, two));
    }

    @Test
    public void neqPutAllTest() {
        NeqRelation nr = new NeqRelation();
        NeqRelation newNr = new NeqRelation();
        Integer one = 1;
        Integer two = 2;
        Integer three = 3;
        nr.add_relation(one, three);
        newNr.putAll(nr);
        Assert.assertFalse((boolean)nr.neq_exists(one, two));
        Assert.assertTrue((boolean)nr.neq_exists(one, three));
        Assert.assertFalse((boolean)nr.neq_exists(two, three));
        Assert.assertFalse((boolean)newNr.neq_exists(two, one));
        Assert.assertTrue((boolean)newNr.neq_exists(three, one));
        Assert.assertFalse((boolean)newNr.neq_exists(three, two));
        nr.remove_relation(one, three);
        Assert.assertFalse((boolean)nr.neq_exists(one, two));
        Assert.assertFalse((boolean)nr.neq_exists(one, three));
        Assert.assertFalse((boolean)nr.neq_exists(two, three));
        Assert.assertFalse((boolean)newNr.neq_exists(two, one));
        Assert.assertTrue((boolean)newNr.neq_exists(three, one));
        Assert.assertFalse((boolean)newNr.neq_exists(three, two));
    }

    @Test
    public void neqRemoveValueTest() {
        NeqRelation nr = new NeqRelation();
        Integer one = 1;
        Integer two = 2;
        Integer three = 3;
        nr.add_relation(one, two);
        nr.add_relation(one, three);
        nr.removeValue(one);
        Assert.assertFalse((boolean)nr.neq_exists(one, two));
        Assert.assertFalse((boolean)nr.neq_exists(one, three));
        Assert.assertFalse((boolean)nr.neq_exists(two, three));
    }

    @Test
    public void neqMergeValuesTest() {
        NeqRelation nr = new NeqRelation();
        Integer one = 1;
        Integer two = 2;
        Integer three = 3;
        nr.add_relation(one, three);
        nr.mergeValues(two, three);
        Assert.assertTrue((boolean)nr.neq_exists(one, two));
        Assert.assertFalse((boolean)nr.neq_exists(one, three));
        Assert.assertFalse((boolean)nr.neq_exists(two, three));
    }
}

