/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smgfork.join;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.sosy_lab.cpachecker.cpa.smgfork.CLangStackFrame;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smgfork.graphs.ReadableSMG;
import org.sosy_lab.cpachecker.cpa.smgfork.graphs.SMGFactory;
import org.sosy_lab.cpachecker.cpa.smgfork.graphs.WritableSMG;
import org.sosy_lab.cpachecker.cpa.smgfork.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smgfork.join.SMGJoinSubSMGs;
import org.sosy_lab.cpachecker.cpa.smgfork.join.SMGNodeMapping;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGRegion;

public final class SMGJoin {
    private boolean defined = false;
    private SMGJoinStatus status = SMGJoinStatus.EQUAL;
    private final WritableSMG smg;

    public static void performChecks(boolean pOn) {
        SMGJoinSubSMGs.performChecks(pOn);
    }

    public SMGJoin(ReadableSMG pSMG1, ReadableSMG pSMG2) throws SMGInconsistentException {
        CLangStackFrame frameInSMG2;
        CLangStackFrame frameInSMG1;
        WritableSMG opSMG1 = SMGFactory.createWritableCopy(pSMG1);
        WritableSMG opSMG2 = SMGFactory.createWritableCopy(pSMG2);
        this.smg = SMGFactory.createWritableSMG(opSMG1.getMachineModel());
        SMGNodeMapping mapping1 = new SMGNodeMapping();
        SMGNodeMapping mapping2 = new SMGNodeMapping();
        Map<String, SMGRegion> globals_in_smg1 = opSMG1.getGlobalObjects();
        ArrayDeque<CLangStackFrame> stack_in_smg1 = opSMG1.getStackFrames();
        Map<String, SMGRegion> globals_in_smg2 = opSMG2.getGlobalObjects();
        ArrayDeque<CLangStackFrame> stack_in_smg2 = opSMG2.getStackFrames();
        HashSet<String> globalVars = new HashSet<String>();
        globalVars.addAll(globals_in_smg1.keySet());
        globalVars.addAll(globals_in_smg2.keySet());
        for (String globalVar : globalVars) {
            SMGRegion globalInSMG1 = globals_in_smg1.get(globalVar);
            SMGRegion globalInSMG2 = globals_in_smg2.get(globalVar);
            if (globalInSMG1 == null || globalInSMG2 == null) {
                return;
            }
            SMGRegion finalObject = new SMGRegion(globalInSMG1);
            this.smg.addGlobalObject(finalObject);
            mapping1.map(globalInSMG1, finalObject);
            mapping2.map(globalInSMG2, finalObject);
        }
        Iterator<CLangStackFrame> smg1stackIterator = stack_in_smg1.descendingIterator();
        Iterator<CLangStackFrame> smg2stackIterator = stack_in_smg2.descendingIterator();
        while (smg1stackIterator.hasNext() && smg2stackIterator.hasNext()) {
            frameInSMG1 = smg1stackIterator.next();
            frameInSMG2 = smg2stackIterator.next();
            this.smg.addStackFrame(frameInSMG1.getFunctionDeclaration());
            HashSet<String> localVars = new HashSet<String>();
            localVars.addAll(frameInSMG1.getVariables().keySet());
            localVars.addAll(frameInSMG2.getVariables().keySet());
            for (String localVar : localVars) {
                if (!frameInSMG1.containsVariable(localVar) || !frameInSMG2.containsVariable(localVar)) {
                    return;
                }
                SMGRegion localInSMG1 = frameInSMG1.getVariable(localVar);
                SMGRegion localInSMG2 = frameInSMG2.getVariable(localVar);
                SMGRegion finalObject = new SMGRegion(localInSMG1);
                this.smg.addStackObject(finalObject);
                mapping1.map(localInSMG1, finalObject);
                mapping2.map(localInSMG2, finalObject);
            }
        }
        for (Map.Entry<String, SMGRegion> entry : globals_in_smg1.entrySet()) {
            SMGObject destinationGlobal;
            SMGObject globalInSMG2;
            SMGObject globalInSMG1 = entry.getValue();
            SMGJoinSubSMGs jss = new SMGJoinSubSMGs(this.status, opSMG1, opSMG2, this.smg, mapping1, mapping2, globalInSMG1, globalInSMG2 = (SMGObject)globals_in_smg2.get(entry.getKey()), destinationGlobal = mapping1.get(globalInSMG1));
            if (!jss.isDefined()) {
                return;
            }
            this.status = jss.getStatus();
        }
        smg1stackIterator = stack_in_smg1.iterator();
        smg2stackIterator = stack_in_smg2.iterator();
        while (smg1stackIterator.hasNext() && smg2stackIterator.hasNext()) {
            frameInSMG1 = smg1stackIterator.next();
            frameInSMG2 = smg2stackIterator.next();
            for (String localVar : frameInSMG1.getVariables().keySet()) {
                SMGObject destinationLocal;
                SMGRegion localInSMG2;
                SMGRegion localInSMG1 = frameInSMG1.getVariable(localVar);
                SMGJoinSubSMGs jss = new SMGJoinSubSMGs(this.status, opSMG1, opSMG2, this.smg, mapping1, mapping2, localInSMG1, localInSMG2 = frameInSMG2.getVariable(localVar), destinationLocal = mapping1.get(localInSMG1));
                if (!jss.isDefined()) {
                    return;
                }
                this.status = jss.getStatus();
            }
        }
        this.defined = true;
    }

    public boolean isDefined() {
        return this.defined;
    }

    public SMGJoinStatus getStatus() {
        return this.status;
    }

    public ReadableSMG getJointSMG() {
        return this.smg;
    }
}

