/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smgfork.join;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGValueFactory;
import org.sosy_lab.cpachecker.cpa.smgfork.graphs.SMGFactory;
import org.sosy_lab.cpachecker.cpa.smgfork.graphs.WritableSMG;
import org.sosy_lab.cpachecker.cpa.smgfork.join.SMGJoinMapTargetAddress;
import org.sosy_lab.cpachecker.cpa.smgfork.join.SMGNodeMapping;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGRegion;

public class SMGJoinMapTargetAddressTest {
    private WritableSMG smg1;
    private WritableSMG destSMG;
    private SMGNodeMapping mapping1;
    private SMGNodeMapping mapping2;
    final SMGRegion obj1 = new SMGRegion(8, "ze label");
    final Integer value1 = SMGValueFactory.getNewValue();
    final SMGEdgePointsTo edge1 = new SMGEdgePointsTo(this.value1, this.obj1, 0);
    final Integer value2 = SMGValueFactory.getNewValue();
    final SMGObject destObj = new SMGRegion(8, "destination");
    final Integer destValue = SMGValueFactory.getNewValue();

    @Before
    public void setUp() {
        this.smg1 = SMGFactory.createWritableSMG(MachineModel.LINUX64);
        this.destSMG = SMGFactory.createWritableSMG(MachineModel.LINUX64);
        this.mapping1 = new SMGNodeMapping();
        this.mapping2 = new SMGNodeMapping();
    }

    @Test
    public void mapTargetAddressExistingNull() {
        WritableSMG origDestSMG = SMGFactory.createWritableCopy(this.destSMG);
        SMGNodeMapping origMapping1 = new SMGNodeMapping(this.mapping1);
        SMGJoinMapTargetAddress mta = new SMGJoinMapTargetAddress(this.smg1, null, this.destSMG, this.mapping1, null, this.smg1.getNullValue(), null);
        Assert.assertEquals((Object)origDestSMG, (Object)mta.getSMG());
        Assert.assertEquals((Object)origMapping1, (Object)mta.getMapping1());
        Assert.assertNull((Object)mta.getMapping2());
        Assert.assertSame((Object)this.destSMG.getNullValue(), (Object)mta.getValue());
    }

    @Test
    public void mapTargetAddressExisting() {
        SMGEdgePointsTo destEdge = new SMGEdgePointsTo(this.destValue, this.destObj, 0);
        this.smg1.addValue(this.value1);
        this.smg1.addObject(this.obj1);
        this.smg1.addPointsToEdge(this.edge1);
        this.destSMG.addValue(this.destValue);
        this.destSMG.addObject(this.destObj);
        this.destSMG.addPointsToEdge(destEdge);
        this.mapping1.map(this.obj1, this.destObj);
        SMGNodeMapping origMapping1 = new SMGNodeMapping(this.mapping1);
        WritableSMG origDestSMG = SMGFactory.createWritableCopy(this.destSMG);
        SMGJoinMapTargetAddress mta = new SMGJoinMapTargetAddress(this.smg1, null, this.destSMG, this.mapping1, null, this.value1, null);
        Assert.assertEquals((Object)origDestSMG, (Object)mta.getSMG());
        Assert.assertEquals((Object)origMapping1, (Object)mta.getMapping1());
        Assert.assertNull((Object)mta.getMapping2());
        Assert.assertSame((Object)this.destValue, (Object)mta.getValue());
    }

    @Test
    public void mapTargetAddressNew() {
        this.smg1.addValue(this.value1);
        this.smg1.addObject(this.obj1);
        this.smg1.addPointsToEdge(this.edge1);
        this.destSMG.addObject(this.destObj);
        this.mapping1.map(this.obj1, this.destObj);
        SMGNodeMapping origMapping1 = new SMGNodeMapping(this.mapping1);
        SMGNodeMapping origMapping2 = new SMGNodeMapping(this.mapping2);
        WritableSMG origDestSMG = SMGFactory.createWritableCopy(this.destSMG);
        SMGJoinMapTargetAddress mta = new SMGJoinMapTargetAddress(this.smg1, null, this.destSMG, this.mapping1, this.mapping2, this.value1, this.value2);
        Assert.assertNotEquals((Object)origDestSMG, (Object)mta.getSMG());
        Assert.assertNotEquals((Object)origMapping1, (Object)mta.getMapping1());
        Assert.assertNotEquals((Object)origMapping2, (Object)mta.getMapping2());
        Assert.assertFalse((boolean)origDestSMG.getValues().contains(mta.getValue()));
        SMGEdgePointsTo newEdge = this.destSMG.getPointer(mta.getValue());
        Assert.assertSame((Object)this.destObj, (Object)newEdge.getObject());
        Assert.assertEquals((long)0L, (long)newEdge.getOffset());
        Assert.assertSame((Object)mta.getValue(), (Object)mta.getMapping1().get(this.value1));
        Assert.assertSame((Object)mta.getValue(), (Object)mta.getMapping2().get(this.value2));
    }
}

