/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smgfork.join;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smgfork.graphs.ReadableSMG;
import org.sosy_lab.cpachecker.cpa.smgfork.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smgfork.join.SMGNodeMapping;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGAbstractObject;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGObject;

final class SMGJoinMatchObjects {
    private boolean defined = false;
    private SMGJoinStatus status;

    private static final boolean checkNull(SMGObject pObj1, SMGObject pObj2) {
        return !pObj1.notNull() || !pObj2.notNull();
    }

    private static final boolean checkMatchingMapping(SMGObject pObj1, SMGObject pObj2, SMGNodeMapping pMapping1, SMGNodeMapping pMapping2, ReadableSMG pSMG1, ReadableSMG pSMG2) {
        return pMapping1.containsKey(pObj1) && pMapping2.containsKey(pObj2) && pMapping1.get(pObj1) != pMapping2.get(pObj2);
    }

    private static final boolean checkConsistentMapping(SMGObject pObj1, SMGObject pObj2, SMGNodeMapping pMapping1, SMGNodeMapping pMapping2, ReadableSMG pSMG1, ReadableSMG pSMG2) {
        return pMapping1.containsKey(pObj1) && pMapping2.containsValue(pMapping1.get(pObj1)) || pMapping2.containsKey(pObj2) && pMapping1.containsValue(pMapping2.get(pObj2));
    }

    private static final boolean checkConsistentObjects(SMGObject pObj1, SMGObject pObj2, ReadableSMG pSMG1, ReadableSMG pSMG2) {
        return pObj1.getSize() != pObj2.getSize() || pSMG1.isObjectValid(pObj1) != pSMG2.isObjectValid(pObj2);
    }

    private static final boolean checkConsistentFields(SMGObject pObj1, SMGObject pObj2, SMGNodeMapping pMapping1, SMGNodeMapping pMapping2, ReadableSMG pSMG1, ReadableSMG pSMG2) {
        ArrayList<SMGEdgeHasValue> fields = new ArrayList<SMGEdgeHasValue>();
        fields.addAll(pSMG1.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObj1)));
        fields.addAll(pSMG2.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObj2)));
        for (SMGEdgeHasValue hv : fields) {
            Set<SMGEdgeHasValue> hv1 = pSMG1.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObj1).filterByType(hv.getType()).filterAtOffset(hv.getOffset()));
            Set<SMGEdgeHasValue> hv2 = pSMG2.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObj2).filterByType(hv.getType()).filterAtOffset(hv.getOffset()));
            if (hv1.size() <= 0 || hv2.size() <= 0) continue;
            Integer v1 = ((SMGEdgeHasValue)Iterators.getOnlyElement(hv1.iterator())).getValue();
            Integer v2 = ((SMGEdgeHasValue)Iterators.getOnlyElement(hv2.iterator())).getValue();
            if (!pMapping1.containsKey(v1) || !pMapping2.containsKey(v2) || pMapping1.get(v1).equals(pMapping2.get(v2))) continue;
            return true;
        }
        return false;
    }

    private static boolean checkMatchingAbstractions(SMGObject pObj1, SMGObject pObj2) {
        SMGAbstractObject pAbstract2;
        SMGAbstractObject pAbstract1;
        return pObj1.isAbstract() && pObj2.isAbstract() && (!(pAbstract1 = (SMGAbstractObject)((Object)pObj1)).matchGenericShape(pAbstract2 = (SMGAbstractObject)((Object)pObj2)) || !pAbstract1.matchSpecificShape(pAbstract2));
    }

    public SMGJoinMatchObjects(SMGJoinStatus pStatus, ReadableSMG pSMG1, ReadableSMG pSMG2, SMGNodeMapping pMapping1, SMGNodeMapping pMapping2, SMGObject pObj1, SMGObject pObj2) {
        if (!pSMG1.getObjects().contains(pObj1) || !pSMG2.getObjects().contains(pObj2)) {
            throw new IllegalArgumentException();
        }
        if (SMGJoinMatchObjects.checkNull(pObj1, pObj2)) {
            return;
        }
        if (SMGJoinMatchObjects.checkMatchingMapping(pObj1, pObj2, pMapping1, pMapping2, pSMG1, pSMG2)) {
            return;
        }
        if (SMGJoinMatchObjects.checkConsistentMapping(pObj1, pObj2, pMapping1, pMapping2, pSMG1, pSMG2)) {
            return;
        }
        if (SMGJoinMatchObjects.checkConsistentObjects(pObj1, pObj2, pSMG1, pSMG2)) {
            return;
        }
        if (SMGJoinMatchObjects.checkMatchingAbstractions(pObj1, pObj2)) {
            return;
        }
        if (SMGJoinMatchObjects.checkConsistentFields(pObj1, pObj2, pMapping1, pMapping2, pSMG1, pSMG2)) {
            return;
        }
        this.status = SMGJoinMatchObjects.updateStatusForAbstractions(pObj1, pObj2, pStatus);
        this.defined = true;
    }

    private static SMGJoinStatus updateStatusForAbstractions(SMGObject pObj1, SMGObject pObj2, SMGJoinStatus pStatus) {
        if (pObj1.isMoreGeneral(pObj2)) {
            return SMGJoinStatus.updateStatus(pStatus, SMGJoinStatus.LEFT_ENTAIL);
        }
        if (pObj2.isMoreGeneral(pObj1)) {
            return SMGJoinStatus.updateStatus(pStatus, SMGJoinStatus.RIGHT_ENTAIL);
        }
        return pStatus;
    }

    public SMGJoinStatus getStatus() {
        return this.status;
    }

    public boolean isDefined() {
        return this.defined;
    }
}

