/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smgfork.join;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smgfork.AnonymousTypes;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGValueFactory;
import org.sosy_lab.cpachecker.cpa.smgfork.graphs.SMGFactory;
import org.sosy_lab.cpachecker.cpa.smgfork.graphs.WritableSMG;
import org.sosy_lab.cpachecker.cpa.smgfork.join.SMGJoinMatchObjects;
import org.sosy_lab.cpachecker.cpa.smgfork.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smgfork.join.SMGNodeMapping;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.DummyAbstraction;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.sll.SMGSingleLinkedList;

public class SMGJoinMatchObjectsTest {
    private static final CType mockType2b = AnonymousTypes.createTypeWithLength(2L);
    private WritableSMG smg1;
    private WritableSMG smg2;
    private final SMGObject srcObj1 = new SMGRegion(8, "Source object 1");
    private final SMGObject destObj1 = new SMGRegion(8, "Destination object 1");
    private final SMGRegion srcObj2 = new SMGRegion(8, "Source object 2");
    private final SMGObject destObj2 = new SMGRegion(8, "Destination object 2");
    private SMGNodeMapping mapping1;
    private SMGNodeMapping mapping2;

    @Before
    public void setUp() {
        this.smg1 = SMGFactory.createWritableSMG(MachineModel.LINUX64);
        this.smg2 = SMGFactory.createWritableSMG(MachineModel.LINUX64);
        this.mapping1 = new SMGNodeMapping();
        this.mapping2 = new SMGNodeMapping();
    }

    @Test
    public void nullObjectTest() {
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, null, null, this.smg1.getNullObject(), this.smg2.getNullObject());
        Assert.assertFalse((boolean)mo.isDefined());
        this.smg1.addObject(this.srcObj1);
        mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, null, null, this.srcObj1, this.smg2.getNullObject());
        Assert.assertFalse((boolean)mo.isDefined());
    }

    @Test(expected=IllegalArgumentException.class)
    public void nonMemberObjectsTestObj1() {
        this.smg2.addObject(this.srcObj2);
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, null, null, this.srcObj1, this.srcObj2);
        mo.getStatus();
    }

    @Test(expected=IllegalArgumentException.class)
    public void nonMemberObjectsTestObj2() {
        this.smg1.addObject(this.srcObj1);
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, null, null, this.srcObj1, this.srcObj2);
        mo.getStatus();
    }

    @Test
    public void inconsistentMappingTest() {
        this.mapping1.map(this.srcObj1, this.destObj1);
        this.smg1.addObject(this.srcObj1);
        this.smg2.addObject(this.srcObj2);
        this.mapping2.map(this.srcObj2, this.destObj1);
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, this.srcObj1, this.srcObj2);
        Assert.assertFalse((boolean)mo.isDefined());
    }

    @Test
    public void inconsistentMappingViceVersaTest() {
        this.mapping2.map(this.srcObj2, this.destObj2);
        this.smg2.addObject(this.srcObj2);
        this.smg1.addObject(this.srcObj1);
        this.mapping1.map(this.srcObj1, this.destObj2);
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, this.srcObj1, this.srcObj2);
        Assert.assertFalse((boolean)mo.isDefined());
    }

    @Test
    public void inconsistentObjectsTest() {
        SMGRegion diffSizeObject = new SMGRegion(16, "Object with different size");
        this.smg1.addObject(this.srcObj1);
        this.smg2.addObject(diffSizeObject);
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, this.srcObj1, diffSizeObject);
        Assert.assertFalse((boolean)mo.isDefined());
        this.smg2.addObject(this.srcObj2);
        this.smg2.setValidity(this.srcObj2, false);
        mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, this.srcObj1, this.srcObj2);
        Assert.assertFalse((boolean)mo.isDefined());
    }

    @Test
    public void nonMatchingMappingTest() {
        this.smg1.addObject(this.srcObj1);
        this.smg1.addObject(this.destObj1);
        this.mapping1.map(this.srcObj1, this.destObj1);
        this.smg2.addObject(this.srcObj2);
        this.smg2.addObject(this.destObj2);
        this.mapping2.map(this.srcObj2, this.destObj2);
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, this.srcObj1, this.srcObj2);
        Assert.assertFalse((boolean)mo.isDefined());
    }

    @Test
    public void fieldInconsistencyTest() {
        this.smg1.addObject(this.srcObj1);
        this.smg2.addObject(this.srcObj2);
        SMGEdgeHasValue hv1 = new SMGEdgeHasValue(mockType2b, 0, this.srcObj1, (int)SMGValueFactory.getNewValue());
        SMGEdgeHasValue hv2 = new SMGEdgeHasValue(mockType2b, 2, (SMGObject)this.srcObj2, (int)SMGValueFactory.getNewValue());
        SMGEdgeHasValue hvMatching1 = new SMGEdgeHasValue(mockType2b, 4, this.srcObj1, (int)SMGValueFactory.getNewValue());
        SMGEdgeHasValue hvMatching2 = new SMGEdgeHasValue(mockType2b, 4, (SMGObject)this.srcObj2, (int)SMGValueFactory.getNewValue());
        this.smg1.addHasValueEdge(hv1);
        this.smg1.addValue(hv1.getValue());
        this.smg2.addHasValueEdge(hv2);
        this.smg2.addValue(hv2.getValue());
        this.smg1.addHasValueEdge(hvMatching1);
        this.smg1.addValue(hvMatching1.getValue());
        this.smg2.addHasValueEdge(hvMatching2);
        this.smg2.addValue(hvMatching2.getValue());
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, this.srcObj1, this.srcObj2);
        Assert.assertTrue((boolean)mo.isDefined());
        this.mapping1.map(hvMatching1.getValue(), SMGValueFactory.getNewValue());
        mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, this.srcObj1, this.srcObj2);
        Assert.assertTrue((boolean)mo.isDefined());
        this.mapping2.map(hvMatching2.getValue(), this.mapping1.get(hvMatching1.getValue()));
        mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, this.srcObj1, this.srcObj2);
        Assert.assertTrue((boolean)mo.isDefined());
        this.mapping2.map(hvMatching2.getValue(), SMGValueFactory.getNewValue());
        mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, this.srcObj1, this.srcObj2);
        Assert.assertFalse((boolean)mo.isDefined());
    }

    @Test
    public void sameAbstractionMatchTest() {
        SMGRegion prototype = new SMGRegion(16, "prototype");
        SMGSingleLinkedList sll1 = new SMGSingleLinkedList(prototype, 8, 7);
        SMGSingleLinkedList sll2 = new SMGSingleLinkedList(prototype, 0, 7);
        this.smg1.addObject(sll1);
        this.smg2.addObject(sll2);
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, sll1, sll2);
        Assert.assertFalse((boolean)mo.isDefined());
    }

    @Test
    public void differentAbstractionMatch() {
        SMGRegion prototype = new SMGRegion(16, "prototype");
        SMGSingleLinkedList sll = new SMGSingleLinkedList(prototype, 8, 3);
        DummyAbstraction dummy = new DummyAbstraction(prototype);
        this.smg1.addObject(sll);
        this.smg2.addObject(dummy);
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, sll, dummy);
        Assert.assertFalse((boolean)mo.isDefined());
    }

    @Test
    public void twoAbstractionsTest() {
        SMGRegion prototype = new SMGRegion(16, "prototype");
        SMGSingleLinkedList sll1 = new SMGSingleLinkedList(prototype, 8, 2);
        SMGSingleLinkedList sll2 = new SMGSingleLinkedList(prototype, 8, 4);
        this.smg1.addObject(sll1);
        this.smg2.addObject(sll2);
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, sll1, sll2);
        Assert.assertTrue((boolean)mo.isDefined());
        Assert.assertEquals((Object)((Object)SMGJoinStatus.LEFT_ENTAIL), (Object)((Object)mo.getStatus()));
        sll1 = new SMGSingleLinkedList(prototype, 8, 4);
        this.smg1.addObject(sll1);
        mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, sll1, sll2);
        Assert.assertTrue((boolean)mo.isDefined());
        Assert.assertEquals((Object)((Object)SMGJoinStatus.EQUAL), (Object)((Object)mo.getStatus()));
        sll1 = new SMGSingleLinkedList(prototype, 8, 8);
        this.smg1.addObject(sll1);
        mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, sll1, sll2);
        Assert.assertTrue((boolean)mo.isDefined());
        Assert.assertEquals((Object)((Object)SMGJoinStatus.RIGHT_ENTAIL), (Object)((Object)mo.getStatus()));
    }

    @Test
    public void oneAbstractionTest() {
        SMGRegion prototype = new SMGRegion(16, "prototype");
        SMGSingleLinkedList sll = new SMGSingleLinkedList(prototype, 8, 8);
        this.smg1.addObject(sll);
        this.smg2.addObject(sll);
        this.smg1.addObject(prototype);
        this.smg2.addObject(prototype);
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, sll, prototype);
        Assert.assertTrue((boolean)mo.isDefined());
        Assert.assertEquals((Object)((Object)SMGJoinStatus.LEFT_ENTAIL), (Object)((Object)mo.getStatus()));
        mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, prototype, sll);
        Assert.assertTrue((boolean)mo.isDefined());
        Assert.assertEquals((Object)((Object)SMGJoinStatus.RIGHT_ENTAIL), (Object)((Object)mo.getStatus()));
    }

    @Test
    public void noAbstractionTest() {
        SMGRegion object = new SMGRegion(16, "prototype");
        this.smg1.addObject(object);
        this.smg2.addObject(object);
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, object, object);
        Assert.assertTrue((boolean)mo.isDefined());
        Assert.assertEquals((Object)((Object)SMGJoinStatus.EQUAL), (Object)((Object)mo.getStatus()));
    }
}

