/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smgfork.join;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smgfork.graphs.ReadableSMG;
import org.sosy_lab.cpachecker.cpa.smgfork.graphs.WritableSMG;
import org.sosy_lab.cpachecker.cpa.smgfork.join.SMGJoinFields;
import org.sosy_lab.cpachecker.cpa.smgfork.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smgfork.join.SMGJoinValues;
import org.sosy_lab.cpachecker.cpa.smgfork.join.SMGNodeMapping;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGObject;

final class SMGJoinSubSMGs {
    private static boolean performChecks = false;
    private SMGJoinStatus status;
    private boolean defined = false;
    private ReadableSMG inputSMG1;
    private ReadableSMG inputSMG2;
    private WritableSMG destSMG;
    private SMGNodeMapping mapping1 = null;
    private SMGNodeMapping mapping2 = null;

    public static void performChecks(boolean pValue) {
        performChecks = pValue;
    }

    public SMGJoinSubSMGs(SMGJoinStatus initialStatus, ReadableSMG pSMG1, ReadableSMG pSMG2, WritableSMG pDestSMG, SMGNodeMapping pMapping1, SMGNodeMapping pMapping2, SMGObject pObj1, SMGObject pObj2, SMGObject pNewObject) throws SMGInconsistentException {
        SMGJoinFields joinFields = new SMGJoinFields(pSMG1, pSMG2, pObj1, pObj2);
        this.inputSMG1 = joinFields.getSMG1();
        this.inputSMG2 = joinFields.getSMG2();
        if (performChecks) {
            SMGJoinFields.checkResultConsistency(this.inputSMG1, this.inputSMG2, pObj1, pObj2);
        }
        this.destSMG = pDestSMG;
        this.status = SMGJoinStatus.updateStatus(initialStatus, joinFields.getStatus());
        this.mapping1 = pMapping1;
        this.mapping2 = pMapping2;
        SMGEdgeHasValueFilter filterOnSMG1 = SMGEdgeHasValueFilter.objectFilter(pObj1);
        SMGEdgeHasValueFilter filterOnSMG2 = SMGEdgeHasValueFilter.objectFilter(pObj2);
        HashSet edgesOnObject1 = Sets.newHashSet(this.inputSMG1.getHVEdges(filterOnSMG1));
        for (SMGEdgeHasValue hvIn1 : edgesOnObject1) {
            filterOnSMG2.filterAtOffset(hvIn1.getOffset());
            filterOnSMG2.filterByType(hvIn1.getType());
            SMGEdgeHasValue hvIn2 = (SMGEdgeHasValue)Iterables.getOnlyElement(this.inputSMG2.getHVEdges(filterOnSMG2));
            SMGJoinValues joinValues = new SMGJoinValues(this.status, this.inputSMG1, this.inputSMG2, this.destSMG, this.mapping1, this.mapping2, hvIn1.getValue(), hvIn2.getValue());
            if (!joinValues.isDefined()) {
                return;
            }
            this.status = joinValues.getStatus();
            this.inputSMG1 = joinValues.getInputSMG1();
            this.inputSMG2 = joinValues.getInputSMG2();
            this.destSMG = joinValues.getDestinationSMG();
            this.mapping1 = joinValues.getMapping1();
            this.mapping2 = joinValues.getMapping2();
            SMGEdgeHasValue newHV = new SMGEdgeHasValue(hvIn1.getType(), hvIn1.getOffset(), pNewObject, (int)joinValues.getValue());
            this.destSMG.addHasValueEdge(newHV);
        }
        this.defined = true;
    }

    public boolean isDefined() {
        return this.defined;
    }

    public SMGJoinStatus getStatus() {
        return this.status;
    }

    public ReadableSMG getSMG1() {
        return this.inputSMG1;
    }

    public ReadableSMG getSMG2() {
        return this.inputSMG2;
    }

    public ReadableSMG getDestSMG() {
        return this.destSMG;
    }

    public SMGNodeMapping getMapping1() {
        return this.mapping1;
    }

    public SMGNodeMapping getMapping2() {
        return this.mapping2;
    }
}

