/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smgfork.join;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGValueFactory;
import org.sosy_lab.cpachecker.cpa.smgfork.graphs.SMGFactory;
import org.sosy_lab.cpachecker.cpa.smgfork.graphs.WritableSMG;
import org.sosy_lab.cpachecker.cpa.smgfork.join.SMGJoinMapTargetAddress;
import org.sosy_lab.cpachecker.cpa.smgfork.join.SMGJoinMatchObjects;
import org.sosy_lab.cpachecker.cpa.smgfork.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smgfork.join.SMGJoinTargetObjects;
import org.sosy_lab.cpachecker.cpa.smgfork.join.SMGNodeMapping;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGRegion;

public class SMGJoinTargetObjectsTest {
    private WritableSMG smg1;
    private WritableSMG smg2;
    private WritableSMG destSMG;
    private SMGNodeMapping mapping1;
    private SMGNodeMapping mapping2;
    private final SMGObject obj1 = new SMGRegion(8, "ze label");
    private final Integer value1 = SMGValueFactory.getNewValue();
    private final SMGEdgePointsTo pt1 = new SMGEdgePointsTo(this.value1, this.obj1, 0);
    private final SMGObject obj2 = new SMGRegion(8, "ze label");
    private final Integer value2 = SMGValueFactory.getNewValue();
    private final SMGEdgePointsTo pt2 = new SMGEdgePointsTo(this.value2, this.obj2, 0);
    private final SMGObject destObj = new SMGRegion(8, "destination");

    @Before
    public void setUp() {
        this.smg1 = SMGFactory.createWritableSMG(MachineModel.LINUX64);
        this.smg2 = SMGFactory.createWritableSMG(MachineModel.LINUX64);
        this.destSMG = SMGFactory.createWritableSMG(MachineModel.LINUX64);
        this.mapping1 = new SMGNodeMapping();
        this.mapping2 = new SMGNodeMapping();
    }

    @Test
    public void matchingObjectsWithoutMappingTest() throws SMGInconsistentException {
        this.smg1.addObject(this.obj1);
        this.smg1.addValue(this.value1);
        this.smg1.addPointsToEdge(this.pt1);
        this.smg2.addObject(this.obj2);
        this.smg2.addValue(this.value2);
        this.smg2.addPointsToEdge(this.pt2);
        SMGJoinTargetObjects jto = new SMGJoinTargetObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.destSMG, this.mapping1, this.mapping2, this.value1, this.value2);
        Assert.assertSame((Object)jto.getMapping1().get(this.obj1), (Object)jto.getMapping2().get(this.obj2));
        Assert.assertNotSame((Object)jto.getMapping1().get(this.obj1), (Object)this.obj1);
        Assert.assertTrue((boolean)((SMGRegion)jto.getMapping1().get(this.obj1)).propertiesEqual((SMGRegion)this.obj1));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void matchingObjectsWithMappingTest() throws SMGInconsistentException {
        this.smg1.addObject(this.obj1);
        this.smg1.addValue(this.value1);
        this.smg1.addPointsToEdge(this.pt1);
        this.smg2.addObject(this.obj2);
        this.smg2.addValue(this.value2);
        this.smg2.addPointsToEdge(this.pt2);
        this.destSMG.addObject(this.destObj);
        this.mapping1.map(this.obj1, this.destObj);
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, this.obj1, this.obj2);
        Assert.assertTrue((boolean)mo.isDefined());
        SMGJoinTargetObjects jto = new SMGJoinTargetObjects(mo.getStatus(), this.smg1, this.smg2, this.destSMG, this.mapping1, this.mapping2, this.value1, this.value2);
        jto.getStatus();
    }

    @Test
    public void nonMatchingObjectsTest() throws SMGInconsistentException {
        this.smg1.addObject(this.obj1);
        this.smg1.addValue(this.value1);
        this.smg1.addPointsToEdge(this.pt1);
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, this.obj1, this.smg2.getNullObject());
        Assert.assertFalse((boolean)mo.isDefined());
        SMGJoinTargetObjects jto = new SMGJoinTargetObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.destSMG, this.mapping1, this.mapping2, this.value1, this.smg2.getNullValue());
        Assert.assertFalse((boolean)jto.isDefined());
        Assert.assertTrue((boolean)jto.isRecoverable());
    }

    @Test
    public void joinTargetObjectsDifferentOffsets() throws SMGInconsistentException {
        SMGEdgePointsTo pt1null = new SMGEdgePointsTo(this.value1, this.smg1.getNullObject(), 2);
        SMGEdgePointsTo pt2null = new SMGEdgePointsTo(this.value2, this.smg2.getNullObject(), 1);
        this.smg1.addObject(this.obj1);
        this.smg1.addValue(this.value1);
        this.smg1.addPointsToEdge(pt1null);
        this.smg2.addObject(this.obj2);
        this.smg2.addValue(this.value2);
        this.smg2.addPointsToEdge(pt2null);
        SMGJoinTargetObjects jto = new SMGJoinTargetObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, null, null, null, this.value1, this.value2);
        Assert.assertFalse((boolean)jto.isDefined());
        Assert.assertTrue((boolean)jto.isRecoverable());
    }

    @Test
    public void joinTargetObjectsAlreadyJoinedNull() throws SMGInconsistentException {
        SMGEdgePointsTo pt1null = new SMGEdgePointsTo(this.value1, this.smg1.getNullObject(), 0);
        SMGEdgePointsTo pt2null = new SMGEdgePointsTo(this.value2, this.smg2.getNullObject(), 0);
        this.smg1.addValue(this.value1);
        this.smg2.addValue(this.value2);
        this.smg1.addPointsToEdge(pt1null);
        this.smg2.addPointsToEdge(pt2null);
        SMGJoinMapTargetAddress mta = new SMGJoinMapTargetAddress(SMGFactory.createWritableCopy(this.smg1), SMGFactory.createWritableCopy(this.smg2), SMGFactory.createWritableCopy(this.destSMG), new SMGNodeMapping(this.mapping1), new SMGNodeMapping(this.mapping2), this.value1, this.value2);
        SMGJoinTargetObjects jto = new SMGJoinTargetObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.destSMG, this.mapping1, this.mapping2, this.value1, this.value2);
        Assert.assertTrue((boolean)jto.isDefined());
        Assert.assertEquals((Object)((Object)SMGJoinStatus.EQUAL), (Object)((Object)jto.getStatus()));
        Assert.assertSame((Object)this.smg1, (Object)jto.getInputSMG1());
        Assert.assertSame((Object)this.smg2, (Object)jto.getInputSMG2());
        Assert.assertEquals((Object)mta.getSMG(), (Object)jto.getDestinationSMG());
        Assert.assertEquals((Object)mta.getMapping1(), (Object)jto.getMapping1());
        Assert.assertEquals((Object)mta.getMapping2(), (Object)jto.getMapping2());
        Assert.assertEquals((Object)mta.getValue(), (Object)jto.getValue());
    }

    @Test
    public void joinTargetObjectsAlreadyJoinedNonNull() throws SMGInconsistentException {
        this.smg1.addValue(this.value1);
        this.smg2.addValue(this.value2);
        this.smg1.addObject(this.obj1);
        this.smg2.addObject(this.obj2);
        this.destSMG.addObject(this.destObj);
        this.smg1.addPointsToEdge(this.pt1);
        this.smg2.addPointsToEdge(this.pt2);
        this.mapping1.map(this.obj1, this.destObj);
        this.mapping2.map(this.obj2, this.destObj);
        SMGJoinTargetObjects jto = new SMGJoinTargetObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.destSMG, this.mapping1, this.mapping2, this.value1, this.value2);
        Assert.assertTrue((boolean)jto.isDefined());
        Assert.assertEquals((Object)((Object)SMGJoinStatus.EQUAL), (Object)((Object)jto.getStatus()));
        Assert.assertSame((Object)this.smg1, (Object)jto.getInputSMG1());
        Assert.assertSame((Object)this.smg2, (Object)jto.getInputSMG2());
        Assert.assertTrue((boolean)jto.getMapping1().containsKey(this.value1));
        Assert.assertEquals((Object)jto.getMapping1().get(this.value1), (Object)jto.getValue());
        Assert.assertTrue((boolean)jto.getMapping2().containsKey(this.value2));
        Assert.assertEquals((Object)jto.getMapping2().get(this.value2), (Object)jto.getValue());
    }
}

