/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smgfork.join;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGValueFactory;
import org.sosy_lab.cpachecker.cpa.smgfork.graphs.SMGFactory;
import org.sosy_lab.cpachecker.cpa.smgfork.graphs.WritableSMG;
import org.sosy_lab.cpachecker.cpa.smgfork.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smgfork.join.SMGJoinValues;
import org.sosy_lab.cpachecker.cpa.smgfork.join.SMGNodeMapping;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGRegion;

public class SMGJoinValuesTest {
    private WritableSMG smg1;
    private WritableSMG smg2;
    private WritableSMG smgDest;
    private SMGNodeMapping mapping1;
    private SMGNodeMapping mapping2;
    private final Integer value1 = SMGValueFactory.getNewValue();
    private final Integer value2 = SMGValueFactory.getNewValue();
    private final Integer value3 = SMGValueFactory.getNewValue();

    @Before
    public void setUp() {
        this.smg1 = SMGFactory.createWritableSMG(MachineModel.LINUX64);
        this.smg2 = SMGFactory.createWritableSMG(MachineModel.LINUX64);
        this.smgDest = SMGFactory.createWritableSMG(MachineModel.LINUX64);
        this.mapping1 = new SMGNodeMapping();
        this.mapping2 = new SMGNodeMapping();
    }

    @Test
    public void joinValuesAlreadyJoinedTest() throws SMGInconsistentException {
        this.smg1.addValue(this.value1);
        this.smg2.addValue(this.value2);
        this.smgDest.addValue(this.value3);
        this.mapping1.map(this.value1, this.value3);
        this.mapping2.map(this.value2, this.value3);
        SMGJoinValues jv = new SMGJoinValues(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.smgDest, this.mapping1, this.mapping2, this.value1, this.value2);
        Assert.assertTrue((boolean)jv.isDefined());
        Assert.assertEquals((Object)((Object)SMGJoinStatus.EQUAL), (Object)((Object)jv.getStatus()));
        Assert.assertSame((Object)this.smg1, (Object)jv.getInputSMG1());
        Assert.assertSame((Object)this.smg2, (Object)jv.getInputSMG2());
        Assert.assertSame((Object)this.smgDest, (Object)jv.getDestinationSMG());
        Assert.assertSame((Object)this.mapping1, (Object)jv.getMapping1());
        Assert.assertSame((Object)this.mapping2, (Object)jv.getMapping2());
        Assert.assertEquals((Object)this.value3, (Object)jv.getValue());
    }

    @Test
    public void joinValuesNonPointers() throws SMGInconsistentException {
        this.smg1.addValue(this.value1);
        this.smg2.addValue(this.value2);
        this.smgDest.addValue(this.value3);
        this.mapping1.map(this.value1, this.value3);
        SMGJoinValues jv = new SMGJoinValues(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.smgDest, this.mapping1, this.mapping2, this.value1, this.value2);
        Assert.assertFalse((boolean)jv.isDefined());
        this.mapping1 = new SMGNodeMapping();
        this.mapping2.map(this.value2, this.value3);
        jv = new SMGJoinValues(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.smgDest, this.mapping1, this.mapping2, this.value1, this.value2);
        Assert.assertFalse((boolean)jv.isDefined());
        this.mapping2 = new SMGNodeMapping();
        jv = new SMGJoinValues(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.smgDest, this.mapping1, this.mapping2, this.value1, this.value2);
        Assert.assertTrue((boolean)jv.isDefined());
        Assert.assertEquals((Object)((Object)SMGJoinStatus.EQUAL), (Object)((Object)jv.getStatus()));
        Assert.assertSame((Object)this.smg1, (Object)jv.getInputSMG1());
        Assert.assertSame((Object)this.smg2, (Object)jv.getInputSMG2());
        Assert.assertSame((Object)this.smgDest, (Object)jv.getDestinationSMG());
        Assert.assertSame((Object)this.mapping1, (Object)jv.getMapping1());
        Assert.assertSame((Object)this.mapping2, (Object)jv.getMapping2());
        Assert.assertNotEquals((Object)this.value1, (Object)jv.getValue());
        Assert.assertNotEquals((Object)this.value2, (Object)jv.getValue());
        Assert.assertNotEquals((Object)this.value3, (Object)jv.getValue());
        Assert.assertEquals((Object)jv.getValue(), (Object)this.mapping1.get(this.value1));
        Assert.assertEquals((Object)jv.getValue(), (Object)this.mapping2.get(this.value2));
    }

    @Test
    public void joinValuesSinglePointer() throws SMGInconsistentException {
        this.smg1.addValue(this.value1);
        this.smg2.addValue(this.value2);
        this.smgDest.addValue(this.value3);
        SMGRegion obj1 = new SMGRegion(8, "Object");
        SMGEdgePointsTo pt = new SMGEdgePointsTo(this.value1, obj1, 0);
        this.smg1.addPointsToEdge(pt);
        SMGJoinValues jv = new SMGJoinValues(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.smgDest, this.mapping1, this.mapping2, this.value1, this.value2);
        Assert.assertFalse((boolean)jv.isDefined());
    }
}

