/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smgfork.objects;

import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGObjectVisitor;

public abstract class SMGObject {
    private final int size;
    private final String label;
    private static final SMGObject nullObject = new SMGObject(0, "NULL"){

        public String toString() {
            return "NULL";
        }
    };

    public static final SMGObject getNullObject() {
        return nullObject;
    }

    protected SMGObject(int pSize, String pLabel) {
        this.size = pSize;
        this.label = pLabel;
    }

    protected SMGObject(SMGObject pOther) {
        this.size = pOther.size;
        this.label = pOther.label;
    }

    public String getLabel() {
        return this.label;
    }

    public int getSize() {
        return this.size;
    }

    public boolean notNull() {
        return !this.equals(nullObject);
    }

    public boolean isAbstract() {
        if (this.equals(nullObject)) {
            return false;
        }
        throw new UnsupportedOperationException("isAbstract() called on SMGObject instance, not on a subclass");
    }

    public void accept(SMGObjectVisitor visitor) {
        throw new UnsupportedOperationException("accept() called on SMGObject instance not on a subclass");
    }

    public boolean isMoreGeneral(SMGObject pOther) {
        if (this.size != pOther.size) {
            throw new IllegalArgumentException("isMoreGeneral called on incompatible pair of objects");
        }
        return false;
    }

    public SMGObject join(SMGObject pOther) {
        throw new UnsupportedOperationException("join() called on SMGObject instance, not on a subclass");
    }
}

