/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smgfork.objects;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGRegion;

public class SMGRegionTest {
    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testIsAbstract() {
        SMGRegion region = new SMGRegion(8, "region");
        Assert.assertFalse((boolean)region.isAbstract());
    }

    @Test
    public void testJoin() {
        SMGRegion region = new SMGRegion(8, "region");
        SMGRegion region_same = new SMGRegion(8, "region");
        SMGObject objectJoint = region.join(region_same);
        Assert.assertTrue((boolean)(objectJoint instanceof SMGRegion));
        SMGRegion regionJoint = (SMGRegion)objectJoint;
        Assert.assertEquals((long)8L, (long)regionJoint.getSize());
        Assert.assertEquals((Object)"region", (Object)regionJoint.getLabel());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testJoinDiffSize() {
        SMGRegion region = new SMGRegion(8, "region");
        SMGRegion regionDiff = new SMGRegion(10, "region");
        region.join(regionDiff);
    }

    @Test
    public void testPropertiesEqual() {
        SMGRegion one = new SMGRegion(8, "region");
        SMGRegion two = new SMGRegion(8, "region");
        SMGRegion three = new SMGRegion(10, "region");
        SMGRegion four = new SMGRegion(8, "REGION");
        Assert.assertTrue((boolean)one.propertiesEqual(two));
        Assert.assertFalse((boolean)one.propertiesEqual(three));
        Assert.assertFalse((boolean)one.propertiesEqual(four));
    }
}

