/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smgfork.objects.sll;

import com.google.common.collect.Iterables;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.smgfork.AnonymousTypes;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smgfork.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smgfork.graphs.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGObject;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.sll.SMGSingleLinkedList;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.sll.SMGSingleLinkedListCandidate;
import org.sosy_lab.cpachecker.cpa.smgfork.objects.sll.TestHelpers;

public class SMGSingleLinkedListCandidateTest {
    @Test
    public void basicTest() {
        SMGRegion object = new SMGRegion(8, "object");
        SMGSingleLinkedListCandidate candidate = new SMGSingleLinkedListCandidate(object, 4, 2);
        Assert.assertSame((Object)object, (Object)candidate.getStart());
        Assert.assertEquals((long)4L, (long)candidate.getOffset());
        Assert.assertEquals((long)2L, (long)candidate.getLength());
        candidate.addLength(4);
        Assert.assertEquals((long)4L, (long)candidate.getOffset());
        Assert.assertEquals((long)6L, (long)candidate.getLength());
    }

    @Test
    public void isCompatibleWithTest() {
        SMGRegion object8_1 = new SMGRegion(8, "object 1");
        SMGRegion object8_2 = new SMGRegion(8, "object 2");
        SMGRegion object16 = new SMGRegion(16, "object 3");
        SMGSingleLinkedListCandidate candidate8_1 = new SMGSingleLinkedListCandidate(object8_1, 4, 2);
        SMGSingleLinkedListCandidate candidate8_2 = new SMGSingleLinkedListCandidate(object8_2, 4, 8);
        SMGSingleLinkedListCandidate candidate16 = new SMGSingleLinkedListCandidate(object16, 4, 2);
        Assert.assertTrue((boolean)candidate8_1.isCompatibleWith(candidate8_2));
        Assert.assertTrue((boolean)candidate8_2.isCompatibleWith(candidate8_1));
        Assert.assertFalse((boolean)candidate16.isCompatibleWith(candidate8_1));
        Assert.assertFalse((boolean)candidate8_1.isCompatibleWith(candidate16));
        candidate8_2 = new SMGSingleLinkedListCandidate(object8_2, 6, 2);
        Assert.assertFalse((boolean)candidate8_1.isCompatibleWith(candidate8_2));
    }

    @Test
    public void executeOnSimpleList() {
        CLangSMG smg = new CLangSMG(MachineModel.LINUX64);
        int NODE_SIZE = 8;
        int SEGMENT_LENGTH = 4;
        int OFFSET = 0;
        SMGEdgeHasValue root = TestHelpers.createGlobalList(smg, SEGMENT_LENGTH + 1, NODE_SIZE, OFFSET, "pointer");
        Integer value = root.getValue();
        SMGObject startObject = smg.getPointer(value).getObject();
        SMGSingleLinkedListCandidate candidate = new SMGSingleLinkedListCandidate(startObject, OFFSET, SEGMENT_LENGTH);
        CLangSMG abstractedSmg = candidate.execute(smg);
        Set<SMGObject> heap = abstractedSmg.getHeapObjects();
        Assert.assertEquals((long)3L, (long)heap.size());
        SMGObject pointedObject = abstractedSmg.getPointer(value).getObject();
        Assert.assertTrue((boolean)(pointedObject instanceof SMGSingleLinkedList));
        Assert.assertTrue((boolean)pointedObject.isAbstract());
        SMGSingleLinkedList segment = (SMGSingleLinkedList)pointedObject;
        Assert.assertEquals((long)NODE_SIZE, (long)segment.getSize());
        Assert.assertEquals((long)SEGMENT_LENGTH, (long)segment.getLength());
        Assert.assertEquals((long)OFFSET, (long)segment.getOffset());
        Set<SMGEdgeHasValue> outboundEdges = abstractedSmg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(segment));
        Assert.assertEquals((long)1L, (long)outboundEdges.size());
        SMGEdgeHasValue onlyOutboundEdge = (SMGEdgeHasValue)Iterables.getOnlyElement(outboundEdges);
        Assert.assertEquals((long)OFFSET, (long)onlyOutboundEdge.getOffset());
        Assert.assertSame((Object)AnonymousTypes.dummyPointer, (Object)onlyOutboundEdge.getType());
        SMGObject stopper = abstractedSmg.getPointer(onlyOutboundEdge.getValue()).getObject();
        Assert.assertTrue((boolean)(stopper instanceof SMGRegion));
        SMGRegion stopperRegion = (SMGRegion)stopper;
        Assert.assertEquals((long)NODE_SIZE, (long)stopperRegion.getSize());
        outboundEdges = abstractedSmg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(stopperRegion));
        Assert.assertEquals((long)1L, (long)outboundEdges.size());
        onlyOutboundEdge = (SMGEdgeHasValue)Iterables.getOnlyElement(outboundEdges);
        Assert.assertEquals((long)0L, (long)onlyOutboundEdge.getValue());
        Assert.assertEquals((long)0L, (long)onlyOutboundEdge.getOffset());
        Assert.assertEquals((long)NODE_SIZE, (long)onlyOutboundEdge.getSizeInBytes(abstractedSmg.getMachineModel()));
    }

    @Test
    public void executeOnNullTerminatedList() {
        CLangSMG smg = new CLangSMG(MachineModel.LINUX64);
        SMGEdgeHasValue root = TestHelpers.createGlobalList(smg, 2, 16, 8, "pointer");
        Integer value = root.getValue();
        SMGObject startObject = smg.getPointer(value).getObject();
        SMGSingleLinkedListCandidate candidate = new SMGSingleLinkedListCandidate(startObject, 8, 2);
        CLangSMG abstractedSmg = candidate.execute(smg);
        Set<SMGObject> heap = abstractedSmg.getHeapObjects();
        Assert.assertEquals((long)2L, (long)heap.size());
        SMGObject sll = abstractedSmg.getPointer(value).getObject();
        Assert.assertTrue((boolean)sll.isAbstract());
        Assert.assertTrue((boolean)(sll instanceof SMGSingleLinkedList));
        SMGSingleLinkedList realSll = (SMGSingleLinkedList)sll;
        Assert.assertEquals((long)2L, (long)realSll.getLength());
        Set<SMGEdgeHasValue> outboundEdges = abstractedSmg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(realSll));
        Assert.assertEquals((long)1L, (long)outboundEdges.size());
        SMGEdgeHasValue outbound = (SMGEdgeHasValue)Iterables.getOnlyElement(outboundEdges);
        Assert.assertEquals((long)8L, (long)outbound.getOffset());
        Assert.assertEquals((long)8L, (long)outbound.getSizeInBytes(abstractedSmg.getMachineModel()));
        Assert.assertEquals((long)0L, (long)outbound.getValue());
    }
}

