/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.statistics;

import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.JSON;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.statistics.StatisticsCPA;
import org.sosy_lab.cpachecker.cpa.statistics.StatisticsData;
import org.sosy_lab.cpachecker.cpa.statistics.StatisticsDataProvider;
import org.sosy_lab.cpachecker.cpa.statistics.StatisticsProvider;
import org.sosy_lab.cpachecker.cpa.statistics.StatisticsState;

@Options(prefix="cpa.statistics")
public class StatisticsCPAStatistics
implements Statistics {
    @Option(secure=true, description="target file to hold the statistics")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path statisticsCPAFile = null;
    private final StatisticsCPA cpa;
    private final LogManager logger;

    public StatisticsCPAStatistics(Configuration config, LogManager logger, StatisticsCPA cpa) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.cpa = cpa;
        this.logger = logger;
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
        StatisticsData statistics;
        if (this.cpa.isAnalysis()) {
            statistics = this.cpa.getFactory().getGlobalAnalysis();
        } else {
            StatisticsState lastState = (StatisticsState)reached.getLastState();
            if (lastState == null) {
                for (AbstractState abstractState : reached.asCollection()) {
                    if (abstractState == null) continue;
                    lastState = (StatisticsState)reached.getLastState();
                }
            }
            statistics = lastState.getStatistics();
        }
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        for (Map.Entry entry : statistics) {
            StatisticsProvider provider = (StatisticsProvider)entry.getKey();
            StatisticsDataProvider data = (StatisticsDataProvider)entry.getValue();
            String propName = provider.getPropertyName();
            Object value = data.getPropertyValue();
            String mergeInfo = "";
            if (!this.cpa.isAnalysis()) {
                Map<String, Object> innerJsonMap;
                String mergeType = provider.getMergeType();
                mergeInfo = "_" + mergeType;
                if (jsonMap.containsKey(propName)) {
                    innerJsonMap = (Map)jsonMap.get(propName);
                } else {
                    innerJsonMap = new HashMap();
                    jsonMap.put(propName, innerJsonMap);
                }
                innerJsonMap.put(mergeType, value);
            } else {
                jsonMap.put(propName, value);
            }
            out.println("\t" + propName + mergeInfo + ": " + value);
        }
        if (this.statisticsCPAFile != null) {
            try {
                JSON.writeJSONString(jsonMap, (Path)this.statisticsCPAFile);
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write statistics to file");
            }
        }
    }

    @Override
    public String getName() {
        return "StatisticsCPA";
    }
}

