/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.statistics;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cpa.statistics.StatisticsDataProvider;
import org.sosy_lab.cpachecker.cpa.statistics.StatisticsProvider;

public class StatisticsData
implements Iterable<Map.Entry<StatisticsProvider, StatisticsDataProvider>> {
    private final Map<StatisticsProvider, StatisticsDataProvider> data;

    public StatisticsData(Set<StatisticsProvider> propertyProviders) {
        HashMap dataProvider = Maps.newHashMapWithExpectedSize((int)propertyProviders.size());
        for (StatisticsProvider providerEntry : propertyProviders) {
            dataProvider.put(providerEntry, providerEntry.createDataProvider());
        }
        this.data = dataProvider;
    }

    private StatisticsData(Map<StatisticsProvider, StatisticsDataProvider> data) {
        this.data = data;
    }

    public StatisticsData mergeState(StatisticsData state2) {
        assert (this.data.size() == state2.data.size()) : "sized and properties have to match";
        HashMap merged = Maps.newHashMapWithExpectedSize((int)this.data.size());
        for (Map.Entry<StatisticsProvider, StatisticsDataProvider> providerEntry : this.data.entrySet()) {
            merged.put(providerEntry.getKey(), providerEntry.getValue().mergePath(state2.data.get(providerEntry.getKey())));
        }
        return new StatisticsData(merged);
    }

    public StatisticsData getNextState(CFAEdge node) {
        HashMap dataProvider = Maps.newHashMapWithExpectedSize((int)this.data.size());
        for (Map.Entry<StatisticsProvider, StatisticsDataProvider> providerEntry : this.data.entrySet()) {
            StatisticsProvider key = providerEntry.getKey();
            StatisticsDataProvider value = providerEntry.getValue();
            value = value.calculateNext(node);
            dataProvider.put(key, value);
        }
        return new StatisticsData(dataProvider);
    }

    @Override
    public Iterator<Map.Entry<StatisticsProvider, StatisticsDataProvider>> iterator() {
        return Iterators.unmodifiableIterator(this.data.entrySet().iterator());
    }
}

