/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.statistics;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithLocation;
import org.sosy_lab.cpachecker.core.interfaces.Partitionable;
import org.sosy_lab.cpachecker.cpa.statistics.StatisticsData;
import org.sosy_lab.cpachecker.cpa.statistics.StatisticsProvider;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class StatisticsState
implements AbstractStateWithLocation,
Partitionable {
    private final CFANode locationNode;
    private final StatisticsStateFactory factory;
    private final StatisticsData data;

    private StatisticsState(StatisticsData data, StatisticsStateFactory factory, CFANode locationNode) {
        this.locationNode = locationNode;
        this.factory = factory;
        this.data = data;
    }

    public StatisticsData getStatistics() {
        if (this.data == null) {
            return null;
        }
        return this.data;
    }

    @Override
    public CFANode getLocationNode() {
        return this.locationNode;
    }

    @Override
    public Iterable<CFAEdge> getOutgoingEdges() {
        return CFAUtils.leavingEdges(this.locationNode);
    }

    public String toString() {
        return this.locationNode.toString();
    }

    @Override
    public Object getPartitionKey() {
        return this;
    }

    public StatisticsState nextState(CFAEdge pSuccessor) {
        return this.factory.nextState(this, pSuccessor);
    }

    public StatisticsState mergeState(StatisticsState state2) {
        return this.factory.mergedState(this, state2);
    }

    public boolean containsPrevious(StatisticsState state2) {
        return this.factory.containsPrevious(this, state2);
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.locationNode.hashCode();
        return hash;
    }

    public boolean equals(Object pArg0) {
        if (super.equals(pArg0)) {
            return true;
        }
        StatisticsState other = (StatisticsState)pArg0;
        if (other == null) {
            return false;
        }
        return this.locationNode.equals(other.locationNode);
    }

    public static class StatisticsStateFactory {
        private Set<StatisticsProvider> propertyProviders = new HashSet<StatisticsProvider>();
        private boolean fixed = false;
        private boolean isAnalysis = false;
        private StatisticsData analysisData = null;
        private Map<CFAEdge, Boolean> analysisTrack = null;

        public StatisticsStateFactory(FactoryAnalysisType analysisType) {
            this.setAnalysisType(analysisType);
        }

        public void setAnalysisType(FactoryAnalysisType analysisType) {
            switch (analysisType) {
                case Analysis: {
                    this.isAnalysis = true;
                    break;
                }
                case MetricsQuery: {
                    this.isAnalysis = false;
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown analysisType");
                }
            }
        }

        public void addProvider(StatisticsProvider provider) {
            if (this.fixed) {
                throw new IllegalStateException("providers are already fixed");
            }
            if (!this.propertyProviders.add(provider)) {
                throw new IllegalStateException("the requested provider was already added!");
            }
        }

        private StatisticsData createInitialDataProvider() {
            this.fixed = true;
            return new StatisticsData(this.propertyProviders);
        }

        public StatisticsState createNew(CFANode node) {
            StatisticsData initialState = this.createInitialDataProvider();
            if (this.isAnalysis) {
                this.analysisData = initialState;
                this.analysisTrack = new HashMap<CFAEdge, Boolean>();
                initialState = null;
            }
            return new StatisticsState(initialState, this, node);
        }

        public StatisticsState nextState(StatisticsState state, CFAEdge successor) {
            StatisticsData nextState = null;
            if (!this.isAnalysis) {
                nextState = state.data.getNextState(successor);
            } else if (!this.analysisTrack.containsKey(successor)) {
                this.analysisData = this.analysisData.getNextState(successor);
                this.analysisTrack.put(successor, true);
            }
            return new StatisticsState(nextState, this, successor.getSuccessor());
        }

        public StatisticsState mergedState(StatisticsState state1, StatisticsState state2) {
            assert (state1.getLocationNode() == state2.getLocationNode()) : "Locations have to match!";
            return new StatisticsState(state1.data.mergeState(state2.data), this, state1.locationNode);
        }

        public boolean containsPrevious(StatisticsState state1, StatisticsState state2) {
            if (!this.isAnalysis) {
                throw new UnsupportedOperationException("Not implemented jet. Figure out if this is already covered (see also mergedState)");
            }
            return state1.locationNode.equals(state2.locationNode);
        }

        public StatisticsData getGlobalAnalysis() {
            return this.analysisData;
        }

        public static enum FactoryAnalysisType {
            Analysis,
            MetricsQuery;

        }
    }
}

