/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.statistics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.statistics.StatisticsState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class StatisticsTransferRelation
extends SingleEdgeTransferRelation {
    public StatisticsTransferRelation(Configuration pConfig, LogManager pLogger) {
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException, InterruptedException {
        StatisticsState state = (StatisticsState)pState;
        CFANode node = state.getLocationNode();
        if (pCfaEdge != null) {
            if (CFAUtils.allLeavingEdges(node).contains((Object)pCfaEdge)) {
                return Collections.singleton(state.nextState(pCfaEdge));
            }
            return Collections.emptySet();
        }
        ArrayList<StatisticsState> allSuccessors = new ArrayList<StatisticsState>(node.getNumLeavingEdges());
        for (CFAEdge successor : CFAUtils.leavingEdges(node)) {
            allSuccessors.add(state.nextState(successor));
        }
        return allSuccessors;
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState pState, List<AbstractState> pOtherStates, CFAEdge pCfaEdge, Precision pPrecision) throws CPATransferException, InterruptedException {
        return null;
    }
}

