/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.statistics.provider;

import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cpa.statistics.StatisticsDataProvider;
import org.sosy_lab.cpachecker.cpa.statistics.StatisticsProvider;

public class SimpleIntProvider
implements StatisticsProvider {
    private SimpleIntProviderImplementation calculator;
    private SimpleIntMergeProvider merger;
    private int defValue;

    public SimpleIntProvider(SimpleIntProviderImplementation calculator, IntMerger merger, int defValue) {
        assert (calculator != null);
        this.calculator = calculator;
        this.merger = new SimpleIntMergeProvider(merger);
        this.defValue = defValue;
    }

    @Override
    public String getPropertyName() {
        return this.calculator.getPropertyName();
    }

    @Override
    public String getMergeType() {
        return this.merger.toString();
    }

    @Override
    public StatisticsDataProvider createDataProvider() {
        return new SimpleIntDataProvider(this.calculator, this.merger, this.defValue);
    }

    public static class SimpleIntDataProvider
    implements StatisticsDataProvider {
        private int data;
        private SimpleIntProviderImplementation calculator;
        private SimpleIntMergeProvider merger;

        SimpleIntDataProvider(SimpleIntProviderImplementation calculator, SimpleIntMergeProvider merger, int data) {
            assert (calculator != null);
            assert (merger != null);
            this.data = data;
            this.merger = merger;
            this.calculator = calculator;
        }

        @Override
        public Object getPropertyValue() {
            return this.data;
        }

        @Override
        public StatisticsDataProvider calculateNext(CFAEdge edge) {
            return new SimpleIntDataProvider(this.calculator, this.merger, this.calculator.calculateNext(this.data, edge));
        }

        @Override
        public StatisticsDataProvider mergePath(StatisticsDataProvider other) {
            return new SimpleIntDataProvider(this.calculator, this.merger, this.merger.mergePath(this, other));
        }
    }

    public static class SimpleIntMergeProvider {
        private IntMerger merger;

        SimpleIntMergeProvider(IntMerger merger) {
            assert (merger != null);
            this.merger = merger;
        }

        public int mergePath(StatisticsDataProvider left, StatisticsDataProvider right) {
            return this.merger.merge(((SimpleIntDataProvider)left).data, ((SimpleIntDataProvider)right).data);
        }

        public String toString() {
            return this.merger.toString();
        }
    }

    public static interface IntMerger {
        public int merge(int var1, int var2);

        public String toString();
    }

    public static interface SimpleIntProviderImplementation {
        public String getPropertyName();

        public int calculateNext(int var1, CFAEdge var2);
    }
}

