/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.uninitvars;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.uninitvars.UninitializedVariablesState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;

public class UninitializedVariablesTransferRelation
extends SingleEdgeTransferRelation {
    private Set<String> globalVars = new HashSet<String>();
    private boolean printWarnings;

    public UninitializedVariablesTransferRelation(String printWarnings, LogManager logger) {
        this.printWarnings = Boolean.parseBoolean(printWarnings);
    }

    private AbstractState getAbstractSuccessor(AbstractState element, CFAEdge cfaEdge, Precision precision) throws CPATransferException {
        UninitializedVariablesState successor = ((UninitializedVariablesState)element).clone();
        successor.clearProperties();
        switch (cfaEdge.getEdgeType()) {
            case DeclarationEdge: {
                this.handleDeclaration(successor, (CDeclarationEdge)cfaEdge);
                break;
            }
            case StatementEdge: {
                this.handleStatement(successor, ((CStatementEdge)cfaEdge).getStatement(), cfaEdge);
                break;
            }
            case ReturnStatementEdge: {
                if (this.isExpressionUninitialized(successor, (CRightHandSide)((CReturnStatementEdge)cfaEdge).getExpression().orNull(), cfaEdge)) {
                    this.setUninitialized(successor, "CPAchecker_UninitVars_FunctionReturn");
                    break;
                }
                this.setInitialized(successor, "CPAchecker_UninitVars_FunctionReturn");
                break;
            }
            case FunctionReturnEdge: {
                CFunctionReturnEdge functionReturnEdge = (CFunctionReturnEdge)cfaEdge;
                CFunctionSummaryEdge ctrEdge = functionReturnEdge.getSummaryEdge();
                this.handleStatement(successor, ctrEdge.getExpression(), ctrEdge);
                break;
            }
            case AssumeEdge: {
                if (!this.printWarnings) break;
                this.isExpressionUninitialized(successor, ((CAssumeEdge)cfaEdge).getExpression(), cfaEdge);
                break;
            }
            case FunctionCallEdge: {
                this.handleFunctionCall(successor, (CFunctionCallEdge)cfaEdge);
                break;
            }
            case BlankEdge: {
                break;
            }
            default: {
                throw new UnrecognizedCFAEdgeException(cfaEdge);
            }
        }
        return successor;
    }

    private void addWarning(CFAEdge edge, String variable, CRightHandSide expression, UninitializedVariablesState element) {
        if (this.printWarnings) {
            String message;
            int lineNumber = edge.getLineNumber();
            if (edge instanceof FunctionSummaryEdge && expression instanceof CFunctionCallExpression) {
                message = "uninitialized return value of function call " + variable + " in line " + lineNumber + ": " + edge.getDescription();
                element.addProperty(UninitializedVariablesState.ElementProperty.UNINITIALIZED_RETURN_VALUE);
            } else {
                message = "uninitialized variable " + variable + " used in line " + lineNumber + ": " + edge.getDescription();
                element.addProperty(UninitializedVariablesState.ElementProperty.UNINITIALIZED_VARIABLE_USED);
            }
            element.addWarning(lineNumber, variable, message);
        }
    }

    private void setUninitialized(UninitializedVariablesState element, String varName) {
        if (this.globalVars.contains(varName)) {
            element.addGlobalVariable(varName);
        } else {
            element.addLocalVariable(varName);
        }
    }

    private void setInitialized(UninitializedVariablesState element, String varName) {
        if (this.globalVars.contains(varName)) {
            element.removeGlobalVariable(varName);
        } else {
            element.removeLocalVariable(varName);
        }
    }

    private void handleDeclaration(UninitializedVariablesState element, CDeclarationEdge declarationEdge) {
        if (!(declarationEdge.getDeclaration() instanceof CVariableDeclaration)) {
            return;
        }
        CVariableDeclaration decl = (CVariableDeclaration)declarationEdge.getDeclaration();
        String varName = decl.getName();
        if (decl.isGlobal()) {
            this.globalVars.add(varName);
        }
        CType type = decl.getType();
        CInitializer initializer = decl.getInitializer();
        if (initializer == null && decl.getCStorageClass() != CStorageClass.EXTERN && !(type instanceof CArrayType) && !(type instanceof CFunctionType)) {
            this.setUninitialized(element, varName);
        } else {
            this.setInitialized(element, varName);
        }
        if (this.isStructType(type)) {
            this.handleStructDeclaration(element, (CCompositeType)type, varName, varName, decl.isGlobal());
        }
    }

    private void handleFunctionCall(UninitializedVariablesState element, CFunctionCallEdge callEdge) throws UnrecognizedCCodeException {
        CFunctionEntryNode functionEntryNode = callEdge.getSuccessor();
        List<String> paramNames = functionEntryNode.getFunctionParameterNames();
        List<CExpression> arguments = callEdge.getArguments();
        if (!arguments.isEmpty()) {
            int numOfParams = paramNames.size();
            if (numOfParams < arguments.size()) {
                for (int j = numOfParams; j < arguments.size(); ++j) {
                    this.isExpressionUninitialized(element, arguments.get(j), callEdge);
                }
            }
            LinkedList<String> uninitParameters = new LinkedList<String>();
            LinkedList<String> initParameters = new LinkedList<String>();
            for (int i = 0; i < numOfParams; ++i) {
                if (this.isExpressionUninitialized(element, arguments.get(i), callEdge)) {
                    uninitParameters.add(paramNames.get(i));
                    continue;
                }
                initParameters.add(paramNames.get(i));
            }
            element.callFunction(functionEntryNode.getFunctionName());
            for (String param : uninitParameters) {
                this.setUninitialized(element, param);
            }
            for (String param : initParameters) {
                this.setInitialized(element, param);
            }
        } else {
            element.callFunction(functionEntryNode.getFunctionName());
        }
    }

    private void handleStatement(UninitializedVariablesState element, CStatement expression, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        if (expression instanceof CFunctionCallStatement) {
            if (cfaEdge instanceof FunctionSummaryEdge) {
                element.returnFromFunction();
            }
            if (this.printWarnings) {
                for (CExpression param : ((CFunctionCallStatement)expression).getFunctionCallExpression().getParameterExpressions()) {
                    this.isExpressionUninitialized(element, param, cfaEdge);
                }
            }
        } else if (expression instanceof CExpressionStatement) {
            if (this.printWarnings) {
                this.isExpressionUninitialized(element, ((CExpressionStatement)expression).getExpression(), cfaEdge);
            }
        } else if (expression instanceof CAssignment) {
            CAssignment assignExpression = (CAssignment)expression;
            this.handleAssign(element, assignExpression, cfaEdge);
        } else {
            throw new UnrecognizedCCodeException("unknown statement", cfaEdge, expression);
        }
    }

    private void handleAssign(UninitializedVariablesState element, CAssignment expression, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        String leftName;
        CLeftHandSide op1 = expression.getLeftHandSide();
        CRightHandSide op2 = expression.getRightHandSide();
        if (op1 instanceof CIdExpression) {
            leftName = ((CIdExpression)op1).getName();
            if (this.isExpressionUninitialized(element, op2, cfaEdge)) {
                this.setUninitialized(element, leftName);
            } else {
                this.setInitialized(element, leftName);
            }
        } else if (op1 instanceof CFieldReference) {
            if (((CFieldReference)op1).isPointerDereference()) {
                if (this.printWarnings) {
                    this.isExpressionUninitialized(element, op1, cfaEdge);
                    this.isExpressionUninitialized(element, op2, cfaEdge);
                }
            } else {
                leftName = op1.toASTString();
                if (this.isExpressionUninitialized(element, op2, cfaEdge)) {
                    this.setUninitialized(element, leftName);
                } else {
                    this.setInitialized(element, leftName);
                }
            }
        } else if (op1 instanceof CPointerExpression || op1 instanceof CArraySubscriptExpression) {
            if (this.printWarnings) {
                this.isExpressionUninitialized(element, op1, cfaEdge);
                this.isExpressionUninitialized(element, op2, cfaEdge);
            }
        } else {
            throw new UnrecognizedCCodeException("unknown left hand side of an assignment", cfaEdge, op1);
        }
        leftName = op1.toASTString();
        String rightName = op2.toASTString();
        CType t1 = op1.getExpressionType().getCanonicalType();
        CType t2 = op2.getExpressionType().getCanonicalType();
        if (this.isStructType(t1) && this.isStructType(t2)) {
            assert (t1.equals(t2));
            this.initializeFields(element, cfaEdge, op2, (CCompositeType)t1, leftName, rightName, leftName, rightName);
        }
    }

    private boolean isStructType(CType t) {
        return t instanceof CCompositeType && ((CCompositeType)t).getKind() == CComplexType.ComplexTypeKind.STRUCT;
    }

    private boolean isExpressionUninitialized(UninitializedVariablesState element, @Nullable CRightHandSide expression, CFAEdge cfaEdge) throws UnrecognizedCCodeException {
        if (expression == null) {
            return false;
        }
        if (expression instanceof CIdExpression) {
            String variable = ((CIdExpression)expression).getName();
            if (element.isUninitialized(variable)) {
                this.addWarning(cfaEdge, variable, expression, element);
                return true;
            }
            return false;
        }
        if (expression instanceof CTypeIdExpression) {
            return false;
        }
        if (expression instanceof CFieldReference) {
            CFieldReference e = (CFieldReference)expression;
            if (e.isPointerDereference()) {
                return this.isExpressionUninitialized(element, e.getFieldOwner(), cfaEdge);
            }
            String variable = expression.toASTString();
            if (element.isUninitialized(variable)) {
                this.addWarning(cfaEdge, variable, expression, element);
                return true;
            }
            return false;
        }
        if (expression instanceof CArraySubscriptExpression) {
            CArraySubscriptExpression arrayExpression = (CArraySubscriptExpression)expression;
            return this.isExpressionUninitialized(element, arrayExpression.getArrayExpression(), cfaEdge) | this.isExpressionUninitialized(element, arrayExpression.getSubscriptExpression(), cfaEdge);
        }
        if (expression instanceof CUnaryExpression) {
            CUnaryExpression unaryExpression = (CUnaryExpression)expression;
            CUnaryExpression.UnaryOperator typeOfOperator = unaryExpression.getOperator();
            if (typeOfOperator == CUnaryExpression.UnaryOperator.AMPER || typeOfOperator == CUnaryExpression.UnaryOperator.SIZEOF) {
                return false;
            }
            return this.isExpressionUninitialized(element, unaryExpression.getOperand(), cfaEdge);
        }
        if (expression instanceof CPointerExpression) {
            return this.isExpressionUninitialized(element, ((CPointerExpression)expression).getOperand(), cfaEdge);
        }
        if (expression instanceof CBinaryExpression) {
            CBinaryExpression binExpression = (CBinaryExpression)expression;
            return this.isExpressionUninitialized(element, binExpression.getOperand1(), cfaEdge) | this.isExpressionUninitialized(element, binExpression.getOperand2(), cfaEdge);
        }
        if (expression instanceof CCastExpression) {
            return this.isExpressionUninitialized(element, ((CCastExpression)expression).getOperand(), cfaEdge);
        }
        if (expression instanceof CFunctionCallExpression) {
            CFunctionCallExpression funcExpression = (CFunctionCallExpression)expression;
            if (cfaEdge instanceof CStatementEdge) {
                for (CExpression param : funcExpression.getParameterExpressions()) {
                    this.isExpressionUninitialized(element, param, cfaEdge);
                }
                return false;
            }
            boolean returnUninit = element.isUninitialized("CPAchecker_UninitVars_FunctionReturn");
            if (this.printWarnings && returnUninit) {
                this.addWarning(cfaEdge, funcExpression.toASTString(), expression, element);
            }
            if (cfaEdge instanceof FunctionSummaryEdge) {
                element.returnFromFunction();
            }
            return returnUninit;
        }
        if (expression instanceof CLiteralExpression) {
            return false;
        }
        throw new UnrecognizedCCodeException("unknown expression", cfaEdge, expression);
    }

    public Collection<AbstractState> getAbstractSuccessorsForEdge(AbstractState element, Precision precision, CFAEdge cfaEdge) throws CPATransferException {
        return Collections.singleton(this.getAbstractSuccessor(element, cfaEdge, precision));
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState element, List<AbstractState> otherElements, CFAEdge cfaEdge, Precision precision) {
        return null;
    }

    private void initializeFields(UninitializedVariablesState element, CFAEdge cfaEdge, CRightHandSide exp, CCompositeType structType, String leftName, String rightName, String recursiveLeftName, String recursiveRightName) {
        for (CCompositeType.CCompositeTypeMemberDeclaration member : structType.getMembers()) {
            CType t = member.getType().getCanonicalType();
            String name = member.getName();
            if (this.isStructType(t)) {
                this.initializeFields(element, cfaEdge, exp, (CCompositeType)t, name, name, recursiveLeftName + "." + name, recursiveRightName + "." + name);
                continue;
            }
            if (!element.isUninitialized(recursiveRightName + "." + name)) continue;
            if (this.printWarnings) {
                this.addWarning(cfaEdge, recursiveRightName + "." + name, exp, element);
            }
            this.setUninitialized(element, recursiveLeftName + "." + name);
        }
    }

    private void handleStructDeclaration(UninitializedVariablesState element, CCompositeType structType, String varName, String recursiveVarName, boolean isGlobalDeclaration) {
        this.setInitialized(element, recursiveVarName);
        for (CCompositeType.CCompositeTypeMemberDeclaration member : structType.getMembers()) {
            CType t = member.getType().getCanonicalType();
            String name = member.getName();
            if (this.isStructType(t)) {
                this.handleStructDeclaration(element, (CCompositeType)t, name, recursiveVarName + "." + name, isGlobalDeclaration);
                continue;
            }
            if (isGlobalDeclaration) {
                this.globalVars.add(recursiveVarName + "." + name);
            }
            this.setUninitialized(element, recursiveVarName + "." + name);
        }
    }
}

