/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.validvars;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class ValidVars
implements Serializable {
    private static final long serialVersionUID = 3944327361058660L;
    private final ImmutableSet<String> globalValidVars;
    private final ImmutableMap<String, Set<String>> localValidVars;
    private final ImmutableMap<String, Byte> numFunctionCalled;
    public static final ValidVars initial = new ValidVars(Collections.emptySet(), Collections.emptyMap(), Collections.emptyMap());

    ValidVars(Set<String> pGlobalValidVars, Map<String, ? extends Set<String>> pLocal, Map<String, Byte> pNumFunctionCalled) {
        this.globalValidVars = ImmutableSet.copyOf(pGlobalValidVars);
        this.localValidVars = ImmutableMap.copyOf(pLocal);
        this.numFunctionCalled = ImmutableMap.copyOf(pNumFunctionCalled);
    }

    public boolean containsVar(String varName) {
        String[] split = varName.split("::");
        if (split.length > 1) {
            Set functionVars = (Set)this.localValidVars.get((Object)split[0]);
            return functionVars != null ? functionVars.contains(split[1]) : false;
        }
        return this.globalValidVars.contains((Object)varName);
    }

    public ValidVars mergeWith(ValidVars pOther) throws CPAException {
        if (!pOther.localValidVars.keySet().containsAll((Collection)this.localValidVars.keySet())) {
            throw new CPAException("Require Callstack CPA to separate different function calls and Location CPA to separate different locations.");
        }
        boolean changed = false;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(pOther.globalValidVars);
        builder.addAll(this.globalValidVars);
        ImmutableSet newGlobals = builder.build();
        if (newGlobals.size() != pOther.globalValidVars.size()) {
            changed = true;
        }
        ImmutableMap.Builder builderMap = ImmutableMap.builder();
        for (String funName : this.localValidVars.keySet()) {
            Preconditions.checkArgument((boolean)((Byte)this.numFunctionCalled.get((Object)funName)).equals(pOther.numFunctionCalled.get((Object)funName)), (Object)"Require Callstack CPA to separate different function calls.");
            builder = ImmutableSet.builder();
            builder.addAll((Iterable)pOther.localValidVars.get((Object)funName));
            builder.addAll((Iterable)this.localValidVars.get((Object)funName));
            ImmutableSet newLocalsForFun = builder.build();
            if (newLocalsForFun.size() != ((Set)pOther.localValidVars.get((Object)funName)).size()) {
                changed = true;
            }
            builderMap.put((Object)funName, (Object)newLocalsForFun);
        }
        if (changed) {
            return new ValidVars((Set<String>)newGlobals, (Map<String, ? extends Set<String>>)builderMap.build(), (Map<String, Byte>)this.numFunctionCalled);
        }
        return pOther;
    }

    public boolean isSubsetOf(ValidVars pOther) {
        boolean subsetLocal = false;
        if (pOther.localValidVars.keySet().containsAll((Collection)this.localValidVars.keySet())) {
            for (String funName : this.localValidVars.keySet()) {
                if (((Set)pOther.localValidVars.get((Object)funName)).containsAll((Collection)this.localValidVars.get((Object)funName))) continue;
                return false;
            }
            subsetLocal = true;
        }
        return subsetLocal && pOther.globalValidVars.containsAll(this.globalValidVars);
    }

    public ValidVars extendGlobalVars(String varName) {
        if (varName != null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            builder.addAll(this.globalValidVars);
            builder.add((Object)varName);
            return new ValidVars((Set<String>)builder.build(), (Map<String, ? extends Set<String>>)this.localValidVars, (Map<String, Byte>)this.numFunctionCalled);
        }
        return this;
    }

    public ValidVars extendLocalVars(String funName, String newLocalVarName) {
        return this.extendLocalVars(funName, (Collection<String>)ImmutableSet.of((Object)newLocalVarName));
    }

    private ValidVars extendLocalVars(String funName, Collection<String> newLocalVarsNames) {
        if (newLocalVarsNames != null) {
            return new ValidVars((Set<String>)this.globalValidVars, (Map<String, ? extends Set<String>>)this.updateLocalVars(funName, newLocalVarsNames), (Map<String, Byte>)this.numFunctionCalled);
        }
        return this;
    }

    private Map<String, Set<String>> updateLocalVars(String funName, Collection<String> newLocalVarsNames) {
        if (newLocalVarsNames != null) {
            ImmutableMap.Builder builderMap = ImmutableMap.builder();
            for (String functionName : this.localValidVars.keySet()) {
                if (functionName.equals(funName)) continue;
                builderMap.put((Object)functionName, this.localValidVars.get((Object)functionName));
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (this.localValidVars.containsKey((Object)funName)) {
                builder.addAll((Iterable)this.localValidVars.get((Object)funName));
            }
            builder.addAll(newLocalVarsNames);
            builderMap.put((Object)funName, (Object)builder.build());
            return builderMap.build();
        }
        return this.localValidVars;
    }

    public ValidVars extendLocalVarsFunctionCall(String funName, Collection<String> newLocalVarsNames) {
        if (newLocalVarsNames != null) {
            return new ValidVars((Set<String>)this.globalValidVars, (Map<String, ? extends Set<String>>)this.updateLocalVars(funName, newLocalVarsNames), this.increaseNumForFunction(funName));
        }
        return this;
    }

    public ValidVars removeVarsOfFunction(String funName) {
        if (this.localValidVars != null && this.localValidVars.containsKey((Object)funName)) {
            if ((Byte)this.numFunctionCalled.get((Object)funName) > 1) {
                return new ValidVars((Set<String>)this.globalValidVars, (Map<String, ? extends Set<String>>)this.localValidVars, this.decreaseNumForFunction(funName));
            }
            ImmutableMap.Builder builderMap = ImmutableMap.builder();
            for (String functionName : this.localValidVars.keySet()) {
                if (functionName.equals(funName)) continue;
                builderMap.put((Object)functionName, this.localValidVars.get((Object)functionName));
            }
            return new ValidVars((Set<String>)this.globalValidVars, (Map<String, ? extends Set<String>>)builderMap.build(), this.decreaseNumForFunction(funName));
        }
        return this;
    }

    private Map<String, Byte> decreaseNumForFunction(String pFunctionName) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String functionName : this.numFunctionCalled.keySet()) {
            if (!functionName.equals(pFunctionName)) {
                builder.put((Object)functionName, this.numFunctionCalled.get((Object)functionName));
                continue;
            }
            if ((Byte)this.numFunctionCalled.get((Object)functionName) <= 1) continue;
            builder.put((Object)functionName, (Object)((byte)((Byte)this.numFunctionCalled.get((Object)functionName) - 1)));
        }
        return builder.build();
    }

    private Map<String, Byte> increaseNumForFunction(String pFunctionName) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String functionName : this.numFunctionCalled.keySet()) {
            if (!functionName.equals(pFunctionName)) {
                builder.put((Object)functionName, this.numFunctionCalled.get((Object)functionName));
                continue;
            }
            builder.put((Object)functionName, (Object)((byte)((Byte)this.numFunctionCalled.get((Object)functionName) + 1)));
        }
        if (!this.numFunctionCalled.containsKey((Object)pFunctionName)) {
            builder.put((Object)pFunctionName, (Object)1);
        }
        return builder.build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("global:\n");
        sb.append(this.globalValidVars.toString());
        sb.append("\n");
        Joiner.on((String)"\n").withKeyValueSeparator(":\n").appendTo(sb, this.localValidVars);
        sb.append(")");
        return sb.toString();
    }

    public String toStringInDOTFormat() {
        StringBuilder sb = new StringBuilder();
        sb.append("(\\n");
        sb.append("global:\\n");
        sb.append(this.globalValidVars.toString());
        sb.append("\\n");
        Joiner.on((String)"\\n").withKeyValueSeparator(":\\n").appendTo(sb, this.localValidVars);
        sb.append(")");
        return sb.toString();
    }
}

