/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.validvars;

import java.util.Collection;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.MergeJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.cpa.validvars.ValidVars;
import org.sosy_lab.cpachecker.cpa.validvars.ValidVarsDomain;
import org.sosy_lab.cpachecker.cpa.validvars.ValidVarsState;
import org.sosy_lab.cpachecker.cpa.validvars.ValidVarsTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

@Options(prefix="cpa.validVars")
public class ValidVarsCPA
implements ConfigurableProgramAnalysis,
ProofChecker {
    @Option(secure=true, name="merge", toUppercase=true, values={"SEP", "JOIN"}, description="which merge operator to use for ValidVarsCPA")
    private String mergeType = "JOIN";
    private final AbstractDomain domain;
    private final TransferRelation transfer;
    private final MergeOperator merge;
    private final StopOperator stop;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(ValidVarsCPA.class);
    }

    public ValidVarsCPA(Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.domain = new ValidVarsDomain();
        this.transfer = new ValidVarsTransferRelation();
        this.merge = this.mergeType.equals("SEP") ? MergeSepOperator.getInstance() : new MergeJoinOperator(this.domain);
        this.stop = new StopSepOperator(this.domain);
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.domain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transfer;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.merge;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stop;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return StaticPrecisionAdjustment.getInstance();
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        return new ValidVarsState(ValidVars.initial);
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) {
        return SingletonPrecision.getInstance();
    }

    @Override
    public boolean areAbstractSuccessors(AbstractState pState, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors) throws CPATransferException, InterruptedException {
        try {
            Collection<? extends AbstractState> computedSuccessors = this.transfer.getAbstractSuccessorsForEdge(pState, SingletonPrecision.getInstance(), pCfaEdge);
            for (AbstractState abstractState : computedSuccessors) {
                boolean found = false;
                for (AbstractState abstractState2 : pSuccessors) {
                    if (!this.isCoveredBy(abstractState, abstractState2)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        catch (CPAException e) {
            throw new CPATransferException("Cannot compare abstract successors", e);
        }
        return true;
    }

    @Override
    public boolean isCoveredBy(AbstractState pState, AbstractState pOtherState) throws CPAException, InterruptedException {
        return this.domain.isLessOrEqual(pState, pOtherState);
    }
}

