/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedLongs;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JArrayCreationExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JArrayInitializer;
import org.sosy_lab.cpachecker.cfa.ast.java.JArrayLengthExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JBooleanLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JClassInstanceCreation;
import org.sosy_lab.cpachecker.cfa.ast.java.JEnumConstantExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodInvocationExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JNullLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.java.JRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JRunTimeTypeEqualsType;
import org.sosy_lab.cpachecker.cfa.ast.java.JSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JThisExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JVariableRunTimeType;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.java.JArrayType;
import org.sosy_lab.cpachecker.cfa.types.java.JBasicType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;
import org.sosy_lab.cpachecker.cpa.value.type.ArrayValue;
import org.sosy_lab.cpachecker.cpa.value.type.BooleanValue;
import org.sosy_lab.cpachecker.cpa.value.type.EnumConstantValue;
import org.sosy_lab.cpachecker.cpa.value.type.NullValue;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.SymbolicValue;
import org.sosy_lab.cpachecker.cpa.value.type.SymbolicValueFormula;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.cpa.value.type.symbolic.SymbolicValueFactory;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;

public abstract class AbstractExpressionValueVisitor
extends DefaultCExpressionVisitor<Value, UnrecognizedCCodeException>
implements CRightHandSideVisitor<Value, UnrecognizedCCodeException>,
JRightHandSideVisitor<Value, RuntimeException>,
JExpressionVisitor<Value, RuntimeException> {
    private static final int SIZE_OF_JAVA_LONG = 64;
    private static final int SIZE_OF_JAVA_FLOAT = 32;
    private static final int SIZE_OF_JAVA_DOUBLE = 64;
    private final String functionName;
    private final MachineModel machineModel;
    private final LogManagerWithoutDuplicates logger;
    private boolean missingFieldAccessInformation = false;

    public AbstractExpressionValueVisitor(String pFunctionName, MachineModel pMachineModel, LogManagerWithoutDuplicates pLogger) {
        this.functionName = pFunctionName;
        this.machineModel = pMachineModel;
        this.logger = pLogger;
    }

    public boolean hasMissingFieldAccessInformation() {
        return this.missingFieldAccessInformation;
    }

    @Override
    protected Value visitDefault(CExpression pExp) {
        return Value.UnknownValue.getInstance();
    }

    public void reset() {
        this.missingFieldAccessInformation = false;
    }

    @Override
    public Value visit(CBinaryExpression pE) throws UnrecognizedCCodeException {
        Value lVal = pE.getOperand1().accept(this);
        if (lVal.isUnknown()) {
            return Value.UnknownValue.getInstance();
        }
        Value rVal = pE.getOperand2().accept(this);
        if (rVal.isUnknown()) {
            return Value.UnknownValue.getInstance();
        }
        return AbstractExpressionValueVisitor.calculateBinaryOperation(lVal, rVal, pE, this.machineModel, this.logger);
    }

    public static Value calculateBinaryOperation(Value lVal, Value rVal, CBinaryExpression binaryExpr, MachineModel machineModel, LogManagerWithoutDuplicates logger) {
        Value result;
        CBinaryExpression.BinaryOperator binaryOperator = binaryExpr.getOperator();
        CType calculationType = binaryExpr.getCalculationType();
        lVal = AbstractExpressionValueVisitor.castCValue(lVal, binaryExpr.getOperand1().getExpressionType(), calculationType, machineModel, logger, binaryExpr.getFileLocation());
        if (binaryOperator != CBinaryExpression.BinaryOperator.SHIFT_LEFT && binaryOperator != CBinaryExpression.BinaryOperator.SHIFT_RIGHT) {
            rVal = AbstractExpressionValueVisitor.castCValue(rVal, binaryExpr.getOperand2().getExpressionType(), calculationType, machineModel, logger, binaryExpr.getFileLocation());
        }
        if (lVal instanceof SymbolicValueFormula || rVal instanceof SymbolicValueFormula) {
            return AbstractExpressionValueVisitor.calculateSymbolicBinaryExpression(lVal, rVal, binaryExpr, logger);
        }
        if (!lVal.isNumericValue() || !rVal.isNumericValue()) {
            logger.logf(Level.FINE, "Parameters to binary operation '%s %s %s' are no numeric values.", new Object[]{lVal, binaryOperator, rVal});
            return Value.UnknownValue.getInstance();
        }
        switch (binaryOperator) {
            case PLUS: 
            case MINUS: 
            case DIVIDE: 
            case MODULO: 
            case MULTIPLY: 
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: 
            case BINARY_AND: 
            case BINARY_OR: 
            case BINARY_XOR: {
                result = AbstractExpressionValueVisitor.arithmeticOperation((NumericValue)lVal, (NumericValue)rVal, binaryOperator, calculationType, machineModel, (LogManager)logger);
                result = AbstractExpressionValueVisitor.castCValue(result, calculationType, binaryExpr.getExpressionType(), machineModel, logger, binaryExpr.getFileLocation());
                break;
            }
            case EQUALS: 
            case NOT_EQUALS: 
            case GREATER_THAN: 
            case GREATER_EQUAL: 
            case LESS_THAN: 
            case LESS_EQUAL: {
                result = AbstractExpressionValueVisitor.booleanOperation((NumericValue)lVal, (NumericValue)rVal, binaryOperator, calculationType, machineModel, (LogManager)logger);
                break;
            }
            default: {
                throw new AssertionError((Object)"unhandled binary operator");
            }
        }
        return result;
    }

    public static Value calculateSymbolicBinaryExpression(Value lVal, Value rVal, CBinaryExpression binaryExpr, LogManagerWithoutDuplicates logger) {
        SymbolicValueFormula.BinaryExpression.BinaryOperator op = SymbolicValueFormula.BinaryExpression.BinaryOperator.fromString(binaryExpr.getOperator().getOperator());
        if (op == null) {
            return Value.UnknownValue.getInstance();
        }
        SymbolicValueFormula.ExpressionBase leftHand = SymbolicValueFormula.expressionFromExplicitValue(lVal);
        SymbolicValueFormula.ExpressionBase rightHand = SymbolicValueFormula.expressionFromExplicitValue(rVal);
        return new SymbolicValueFormula(new SymbolicValueFormula.BinaryExpression(leftHand, rightHand, op, binaryExpr.getExpressionType(), binaryExpr.getCalculationType())).simplify(logger);
    }

    private static long arithmeticOperation(long l, long r, CBinaryExpression.BinaryOperator op, CType calculationType, MachineModel machineModel, LogManager logger) {
        CSimpleType st = AbstractExpressionValueVisitor.getArithmeticType(calculationType);
        if (st != null && machineModel.getSizeofInBits(st) >= 64 && st.isUnsigned()) {
            switch (op) {
                case DIVIDE: {
                    if (r == 0L) {
                        logger.logf(Level.SEVERE, "Division by Zero (%d / %d)", new Object[]{l, r});
                        return 0L;
                    }
                    return UnsignedLongs.divide((long)l, (long)r);
                }
                case MODULO: {
                    return UnsignedLongs.remainder((long)l, (long)r);
                }
                case SHIFT_RIGHT: {
                    return l >>> (int)r;
                }
            }
        }
        switch (op) {
            case PLUS: {
                return l + r;
            }
            case MINUS: {
                return l - r;
            }
            case DIVIDE: {
                if (r == 0L) {
                    logger.logf(Level.SEVERE, "Division by Zero (%d / %d)", new Object[]{l, r});
                    return 0L;
                }
                return l / r;
            }
            case MODULO: {
                return l % r;
            }
            case MULTIPLY: {
                return l * r;
            }
            case SHIFT_LEFT: {
                return r >= 64L ? 0L : l << (int)r;
            }
            case SHIFT_RIGHT: {
                return l >> (int)r;
            }
            case BINARY_AND: {
                return l & r;
            }
            case BINARY_OR: {
                return l | r;
            }
            case BINARY_XOR: {
                return l ^ r;
            }
        }
        throw new AssertionError((Object)("unknown binary operation: " + op));
    }

    private static double arithmeticOperation(double l, double r, CBinaryExpression.BinaryOperator op, CType calculationType, MachineModel machineModel, LogManager logger) {
        switch (op) {
            case PLUS: {
                return l + r;
            }
            case MINUS: {
                return l - r;
            }
            case DIVIDE: {
                return l / r;
            }
            case MODULO: {
                return l % r;
            }
            case MULTIPLY: {
                return l * r;
            }
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: 
            case BINARY_AND: 
            case BINARY_OR: 
            case BINARY_XOR: {
                throw new AssertionError((Object)("trying to perform " + op + " on floating point operands"));
            }
        }
        throw new AssertionError((Object)("unknown binary operation: " + op));
    }

    private static float arithmeticOperation(float l, float r, CBinaryExpression.BinaryOperator op, CType calculationType, MachineModel machineModel, LogManager logger) {
        switch (op) {
            case PLUS: {
                return l + r;
            }
            case MINUS: {
                return l - r;
            }
            case DIVIDE: {
                return l / r;
            }
            case MODULO: {
                return l % r;
            }
            case MULTIPLY: {
                return l * r;
            }
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: 
            case BINARY_AND: 
            case BINARY_OR: 
            case BINARY_XOR: {
                throw new AssertionError((Object)("trying to perform " + op + " on floating point operands"));
            }
        }
        throw new AssertionError((Object)("unknown binary operation: " + op));
    }

    private static Value arithmeticOperation(NumericValue lNum, NumericValue rNum, CBinaryExpression.BinaryOperator op, CType calculationType, MachineModel machineModel, LogManager logger) {
        CSimpleType type = AbstractExpressionValueVisitor.getArithmeticType(calculationType);
        if (type == null) {
            logger.logf(Level.FINE, "unsupported type %s for result of binary operation %s", new Object[]{calculationType, op});
            return Value.UnknownValue.getInstance();
        }
        switch (type.getType()) {
            case INT: {
                long lVal = lNum.getNumber().longValue();
                long rVal = rNum.getNumber().longValue();
                long result = AbstractExpressionValueVisitor.arithmeticOperation(lVal, rVal, op, calculationType, machineModel, logger);
                return new NumericValue(result);
            }
            case DOUBLE: {
                double lVal = lNum.doubleValue();
                double rVal = rNum.doubleValue();
                double result = AbstractExpressionValueVisitor.arithmeticOperation(lVal, rVal, op, calculationType, machineModel, logger);
                return new NumericValue(result);
            }
            case FLOAT: {
                float lVal = lNum.floatValue();
                float rVal = rNum.floatValue();
                float result = AbstractExpressionValueVisitor.arithmeticOperation(lVal, rVal, op, calculationType, machineModel, logger);
                return new NumericValue(Float.valueOf(result));
            }
        }
        logger.logf(Level.FINE, "unsupported type for result of binary operation %s", new Object[]{type.toString()});
        return Value.UnknownValue.getInstance();
    }

    private static Value booleanOperation(NumericValue l, NumericValue r, CBinaryExpression.BinaryOperator op, CType calculationType, MachineModel machineModel, LogManager logger) {
        int cmp;
        CSimpleType type = AbstractExpressionValueVisitor.getArithmeticType(calculationType);
        if (type == null) {
            logger.logf(Level.FINE, "unsupported type %s for result of binary operation %s", new Object[]{calculationType, op});
            return Value.UnknownValue.getInstance();
        }
        switch (type.getType()) {
            case INT: {
                CSimpleType canonicalType = type.getCanonicalType();
                int sizeInBits = machineModel.getSizeof(canonicalType) * machineModel.getSizeofCharInBits();
                if (!machineModel.isSigned(canonicalType) && sizeInBits == 64 || sizeInBits > 64) {
                    BigInteger leftBigInt = l.getNumber() instanceof BigInteger ? (BigInteger)l.getNumber() : BigInteger.valueOf(l.longValue());
                    BigInteger rightBigInt = r.getNumber() instanceof BigInteger ? (BigInteger)r.getNumber() : BigInteger.valueOf(r.longValue());
                    cmp = leftBigInt.compareTo(rightBigInt);
                    break;
                }
                cmp = Long.compare(l.longValue(), r.longValue());
                break;
            }
            case FLOAT: {
                cmp = Float.compare(l.floatValue(), r.floatValue());
                break;
            }
            case DOUBLE: {
                cmp = Double.compare(l.doubleValue(), r.doubleValue());
                break;
            }
            default: {
                logger.logf(Level.FINE, "unsupported type %s for result of binary operation %s", new Object[]{type.toString(), op});
                return Value.UnknownValue.getInstance();
            }
        }
        return new NumericValue(AbstractExpressionValueVisitor.matchBooleanOperation(op, cmp) ? 1L : 0L);
    }

    private static boolean matchBooleanOperation(CBinaryExpression.BinaryOperator op, int cmp) {
        switch (op) {
            case GREATER_THAN: {
                return cmp > 0;
            }
            case GREATER_EQUAL: {
                return cmp >= 0;
            }
            case LESS_THAN: {
                return cmp < 0;
            }
            case LESS_EQUAL: {
                return cmp <= 0;
            }
            case EQUALS: {
                return cmp == 0;
            }
            case NOT_EQUALS: {
                return cmp != 0;
            }
        }
        throw new AssertionError((Object)("unknown binary operation: " + op));
    }

    @Override
    public Value visit(CCastExpression pE) throws UnrecognizedCCodeException {
        return AbstractExpressionValueVisitor.castCValue(pE.getOperand().accept(this), pE.getOperand().getExpressionType(), pE.getExpressionType(), this.machineModel, this.logger, pE.getFileLocation());
    }

    @Override
    public Value visit(CComplexCastExpression pE) throws UnrecognizedCCodeException {
        return Value.UnknownValue.getInstance();
    }

    @Override
    public Value visit(CFunctionCallExpression pIastFunctionCallExpression) throws UnrecognizedCCodeException {
        return Value.UnknownValue.getInstance();
    }

    @Override
    public Value visit(CCharLiteralExpression pE) throws UnrecognizedCCodeException {
        return new NumericValue((long)pE.getCharacter());
    }

    @Override
    public Value visit(CFloatLiteralExpression pE) throws UnrecognizedCCodeException {
        return new NumericValue(pE.getValue());
    }

    @Override
    public Value visit(CIntegerLiteralExpression pE) throws UnrecognizedCCodeException {
        return new NumericValue(pE.getValue());
    }

    @Override
    public Value visit(CImaginaryLiteralExpression pE) throws UnrecognizedCCodeException {
        return pE.getValue().accept(this);
    }

    @Override
    public Value visit(CStringLiteralExpression pE) throws UnrecognizedCCodeException {
        return Value.UnknownValue.getInstance();
    }

    @Override
    public Value visit(CTypeIdExpression pE) {
        CTypeIdExpression.TypeIdOperator idOperator = pE.getOperator();
        CType innerType = pE.getType();
        switch (idOperator) {
            case SIZEOF: {
                int size = this.machineModel.getSizeof(innerType);
                return new NumericValue(size);
            }
        }
        return Value.UnknownValue.getInstance();
    }

    @Override
    public Value visit(CIdExpression idExp) throws UnrecognizedCCodeException {
        if (idExp.getDeclaration() instanceof CEnumType.CEnumerator) {
            CEnumType.CEnumerator enumerator = (CEnumType.CEnumerator)idExp.getDeclaration();
            if (enumerator.hasValue()) {
                return new NumericValue(enumerator.getValue());
            }
            return Value.UnknownValue.getInstance();
        }
        return this.evaluateCIdExpression(idExp);
    }

    @Override
    public Value visit(CUnaryExpression unaryExpression) throws UnrecognizedCCodeException {
        CUnaryExpression.UnaryOperator unaryOperator = unaryExpression.getOperator();
        CExpression unaryOperand = unaryExpression.getOperand();
        if (unaryOperator == CUnaryExpression.UnaryOperator.SIZEOF) {
            return new NumericValue(this.machineModel.getSizeof(unaryOperand.getExpressionType()));
        }
        if (unaryOperator == CUnaryExpression.UnaryOperator.ALIGNOF) {
            return new NumericValue(this.machineModel.getAlignof(unaryOperand.getExpressionType()));
        }
        if (unaryOperator == CUnaryExpression.UnaryOperator.AMPER) {
            return Value.UnknownValue.getInstance();
        }
        Value value = unaryOperand.accept(this);
        if (value.isUnknown()) {
            return Value.UnknownValue.getInstance();
        }
        if (!value.isNumericValue()) {
            this.logger.logf(Level.FINE, "Invalid argument %s for unary operator %s.", new Object[]{value, unaryOperator});
            return Value.UnknownValue.getInstance();
        }
        NumericValue numericValue = (NumericValue)value;
        switch (unaryOperator) {
            case MINUS: {
                return numericValue.negate();
            }
            case TILDE: {
                return new NumericValue(numericValue.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
        throw new AssertionError((Object)("unknown operator: " + unaryOperator));
    }

    @Override
    public Value visit(CPointerExpression pointerExpression) throws UnrecognizedCCodeException {
        return this.evaluateCPointerExpression(pointerExpression);
    }

    @Override
    public Value visit(CFieldReference fieldReferenceExpression) throws UnrecognizedCCodeException {
        return this.evaluateCFieldReference(fieldReferenceExpression);
    }

    @Override
    public Value visit(CArraySubscriptExpression pE) throws UnrecognizedCCodeException {
        return this.evaluateCArraySubscriptExpression(pE);
    }

    @Override
    public Value visit(JCharLiteralExpression pE) {
        return new NumericValue((long)pE.getCharacter());
    }

    @Override
    public Value visit(JBinaryExpression pE) {
        JBinaryExpression.BinaryOperator binaryOperator = pE.getOperator();
        JExpression lVarInBinaryExp = pE.getOperand1();
        JExpression rVarInBinaryExp = pE.getOperand2();
        JType lValType = lVarInBinaryExp.getExpressionType();
        JType rValType = rVarInBinaryExp.getExpressionType();
        JType expressionType = pE.getExpressionType();
        Value lValue = lVarInBinaryExp.accept(this);
        if (lValue.isUnknown()) {
            return Value.UnknownValue.getInstance();
        }
        Value rValue = rVarInBinaryExp.accept(this);
        if (rValue.isUnknown()) {
            return Value.UnknownValue.getInstance();
        }
        try {
            return this.calculateBinaryOperation(binaryOperator, lValue, lValType, rValue, rValType, expressionType);
        }
        catch (IllegalOperationException e) {
            this.logger.logUserException(Level.SEVERE, (Throwable)e, pE.getFileLocation().toString());
            return Value.UnknownValue.getInstance();
        }
    }

    private Value calculateBinaryOperation(JBinaryExpression.BinaryOperator pOperator, Value pLValue, JType pLType, Value pRValue, JType pRType, JType pExpType) throws IllegalOperationException {
        assert (!pLValue.isUnknown() && !pRValue.isUnknown());
        if (pLValue instanceof SymbolicValue || pRValue instanceof SymbolicValue) {
            return this.calculateSymbolicOperation(pLValue, pLType, pRValue, pRType, pOperator);
        }
        if (pLValue instanceof NumericValue) {
            assert (pRValue instanceof NumericValue);
            assert (pLType instanceof JSimpleType && pRType instanceof JSimpleType);
            assert (pExpType instanceof JSimpleType);
            if (AbstractExpressionValueVisitor.isFloatType(pLType) || AbstractExpressionValueVisitor.isFloatType(pRType)) {
                return this.calculateFloatOperation((NumericValue)pLValue, (NumericValue)pRValue, pOperator, ((JSimpleType)pLType).getType(), ((JSimpleType)pRType).getType());
            }
            return this.calculateIntegerOperation((NumericValue)pLValue, (NumericValue)pRValue, pOperator, ((JSimpleType)pLType).getType(), ((JSimpleType)pRType).getType());
        }
        if (pLValue instanceof BooleanValue) {
            assert (pRValue instanceof BooleanValue);
            boolean lVal = ((BooleanValue)pLValue).isTrue();
            boolean rVal = ((BooleanValue)pRValue).isTrue();
            return this.calculateBooleanOperation(lVal, rVal, pOperator);
        }
        if (pOperator == JBinaryExpression.BinaryOperator.EQUALS || pOperator == JBinaryExpression.BinaryOperator.NOT_EQUALS) {
            return this.calculateComparison(pLValue, pRValue, pOperator);
        }
        return Value.UnknownValue.getInstance();
    }

    private Value calculateSymbolicOperation(Value pLeftValue, JType pLeftType, Value pRightValue, JType pRightType, JBinaryExpression.BinaryOperator pOperator) {
        assert (pLeftValue instanceof SymbolicValue || pRightValue instanceof SymbolicValue);
        if (pOperator == JBinaryExpression.BinaryOperator.EQUALS || pOperator == JBinaryExpression.BinaryOperator.NOT_EQUALS) {
            return this.calculateComparison(pLeftValue, pRightValue, pOperator);
        }
        return this.createSymbolicFormula(pLeftValue, pLeftType, pRightValue, pRightType, pOperator);
    }

    private SymbolicValue createSymbolicFormula(Value pLeftValue, JType pLeftType, Value pRightValue, JType pRightType, JBinaryExpression.BinaryOperator pOperator) {
        SymbolicValueFactory factory = SymbolicValueFactory.getInstance();
        switch (pOperator) {
            case PLUS: {
                return factory.createAddition(pLeftValue, pLeftType, pRightValue, pRightType);
            }
            case MINUS: {
                throw new AssertionError();
            }
            case MULTIPLY: {
                return factory.createMultiplication(pLeftValue, pLeftType, pRightValue, pRightType);
            }
            case DIVIDE: {
                return factory.createDivision(pLeftValue, pLeftType, pRightValue, pRightType);
            }
            case MODULO: {
                return factory.createModulo(pLeftValue, pLeftType, pRightValue, pRightType);
            }
            case SHIFT_LEFT: {
                return factory.createShiftLeft(pLeftValue, pLeftType, pRightValue, pRightType);
            }
            case SHIFT_RIGHT_SIGNED: {
                return factory.createShiftRight(pLeftValue, pLeftType, pRightValue, pRightType);
            }
            case SHIFT_RIGHT_UNSIGNED: {
                throw new AssertionError();
            }
            case BINARY_AND: 
            case LOGICAL_AND: {
                return factory.createBinaryAnd(pLeftValue, pLeftType, pRightValue, pRightType);
            }
            case BINARY_OR: 
            case LOGICAL_OR: {
                return factory.createBinaryOr(pLeftValue, pLeftType, pRightValue, pRightType);
            }
            case BINARY_XOR: 
            case LOGICAL_XOR: {
                return factory.createBinaryXor(pLeftValue, pLeftType, pRightValue, pRightType);
            }
            case EQUALS: {
                return factory.createEquals(pLeftValue, pLeftType, pRightValue, pRightType);
            }
            case NOT_EQUALS: {
                SymbolicValue equalsFormula = factory.createEquals(pLeftValue, pLeftType, pRightValue, pRightType);
                return factory.createLogicalNot(equalsFormula, JSimpleType.getBoolean());
            }
            case LESS_THAN: {
                return factory.createLessThan(pLeftValue, pLeftType, pRightValue, pRightType);
            }
            case LESS_EQUAL: {
                return factory.createLessThanOrEqual(pLeftValue, pLeftType, pRightValue, pRightType);
            }
            case GREATER_THAN: {
                return factory.createGreaterThan(pLeftValue, pLeftType, pRightValue, pRightType);
            }
            case GREATER_EQUAL: {
                return factory.createGreaterThanOrEqual(pLeftValue, pLeftType, pRightValue, pRightType);
            }
            case CONDITIONAL_AND: {
                return factory.createConditionalAnd(pLeftValue, pLeftType, pRightValue, pRightType);
            }
            case CONDITIONAL_OR: {
                return factory.createConditionalOr(pLeftValue, pLeftType, pRightValue, pRightType);
            }
        }
        throw new AssertionError((Object)("Unhandled binary operation " + pOperator));
    }

    private Value calculateIntegerOperation(NumericValue pLeftValue, NumericValue pRightValue, JBinaryExpression.BinaryOperator pBinaryOperator, JBasicType pLeftType, JBasicType pRightType) throws IllegalOperationException {
        Preconditions.checkNotNull((Object)((Object)pLeftType));
        Preconditions.checkNotNull((Object)((Object)pRightType));
        long lVal = pLeftValue.longValue();
        long rVal = pRightValue.longValue();
        switch (pBinaryOperator) {
            case PLUS: 
            case MINUS: 
            case MULTIPLY: 
            case DIVIDE: 
            case MODULO: 
            case SHIFT_LEFT: 
            case SHIFT_RIGHT_SIGNED: 
            case SHIFT_RIGHT_UNSIGNED: 
            case BINARY_AND: 
            case BINARY_OR: 
            case BINARY_XOR: {
                long numResult;
                switch (pBinaryOperator) {
                    case PLUS: {
                        numResult = lVal + rVal;
                        break;
                    }
                    case MINUS: {
                        numResult = lVal - rVal;
                        break;
                    }
                    case DIVIDE: {
                        if (rVal == 0L) {
                            throw new IllegalOperationException("Division by zero: " + lVal + " / " + rVal);
                        }
                        numResult = lVal / rVal;
                        break;
                    }
                    case MULTIPLY: {
                        numResult = lVal * rVal;
                        break;
                    }
                    case BINARY_AND: {
                        numResult = lVal & rVal;
                        break;
                    }
                    case BINARY_OR: {
                        numResult = lVal | rVal;
                        break;
                    }
                    case BINARY_XOR: {
                        numResult = lVal ^ rVal;
                        break;
                    }
                    case MODULO: {
                        numResult = lVal % rVal;
                        break;
                    }
                    case SHIFT_LEFT: {
                        if (pLeftType != JBasicType.LONG && pRightType != JBasicType.LONG) {
                            numResult = (int)lVal << (int)rVal;
                            break;
                        }
                        numResult = lVal << (int)rVal;
                        break;
                    }
                    case SHIFT_RIGHT_SIGNED: {
                        if (pLeftType != JBasicType.LONG && pRightType != JBasicType.LONG) {
                            numResult = (int)lVal >> (int)rVal;
                            break;
                        }
                        numResult = lVal >> (int)rVal;
                        break;
                    }
                    case SHIFT_RIGHT_UNSIGNED: {
                        if (pLeftType != JBasicType.LONG && pRightType != JBasicType.LONG) {
                            numResult = (int)lVal >>> (int)rVal;
                            break;
                        }
                        numResult = lVal >>> (int)rVal;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled operator " + pBinaryOperator));
                    }
                }
                if (pLeftType != JBasicType.LONG && pRightType != JBasicType.LONG) {
                    numResult = (int)numResult;
                }
                return new NumericValue(numResult);
            }
            case EQUALS: 
            case NOT_EQUALS: 
            case LESS_THAN: 
            case LESS_EQUAL: 
            case GREATER_THAN: 
            case GREATER_EQUAL: {
                boolean result;
                switch (pBinaryOperator) {
                    case EQUALS: {
                        result = lVal == rVal;
                        break;
                    }
                    case NOT_EQUALS: {
                        result = lVal != rVal;
                        break;
                    }
                    case GREATER_THAN: {
                        result = lVal > rVal;
                        break;
                    }
                    case GREATER_EQUAL: {
                        result = lVal >= rVal;
                        break;
                    }
                    case LESS_THAN: {
                        result = lVal < rVal;
                        break;
                    }
                    case LESS_EQUAL: {
                        result = lVal <= rVal;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled operation " + pBinaryOperator));
                    }
                }
                return BooleanValue.valueOf(result);
            }
        }
        return Value.UnknownValue.getInstance();
    }

    private Value calculateFloatOperation(NumericValue pLeftValue, NumericValue pRightValue, JBinaryExpression.BinaryOperator pBinaryOperator, JBasicType pLeftOperand, JBasicType pRightOperand) throws IllegalOperationException {
        double rVal;
        double lVal;
        if (pLeftOperand != JBasicType.DOUBLE && pRightOperand != JBasicType.DOUBLE) {
            lVal = pLeftValue.floatValue();
            rVal = pRightValue.floatValue();
        } else {
            lVal = pLeftValue.doubleValue();
            rVal = pRightValue.doubleValue();
        }
        switch (pBinaryOperator) {
            case PLUS: 
            case MINUS: 
            case MULTIPLY: 
            case DIVIDE: 
            case MODULO: {
                switch (pBinaryOperator) {
                    case PLUS: {
                        return new NumericValue(lVal + rVal);
                    }
                    case MINUS: {
                        return new NumericValue(lVal - rVal);
                    }
                    case DIVIDE: {
                        if (rVal == 0.0) {
                            throw new IllegalOperationException("Division by zero: " + lVal + " / " + rVal);
                        }
                        return new NumericValue(lVal / rVal);
                    }
                    case MULTIPLY: {
                        return new NumericValue(lVal * rVal);
                    }
                    case MODULO: {
                        return new NumericValue(lVal % rVal);
                    }
                }
                throw new AssertionError((Object)("Unsupported binary operation " + pBinaryOperator.toString() + " on double values"));
            }
            case EQUALS: 
            case NOT_EQUALS: 
            case LESS_THAN: 
            case LESS_EQUAL: 
            case GREATER_THAN: 
            case GREATER_EQUAL: {
                boolean result;
                switch (pBinaryOperator) {
                    case EQUALS: {
                        result = lVal == rVal;
                        break;
                    }
                    case NOT_EQUALS: {
                        result = lVal != rVal;
                        break;
                    }
                    case GREATER_THAN: {
                        result = lVal > rVal;
                        break;
                    }
                    case GREATER_EQUAL: {
                        result = lVal >= rVal;
                        break;
                    }
                    case LESS_THAN: {
                        result = lVal < rVal;
                        break;
                    }
                    case LESS_EQUAL: {
                        result = lVal <= rVal;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unsupported binary operation " + pBinaryOperator.toString() + " on floating point values"));
                    }
                }
                return BooleanValue.valueOf(result);
            }
        }
        return Value.UnknownValue.getInstance();
    }

    private Value calculateBooleanOperation(boolean lVal, boolean rVal, JBinaryExpression.BinaryOperator operator) {
        switch (operator) {
            case LOGICAL_AND: 
            case CONDITIONAL_AND: {
                return BooleanValue.valueOf(lVal && rVal);
            }
            case LOGICAL_OR: 
            case CONDITIONAL_OR: {
                return BooleanValue.valueOf(lVal || rVal);
            }
            case LOGICAL_XOR: {
                return BooleanValue.valueOf(lVal ^ rVal);
            }
            case EQUALS: {
                return BooleanValue.valueOf(lVal == rVal);
            }
            case NOT_EQUALS: {
                return BooleanValue.valueOf(lVal != rVal);
            }
        }
        throw new AssertionError((Object)("Unhandled operator " + operator + " for boolean expression"));
    }

    private Value calculateComparison(Value pLeftValue, Value pRightValue, JBinaryExpression.BinaryOperator pOperator) {
        assert (pOperator == JBinaryExpression.BinaryOperator.NOT_EQUALS || pOperator == JBinaryExpression.BinaryOperator.EQUALS);
        return BooleanValue.valueOf(pOperator != JBinaryExpression.BinaryOperator.EQUALS ^ pLeftValue.equals(pRightValue));
    }

    @Override
    public Value visit(JIdExpression idExp) {
        JSimpleDeclaration decl = idExp.getDeclaration();
        if (decl == null) {
            return Value.UnknownValue.getInstance();
        }
        if (decl instanceof JFieldDeclaration && !((JFieldDeclaration)decl).isStatic()) {
            this.missingFieldAccessInformation = true;
        }
        return this.evaluateJIdExpression(idExp);
    }

    @Override
    public Value visit(JUnaryExpression unaryExpression) {
        JUnaryExpression.UnaryOperator unaryOperator = unaryExpression.getOperator();
        JExpression unaryOperand = unaryExpression.getOperand();
        Value valueObject = unaryOperand.accept(this);
        String errorMsg = "Invalid argument [" + valueObject + "] for unary operator [" + unaryOperator + "].";
        if (valueObject.isUnknown()) {
            return Value.UnknownValue.getInstance();
        }
        if (valueObject.isNumericValue()) {
            NumericValue value = (NumericValue)valueObject;
            switch (unaryOperator) {
                case MINUS: {
                    return value.negate();
                }
                case COMPLEMENT: {
                    return this.evaluateComplement(unaryOperand, value);
                }
                case PLUS: {
                    return value;
                }
            }
            this.logger.log(Level.FINE, new Object[]{errorMsg});
            return Value.UnknownValue.getInstance();
        }
        if (valueObject instanceof BooleanValue && unaryOperator == JUnaryExpression.UnaryOperator.NOT) {
            return ((BooleanValue)valueObject).negate();
        }
        this.logger.logf(Level.FINE, errorMsg, new Object[0]);
        return Value.UnknownValue.getInstance();
    }

    private Value evaluateComplement(JExpression pExpression, NumericValue value) {
        JType type = pExpression.getExpressionType();
        if (AbstractExpressionValueVisitor.isIntegerType(type)) {
            return new NumericValue(value.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
        }
        this.logger.logf(Level.FINE, "Invalid argument %s for unary operator ~.", new Object[]{value});
        return Value.UnknownValue.getInstance();
    }

    private static boolean isIntegerType(JType type) {
        return type instanceof JSimpleType && ((JSimpleType)type).getType().isIntegerType();
    }

    private static boolean isFloatType(JType type) {
        return type instanceof JSimpleType && ((JSimpleType)type).getType().isFloatingPointType();
    }

    @Override
    public Value visit(JIntegerLiteralExpression pE) {
        return new NumericValue(pE.asLong());
    }

    @Override
    public Value visit(JBooleanLiteralExpression pE) {
        return BooleanValue.valueOf(pE.getValue());
    }

    @Override
    public Value visit(JArraySubscriptExpression pJArraySubscriptExpression) {
        NumericValue subscriptValue = (NumericValue)pJArraySubscriptExpression.getSubscriptExpression().accept(this);
        JExpression arrayExpression = pJArraySubscriptExpression.getArrayExpression();
        Value idValue = arrayExpression.accept(this);
        if (!idValue.isUnknown()) {
            ArrayValue innerMostArray = (ArrayValue)arrayExpression.accept(this);
            assert (subscriptValue.longValue() >= 0L && subscriptValue.longValue() <= Integer.MAX_VALUE);
            return innerMostArray.getValueAt((int)subscriptValue.longValue());
        }
        return Value.UnknownValue.getInstance();
    }

    @Override
    public Value visit(JArrayLengthExpression pJArrayLengthExpression) {
        JExpression arrayId = pJArrayLengthExpression.getQualifier();
        Value array = arrayId.accept(this);
        if (!array.isExplicitlyKnown()) {
            return Value.UnknownValue.getInstance();
        }
        assert (array instanceof ArrayValue);
        return new NumericValue(((ArrayValue)array).getArraySize());
    }

    @Override
    public Value visit(JEnumConstantExpression pJEnumConstantExpression) {
        JClassType enumType = pJEnumConstantExpression.getExpressionType();
        String fullName = pJEnumConstantExpression.getConstantName();
        return new EnumConstantValue(enumType, fullName);
    }

    @Override
    public Value visit(JCastExpression pJCastExpression) {
        JExpression operand = pJCastExpression.getOperand();
        JType castType = pJCastExpression.getCastType();
        return AbstractExpressionValueVisitor.castJValue(operand.accept(this), operand.getExpressionType(), castType, this.logger, pJCastExpression.getFileLocation());
    }

    @Override
    public Value visit(JMethodInvocationExpression pAFunctionCallExpression) {
        return Value.UnknownValue.getInstance();
    }

    @Override
    public Value visit(JClassInstanceCreation pJClassInstanzeCreation) {
        return Value.UnknownValue.getInstance();
    }

    @Override
    public Value visit(JStringLiteralExpression pPaStringLiteralExpression) {
        return Value.UnknownValue.getInstance();
    }

    @Override
    public Value visit(JFloatLiteralExpression pJBooleanLiteralExpression) {
        return new NumericValue(pJBooleanLiteralExpression.getValue());
    }

    @Override
    public Value visit(JArrayCreationExpression pJArrayCreationExpression) {
        ArrayList<JExpression> arraySizeExpressions = new ArrayList<JExpression>(pJArrayCreationExpression.getLength());
        Value currentArrayValue = null;
        int currentDimension = 0;
        JType elementType = pJArrayCreationExpression.getExpressionType().getElementType();
        Collections.reverse(arraySizeExpressions);
        for (JExpression sizeExpression : arraySizeExpressions) {
            ++currentDimension;
            Value.UnknownValue lastArrayValue = currentArrayValue;
            Value sizeValue = sizeExpression.accept(this);
            if (sizeValue.isUnknown()) {
                currentArrayValue = Value.UnknownValue.getInstance();
                continue;
            }
            long concreteArraySize = ((NumericValue)sizeValue).longValue();
            currentArrayValue = this.createArrayValue(new JArrayType(elementType, currentDimension), concreteArraySize);
            if (lastArrayValue == null) continue;
            Value newValue = lastArrayValue;
            int index = 0;
            while ((long)index < concreteArraySize) {
                ((ArrayValue)currentArrayValue).setValue(newValue, index);
                if (lastArrayValue instanceof ArrayValue) {
                    newValue = ArrayValue.copyOf((ArrayValue)((Object)lastArrayValue));
                }
                ++index;
            }
        }
        return currentArrayValue;
    }

    private ArrayValue createArrayValue(JArrayType pType, long pArraySize) {
        if (pArraySize < 0L || pArraySize > Integer.MAX_VALUE) {
            throw new AssertionError((Object)("Trying to create array of size " + pArraySize + ". Java arrays can't be smaller than 0 or bigger than the max int value."));
        }
        return new ArrayValue(pType, (int)pArraySize);
    }

    @Override
    public Value visit(JArrayInitializer pJArrayInitializer) {
        JArrayType arrayType = pJArrayInitializer.getExpressionType();
        List<JExpression> initializerExpressions = pJArrayInitializer.getInitializerExpressions();
        LinkedList<Value> slotValues = new LinkedList<Value>();
        for (JExpression currentExpression : initializerExpressions) {
            slotValues.add(currentExpression.accept(this));
        }
        return new ArrayValue(arrayType, slotValues);
    }

    @Override
    public Value visit(JVariableRunTimeType pJThisRunTimeType) {
        return Value.UnknownValue.getInstance();
    }

    @Override
    public Value visit(JRunTimeTypeEqualsType pJRunTimeTypeEqualsType) {
        return Value.UnknownValue.getInstance();
    }

    @Override
    public Value visit(JNullLiteralExpression pJNullLiteralExpression) {
        return NullValue.getInstance();
    }

    @Override
    public Value visit(JThisExpression pThisExpression) {
        return Value.UnknownValue.getInstance();
    }

    protected abstract Value evaluateCPointerExpression(CPointerExpression var1) throws UnrecognizedCCodeException;

    protected abstract Value evaluateCIdExpression(CIdExpression var1) throws UnrecognizedCCodeException;

    protected abstract Value evaluateJIdExpression(JIdExpression var1);

    protected abstract Value evaluateCFieldReference(CFieldReference var1) throws UnrecognizedCCodeException;

    protected abstract Value evaluateCArraySubscriptExpression(CArraySubscriptExpression var1) throws UnrecognizedCCodeException;

    public String getFunctionName() {
        return this.functionName;
    }

    public long getSizeof(CType pType) throws UnrecognizedCCodeException {
        return this.machineModel.getSizeof(pType);
    }

    public Value evaluate(CExpression pExp, CType pTargetType) throws UnrecognizedCCodeException {
        return AbstractExpressionValueVisitor.castCValue(pExp.accept(this), pExp.getExpressionType(), pTargetType, this.machineModel, this.logger, pExp.getFileLocation());
    }

    public Value evaluate(CRightHandSide pExp, CType pTargetType) throws UnrecognizedCCodeException {
        return AbstractExpressionValueVisitor.castCValue(pExp.accept(this), pExp.getExpressionType(), pTargetType, this.machineModel, this.logger, pExp.getFileLocation());
    }

    public Value evaluate(JRightHandSide pExp, JType pTargetType) {
        return AbstractExpressionValueVisitor.castJValue(pExp.accept(this), (JType)pExp.getExpressionType(), pTargetType, this.logger, pExp.getFileLocation());
    }

    public static Value castCValue(@Nonnull Value value, CType sourceType, CType targetType, MachineModel machineModel, LogManagerWithoutDuplicates logger, FileLocation fileLocation) {
        if (!value.isExplicitlyKnown()) {
            return value;
        }
        if (!value.isNumericValue()) {
            logger.logf(Level.FINE, "Can not cast C value %s to %s", new Object[]{value.toString(), targetType.toString()});
            return value;
        }
        NumericValue numericValue = (NumericValue)value;
        CType type = targetType.getCanonicalType();
        if (type instanceof CSimpleType) {
            CSimpleType st = (CSimpleType)type;
            switch (st.getType()) {
                case INT: 
                case CHAR: {
                    int size = machineModel.getSizeofInBits(st);
                    long longValue = numericValue.longValue();
                    boolean targetIsSigned = machineModel.isSigned(st);
                    if (size < 64) {
                        long maxValue = 1L << size;
                        long result = longValue % maxValue;
                        if (targetIsSigned) {
                            if (result > maxValue / 2L - 1L) {
                                result -= maxValue;
                            } else if (result < -(maxValue / 2L)) {
                                result += maxValue;
                            }
                        } else if (longValue < 0L) {
                            result += maxValue;
                        }
                        return new NumericValue(result);
                    }
                    if (size == 64) {
                        if (!targetIsSigned && longValue < 0L) {
                            return new NumericValue(BigInteger.valueOf(longValue).andNot(BigInteger.valueOf(-1L).shiftLeft(size)));
                        }
                        return new NumericValue(longValue);
                    }
                    logger.logfOnce(Level.INFO, "%s: value %s of c-type '%s' is too big for java-type 'long'.", new Object[]{fileLocation, value, targetType});
                    return value;
                }
                case FLOAT: {
                    NumericValue result;
                    float floatValue = numericValue.floatValue();
                    int bitPerByte = machineModel.getSizeofCharInBits();
                    int numBytes = machineModel.getSizeof(st);
                    int size = bitPerByte * numBytes;
                    if (size == 32) {
                        result = new NumericValue(Float.valueOf(floatValue));
                    } else if (size == 64) {
                        result = new NumericValue(Float.valueOf(floatValue));
                    } else {
                        throw new AssertionError((Object)("Trying to cast to unsupported floating point type: " + st));
                    }
                    return result;
                }
                case DOUBLE: {
                    NumericValue result;
                    double doubleValue = numericValue.doubleValue();
                    int bitPerByte = machineModel.getSizeofCharInBits();
                    int numBytes = machineModel.getSizeof(st);
                    int size = bitPerByte * numBytes;
                    if (size == 32) {
                        result = new NumericValue(Float.valueOf((float)doubleValue));
                    } else if (size == 64) {
                        result = new NumericValue(doubleValue);
                    } else {
                        throw new AssertionError((Object)("Trying to cast to unsupported floating point type: " + st));
                    }
                    return result;
                }
            }
            return value;
        }
        return value;
    }

    public static Value castJValue(@Nonnull Value value, JType sourceType, JType targetType, LogManagerWithoutDuplicates logger, FileLocation fileLocation) {
        if (!value.isExplicitlyKnown()) {
            return value;
        }
        if (!value.isNumericValue()) {
            logger.logf(Level.FINE, "Can not cast Java value %s to %s", new Object[]{value.toString(), targetType.toString()});
            return value;
        }
        NumericValue numericValue = (NumericValue)value;
        if (targetType instanceof JSimpleType) {
            JSimpleType st = (JSimpleType)targetType;
            if (AbstractExpressionValueVisitor.isIntegerType(sourceType)) {
                long longValue = numericValue.longValue();
                return AbstractExpressionValueVisitor.createValue(longValue, st.getType());
            }
            if (AbstractExpressionValueVisitor.isFloatType(sourceType)) {
                double doubleValue = numericValue.doubleValue();
                return AbstractExpressionValueVisitor.createValue(doubleValue, st.getType());
            }
            throw new AssertionError((Object)("Cast from " + sourceType.toString() + " to " + targetType.toString() + " not possible."));
        }
        return value;
    }

    private static Value createValue(long value, JBasicType targetType) {
        switch (targetType) {
            case BYTE: {
                return new NumericValue((byte)value);
            }
            case CHAR: {
                char castedValue = (char)value;
                return new NumericValue((int)castedValue);
            }
            case SHORT: {
                return new NumericValue((short)value);
            }
            case INT: {
                return new NumericValue((int)value);
            }
            case LONG: {
                return new NumericValue(value);
            }
            case FLOAT: {
                return new NumericValue(Float.valueOf(value));
            }
            case DOUBLE: {
                return new NumericValue(value);
            }
        }
        throw new AssertionError((Object)("Trying to cast to unsupported type " + (Object)((Object)targetType)));
    }

    private static Value createValue(double value, JBasicType targetType) {
        switch (targetType) {
            case BYTE: {
                return new NumericValue((byte)value);
            }
            case CHAR: 
            case SHORT: {
                return new NumericValue((short)value);
            }
            case INT: {
                return new NumericValue((int)value);
            }
            case LONG: {
                return new NumericValue(value);
            }
            case FLOAT: {
                return new NumericValue(Float.valueOf((float)value));
            }
            case DOUBLE: {
                return new NumericValue(value);
            }
        }
        throw new AssertionError((Object)("Trying to cast to unsupported type " + (Object)((Object)targetType)));
    }

    public static CSimpleType getArithmeticType(CType type) {
        if ((type = type.getCanonicalType()) instanceof CPointerType) {
            return CNumericTypes.INT;
        }
        if (type instanceof CSimpleType) {
            return (CSimpleType)type;
        }
        return null;
    }

    protected static class IllegalOperationException
    extends CPAException {
        private static final long serialVersionUID = 5420891133452817345L;

        public IllegalOperationException(String msg) {
            super(msg);
        }

        public IllegalOperationException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

