/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JIdExpression;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.ForwardingTransferRelation;
import org.sosy_lab.cpachecker.cpa.value.AbstractExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.type.SymbolicValueFormula;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;

public class ExpressionValueVisitor
extends AbstractExpressionValueVisitor {
    private boolean missingPointer = false;
    private final ValueAnalysisState state;
    private boolean symbolicValues = false;
    private static Map<FileLocation, Integer> numberOfSymbolsGenerated = new HashMap<FileLocation, Integer>();
    private static final int MAX_NUMBER_OF_SYMBOLS_GENERATED = 200;

    public ExpressionValueVisitor(ValueAnalysisState pState, String pFunctionName, MachineModel pMachineModel, LogManagerWithoutDuplicates pLogger, boolean pSymbolicValues) {
        super(pFunctionName, pMachineModel, pLogger);
        this.state = pState;
        this.symbolicValues = pSymbolicValues;
    }

    @Override
    public void reset() {
        super.reset();
        this.missingPointer = false;
    }

    public boolean hasMissingPointer() {
        return this.missingPointer;
    }

    @Override
    public Value visit(CFunctionCallExpression pIastFunctionCallExpression) throws UnrecognizedCCodeException {
        if (this.symbolicValues) {
            FileLocation key = pIastFunctionCallExpression.getFileLocation();
            int generatedSymbols = 0;
            if (numberOfSymbolsGenerated.containsKey(key)) {
                generatedSymbols = numberOfSymbolsGenerated.get(key);
            }
            if (generatedSymbols < 200) {
                numberOfSymbolsGenerated.put(key, generatedSymbols + 1);
                return new SymbolicValueFormula(new SymbolicValueFormula.SymbolicValue(pIastFunctionCallExpression.toASTString()));
            }
        }
        return Value.UnknownValue.getInstance();
    }

    @Override
    protected Value evaluateCIdExpression(CIdExpression varName) {
        return this.evaluateAIdExpression(varName);
    }

    @Override
    protected Value evaluateJIdExpression(JIdExpression varName) {
        return this.evaluateAIdExpression(varName);
    }

    private Value evaluateAIdExpression(AIdExpression varName) {
        ValueAnalysisState.MemoryLocation memLoc = !ForwardingTransferRelation.isGlobal(varName) ? ValueAnalysisState.MemoryLocation.valueOf(this.getFunctionName(), varName.getName(), 0L) : ValueAnalysisState.MemoryLocation.valueOf(varName.getName(), 0L);
        if (this.state.contains(memLoc)) {
            return this.state.getValueFor(memLoc);
        }
        return Value.UnknownValue.getInstance();
    }

    private Value evaluateLValue(CLeftHandSide pLValue) throws UnrecognizedCCodeException {
        ValueAnalysisState.MemoryLocation varLoc = this.evaluateMemoryLocation(pLValue);
        if (varLoc == null) {
            return Value.UnknownValue.getInstance();
        }
        if (this.getState().contains(varLoc)) {
            return this.state.getValueFor(varLoc);
        }
        return Value.UnknownValue.getInstance();
    }

    @Override
    protected Value evaluateCFieldReference(CFieldReference pLValue) throws UnrecognizedCCodeException {
        return this.evaluateLValue(pLValue);
    }

    @Override
    protected Value evaluateCArraySubscriptExpression(CArraySubscriptExpression pLValue) throws UnrecognizedCCodeException {
        return this.evaluateLValue(pLValue);
    }

    @Override
    protected Value evaluateCPointerExpression(CPointerExpression pVarName) {
        this.missingPointer = true;
        return Value.UnknownValue.getInstance();
    }

    public boolean canBeEvaluated(CExpression lValue) throws UnrecognizedCCodeException {
        return lValue.accept(new MemoryLocationEvaluator(this)) != null;
    }

    public ValueAnalysisState.MemoryLocation evaluateMemoryLocation(CExpression lValue) throws UnrecognizedCCodeException {
        return lValue.accept(new MemoryLocationEvaluator(this));
    }

    public ValueAnalysisState getState() {
        return this.state;
    }

    private static class MemoryLocationEvaluator
    extends DefaultCExpressionVisitor<ValueAnalysisState.MemoryLocation, UnrecognizedCCodeException> {
        private final ExpressionValueVisitor evv;

        public MemoryLocationEvaluator(ExpressionValueVisitor pEvv) {
            this.evv = pEvv;
        }

        @Override
        protected ValueAnalysisState.MemoryLocation visitDefault(CExpression pExp) throws UnrecognizedCCodeException {
            return null;
        }

        @Override
        public ValueAnalysisState.MemoryLocation visit(CArraySubscriptExpression pIastArraySubscriptExpression) throws UnrecognizedCCodeException {
            CExpression arrayExpression = pIastArraySubscriptExpression.getArrayExpression();
            CType arrayExpressionType = arrayExpression.getExpressionType().getCanonicalType();
            if (arrayExpressionType instanceof CPointerType) {
                this.evv.missingPointer = true;
                return null;
            }
            CExpression subscript = pIastArraySubscriptExpression.getSubscriptExpression();
            CType elementType = pIastArraySubscriptExpression.getExpressionType();
            ValueAnalysisState.MemoryLocation arrayLoc = arrayExpression.accept(this);
            if (arrayLoc == null) {
                return null;
            }
            Value subscriptValue = subscript.accept(this.evv);
            if (!subscriptValue.isExplicitlyKnown() || !subscriptValue.isNumericValue()) {
                return null;
            }
            long typeSize = this.evv.getSizeof(elementType);
            long subscriptOffset = subscriptValue.asNumericValue().longValue() * typeSize;
            if (arrayLoc.isOnFunctionStack()) {
                return ValueAnalysisState.MemoryLocation.valueOf(arrayLoc.getFunctionName(), arrayLoc.getIdentifier(), subscriptOffset);
            }
            return ValueAnalysisState.MemoryLocation.valueOf(arrayLoc.getIdentifier(), subscriptOffset);
        }

        @Override
        public ValueAnalysisState.MemoryLocation visit(CFieldReference pIastFieldReference) throws UnrecognizedCCodeException {
            String fieldName;
            if (pIastFieldReference.isPointerDereference()) {
                this.evv.missingPointer = true;
                return null;
            }
            CLeftHandSide fieldOwner = (CLeftHandSide)pIastFieldReference.getFieldOwner();
            ValueAnalysisState.MemoryLocation memLocOfFieldOwner = fieldOwner.accept(this);
            if (memLocOfFieldOwner == null) {
                return null;
            }
            CType ownerType = fieldOwner.getExpressionType().getCanonicalType();
            Integer offset = this.getFieldOffset(ownerType, fieldName = pIastFieldReference.getFieldName());
            if (offset == null) {
                return null;
            }
            if (memLocOfFieldOwner.isOnFunctionStack()) {
                return ValueAnalysisState.MemoryLocation.valueOf(memLocOfFieldOwner.getFunctionName(), memLocOfFieldOwner.getIdentifier(), memLocOfFieldOwner.getOffset() + (long)offset.intValue());
            }
            return ValueAnalysisState.MemoryLocation.valueOf(memLocOfFieldOwner.getIdentifier(), (long)offset.intValue() + memLocOfFieldOwner.getOffset());
        }

        private Integer getFieldOffset(CType ownerType, String fieldName) throws UnrecognizedCCodeException {
            if (ownerType instanceof CElaboratedType) {
                return this.getFieldOffset(((CElaboratedType)ownerType).getRealType(), fieldName);
            }
            if (ownerType instanceof CCompositeType) {
                return this.getFieldOffset((CCompositeType)ownerType, fieldName);
            }
            if (ownerType instanceof CPointerType) {
                this.evv.missingPointer = true;
                return null;
            }
            throw new AssertionError();
        }

        private Integer getFieldOffset(CCompositeType ownerType, String fieldName) throws UnrecognizedCCodeException {
            List<CCompositeType.CCompositeTypeMemberDeclaration> membersOfType = ownerType.getMembers();
            int offset = 0;
            for (CCompositeType.CCompositeTypeMemberDeclaration typeMember : membersOfType) {
                String memberName = typeMember.getName();
                if (memberName.equals(fieldName)) {
                    return offset;
                }
                if (ownerType.getKind() == CComplexType.ComplexTypeKind.UNION) continue;
                CType fieldType = typeMember.getType().getCanonicalType();
                offset = (int)((long)offset + this.evv.getSizeof(fieldType));
            }
            return null;
        }

        @Override
        public ValueAnalysisState.MemoryLocation visit(CIdExpression idExp) throws UnrecognizedCCodeException {
            boolean isGlobal = ForwardingTransferRelation.isGlobal((AExpression)idExp);
            if (isGlobal) {
                return ValueAnalysisState.MemoryLocation.valueOf(idExp.getName(), 0L);
            }
            return ValueAnalysisState.MemoryLocation.valueOf(this.evv.getFunctionName(), idExp.getName(), 0L);
        }

        @Override
        public ValueAnalysisState.MemoryLocation visit(CPointerExpression pPointerExpression) throws UnrecognizedCCodeException {
            this.evv.missingPointer = true;
            return null;
        }

        @Override
        public ValueAnalysisState.MemoryLocation visit(CCastExpression pE) throws UnrecognizedCCodeException {
            return pE.getOperand().accept(this);
        }
    }
}

