/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value;

import com.google.common.collect.Lists;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.common.log.TestLogManager;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.value.ExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;

@RunWith(value=Parameterized.class)
public class ExpressionValueVisitorTest {
    @Parameterized.Parameter(value=0)
    public MachineModel machineModel;
    @Parameterized.Parameter(value=1)
    public boolean symbolicValues;
    private static final int MAX_CHAR = 256;
    private static final int MAX_SHORT = 65536;
    private static final long MAX_INT = 0x100000000L;
    private static final CSimpleType S_CHAR = CNumericTypes.SIGNED_CHAR;
    private static final CSimpleType U_CHAR = CNumericTypes.UNSIGNED_CHAR;
    private static final CSimpleType S_SHORT_INT = CNumericTypes.SHORT_INT;
    private static final CSimpleType U_SHORT_INT = CNumericTypes.UNSIGNED_SHORT_INT;
    private static final CSimpleType S_INT = CNumericTypes.INT;
    private static final CSimpleType U_INT = CNumericTypes.UNSIGNED_INT;
    private static final CSimpleType S_LONG_INT = CNumericTypes.LONG_INT;
    private static final CSimpleType U_LONG_INT = CNumericTypes.UNSIGNED_LONG_INT;
    private static final CSimpleType S_LONG_LONG_INT = CNumericTypes.LONG_LONG_INT;
    private static final CSimpleType U_LONG_LONG_INT = CNumericTypes.UNSIGNED_LONG_LONG_INT;
    private LogManagerWithoutDuplicates logger;
    private ExpressionValueVisitor evv;

    @Parameterized.Parameters(name="{0}, symbolicValues={1}")
    public static List<Object[]> getParameters() {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (MachineModel model : MachineModel.values()) {
            result.add(new Object[]{model, false});
            result.add(new Object[]{model, true});
        }
        return result;
    }

    @Before
    public void init() {
        this.logger = new LogManagerWithoutDuplicates(TestLogManager.getInstance());
        this.evv = new ExpressionValueVisitor(new ValueAnalysisState(), "dummy_function", this.machineModel, this.logger, this.symbolicValues);
    }

    @Test
    public void checkSimpleCasts() throws Exception {
        int i;
        for (i = -128; i < 256; i += 50) {
            this.checkCast(i, i < 128 ? (long)i : (long)(-256 + i), S_CHAR);
            this.checkCast(i, i < 0 ? (long)(256 + i) : (long)i, U_CHAR);
        }
        for (i = 32768; i < 65536; i += 5000) {
            this.checkCast(i, i < 32768 ? (long)i : (long)(-65536 + i), S_SHORT_INT);
            this.checkCast(i, i < 0 ? (long)(65536 + i) : (long)i, U_SHORT_INT);
        }
        for (long i2 = 0x80000000L; i2 < 0x100000000L; i2 += 10000000L) {
            this.checkCast(i2, i2 < 0x80000000L ? i2 : -4294967296L + i2, S_INT);
            this.checkCast(i2, i2 < 0L ? 0x100000000L + i2 : i2, U_INT);
        }
    }

    @Test
    public void checkCastsDirect() throws Exception {
        this.checkCast(4L, 4L, S_CHAR);
        this.checkCast(-4L, -4L, S_CHAR);
        this.checkCast(256L, 0L, S_CHAR);
        this.checkCast(260L, 4L, S_CHAR);
        this.checkCast(127L, 127L, S_CHAR);
        this.checkCast(128L, -128L, S_CHAR);
        this.checkCast(-127L, -127L, S_CHAR);
        this.checkCast(-128L, -128L, S_CHAR);
        this.checkCast(1050L, 26L, S_CHAR);
        this.checkCast(-1050L, -26L, S_CHAR);
        this.checkCast(4L, 4L, U_CHAR);
        this.checkCast(-4L, 252L, U_CHAR);
        this.checkCast(256L, 0L, U_CHAR);
        this.checkCast(260L, 4L, U_CHAR);
        this.checkCast(127L, 127L, U_CHAR);
        this.checkCast(-128L, 128L, U_CHAR);
        this.checkCast(-127L, 129L, U_CHAR);
        this.checkCast(-1L, 255L, U_CHAR);
        this.checkCast(1050L, 26L, U_CHAR);
        this.checkCast(-1050L, 230L, U_CHAR);
        this.checkCast(4L, 4L, S_INT);
        this.checkCast(-4L, -4L, S_INT);
        this.checkCast(0x100000000L, 0L, S_INT);
        this.checkCast(0x100000004L, 4L, S_INT);
        this.checkCast(Integer.MAX_VALUE, Integer.MAX_VALUE, S_INT);
        this.checkCast(Integer.MIN_VALUE, Integer.MIN_VALUE, S_INT);
        this.checkCast(0x80000000L, Integer.MIN_VALUE, S_INT);
        this.checkCast(-2147483649L, Integer.MAX_VALUE, S_INT);
        this.checkCast(0x80000001L, -2147483647L, S_INT);
        this.checkCast(4L, 4L, U_INT);
        this.checkCast(-4L, 0xFFFFFFFCL, U_INT);
        this.checkCast(0x100000000L, 0L, U_INT);
        this.checkCast(0x100000004L, 4L, U_INT);
        this.checkCast(Integer.MAX_VALUE, Integer.MAX_VALUE, U_INT);
        this.checkCast(0x80000001L, 0x80000001L, U_INT);
        this.checkCast(Integer.MIN_VALUE, 0x80000000L, U_INT);
        this.checkCast(-2147483649L, Integer.MAX_VALUE, U_INT);
        this.checkCast(-1L, 0xFFFFFFFFL, U_INT);
    }

    @Test
    public void checkCasts32() throws Exception {
        TruthJUnit.assume().that((Comparable)((Object)this.machineModel)).named("MachineModel").isSameAs((Object)MachineModel.LINUX32);
        for (long i = Integer.MIN_VALUE; i < 0x100000000L; i += 10000000L) {
            this.checkCast(i, i < 0x80000000L ? i : -4294967296L + i, S_INT);
            this.checkCast(i, i < 0L ? 0x100000000L + i : i, U_INT);
            this.checkCast(i, i < 0x80000000L ? i : -4294967296L + i, S_LONG_INT);
            this.checkCast(i, i < 0L ? 0x100000000L + i : i, U_LONG_INT);
            this.checkCast(i, i, S_LONG_LONG_INT);
            this.checkCast(i, i, U_LONG_LONG_INT);
        }
        for (CType t : Lists.newArrayList((Object[])new CSimpleType[]{S_INT, S_LONG_INT})) {
            this.checkCast(4L, 4L, t);
            this.checkCast(-4L, -4L, t);
            this.checkCast(0x100000000L, 0L, t);
            this.checkCast(0x100000004L, 4L, t);
            this.checkCast(Integer.MAX_VALUE, Integer.MAX_VALUE, t);
            this.checkCast(Integer.MIN_VALUE, Integer.MIN_VALUE, t);
            this.checkCast(0x80000000L, Integer.MIN_VALUE, t);
            this.checkCast(-2147483649L, Integer.MAX_VALUE, t);
            this.checkCast(0x80000001L, -2147483647L, t);
        }
        for (CType t : Lists.newArrayList((Object[])new CSimpleType[]{U_INT, U_LONG_INT})) {
            this.checkCast(4L, 4L, t);
            this.checkCast(-4L, 0xFFFFFFFCL, t);
            this.checkCast(0x100000000L, 0L, t);
            this.checkCast(0x100000004L, 4L, t);
            this.checkCast(Integer.MAX_VALUE, Integer.MAX_VALUE, t);
            this.checkCast(0x80000001L, 0x80000001L, t);
            this.checkCast(Integer.MIN_VALUE, 0x80000000L, t);
            this.checkCast(-2147483649L, Integer.MAX_VALUE, t);
            this.checkCast(-1L, 0xFFFFFFFFL, t);
        }
    }

    @Test
    public void checkCasts64() throws Exception {
        TruthJUnit.assume().that((Comparable)((Object)this.machineModel)).named("MachineModel").isSameAs((Object)MachineModel.LINUX64);
        for (long i = Integer.MIN_VALUE; i < 0x100000000L; i += 10000000L) {
            this.checkCast(i, i < 0x80000000L ? i : -4294967296L + i, S_INT);
            this.checkCast(i, i < 0L ? 0x100000000L + i : i, U_INT);
            this.checkCast(i, i, S_LONG_INT);
            this.checkCast(i, i, U_LONG_INT);
            this.checkCast(i, i, S_LONG_LONG_INT);
            this.checkCast(i, i, U_LONG_LONG_INT);
        }
        this.checkCast(4L, 4L, S_INT);
        this.checkCast(-4L, -4L, S_INT);
        this.checkCast(0x100000000L, 0L, S_INT);
        this.checkCast(0x100000004L, 4L, S_INT);
        this.checkCast(Integer.MAX_VALUE, Integer.MAX_VALUE, S_INT);
        this.checkCast(Integer.MIN_VALUE, Integer.MIN_VALUE, S_INT);
        this.checkCast(0x80000000L, Integer.MIN_VALUE, S_INT);
        this.checkCast(-2147483649L, Integer.MAX_VALUE, S_INT);
        this.checkCast(0x80000001L, -2147483647L, S_INT);
        this.checkCast(4L, 4L, U_INT);
        this.checkCast(-4L, 0xFFFFFFFCL, U_INT);
        this.checkCast(0x100000000L, 0L, U_INT);
        this.checkCast(0x100000004L, 4L, U_INT);
        this.checkCast(Integer.MAX_VALUE, Integer.MAX_VALUE, U_INT);
        this.checkCast(0x80000001L, 0x80000001L, U_INT);
        this.checkCast(Integer.MIN_VALUE, 0x80000000L, U_INT);
        this.checkCast(-2147483649L, Integer.MAX_VALUE, U_INT);
        this.checkCast(-1L, 0xFFFFFFFFL, U_INT);
        this.checkCast(4L, 4L, S_LONG_INT);
        this.checkCast(-4L, -4L, S_LONG_INT);
        this.checkCast(0x80000001L, 0x80000001L, S_LONG_INT);
        this.checkCast(-2147483649L, -2147483649L, S_LONG_INT);
        this.checkCast(0x100000000L, 0x100000000L, S_LONG_INT);
        this.checkCast(0x100000004L, 0x100000004L, S_LONG_INT);
        this.checkCast(Long.MAX_VALUE, Long.MAX_VALUE, S_LONG_INT);
        this.checkCast(Long.MIN_VALUE, Long.MIN_VALUE, S_LONG_INT);
        this.checkCast(4L, 4L, U_LONG_INT);
        this.checkCast(0x80000001L, 0x80000001L, U_LONG_INT);
        this.checkCast(0x100000004L, 0x100000004L, U_LONG_INT);
        this.checkCast(-2147483626L, -2147483626L, U_LONG_INT);
    }

    private void checkCast(long in, long expectedOut, CType outType) throws UnrecognizedCCodeException {
        Value value = this.evv.evaluate(new CIntegerLiteralExpression(FileLocation.DUMMY, CNumericTypes.INT, BigInteger.valueOf(in)), outType);
        Truth.assertThat((Long)value.asLong(CNumericTypes.INT)).isEqualTo((Object)expectedOut);
    }
}

