/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteStatePath;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.DelegateAbstractDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.defaults.StopJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.StopNeverOperator;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.defaults.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithBAM;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithConcreteCex;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPAStatistics;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisPrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisReducer;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisTransferRelation;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisConcreteErrorPathAllocator;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

@Options(prefix="cpa.value")
public class ValueAnalysisCPA
implements ConfigurableProgramAnalysisWithBAM,
StatisticsProvider,
ProofChecker,
ConfigurableProgramAnalysisWithConcreteCex {
    @Option(secure=true, name="merge", toUppercase=true, values={"SEP", "JOIN"}, description="which merge operator to use for ValueAnalysisCPA")
    private String mergeType = "SEP";
    @Option(secure=true, name="stop", toUppercase=true, values={"SEP", "JOIN", "NEVER"}, description="which stop operator to use for ValueAnalysisCPA")
    private String stopType = "SEP";
    @Option(secure=true, description="get an initial precison from file")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private Path initialPrecisionFile = null;
    private AbstractDomain abstractDomain;
    private MergeOperator mergeOperator;
    private StopOperator stopOperator;
    private ValueAnalysisTransferRelation transferRelation;
    private VariableTrackingPrecision precision;
    private ValueAnalysisPrecisionAdjustment precisionAdjustment;
    private final ValueAnalysisReducer reducer;
    private final ValueAnalysisCPAStatistics statistics;
    private final Configuration config;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final CFA cfa;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(ValueAnalysisCPA.class);
    }

    private ValueAnalysisCPA(Configuration config, LogManager logger, ShutdownNotifier pShutdownNotifier, CFA cfa) throws InvalidConfigurationException {
        this.config = config;
        this.logger = logger;
        this.shutdownNotifier = pShutdownNotifier;
        this.cfa = cfa;
        config.inject((Object)this);
        this.abstractDomain = DelegateAbstractDomain.getInstance();
        this.transferRelation = new ValueAnalysisTransferRelation(config, logger, cfa);
        this.precision = this.initializePrecision(config, cfa);
        this.mergeOperator = this.initializeMergeOperator();
        this.stopOperator = this.initializeStopOperator();
        this.precisionAdjustment = new ValueAnalysisPrecisionAdjustment(config, cfa);
        this.reducer = new ValueAnalysisReducer();
        this.statistics = new ValueAnalysisCPAStatistics(this, config);
    }

    private MergeOperator initializeMergeOperator() {
        if (this.mergeType.equals("SEP")) {
            return MergeSepOperator.getInstance();
        }
        if (this.mergeType.equals("JOIN")) {
            return new MergeJoinOperator(this.abstractDomain);
        }
        return null;
    }

    private StopOperator initializeStopOperator() {
        if (this.stopType.equals("SEP")) {
            return new StopSepOperator(this.abstractDomain);
        }
        if (this.stopType.equals("JOIN")) {
            return new StopJoinOperator(this.abstractDomain);
        }
        if (this.stopType.equals("NEVER")) {
            return new StopNeverOperator();
        }
        return null;
    }

    private VariableTrackingPrecision initializePrecision(Configuration config, CFA cfa) throws InvalidConfigurationException {
        if (this.initialPrecisionFile == null) {
            return VariableTrackingPrecision.createStaticPrecision(config, cfa.getVarClassification(), this.getClass());
        }
        VariableTrackingPrecision precision = VariableTrackingPrecision.createRefineablePrecision(config, VariableTrackingPrecision.createStaticPrecision(config, cfa.getVarClassification(), this.getClass()));
        return precision.withIncrement(this.restoreMappingFromFile(cfa));
    }

    private Multimap<CFANode, ValueAnalysisState.MemoryLocation> restoreMappingFromFile(CFA cfa) throws InvalidConfigurationException {
        HashMultimap mapping = HashMultimap.create();
        ImmutableList contents = null;
        try {
            contents = this.initialPrecisionFile.asCharSource(Charset.defaultCharset()).readLines();
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not read precision from file named " + this.initialPrecisionFile);
            return mapping;
        }
        Map<Integer, CFANode> idToCfaNode = this.createMappingForCFANodes(cfa);
        Pattern CFA_NODE_PATTERN = Pattern.compile("N([0-9][0-9]*)");
        CFANode location = this.getDefaultLocation(idToCfaNode);
        for (String currentLine : contents) {
            if (currentLine.trim().isEmpty()) continue;
            if (currentLine.endsWith(":")) {
                String scopeSelectors = currentLine.substring(0, currentLine.indexOf(":"));
                Matcher matcher = CFA_NODE_PATTERN.matcher(scopeSelectors);
                if (!matcher.matches()) continue;
                location = idToCfaNode.get(Integer.parseInt(matcher.group(1)));
                continue;
            }
            mapping.put((Object)location, (Object)ValueAnalysisState.MemoryLocation.valueOf(currentLine));
        }
        return mapping;
    }

    private CFANode getDefaultLocation(Map<Integer, CFANode> idToCfaNode) {
        return idToCfaNode.values().iterator().next();
    }

    private Map<Integer, CFANode> createMappingForCFANodes(CFA cfa) {
        HashMap idToNodeMap = Maps.newHashMap();
        for (CFANode n : cfa.getAllNodes()) {
            idToNodeMap.put(n.getNodeNumber(), n);
        }
        return idToNodeMap;
    }

    public void injectRefinablePrecision() throws InvalidConfigurationException {
        if (this.initialPrecisionFile == null) {
            this.precision = VariableTrackingPrecision.createRefineablePrecision(this.config, this.precision);
        }
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public StopOperator getStopOperator() {
        return this.stopOperator;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        return new ValueAnalysisState();
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) {
        return this.precision;
    }

    VariableTrackingPrecision getPrecision() {
        return this.precision;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return this.precisionAdjustment;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public LogManager getLogger() {
        return this.logger;
    }

    public ShutdownNotifier getShutdownNotifier() {
        return this.shutdownNotifier;
    }

    public CFA getCFA() {
        return this.cfa;
    }

    @Override
    public Reducer getReducer() {
        return this.reducer;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.statistics);
        this.precisionAdjustment.collectStatistics(pStatsCollection);
    }

    public ValueAnalysisCPAStatistics getStats() {
        return this.statistics;
    }

    @Override
    public boolean areAbstractSuccessors(AbstractState pState, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors) throws CPATransferException, InterruptedException {
        try {
            Collection computedSuccessors = this.transferRelation.getAbstractSuccessorsForEdge(pState, SingletonPrecision.getInstance(), pCfaEdge);
            for (AbstractState comp : computedSuccessors) {
                boolean found = false;
                for (AbstractState abstractState : pSuccessors) {
                    if (!this.isCoveredBy(comp, abstractState)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        catch (CPAException e) {
            throw new CPATransferException("Cannot compare abstract successors", e);
        }
        return true;
    }

    @Override
    public boolean isCoveredBy(AbstractState pState, AbstractState pOtherState) throws CPAException, InterruptedException {
        return this.abstractDomain.isLessOrEqual(pState, pOtherState);
    }

    @Override
    public ConcreteStatePath createConcreteStatePath(ARGPath pPath) {
        ValueAnalysisConcreteErrorPathAllocator alloc = new ValueAnalysisConcreteErrorPathAllocator(this.logger, this.shutdownNotifier);
        return alloc.allocateAssignmentsToPath(pPath);
    }
}

