/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value;

import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.defaults.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.WrapperPrecision;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPA;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

@Options(prefix="cpa.value")
public class ValueAnalysisCPAStatistics
implements Statistics {
    @Option(secure=true, description="target file to hold the exported precision")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path precisionFile = null;
    private final ValueAnalysisCPA cpa;
    private Refiner refiner = null;

    public ValueAnalysisCPAStatistics(ValueAnalysisCPA cpa, Configuration config) throws InvalidConfigurationException {
        this.cpa = cpa;
        config.inject((Object)this, ValueAnalysisCPAStatistics.class);
    }

    @Override
    public String getName() {
        return "ValueAnalysisCPA";
    }

    public void addRefiner(Refiner refiner) {
        this.refiner = refiner;
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
        StatInt numberOfVariables = new StatInt(StatKind.COUNT, "Number of variables");
        StatInt numberOfGlobalVariables = new StatInt(StatKind.COUNT, "Number of global variables");
        for (AbstractState currentAbstractState : reached) {
            ValueAnalysisState currentState = AbstractStates.extractStateByType(currentAbstractState, ValueAnalysisState.class);
            numberOfVariables.setNextValue(currentState.getSize());
            numberOfGlobalVariables.setNextValue(currentState.getNumberOfGlobalVariables());
        }
        StatisticsWriter writer = StatisticsWriter.writingStatisticsTo(out);
        writer.put(numberOfVariables);
        writer.put(numberOfGlobalVariables);
        if (this.refiner != null && this.precisionFile != null) {
            this.exportPrecision(reached);
        }
    }

    private void exportPrecision(ReachedSet reached) {
        VariableTrackingPrecision consolidatedPrecision = this.getConsolidatedPrecision(reached);
        try (Writer writer = Files.openOutputFile((Path)this.precisionFile, (FileWriteMode[])new FileWriteMode[0]);){
            consolidatedPrecision.serialize(writer);
        }
        catch (IOException e) {
            this.cpa.getLogger().logUserException(Level.WARNING, (Throwable)e, "Could not write value-analysis precision to file");
        }
    }

    private VariableTrackingPrecision getConsolidatedPrecision(ReachedSet reached) {
        VariableTrackingPrecision joinedPrecision = null;
        for (Precision precision : reached.getPrecisions()) {
            if (!(precision instanceof WrapperPrecision)) continue;
            VariableTrackingPrecision prec = ((WrapperPrecision)precision).retrieveWrappedPrecision(VariableTrackingPrecision.class);
            if (joinedPrecision == null) {
                joinedPrecision = prec;
                continue;
            }
            joinedPrecision = joinedPrecision.join(prec);
        }
        return joinedPrecision;
    }
}

