/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.PrintStream;
import java.util.Collection;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.defaults.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.conditions.path.AssignmentsInPathCondition;
import org.sosy_lab.cpachecker.cpa.location.LocationState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.LiveVariables;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

@Options(prefix="cpa.value.blk")
public class ValueAnalysisPrecisionAdjustment
implements PrecisionAdjustment,
StatisticsProvider {
    @Option(secure=true, description="restrict abstractions to loop heads")
    private boolean alwaysAtLoops = false;
    @Option(secure=true, description="restrict abstractions to function calls/returns")
    private boolean alwaysAtFunctions = false;
    @Option(secure=true, description="restrict abstractions to assume edges")
    private boolean alwaysAtAssumes = false;
    @Option(secure=true, description="restrict abstractions to join points")
    private boolean alwaysAtJoins = false;
    @Option(secure=true, description="restrict liveness abstractions to nodes with more than one entering and/or leaving edge")
    private boolean onlyAtNonLinearCFA = false;
    private final ImmutableSet<CFANode> loopHeads;
    final StatCounter abstractions = new StatCounter("Number of abstraction computations");
    final StatTimer totalLiveness = new StatTimer("Total time for liveness abstraction");
    final StatTimer totalAbstraction = new StatTimer("Total time for abstraction computation");
    final StatTimer totalEnforcePath = new StatTimer("Total time for path thresholds");
    private final Statistics statistics;
    private final Optional<LiveVariables> liveVariables;

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.statistics);
    }

    public ValueAnalysisPrecisionAdjustment(Configuration pConfig, CFA pCfa) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.loopHeads = this.alwaysAtLoops && pCfa.getAllLoopHeads().isPresent() ? (ImmutableSet)pCfa.getAllLoopHeads().get() : null;
        this.statistics = new Statistics(){

            @Override
            public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, ReachedSet pReached) {
                StatisticsWriter writer = StatisticsWriter.writingStatisticsTo(pOut);
                writer.put(ValueAnalysisPrecisionAdjustment.this.abstractions);
                writer.put(ValueAnalysisPrecisionAdjustment.this.totalLiveness);
                writer.put(ValueAnalysisPrecisionAdjustment.this.totalAbstraction);
                writer.put(ValueAnalysisPrecisionAdjustment.this.totalEnforcePath);
            }

            @Override
            public String getName() {
                return ValueAnalysisPrecisionAdjustment.this.getClass().getSimpleName();
            }
        };
        this.liveVariables = pCfa.getLiveVariables();
    }

    @Override
    public PrecisionAdjustment.PrecisionAdjustmentResult prec(AbstractState pState, Precision pPrecision, UnmodifiableReachedSet pStates, AbstractState fullState) throws CPAException, InterruptedException {
        return this.prec((ValueAnalysisState)pState, (VariableTrackingPrecision)pPrecision, AbstractStates.extractStateByType(fullState, LocationState.class), AbstractStates.extractStateByType(fullState, AssignmentsInPathCondition.UniqueAssignmentsInPathConditionState.class));
    }

    private PrecisionAdjustment.PrecisionAdjustmentResult prec(ValueAnalysisState pState, VariableTrackingPrecision pPrecision, LocationState location, AssignmentsInPathCondition.UniqueAssignmentsInPathConditionState assignments) {
        ValueAnalysisState resultState = ValueAnalysisState.copyOf(pState);
        if (this.liveVariables.isPresent()) {
            this.totalLiveness.start();
            this.enforceLiveness(pState, location, resultState);
            this.totalLiveness.stop();
        }
        if (assignments == null) {
            this.totalAbstraction.start();
            this.enforcePrecision(resultState, location, pPrecision);
            this.totalAbstraction.stop();
        } else {
            this.totalEnforcePath.start();
            this.enforcePathThreshold(resultState, pPrecision, assignments, location.getLocationNode());
            this.totalEnforcePath.stop();
        }
        return PrecisionAdjustment.PrecisionAdjustmentResult.create(resultState, pPrecision, PrecisionAdjustment.Action.CONTINUE);
    }

    private void enforceLiveness(ValueAnalysisState pState, LocationState location, ValueAnalysisState resultState) {
        boolean hasMoreThanOneEnteringLeavingEdge;
        CFANode actNode = location.getLocationNode();
        boolean bl = hasMoreThanOneEnteringLeavingEdge = actNode.getNumEnteringEdges() > 1 || actNode.getNumLeavingEdges() > 1;
        if (!this.onlyAtNonLinearCFA || hasMoreThanOneEnteringLeavingEdge) {
            boolean onlyBlankEdgesEntering = true;
            for (int i = 0; i < actNode.getNumEnteringEdges() && onlyBlankEdgesEntering; ++i) {
                onlyBlankEdgesEntering = location.getLocationNode().getEnteringEdge(i) instanceof BlankEdge;
            }
            if (!onlyBlankEdgesEntering) {
                for (ValueAnalysisState.MemoryLocation variable : pState.getTrackedMemoryLocations()) {
                    if (((LiveVariables)this.liveVariables.get()).isVariableLive(variable.getAsSimpleString(), location.getLocationNode())) continue;
                    resultState.forget(variable);
                }
            }
        }
    }

    private void enforcePrecision(ValueAnalysisState state, LocationState location, VariableTrackingPrecision precision) {
        if (this.abstractAtEachLocation() || this.abstractAtAssumes(location) || this.abstractAtJoins(location) || this.abstractAtFunction(location) || this.abstractAtLoopHead(location)) {
            for (ValueAnalysisState.MemoryLocation memoryLocation : state.getTrackedMemoryLocations()) {
                if (precision.isTracking(memoryLocation, state.getTypeForMemoryLocation(memoryLocation), location.getLocationNode())) continue;
                state.forget(memoryLocation);
            }
            this.abstractions.inc();
        }
    }

    private boolean abstractAtEachLocation() {
        return !this.alwaysAtAssumes && !this.alwaysAtJoins && !this.alwaysAtFunctions && !this.alwaysAtLoops;
    }

    private boolean abstractAtAssumes(LocationState location) {
        return this.alwaysAtAssumes && location.getLocationNode().getEnteringEdge(0).getEdgeType() == CFAEdgeType.AssumeEdge;
    }

    private boolean abstractAtJoins(LocationState location) {
        return this.alwaysAtJoins && location.getLocationNode().getNumEnteringEdges() > 1;
    }

    private boolean abstractAtFunction(LocationState location) {
        return this.alwaysAtFunctions && (location.getLocationNode() instanceof FunctionEntryNode || location.getLocationNode().getEnteringSummaryEdge() != null);
    }

    private boolean abstractAtLoopHead(LocationState location) {
        Preconditions.checkState((!this.alwaysAtLoops || this.loopHeads != null ? 1 : 0) != 0);
        return this.alwaysAtLoops && this.loopHeads.contains((Object)location.getLocationNode());
    }

    private void enforcePathThreshold(ValueAnalysisState state, VariableTrackingPrecision precision, AssignmentsInPathCondition.UniqueAssignmentsInPathConditionState assignments, CFANode location) {
        for (ValueAnalysisState.MemoryLocation memoryLocation : state.getTrackedMemoryLocations()) {
            if (precision.isTracking(memoryLocation, state.getTypeForMemoryLocation(memoryLocation), location)) {
                assignments.updateAssignmentInformation(memoryLocation, state.getValueFor(memoryLocation));
                if (!assignments.exceedsHardThreshold(memoryLocation)) continue;
                state.forget(memoryLocation);
                continue;
            }
            if (assignments.wouldExceedSoftThreshold(state, memoryLocation)) {
                state.forget(memoryLocation);
                continue;
            }
            assignments.updateAssignmentInformation(memoryLocation, state.getValueFor(memoryLocation));
        }
    }
}

