/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value;

import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.blocks.Block;
import org.sosy_lab.cpachecker.cfa.blocks.ReferencedVariable;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Reducer;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;

public class ValueAnalysisReducer
implements Reducer {
    private boolean occursInBlock(Block pBlock, String pVar) {
        for (ReferencedVariable referencedVar : pBlock.getReferencedVariables()) {
            if (!referencedVar.getName().equals(pVar)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AbstractState getVariableReducedState(AbstractState pExpandedState, Block pContext, CFANode pCallNode) {
        ValueAnalysisState expandedState = (ValueAnalysisState)pExpandedState;
        ValueAnalysisState clonedElement = ValueAnalysisState.copyOf(expandedState);
        for (ValueAnalysisState.MemoryLocation trackedVar : expandedState.getTrackedMemoryLocations()) {
            String simpleName = trackedVar.getAsSimpleString();
            if (this.occursInBlock(pContext, simpleName)) continue;
            clonedElement.forget(trackedVar);
        }
        return clonedElement;
    }

    @Override
    public AbstractState getVariableExpandedState(AbstractState pRootState, Block pReducedContext, AbstractState pReducedState) {
        ValueAnalysisState rootState = (ValueAnalysisState)pRootState;
        ValueAnalysisState reducedState = (ValueAnalysisState)pReducedState;
        ValueAnalysisState diffElement = ValueAnalysisState.copyOf(reducedState);
        for (ValueAnalysisState.MemoryLocation trackedVar : rootState.getTrackedMemoryLocations()) {
            String simpleName = trackedVar.getAsSimpleString();
            if (this.occursInBlock(pReducedContext, simpleName)) continue;
            diffElement.assignConstant(trackedVar, rootState.getValueFor(trackedVar), rootState.getTypeForMemoryLocation(trackedVar));
        }
        return diffElement;
    }

    @Override
    public Precision getVariableReducedPrecision(Precision pPrecision, Block pContext) {
        VariableTrackingPrecision precision = (VariableTrackingPrecision)pPrecision;
        return precision;
    }

    @Override
    public Precision getVariableExpandedPrecision(Precision pRootPrecision, Block pRootContext, Precision pReducedPrecision) {
        VariableTrackingPrecision reducedPrecision = (VariableTrackingPrecision)pReducedPrecision;
        return reducedPrecision;
    }

    @Override
    public Object getHashCodeForState(AbstractState pElementKey, Precision pPrecisionKey) {
        ValueAnalysisState elementKey = (ValueAnalysisState)pElementKey;
        VariableTrackingPrecision precisionKey = (VariableTrackingPrecision)pPrecisionKey;
        return Pair.of(elementKey.getConstantsMap(), (Object)precisionKey);
    }

    @Override
    public int measurePrecisionDifference(Precision pPrecision, Precision pOtherPrecision) {
        return 0;
    }

    @Override
    public AbstractState getVariableReducedStateForProofChecking(AbstractState pExpandedState, Block pContext, CFANode pCallNode) {
        return this.getVariableReducedState(pExpandedState, pContext, pCallNode);
    }

    @Override
    public AbstractState getVariableExpandedStateForProofChecking(AbstractState pRootState, Block pReducedContext, AbstractState pReducedState) {
        return this.getVariableExpandedState(pRootState, pReducedContext, pReducedState);
    }

    @Override
    public AbstractState rebuildStateAfterFunctionCall(AbstractState pRootState, AbstractState entryState, AbstractState pExpandedState, CFANode exitLocation) {
        ValueAnalysisState rootState = (ValueAnalysisState)pRootState;
        ValueAnalysisState expandedState = (ValueAnalysisState)pExpandedState;
        return expandedState.rebuildStateAfterFunctionCall(rootState);
    }
}

