/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value;

import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cpa.smg.SMGExpressionEvaluator;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.SMGTransferRelation;
import org.sosy_lab.cpachecker.cpa.value.ExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.SymbolicValuesOption;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;

public class ValueAnalysisSMGCommunicator {
    private boolean symbolicValues = new SymbolicValuesOption().areSymbolicValuesEnabled();
    private final CFAEdge cfaEdge;
    private final LogManagerWithoutDuplicates logger;
    private final MachineModel machineModel;
    private final SMGState smgState;
    private final ValueAnalysisState valueAnalysisState;
    private final String functionName;

    public ValueAnalysisSMGCommunicator(ValueAnalysisState pValueAnalysisState, String pFunctionName, SMGState pSmgState, MachineModel pMachineModel, LogManagerWithoutDuplicates pLogger, CFAEdge pCfaEdge) {
        this.valueAnalysisState = pValueAnalysisState;
        this.smgState = pSmgState;
        this.machineModel = pMachineModel;
        this.logger = pLogger;
        this.cfaEdge = pCfaEdge;
        this.functionName = pFunctionName;
    }

    public Value evaluateExpression(CRightHandSide rValue) throws UnrecognizedCCodeException {
        ExplicitExpressionValueVisitor evv = new ExplicitExpressionValueVisitor();
        return rValue.accept(evv);
    }

    public SMGTransferRelation.SMGSymbolicValue evaluateSMGExpression(CRightHandSide rValue) throws CPATransferException {
        SMGExplicitExpressionEvaluator eee = new SMGExplicitExpressionEvaluator();
        return eee.evaluateExpressionValueV2(this.smgState, this.cfaEdge, rValue);
    }

    public SMGTransferRelation.SMGAddressValue evaluateSMGAddressExpression(CRightHandSide rValue) throws CPATransferException {
        SMGExplicitExpressionEvaluator eee = new SMGExplicitExpressionEvaluator();
        return eee.evaluateAddressV2(this.smgState, this.cfaEdge, rValue);
    }

    public ValueAnalysisState.MemoryLocation evaluateLeftHandSide(CExpression lValue) throws UnrecognizedCCodeException {
        ExplicitExpressionValueVisitor evv = new ExplicitExpressionValueVisitor();
        return evv.evaluateMemloc(lValue);
    }

    public SMGTransferRelation.SMGAddress evaluateSMGLeftHandSide(CExpression lValue) throws UnrecognizedCCodeException {
        ExplicitExpressionValueVisitor evv = new ExplicitExpressionValueVisitor();
        return evv.evaluateAddress(lValue);
    }

    private class SMGExplicitExpressionEvaluator
    extends SMGExpressionEvaluator {
        ExplicitExpressionValueVisitor evv;

        public SMGExplicitExpressionEvaluator(ExplicitExpressionValueVisitor pEvv) {
            super(ValueAnalysisSMGCommunicator.this.logger, ValueAnalysisSMGCommunicator.this.machineModel);
            this.evv = pEvv;
        }

        public SMGExplicitExpressionEvaluator() {
            super(ValueAnalysisSMGCommunicator.this.logger, ValueAnalysisSMGCommunicator.this.machineModel);
            this.evv = new ExplicitExpressionValueVisitor(this);
        }

        @Override
        public SMGTransferRelation.SMGExplicitValue evaluateExplicitValueV2(SMGState pSmgState, CFAEdge pCfaEdge, CRightHandSide pRValue) throws CPATransferException {
            Value value = pRValue.accept(this.evv);
            if (value.isExplicitlyKnown() && value.isNumericValue()) {
                return SMGTransferRelation.SMGKnownExpValue.valueOf(value.asNumericValue().longValue());
            }
            return SMGTransferRelation.SMGUnknownValue.getInstance();
        }
    }

    private class ExplicitExpressionValueVisitor
    extends ExpressionValueVisitor {
        private final SMGExplicitExpressionEvaluator smgEvaluator;

        public ExplicitExpressionValueVisitor() {
            super(ValueAnalysisSMGCommunicator.this.valueAnalysisState, ValueAnalysisSMGCommunicator.this.functionName, ValueAnalysisSMGCommunicator.this.machineModel, ValueAnalysisSMGCommunicator.this.logger, ValueAnalysisSMGCommunicator.this.symbolicValues);
            this.smgEvaluator = new SMGExplicitExpressionEvaluator(this);
        }

        public ExplicitExpressionValueVisitor(SMGExplicitExpressionEvaluator pSmgEvaluator) {
            super(ValueAnalysisSMGCommunicator.this.valueAnalysisState, ValueAnalysisSMGCommunicator.this.functionName, ValueAnalysisSMGCommunicator.this.machineModel, ValueAnalysisSMGCommunicator.this.logger, ValueAnalysisSMGCommunicator.this.symbolicValues);
            this.smgEvaluator = pSmgEvaluator;
        }

        public SMGTransferRelation.SMGAddress evaluateAddress(CExpression pOperand) throws UnrecognizedCCodeException {
            SMGTransferRelation.SMGAddress value;
            SMGExpressionEvaluator.LValueAssignmentVisitor visitor = this.smgEvaluator.getLValueAssignmentVisitor(ValueAnalysisSMGCommunicator.this.cfaEdge, ValueAnalysisSMGCommunicator.this.smgState);
            try {
                value = pOperand.accept(visitor).getAddress();
            }
            catch (CPATransferException e) {
                if (e instanceof UnrecognizedCCodeException) {
                    throw (UnrecognizedCCodeException)e;
                }
                ValueAnalysisSMGCommunicator.this.logger.logDebugException((Throwable)e);
                throw new UnrecognizedCCodeException("Could not evluate Address of " + pOperand.toASTString(), ValueAnalysisSMGCommunicator.this.cfaEdge, pOperand);
            }
            return value;
        }

        @Override
        public Value visit(CPointerExpression pPointerExpression) throws UnrecognizedCCodeException {
            ValueAnalysisState.MemoryLocation memloc = this.evaluateMemloc(pPointerExpression);
            return this.getValueFromLocation(memloc, pPointerExpression);
        }

        @Override
        public Value visit(CFieldReference pFieldReferenceExpression) throws UnrecognizedCCodeException {
            ValueAnalysisState.MemoryLocation memloc = this.evaluateMemloc(pFieldReferenceExpression);
            return this.getValueFromLocation(memloc, pFieldReferenceExpression);
        }

        @Override
        public Value visit(CBinaryExpression pE) throws UnrecognizedCCodeException {
            Value result = super.visit(pE);
            if (!result.isUnknown()) {
                return result;
            }
            CExpression op1 = pE.getOperand1();
            CExpression op2 = pE.getOperand2();
            if (!(op1.getExpressionType().getCanonicalType() instanceof CPointerType)) {
                return Value.UnknownValue.getInstance();
            }
            if (!(op2.getExpressionType().getCanonicalType() instanceof CPointerType)) {
                return Value.UnknownValue.getInstance();
            }
            try {
                SMGTransferRelation.SMGAddressValue op1Value = ValueAnalysisSMGCommunicator.this.evaluateSMGAddressExpression(op1);
                SMGTransferRelation.SMGAddressValue op2Value = ValueAnalysisSMGCommunicator.this.evaluateSMGAddressExpression(op2);
                if (op1Value.isUnknown() || op2Value.isUnknown()) {
                    return Value.UnknownValue.getInstance();
                }
                if (op1Value.getOffset().isUnknown() || op2Value.getOffset().isUnknown()) {
                    return Value.UnknownValue.getInstance();
                }
                long op1Offset = op1Value.getOffset().getAsLong();
                long op2Offset = op2Value.getOffset().getAsLong();
                switch (pE.getOperator()) {
                    case EQUALS: {
                        return this.booleanAsLong(op1Value.getObject().equals(op2Value.getObject()) && op1Offset == op2Offset);
                    }
                    case NOT_EQUALS: {
                        return this.booleanAsLong(!op1Value.getObject().equals(op2Value.getObject()) || op1Offset != op2Offset);
                    }
                    case GREATER_EQUAL: 
                    case GREATER_THAN: 
                    case LESS_EQUAL: 
                    case LESS_THAN: {
                        if (!op1Value.getObject().equals(op2Value.getObject())) {
                            return Value.UnknownValue.getInstance();
                        }
                        switch (pE.getOperator()) {
                            case GREATER_EQUAL: {
                                return this.booleanAsLong(op1Offset >= op2Offset);
                            }
                            case GREATER_THAN: {
                                return this.booleanAsLong(op1Offset > op2Offset);
                            }
                            case LESS_EQUAL: {
                                return this.booleanAsLong(op1Offset <= op2Offset);
                            }
                            case LESS_THAN: {
                                return this.booleanAsLong(op1Offset < op2Offset);
                            }
                        }
                        throw new AssertionError();
                    }
                }
                return Value.UnknownValue.getInstance();
            }
            catch (CPATransferException e) {
                UnrecognizedCCodeException e2 = new UnrecognizedCCodeException("Could not symbolically evaluate expression", pE);
                e2.initCause(e);
                throw e2;
            }
        }

        private Value booleanAsLong(boolean b) {
            return b ? new NumericValue(1L) : new NumericValue(0L);
        }

        @Override
        public Value visit(CArraySubscriptExpression pE) throws UnrecognizedCCodeException {
            ValueAnalysisState.MemoryLocation memloc = this.evaluateMemloc(pE);
            return this.getValueFromLocation(memloc, pE);
        }

        private Value getValueFromLocation(ValueAnalysisState.MemoryLocation pMemloc, CExpression rValue) throws UnrecognizedCCodeException {
            SMGTransferRelation.SMGSymbolicValue value;
            if (pMemloc == null) {
                return Value.UnknownValue.getInstance();
            }
            ValueAnalysisState explState = this.getState();
            if (explState.contains(pMemloc)) {
                return explState.getValueFor(pMemloc);
            }
            try {
                value = this.smgEvaluator.evaluateExpressionValueV2(ValueAnalysisSMGCommunicator.this.smgState, ValueAnalysisSMGCommunicator.this.cfaEdge, rValue);
            }
            catch (CPATransferException e) {
                ValueAnalysisSMGCommunicator.this.logger.logDebugException((Throwable)e);
                throw new UnrecognizedCCodeException("Rvalue Could not be evaluated by smgEvaluator", ValueAnalysisSMGCommunicator.this.cfaEdge, rValue);
            }
            if (value.isUnknown() || value.getAsInt() != 0) {
                return Value.UnknownValue.getInstance();
            }
            return new NumericValue(0L);
        }

        public ValueAnalysisState.MemoryLocation evaluateMemloc(CExpression pOperand) throws UnrecognizedCCodeException {
            SMGTransferRelation.SMGAddress value = this.evaluateAddress(pOperand);
            if (value == null || value.isUnknown()) {
                return null;
            }
            return ValueAnalysisSMGCommunicator.this.smgState.resolveMemLoc(value, this.getFunctionName());
        }
    }
}

