/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Longs;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.core.interfaces.FormulaReportingState;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisInterpolant;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.util.predicates.interfaces.BooleanFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.NumeralFormula;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.interfaces.view.NumeralFormulaManagerView;

public class ValueAnalysisState
implements AbstractQueryableState,
FormulaReportingState,
Serializable,
Graphable,
LatticeAbstractState<ValueAnalysisState> {
    private static final long serialVersionUID = -3152134511524554357L;
    private static final Set<MemoryLocation> blacklist = new HashSet<MemoryLocation>();
    private PersistentMap<MemoryLocation, Value> constantsMap;
    private transient PersistentMap<MemoryLocation, Type> memLocToType = PathCopyingPersistentTreeMap.of();

    static void addToBlacklist(MemoryLocation var) {
        blacklist.add((MemoryLocation)Preconditions.checkNotNull((Object)var));
    }

    public ValueAnalysisState() {
        this.constantsMap = PathCopyingPersistentTreeMap.of();
    }

    public ValueAnalysisState(PersistentMap<MemoryLocation, Value> pConstantsMap, PersistentMap<MemoryLocation, Type> pLocToTypeMap) {
        this.constantsMap = pConstantsMap;
        this.memLocToType = pLocToTypeMap;
    }

    public static ValueAnalysisState copyOf(ValueAnalysisState state) {
        return new ValueAnalysisState(state.constantsMap, state.memLocToType);
    }

    void assignConstant(String variableName, Value value) {
        if (blacklist.contains(MemoryLocation.valueOf(variableName))) {
            return;
        }
        this.constantsMap = this.constantsMap.putAndCopy((Object)MemoryLocation.valueOf(variableName), Preconditions.checkNotNull((Object)value));
    }

    public void assignConstant(MemoryLocation pMemoryLocation, Value value, Type pType) {
        if (blacklist.contains(pMemoryLocation)) {
            return;
        }
        this.constantsMap = this.constantsMap.putAndCopy((Object)pMemoryLocation, Preconditions.checkNotNull((Object)value));
        this.memLocToType = this.memLocToType.putAndCopy((Object)pMemoryLocation, (Object)pType);
    }

    public Pair<Value, Type> forget(String variableName) {
        return this.forget(MemoryLocation.valueOf(variableName));
    }

    public Pair<Value, Type> forget(MemoryLocation pMemoryLocation) {
        Value value = (Value)this.constantsMap.get((Object)pMemoryLocation);
        Type type = (Type)this.memLocToType.get((Object)pMemoryLocation);
        this.constantsMap = this.constantsMap.removeAndCopy((Object)pMemoryLocation);
        this.memLocToType = this.memLocToType.removeAndCopy((Object)pMemoryLocation);
        return Pair.of((Object)value, (Object)type);
    }

    public void retainAll(Set<MemoryLocation> toRetain) {
        HashSet<MemoryLocation> toRemove = new HashSet<MemoryLocation>();
        for (MemoryLocation memoryLocation : this.constantsMap.keySet()) {
            if (toRetain.contains(memoryLocation)) continue;
            toRemove.add(memoryLocation);
        }
        for (MemoryLocation memoryLocation : toRemove) {
            this.forget(memoryLocation);
        }
    }

    void dropFrame(String functionName) {
        for (MemoryLocation variableName : this.constantsMap.keySet()) {
            if (!variableName.isOnFunctionStack(functionName)) continue;
            this.constantsMap = this.constantsMap.removeAndCopy((Object)variableName);
            this.memLocToType = this.memLocToType.removeAndCopy((Object)variableName);
        }
    }

    public Value getValueFor(String variableName) {
        return this.getValueFor(MemoryLocation.valueOf(variableName));
    }

    public Value getValueFor(MemoryLocation variableName) {
        return (Value)Preconditions.checkNotNull((Object)this.constantsMap.get((Object)variableName));
    }

    public Type getTypeForMemoryLocation(MemoryLocation loc) {
        return (Type)this.memLocToType.get((Object)loc);
    }

    public boolean contains(String variableName) {
        return this.contains(MemoryLocation.valueOf(variableName));
    }

    public boolean contains(MemoryLocation pMemoryLocation) {
        return this.constantsMap.containsKey((Object)pMemoryLocation);
    }

    public int getSize() {
        return this.constantsMap.size();
    }

    int getNumberOfGlobalVariables() {
        int numberOfGlobalVariables = 0;
        for (MemoryLocation variableName : this.constantsMap.keySet()) {
            if (variableName.isOnFunctionStack()) continue;
            ++numberOfGlobalVariables;
        }
        return numberOfGlobalVariables;
    }

    @Override
    public ValueAnalysisState join(ValueAnalysisState reachedState) {
        PersistentSortedMap newConstantsMap = PathCopyingPersistentTreeMap.of();
        PersistentSortedMap newlocToTypeMap = PathCopyingPersistentTreeMap.of();
        for (Map.Entry otherEntry : reachedState.constantsMap.entrySet()) {
            MemoryLocation key = (MemoryLocation)otherEntry.getKey();
            if (!Objects.equals(otherEntry.getValue(), this.constantsMap.get((Object)key))) continue;
            newConstantsMap = newConstantsMap.putAndCopy((Object)key, otherEntry.getValue());
            newlocToTypeMap = newlocToTypeMap.putAndCopy((Object)key, this.memLocToType.get((Object)key));
        }
        if (newConstantsMap.size() == reachedState.constantsMap.size()) {
            return reachedState;
        }
        return new ValueAnalysisState((PersistentMap<MemoryLocation, Value>)newConstantsMap, (PersistentMap<MemoryLocation, Type>)newlocToTypeMap);
    }

    @Override
    public boolean isLessOrEqual(ValueAnalysisState other) {
        if (this.constantsMap.size() < other.constantsMap.size()) {
            return false;
        }
        for (Map.Entry otherEntry : other.constantsMap.entrySet()) {
            MemoryLocation key = (MemoryLocation)otherEntry.getKey();
            if (((Value)otherEntry.getValue()).equals(this.constantsMap.get((Object)key))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        ValueAnalysisState otherElement = (ValueAnalysisState)other;
        return otherElement.constantsMap.equals(this.constantsMap) && Objects.equals(this.memLocToType, otherElement.memLocToType);
    }

    public int hashCode() {
        return this.constantsMap.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Map.Entry entry : this.constantsMap.entrySet()) {
            MemoryLocation key = (MemoryLocation)entry.getKey();
            sb.append(" <");
            sb.append(key.getAsSimpleString());
            sb.append(" = ");
            sb.append(entry.getValue());
            sb.append(">\n");
        }
        return sb.append("] size->  ").append(this.constantsMap.size()).toString();
    }

    @Override
    public String toDOTLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Joiner.on((String)", ").withKeyValueSeparator("=").appendTo(sb, this.constantsMap);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean shouldBeHighlighted() {
        return false;
    }

    @Override
    public Object evaluateProperty(String pProperty) throws InvalidQueryException {
        if ((pProperty = pProperty.trim()).startsWith("contains(")) {
            String varName = pProperty.substring("contains(".length(), pProperty.length() - 1);
            return this.constantsMap.containsKey((Object)MemoryLocation.valueOf(varName));
        }
        String[] parts = pProperty.split("==");
        if (parts.length != 2) {
            Value value = (Value)this.constantsMap.get((Object)MemoryLocation.valueOf(pProperty));
            if (value != null && value.isExplicitlyKnown()) {
                return value;
            }
            throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. Could not find the variable \"" + pProperty + "\"");
        }
        return this.checkProperty(pProperty);
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        String[] parts = pProperty.split("==");
        if (parts.length != 2) {
            throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. Could not split the property string correctly.");
        }
        Value val = (Value)this.constantsMap.get((Object)MemoryLocation.valueOf(parts[0]));
        if (val == null) {
            return false;
        }
        Long value = val.asLong(CNumericTypes.INT);
        if (value == null) {
            return false;
        }
        try {
            return value == Long.parseLong(parts[1]);
        }
        catch (NumberFormatException e) {
            throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. Could not parse the long \"" + parts[1] + "\"");
        }
    }

    private static boolean startsWithIgnoreCase(String s, String prefix) {
        s = s.substring(0, prefix.length());
        return s.equalsIgnoreCase(prefix);
    }

    @Override
    public void modifyProperty(String pModification) throws InvalidQueryException {
        String[] statements;
        Preconditions.checkNotNull((Object)pModification);
        for (String statement : statements = pModification.split(";")) {
            if (ValueAnalysisState.startsWithIgnoreCase(statement = statement.trim(), "deletevalues(")) {
                if (!statement.endsWith(")")) {
                    throw new InvalidQueryException(statement + " should end with \")\"");
                }
                String varName = statement.substring("deletevalues(".length(), statement.length() - 1);
                if (!this.contains(varName)) continue;
                this.forget(varName);
                continue;
            }
            if (!ValueAnalysisState.startsWithIgnoreCase(statement, "setvalue(")) continue;
            if (!statement.endsWith(")")) {
                throw new InvalidQueryException(statement + " should end with \")\"");
            }
            String assignment = statement.substring("setvalue(".length(), statement.length() - 1);
            String[] assignmentParts = assignment.split(":=");
            if (assignmentParts.length != 2) {
                throw new InvalidQueryException("The Query \"" + pModification + "\" is invalid. Could not split the property string correctly.");
            }
            String varName = assignmentParts[0].trim();
            try {
                NumericValue newValue = new NumericValue(Long.parseLong(assignmentParts[1].trim()));
                this.assignConstant(varName, newValue);
            }
            catch (NumberFormatException e) {
                throw new InvalidQueryException("The Query \"" + pModification + "\" is invalid. Could not parse the long \"" + assignmentParts[1].trim() + "\"");
            }
        }
    }

    @Override
    public String getCPAName() {
        return "ValueAnalysis";
    }

    @Override
    public BooleanFormula getFormulaApproximation(FormulaManagerView manager) {
        BooleanFormulaManagerView bfmgr = manager.getBooleanFormulaManager();
        NumeralFormulaManagerView<NumeralFormula, NumeralFormula.RationalFormula> nfmgr = manager.getRationalFormulaManager();
        BooleanFormula formula = bfmgr.makeBoolean(true);
        for (Map.Entry entry : this.constantsMap.entrySet()) {
            NumeralFormula.RationalFormula var = (NumeralFormula.RationalFormula)nfmgr.makeVariable(((MemoryLocation)entry.getKey()).getAsSimpleString());
            NumeralFormula.RationalFormula val = (NumeralFormula.RationalFormula)nfmgr.makeNumber(((Value)entry.getValue()).asLong(CNumericTypes.INT));
            formula = bfmgr.and(formula, nfmgr.equal(var, val));
        }
        return formula;
    }

    public Set<MemoryLocation> getDifference(ValueAnalysisState other) {
        HashSet<MemoryLocation> difference = new HashSet<MemoryLocation>();
        for (MemoryLocation variableName : other.constantsMap.keySet()) {
            if (!this.contains(variableName)) {
                difference.add(variableName);
                continue;
            }
            if (this.getValueFor(variableName).equals(other.getValueFor(variableName))) continue;
            difference.add(variableName);
        }
        return difference;
    }

    public Multimap<String, Value> addToValueMapping(Multimap<String, Value> valueMapping) {
        for (Map.Entry entry : this.constantsMap.entrySet()) {
            valueMapping.put((Object)((MemoryLocation)entry.getKey()).getAsSimpleString(), entry.getValue());
        }
        return valueMapping;
    }

    public Set<String> getTrackedVariableNames() {
        HashSet<String> result = new HashSet<String>();
        for (MemoryLocation loc : this.constantsMap.keySet()) {
            result.add(loc.getAsSimpleString());
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<MemoryLocation> getTrackedMemoryLocations() {
        return this.constantsMap.keySet();
    }

    Map<MemoryLocation, Value> getConstantsMap() {
        return this.constantsMap;
    }

    public Map<MemoryLocation, Value> getConstantsMapView() {
        return Collections.unmodifiableMap(this.constantsMap);
    }

    public ValueAnalysisInterpolant createInterpolant() {
        return new ValueAnalysisInterpolant(new HashMap<MemoryLocation, Value>((Map<MemoryLocation, Value>)this.constantsMap), new HashMap<MemoryLocation, Type>((Map<MemoryLocation, Type>)this.memLocToType));
    }

    public Set<MemoryLocation> getMemoryLocationsOnStack(String pFunctionName) {
        HashSet<MemoryLocation> result = new HashSet<MemoryLocation>();
        Set memoryLocations = this.constantsMap.keySet();
        for (MemoryLocation memoryLocation : memoryLocations) {
            if (!memoryLocation.isOnFunctionStack() || !memoryLocation.getFunctionName().equals(pFunctionName)) continue;
            result.add(memoryLocation);
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<MemoryLocation> getGlobalMemoryLocations() {
        HashSet<MemoryLocation> result = new HashSet<MemoryLocation>();
        Set memoryLocations = this.constantsMap.keySet();
        for (MemoryLocation memoryLocation : memoryLocations) {
            if (memoryLocation.isOnFunctionStack()) continue;
            result.add(memoryLocation);
        }
        return Collections.unmodifiableSet(result);
    }

    public void forgetValuesWithIdentifier(String pIdentifier) {
        for (MemoryLocation memoryLocation : this.constantsMap.keySet()) {
            if (!memoryLocation.getIdentifier().equals(pIdentifier)) continue;
            this.constantsMap = this.constantsMap.removeAndCopy((Object)memoryLocation);
            this.memLocToType = this.memLocToType.removeAndCopy((Object)memoryLocation);
        }
    }

    public ValueAnalysisState rebuildStateAfterFunctionCall(ValueAnalysisState callState) {
        ValueAnalysisState rebuildState = ValueAnalysisState.copyOf(callState);
        for (MemoryLocation trackedVar : callState.getTrackedMemoryLocations()) {
            if (trackedVar.isOnFunctionStack()) continue;
            rebuildState.forget(trackedVar);
        }
        for (MemoryLocation trackedVar : this.getTrackedMemoryLocations()) {
            if (!trackedVar.isOnFunctionStack()) {
                rebuildState.assignConstant(trackedVar, this.getValueFor(trackedVar), this.getTypeForMemoryLocation(trackedVar));
                continue;
            }
            if (!"__retval__".equals(trackedVar.getIdentifier())) continue;
            assert (!rebuildState.contains(trackedVar)) : "calling function should not contain return-variable of called function: " + trackedVar;
            if (!this.contains(trackedVar)) continue;
            rebuildState.assignConstant(trackedVar, this.getValueFor(trackedVar), this.getTypeForMemoryLocation(trackedVar));
        }
        return rebuildState;
    }

    private void readObject(ObjectInputStream in) throws IOException {
        try {
            in.defaultReadObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("", e);
        }
        this.memLocToType = PathCopyingPersistentTreeMap.of();
    }

    public static class MemoryLocation
    implements Comparable<MemoryLocation>,
    Serializable {
        private static final long serialVersionUID = -8910967707373729034L;
        private final String functionName;
        private final String identifier;
        private final long offset;
        public static final Function<String, MemoryLocation> FROM_STRING_TO_MEMORYLOCATION = new Function<String, MemoryLocation>(){

            public MemoryLocation apply(String variableName) {
                return MemoryLocation.valueOf(variableName);
            }
        };
        public static final Function<MemoryLocation, String> FROM_MEMORYLOCATION_TO_STRING = new Function<MemoryLocation, String>(){

            public String apply(MemoryLocation memoryLocation) {
                return memoryLocation.getAsSimpleString();
            }
        };

        private MemoryLocation(String pFunctionName, String pIdentifier, long pOffset) {
            Preconditions.checkNotNull((Object)pFunctionName);
            Preconditions.checkNotNull((Object)pIdentifier);
            this.functionName = pFunctionName;
            this.identifier = pIdentifier;
            this.offset = pOffset;
        }

        private MemoryLocation(String pIdentifier, long pOffset) {
            Preconditions.checkNotNull((Object)pIdentifier);
            this.functionName = null;
            this.identifier = pIdentifier;
            this.offset = pOffset;
        }

        public static MemoryLocation valueOf(String pFunctionName, String pIdentifier, long pOffest) {
            return new MemoryLocation(pFunctionName, pIdentifier, pOffest);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MemoryLocation)) {
                return false;
            }
            MemoryLocation otherLocation = (MemoryLocation)other;
            return Objects.equals(this.functionName, otherLocation.functionName) && Objects.equals(this.identifier, otherLocation.identifier) && this.offset == otherLocation.offset;
        }

        public int hashCode() {
            int hc = 17;
            int hashMultiplier = 59;
            hc = hc * hashMultiplier + Objects.hashCode(this.functionName);
            hc = hc * hashMultiplier + this.identifier.hashCode();
            hc = hc * hashMultiplier + Longs.hashCode((long)this.offset);
            return hc;
        }

        public static MemoryLocation valueOf(String pIdentifier, long pOffest) {
            return new MemoryLocation(pIdentifier, pOffest);
        }

        public static MemoryLocation valueOf(String pVariableName) {
            int offset;
            String[] nameParts = pVariableName.split("::");
            String[] offsetParts = pVariableName.split("/");
            boolean isScoped = nameParts.length == 2;
            boolean hasOffset = offsetParts.length == 2;
            int n = offset = hasOffset ? Integer.parseInt(offsetParts[1]) : 0;
            if (isScoped) {
                return new MemoryLocation(nameParts[0], nameParts[1].replace("/" + offset, ""), offset);
            }
            return new MemoryLocation(nameParts[0].replace("/" + offset, ""), offset);
        }

        public String getAsSimpleString() {
            return this.isOnFunctionStack() ? this.functionName + "::" + this.identifier : this.identifier;
        }

        public String serialize() {
            String simpleName = this.identifier + "/" + this.offset;
            return this.isOnFunctionStack() ? this.functionName + "::" + simpleName : simpleName;
        }

        public boolean isOnFunctionStack() {
            return this.functionName != null;
        }

        public boolean isOnFunctionStack(String pFunctionName) {
            return this.functionName != null && pFunctionName.equals(this.functionName);
        }

        public String getFunctionName() {
            return (String)Preconditions.checkNotNull((Object)this.functionName);
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public long getOffset() {
            return this.offset;
        }

        public String toString() {
            return this.getAsSimpleString();
        }

        public static PersistentMap<MemoryLocation, Long> transform(PersistentMap<String, Long> pConstantMap) {
            PersistentSortedMap result = PathCopyingPersistentTreeMap.of();
            for (Map.Entry entry : pConstantMap.entrySet()) {
                result = result.putAndCopy((Object)MemoryLocation.valueOf((String)entry.getKey()), Preconditions.checkNotNull(entry.getValue()));
            }
            return result;
        }

        @Override
        public int compareTo(MemoryLocation other) {
            int result = 0;
            result = this.isOnFunctionStack() ? (other.isOnFunctionStack() ? this.functionName.compareTo(other.functionName) : 1) : (other.isOnFunctionStack() ? -1 : 0);
            if (result != 0) {
                return result;
            }
            return ComparisonChain.start().compare((Comparable)((Object)this.identifier), (Comparable)((Object)other.identifier)).compare(this.offset, other.offset).result();
        }
    }
}

