/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.AAssignment;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.AInitializer;
import org.sosy_lab.cpachecker.cfa.ast.AInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.ALeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.AParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.APointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.ARightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.java.JArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.java.JSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.java.JArrayType;
import org.sosy_lab.cpachecker.cfa.types.java.JBasicType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;
import org.sosy_lab.cpachecker.core.defaults.ForwardingTransferRelation;
import org.sosy_lab.cpachecker.core.defaults.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.rtt.NameProvider;
import org.sosy_lab.cpachecker.cpa.rtt.RTTState;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.SMGTransferRelation;
import org.sosy_lab.cpachecker.cpa.value.ExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.SymbolicValuesOption;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisSMGCommunicator;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.type.ArrayValue;
import org.sosy_lab.cpachecker.cpa.value.type.BooleanValue;
import org.sosy_lab.cpachecker.cpa.value.type.EnumConstantValue;
import org.sosy_lab.cpachecker.cpa.value.type.NullValue;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.SymbolicValueFormula;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.cpa.value.type.symbolic.SymbolicValueFactory;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCCodeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCCodeException;
import org.sosy_lab.cpachecker.util.VariableClassification;

@Options(prefix="cpa.value")
public class ValueAnalysisTransferRelation
extends ForwardingTransferRelation<ValueAnalysisState, ValueAnalysisState, VariableTrackingPrecision> {
    private static final Map<String, String> UNSUPPORTED_FUNCTIONS = ImmutableMap.of((Object)"pthread_create", (Object)"threads");
    private boolean symbolicValues = new SymbolicValuesOption().areSymbolicValuesEnabled();
    @Option(secure=true, description="if there is an assumption like (x!=0), this option sets unknown (uninitialized) variables to 1L, when the true-branch is handled.")
    private boolean initAssumptionVars = false;
    @Option(secure=true, description="Process the Automaton ASSUMEs as if they were statements, not as if they were assumptions.")
    private boolean automatonAssumesAsStatements = false;
    @Option(secure=true, description="Assume that variables used only in a boolean context are either zero or one.")
    private boolean optimizeBooleanVariables = true;
    @Option(secure=true, description="Track Java array values in explicit value analysis. This may be costly if the verified program uses big or lots of arrays. Arrays in C programs will always be tracked, even if this value is false.")
    private boolean trackJavaArrayValues = true;
    private final Set<String> javaNonStaticVariables = new HashSet<String>();
    private JRightHandSide missingInformationRightJExpression = null;
    private String missingInformationLeftJVariable = null;
    private boolean missingFieldVariableObject;
    private Pair<String, Value> fieldNameAndInitialValue;
    private boolean missingScopedFieldName;
    private JIdExpression notScopedField;
    private Value notScopedFieldValue;
    private boolean missingAssumeInformation;
    private List<MissingInformation> missingInformationList;
    private ValueAnalysisState oldState;
    private final MachineModel machineModel;
    private final LogManagerWithoutDuplicates logger;
    private final Collection<String> addressedVariables;
    private final Collection<String> booleanVariables;

    public ValueAnalysisTransferRelation(Configuration config, LogManager pLogger, CFA pCfa) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.machineModel = pCfa.getMachineModel();
        this.logger = new LogManagerWithoutDuplicates(pLogger);
        if (pCfa.getVarClassification().isPresent()) {
            this.addressedVariables = ((VariableClassification)pCfa.getVarClassification().get()).getAddressedVariables();
            this.booleanVariables = ((VariableClassification)pCfa.getVarClassification().get()).getIntBoolVars();
        } else {
            this.addressedVariables = ImmutableSet.of();
            this.booleanVariables = ImmutableSet.of();
        }
    }

    @Override
    protected Collection<ValueAnalysisState> postProcessing(ValueAnalysisState successor) {
        if (successor != null) {
            successor = ValueAnalysisState.copyOf(successor);
        }
        return super.postProcessing(successor);
    }

    @Override
    protected void setInfo(AbstractState pAbstractState, Precision pAbstractPrecision, CFAEdge pCfaEdge) {
        super.setInfo(pAbstractState, pAbstractPrecision, pCfaEdge);
        this.missingInformationList = new ArrayList<MissingInformation>(5);
        this.oldState = ValueAnalysisState.copyOf((ValueAnalysisState)pAbstractState);
    }

    @Override
    protected ValueAnalysisState handleMultiEdge(MultiEdge cfaEdge) throws CPATransferException {
        ValueAnalysisState backup = (ValueAnalysisState)this.state;
        for (CFAEdge edge : cfaEdge) {
            this.state = (AbstractState)this.handleSimpleEdge(edge);
        }
        ValueAnalysisState successor = (ValueAnalysisState)this.state;
        this.state = backup;
        return successor;
    }

    @Override
    protected ValueAnalysisState handleFunctionCallEdge(FunctionCallEdge callEdge, List<? extends AExpression> arguments, List<? extends AParameterDeclaration> parameters, String calledFunctionName) throws UnrecognizedCCodeException {
        ValueAnalysisState newElement = ValueAnalysisState.copyOf((ValueAnalysisState)this.state);
        assert (parameters.size() == arguments.size() || callEdge.getSuccessor().getFunctionDefinition().getType().takesVarArgs());
        ExpressionValueVisitor visitor = this.getVisitor();
        for (int i = 0; i < parameters.size(); ++i) {
            Value value;
            AExpression exp = arguments.get(i);
            if (exp instanceof JExpression) {
                value = ((JExpression)exp).accept(visitor);
            } else if (exp instanceof CExpression) {
                value = visitor.evaluate((CExpression)exp, (CType)parameters.get(i).getType());
            } else {
                throw new AssertionError((Object)("Unknown expression: " + exp));
            }
            String paramName = parameters.get(i).getName();
            ValueAnalysisState.MemoryLocation formalParamName = ValueAnalysisState.MemoryLocation.valueOf(calledFunctionName, paramName, 0L);
            if (value.isUnknown()) {
                newElement.forget(formalParamName);
                if (this.isMissingCExpressionInformation(visitor, exp)) {
                    this.addMissingInformation(formalParamName, exp);
                }
            } else {
                newElement.assignConstant(formalParamName, value, parameters.get(i).getType());
            }
            visitor.reset();
        }
        return newElement;
    }

    @Override
    protected ValueAnalysisState handleBlankEdge(BlankEdge cfaEdge) {
        if (cfaEdge.getSuccessor() instanceof FunctionExitNode) {
            assert ("default return".equals(cfaEdge.getDescription()) || "skipped unnecessary edges".equals(cfaEdge.getDescription()));
            this.state = ValueAnalysisState.copyOf((ValueAnalysisState)this.state);
            ((ValueAnalysisState)this.state).dropFrame(this.functionName);
        }
        return (ValueAnalysisState)this.state;
    }

    @Override
    protected ValueAnalysisState handleReturnStatementEdge(AReturnStatementEdge returnEdge) throws UnrecognizedCCodeException {
        ExpressionValueVisitor evv = new ExpressionValueVisitor((ValueAnalysisState)this.state, this.functionName, this.machineModel, this.logger, this.symbolicValues);
        this.state = ValueAnalysisState.copyOf((ValueAnalysisState)this.state);
        ((ValueAnalysisState)this.state).dropFrame(this.functionName);
        AExpression expression = (AExpression)returnEdge.getExpression().orNull();
        if (expression == null && returnEdge instanceof CReturnStatementEdge) {
            expression = CIntegerLiteralExpression.ZERO;
        }
        FunctionEntryNode functionEntryNode = returnEdge.getSuccessor().getEntryNode();
        ValueAnalysisState.MemoryLocation functionReturnVar = null;
        if (functionEntryNode.getReturnVariable().isPresent()) {
            functionReturnVar = ValueAnalysisState.MemoryLocation.valueOf(((AVariableDeclaration)functionEntryNode.getReturnVariable().get()).getQualifiedName());
        }
        if (expression != null && functionReturnVar != null) {
            return this.handleAssignmentToVariable(functionReturnVar, functionEntryNode.getFunctionDefinition().getType().getReturnType(), expression, evv);
        }
        return (ValueAnalysisState)this.state;
    }

    @Override
    protected ValueAnalysisState handleFunctionReturnEdge(FunctionReturnEdge functionReturnEdge, FunctionSummaryEdge summaryEdge, AFunctionCall exprOnSummary, String callerFunctionName) throws UnrecognizedCodeException {
        ValueAnalysisState newElement = ValueAnalysisState.copyOf((ValueAnalysisState)this.state);
        Optional<? extends AVariableDeclaration> returnVarName = functionReturnEdge.getFunctionEntry().getReturnVariable();
        ValueAnalysisState.MemoryLocation functionReturnVar = null;
        if (returnVarName.isPresent()) {
            functionReturnVar = ValueAnalysisState.MemoryLocation.valueOf(((AVariableDeclaration)returnVarName.get()).getQualifiedName());
        }
        if (exprOnSummary instanceof AFunctionCallAssignmentStatement) {
            AFunctionCallAssignmentStatement assignExp = (AFunctionCallAssignmentStatement)exprOnSummary;
            ALeftHandSide op1 = assignExp.getLeftHandSide();
            if (op1 instanceof CLeftHandSide) {
                ExpressionValueVisitor v = new ExpressionValueVisitor((ValueAnalysisState)this.state, callerFunctionName, this.machineModel, this.logger, this.symbolicValues);
                ValueAnalysisState.MemoryLocation assignedVarName = v.evaluateMemoryLocation((CLeftHandSide)op1);
                boolean valueExists = ((ValueAnalysisState)this.state).contains(functionReturnVar);
                if (assignedVarName == null) {
                    if (v.hasMissingPointer() && valueExists) {
                        Value value = ((ValueAnalysisState)this.state).getValueFor(functionReturnVar);
                        this.addMissingInformation((CLeftHandSide)op1, value);
                    }
                } else if (valueExists) {
                    Value value = ((ValueAnalysisState)this.state).getValueFor(functionReturnVar);
                    newElement.assignConstant(assignedVarName, value, ((ValueAnalysisState)this.state).getTypeForMemoryLocation(functionReturnVar));
                } else {
                    newElement.forget(assignedVarName);
                }
            } else if (op1 instanceof AIdExpression) {
                String assignedVarName = ((AIdExpression)op1).getDeclaration().getQualifiedName();
                if (!((ValueAnalysisState)this.state).contains(functionReturnVar)) {
                    newElement.forget(assignedVarName);
                } else if (op1 instanceof JIdExpression && this.isDynamicField((JIdExpression)op1)) {
                    this.missingScopedFieldName = true;
                    this.notScopedField = (JIdExpression)op1;
                    this.notScopedFieldValue = ((ValueAnalysisState)this.state).getValueFor(functionReturnVar);
                } else {
                    newElement.assignConstant(assignedVarName, ((ValueAnalysisState)this.state).getValueFor(functionReturnVar));
                }
            } else if (!(op1 instanceof APointerExpression)) {
                if (op1 instanceof JArraySubscriptExpression) {
                    Value newValue = Value.UnknownValue.getInstance();
                    JArraySubscriptExpression arraySubscriptExpression = (JArraySubscriptExpression)op1;
                    if (((ValueAnalysisState)this.state).contains(functionReturnVar)) {
                        newValue = ((ValueAnalysisState)this.state).getValueFor(functionReturnVar);
                    }
                    ArrayValue assignedArray = this.getInnerMostArray(arraySubscriptExpression);
                    Optional<Integer> maybeIndex = this.getIndex(arraySubscriptExpression);
                    if (maybeIndex.isPresent() && assignedArray != null) {
                        assignedArray.setValue(newValue, (Integer)maybeIndex.get());
                    } else {
                        this.assignUnknownValueToEnclosingInstanceOfArray(arraySubscriptExpression);
                    }
                } else {
                    throw new UnrecognizedCodeException("on function return", summaryEdge, op1);
                }
            }
        }
        if (returnVarName.isPresent()) {
            newElement.forget(functionReturnVar);
        }
        return newElement;
    }

    private boolean isDynamicField(JIdExpression pIdentifier) {
        JSimpleDeclaration declaration = pIdentifier.getDeclaration();
        return declaration instanceof JFieldDeclaration && !((JFieldDeclaration)declaration).isStatic();
    }

    private Optional<Integer> getIndex(JArraySubscriptExpression pExpression) {
        ExpressionValueVisitor evv = this.getVisitor();
        Value indexValue = pExpression.getSubscriptExpression().accept(evv);
        if (indexValue.isUnknown()) {
            return Optional.absent();
        }
        return Optional.of((Object)((int)((NumericValue)indexValue).longValue()));
    }

    @Override
    protected ValueAnalysisState handleFunctionSummaryEdge(CFunctionSummaryEdge cfaEdge) throws CPATransferException {
        ValueAnalysisState.MemoryLocation assignedMemoryLocation;
        AFunctionCallAssignmentStatement assignment;
        ALeftHandSide leftHandSide;
        ValueAnalysisState newState = ValueAnalysisState.copyOf((ValueAnalysisState)this.state);
        CFunctionCall functionCall = cfaEdge.getExpression();
        if (functionCall instanceof AFunctionCallAssignmentStatement && (leftHandSide = (assignment = (AFunctionCallAssignmentStatement)((Object)functionCall)).getLeftHandSide()) instanceof CLeftHandSide && newState.contains(assignedMemoryLocation = this.getVisitor().evaluateMemoryLocation((CLeftHandSide)leftHandSide))) {
            newState.forget(assignedMemoryLocation);
        }
        return newState;
    }

    @Override
    protected ValueAnalysisState handleAssumption(AssumeEdge cfaEdge, AExpression expression, boolean truthValue) throws UnrecognizedCCodeException {
        ExpressionValueVisitor evv = this.getVisitor();
        Type booleanType = this.getBooleanType(expression);
        Value value = this.getExpressionValue(expression, booleanType, evv);
        if (!value.isExplicitlyKnown()) {
            ValueAnalysisState element = ValueAnalysisState.copyOf((ValueAnalysisState)this.state);
            if (value instanceof SymbolicValueFormula) {
                Pair<SymbolicValueFormula.SymbolicValue, Value> replacement = null;
                replacement = ((SymbolicValueFormula)value).inferAssignment(truthValue, this.logger);
                if (replacement != null) {
                    for (ValueAnalysisState.MemoryLocation memloc : ((ValueAnalysisState)this.state).getTrackedMemoryLocations()) {
                        SymbolicValueFormula trackedFormula;
                        Value newValue;
                        Value trackedValue = ((ValueAnalysisState)this.state).getValueFor(memloc);
                        if (!(trackedValue instanceof SymbolicValueFormula) || (newValue = (trackedFormula = (SymbolicValueFormula)trackedValue).replaceSymbolWith((SymbolicValueFormula.SymbolicValue)replacement.getFirst(), (Value)replacement.getSecond(), this.logger)) == trackedValue) continue;
                        element.assignConstant(memloc, newValue, ((ValueAnalysisState)this.state).getTypeForMemoryLocation(memloc));
                    }
                }
            }
            AssigningValueVisitor avv = new AssigningValueVisitor(element, truthValue, this.booleanVariables);
            if (expression instanceof JExpression && !(expression instanceof CExpression)) {
                ((JExpression)expression).accept(avv);
                if (avv.hasMissingFieldAccessInformation()) {
                    assert (this.missingInformationRightJExpression != null);
                    this.missingAssumeInformation = true;
                }
            } else {
                ((CExpression)expression).accept(avv);
            }
            if (this.isMissingCExpressionInformation(evv, expression)) {
                this.missingInformationList.add(new MissingInformation(truthValue, (ARightHandSide)expression));
            }
            return element;
        }
        if (this.representsBoolean(value, truthValue)) {
            return ValueAnalysisState.copyOf((ValueAnalysisState)this.state);
        }
        return null;
    }

    private Type getBooleanType(AExpression pExpression) {
        if (pExpression instanceof JExpression) {
            return JSimpleType.getBoolean();
        }
        if (pExpression instanceof CExpression) {
            return CNumericTypes.INT;
        }
        throw new AssertionError((Object)("Unhandled expression type " + pExpression.getClass()));
    }

    private boolean representsBoolean(Value value, boolean bool) {
        if (value instanceof BooleanValue) {
            return ((BooleanValue)value).isTrue() == bool;
        }
        if (value.isNumericValue()) {
            return ((NumericValue)value).equals(new NumericValue(bool ? 1L : 0L));
        }
        return false;
    }

    @Override
    protected ValueAnalysisState handleDeclarationEdge(ADeclarationEdge declarationEdge, ADeclaration declaration) throws UnrecognizedCCodeException {
        if (!(declaration instanceof AVariableDeclaration) || !this.isTrackedType(declaration.getType())) {
            return (ValueAnalysisState)this.state;
        }
        ValueAnalysisState newElement = ValueAnalysisState.copyOf((ValueAnalysisState)this.state);
        AVariableDeclaration decl = (AVariableDeclaration)declaration;
        Type declarationType = decl.getType();
        String varName = decl.getName();
        Value initialValue = this.getDefaultInitialValue(decl);
        AInitializer init = decl.getInitializer();
        if (decl.isGlobal() && decl instanceof JFieldDeclaration && !((JFieldDeclaration)decl).isStatic()) {
            this.missingFieldVariableObject = true;
            this.javaNonStaticVariables.add(varName);
        }
        ValueAnalysisState.MemoryLocation memoryLocation = decl.isGlobal() ? ValueAnalysisState.MemoryLocation.valueOf(varName, 0L) : ValueAnalysisState.MemoryLocation.valueOf(this.functionName, varName, 0L);
        if (this.addressedVariables.contains(decl.getQualifiedName()) && declarationType instanceof CType && ((CType)declarationType).getCanonicalType() instanceof CPointerType) {
            ValueAnalysisState.addToBlacklist(memoryLocation);
        }
        if (init instanceof AInitializerExpression) {
            ExpressionValueVisitor evv = this.getVisitor();
            AExpression exp = ((AInitializerExpression)init).getExpression();
            initialValue = this.getExpressionValue(exp, declarationType, evv);
            if (this.isMissingCExpressionInformation(evv, exp)) {
                this.addMissingInformation(memoryLocation, exp);
            }
        }
        if (initialValue.isUnknown() && declarationType instanceof JType) {
            initialValue = this.getSymbolicIdentifier(declarationType);
        }
        if (this.isTrackedField(decl, initialValue)) {
            if (this.missingFieldVariableObject) {
                this.fieldNameAndInitialValue = Pair.of((Object)varName, (Object)initialValue);
            } else if (this.missingInformationRightJExpression == null) {
                newElement.assignConstant(memoryLocation, initialValue, declarationType);
            } else {
                this.missingInformationLeftJVariable = memoryLocation.getAsSimpleString();
            }
        } else {
            this.missingFieldVariableObject = false;
            newElement.forget(memoryLocation);
        }
        return newElement;
    }

    private Value getDefaultInitialValue(AVariableDeclaration pDeclaration) {
        boolean defaultBooleanValue = false;
        long defaultNumericValue = 0L;
        if (pDeclaration.isGlobal()) {
            Type declarationType = pDeclaration.getType();
            if (this.isComplexJavaType(declarationType)) {
                return NullValue.getInstance();
            }
            if (declarationType instanceof JSimpleType) {
                JBasicType basicType = ((JSimpleType)declarationType).getType();
                switch (basicType) {
                    case BOOLEAN: {
                        return BooleanValue.valueOf(false);
                    }
                    case BYTE: 
                    case CHAR: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return new NumericValue(0L);
                    }
                    case UNSPECIFIED: {
                        return Value.UnknownValue.getInstance();
                    }
                }
                throw new AssertionError((Object)("Impossible type for declaration: " + (Object)((Object)basicType)));
            }
        }
        return Value.UnknownValue.getInstance();
    }

    private boolean isMissingCExpressionInformation(ExpressionValueVisitor pEvv, ARightHandSide pExp) {
        return pExp instanceof CExpression && pEvv.hasMissingPointer();
    }

    private boolean isTrackedField(ADeclaration pDeclaration, Value pInitialValue) {
        boolean isNoComplexType = !this.isComplexJavaType(pDeclaration.getType()) && (this.missingInformationRightJExpression != null || !pInitialValue.isUnknown());
        return isNoComplexType || pInitialValue instanceof EnumConstantValue || pInitialValue instanceof ArrayValue || pInitialValue instanceof NullValue || pInitialValue.isUnknown();
    }

    private boolean isComplexJavaType(Type pType) {
        return pType instanceof JClassOrInterfaceType || pType instanceof JArrayType;
    }

    private Value getSymbolicIdentifier(Type pType) {
        SymbolicValueFactory factory = SymbolicValueFactory.getInstance();
        return factory.createIdentifier(pType);
    }

    @Override
    protected ValueAnalysisState handleStatementEdge(AStatementEdge cfaEdge, AStatement expression) throws UnrecognizedCodeException {
        CExpression fn;
        if (expression instanceof CFunctionCall && (fn = ((CFunctionCall)expression).getFunctionCallExpression().getFunctionNameExpression()) instanceof CIdExpression) {
            String func = ((CIdExpression)fn).getName();
            if (UNSUPPORTED_FUNCTIONS.containsKey(func)) {
                throw new UnsupportedCCodeException(UNSUPPORTED_FUNCTIONS.get(func), (CFAEdge)cfaEdge, fn);
            }
            if (func.equals("free")) {
                this.missingInformationList.add(new MissingInformation(((CFunctionCall)expression).getFunctionCallExpression()));
            }
        }
        if (expression instanceof AAssignment) {
            return this.handleAssignment((AAssignment)((Object)expression), cfaEdge);
        }
        if (!(expression instanceof AFunctionCallStatement) && !(expression instanceof AExpressionStatement)) {
            throw new UnrecognizedCodeException("Unknown statement", cfaEdge, expression);
        }
        return (ValueAnalysisState)this.state;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ValueAnalysisState handleAssignment(AAssignment assignExpression, CFAEdge cfaEdge) throws UnrecognizedCodeException {
        ALeftHandSide op1 = assignExpression.getLeftHandSide();
        ARightHandSide op2 = assignExpression.getRightHandSide();
        if (!this.isTrackedType(op1.getExpressionType())) {
            return (ValueAnalysisState)this.state;
        }
        if (op1 instanceof AIdExpression) {
            if (op1 instanceof JIdExpression && this.isDynamicField((JIdExpression)op1)) {
                this.missingScopedFieldName = true;
                this.notScopedField = (JIdExpression)op1;
            }
            ValueAnalysisState.MemoryLocation memloc = this.getMemoryLocation((AIdExpression)op1);
            return this.handleAssignmentToVariable(memloc, op1.getExpressionType(), op2, this.getVisitor());
        }
        if (op1 instanceof APointerExpression) {
            if (!this.isRelevant(op1, op2)) return (ValueAnalysisState)this.state;
            this.missingInformationList.add(new MissingInformation(op1, op2));
            return (ValueAnalysisState)this.state;
        } else {
            if (op1 instanceof CFieldReference) {
                ExpressionValueVisitor v = this.getVisitor();
                ValueAnalysisState.MemoryLocation memLoc = v.evaluateMemoryLocation((CFieldReference)op1);
                if (v.hasMissingPointer() && this.isRelevant(op1, op2)) {
                    this.missingInformationList.add(new MissingInformation(op1, op2));
                }
                if (memLoc == null) return (ValueAnalysisState)this.state;
                return this.handleAssignmentToVariable(memLoc, op1.getExpressionType(), op2, v);
            }
            if (!(op1 instanceof AArraySubscriptExpression)) throw new UnrecognizedCodeException("left operand of assignment has to be a variable", cfaEdge, op1);
            if (op1 instanceof CArraySubscriptExpression) {
                ExpressionValueVisitor v = this.getVisitor();
                ValueAnalysisState.MemoryLocation memLoc = v.evaluateMemoryLocation((CLeftHandSide)op1);
                if (v.hasMissingPointer() && this.isRelevant(op1, op2)) {
                    this.missingInformationList.add(new MissingInformation(op1, op2));
                }
                if (memLoc == null) return (ValueAnalysisState)this.state;
                return this.handleAssignmentToVariable(memLoc, op1.getExpressionType(), op2, v);
            }
            if (!(op1 instanceof JArraySubscriptExpression)) return (ValueAnalysisState)this.state;
            JArraySubscriptExpression arrayExpression = (JArraySubscriptExpression)op1;
            ExpressionValueVisitor evv = this.getVisitor();
            ArrayValue arrayToChange = this.getInnerMostArray(arrayExpression);
            Value maybeIndex = arrayExpression.getSubscriptExpression().accept(evv);
            if (arrayToChange == null || maybeIndex.isUnknown()) {
                this.assignUnknownValueToEnclosingInstanceOfArray(arrayExpression);
                return (ValueAnalysisState)this.state;
            } else {
                long concreteIndex = ((NumericValue)maybeIndex).longValue();
                if (concreteIndex < 0L || concreteIndex >= (long)arrayToChange.getArraySize()) {
                    throw new UnrecognizedCodeException("Invalid index " + concreteIndex + " for array " + arrayToChange, cfaEdge);
                }
                this.handleAssignmentToArray(arrayToChange, (int)concreteIndex, op2);
                return ValueAnalysisState.copyOf((ValueAnalysisState)this.state);
            }
        }
    }

    private boolean isTrackedType(Type pType) {
        return !(pType instanceof JType) || this.trackJavaArrayValues || !(pType instanceof JArrayType);
    }

    private ValueAnalysisState.MemoryLocation getMemoryLocation(AIdExpression pIdExpression) {
        String varName = pIdExpression.getName();
        if (ValueAnalysisTransferRelation.isGlobal(pIdExpression)) {
            return ValueAnalysisState.MemoryLocation.valueOf(varName, 0L);
        }
        return ValueAnalysisState.MemoryLocation.valueOf(this.functionName, varName, 0L);
    }

    private boolean isRelevant(AExpression pOp1, ARightHandSide pOp2) {
        return pOp1 instanceof CExpression && pOp2 instanceof CExpression;
    }

    private ValueAnalysisState handleAssignmentToVariable(ValueAnalysisState.MemoryLocation assignedVar, Type lType, ARightHandSide exp, ExpressionValueVisitor visitor) throws UnrecognizedCCodeException {
        Value value;
        if (exp instanceof JRightHandSide) {
            value = visitor.evaluate((JRightHandSide)exp, (JType)lType);
        } else if (exp instanceof CRightHandSide) {
            value = visitor.evaluate((CRightHandSide)exp, (CType)lType);
        } else {
            throw new AssertionError((Object)("unknown righthandside-expression: " + exp));
        }
        if (visitor.hasMissingPointer()) assert (!value.isExplicitlyKnown());
        if (this.isMissingCExpressionInformation(visitor, exp)) {
            this.addMissingInformation(assignedVar, exp);
        }
        ValueAnalysisState newElement = ValueAnalysisState.copyOf((ValueAnalysisState)this.state);
        if (visitor.hasMissingFieldAccessInformation()) {
            if (!value.isUnknown()) {
                newElement.forget(assignedVar);
                return newElement;
            }
            this.missingInformationRightJExpression = (JRightHandSide)exp;
            if (!this.missingScopedFieldName) {
                this.missingInformationLeftJVariable = assignedVar.getAsSimpleString();
            }
        }
        if (this.missingScopedFieldName) {
            this.notScopedFieldValue = value;
        } else {
            if (value.isUnknown() && this.missingInformationRightJExpression == null) {
                if (lType instanceof JType) {
                    value = this.getSymbolicIdentifier(lType);
                } else {
                    newElement.forget(assignedVar);
                }
            }
            if (!value.isUnknown()) {
                newElement.assignConstant(assignedVar, value, lType);
            }
        }
        return newElement;
    }

    private void addMissingInformation(ValueAnalysisState.MemoryLocation pMemLoc, ARightHandSide pExp) {
        if (pExp instanceof CExpression) {
            this.missingInformationList.add(new MissingInformation(pMemLoc, (CExpression)pExp));
        }
    }

    private void addMissingInformation(CLeftHandSide pOp1, Value pValue) {
        this.missingInformationList.add(new MissingInformation((CExpression)pOp1, pValue));
    }

    @Nullable
    private ArrayValue getInnerMostArray(JArraySubscriptExpression pArraySubscriptExpression) {
        JExpression arrayExpression = pArraySubscriptExpression.getArrayExpression();
        if (arrayExpression instanceof JIdExpression) {
            String idName;
            Value idValue;
            JSimpleDeclaration arrayDeclaration = ((JIdExpression)arrayExpression).getDeclaration();
            if (arrayDeclaration != null && (idValue = ((ValueAnalysisState)this.state).getValueFor(idName = arrayDeclaration.getQualifiedName())).isExplicitlyKnown()) {
                return (ArrayValue)idValue;
            }
            return null;
        }
        JArraySubscriptExpression arraySubscriptExpression = (JArraySubscriptExpression)arrayExpression;
        ArrayValue enclosingArray = this.getInnerMostArray(arraySubscriptExpression);
        Optional<Integer> maybeIndex = this.getIndex(arraySubscriptExpression);
        if (maybeIndex.isPresent() && enclosingArray != null) {
            assert (enclosingArray.getArrayType().getDimensions() > 1);
        } else {
            return null;
        }
        int index = (Integer)maybeIndex.get();
        if (index >= enclosingArray.getArraySize() || index < 0) {
            return null;
        }
        return (ArrayValue)enclosingArray.getValueAt(index);
    }

    private void handleAssignmentToArray(ArrayValue pArray, int index, ARightHandSide exp) {
        assert (exp instanceof JExpression);
        pArray.setValue(((JExpression)exp).accept(this.getVisitor()), index);
    }

    private void assignUnknownValueToEnclosingInstanceOfArray(JArraySubscriptExpression pArraySubscriptExpression) {
        JExpression enclosingExpression = pArraySubscriptExpression.getArrayExpression();
        if (enclosingExpression instanceof JIdExpression) {
            JIdExpression idExpression = (JIdExpression)enclosingExpression;
            ValueAnalysisState.MemoryLocation memLoc = this.getMemoryLocation(idExpression);
            ((ValueAnalysisState)this.state).assignConstant(memLoc, Value.UnknownValue.getInstance(), JSimpleType.getUnspecified());
        } else {
            JArraySubscriptExpression enclosingSubscriptExpression = (JArraySubscriptExpression)enclosingExpression;
            ArrayValue enclosingArray = this.getInnerMostArray(enclosingSubscriptExpression);
            Optional<Integer> maybeIndex = this.getIndex(enclosingSubscriptExpression);
            if (maybeIndex.isPresent() && enclosingArray != null) {
                enclosingArray.setValue(Value.UnknownValue.getInstance(), (Integer)maybeIndex.get());
            } else {
                this.assignUnknownValueToEnclosingInstanceOfArray(enclosingSubscriptExpression);
            }
        }
    }

    private Value getExpressionValue(AExpression expression, Type type, ExpressionValueVisitor evv) throws UnrecognizedCCodeException {
        if (!this.isTrackedType(type)) {
            return Value.UnknownValue.getInstance();
        }
        if (expression instanceof JRightHandSide) {
            Value value = evv.evaluate((JRightHandSide)((Object)expression), (JType)type);
            if (evv.hasMissingFieldAccessInformation()) {
                this.missingInformationRightJExpression = (JRightHandSide)((Object)expression);
                return Value.UnknownValue.getInstance();
            }
            return value;
        }
        if (expression instanceof CRightHandSide) {
            return evv.evaluate((CRightHandSide)((Object)expression), (CType)type);
        }
        throw new AssertionError((Object)("unhandled righthandside-expression: " + expression));
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState element, List<AbstractState> elements, CFAEdge cfaEdge, Precision precision) throws CPATransferException {
        assert (element instanceof ValueAnalysisState);
        ArrayList<ValueAnalysisState> toStrengthen = new ArrayList<ValueAnalysisState>();
        ArrayList<ValueAnalysisState> result = new ArrayList<ValueAnalysisState>();
        toStrengthen.add((ValueAnalysisState)element);
        result.add((ValueAnalysisState)element);
        for (AbstractState ae : elements) {
            Collection<ValueAnalysisState> ret;
            if (ae instanceof RTTState) {
                result.clear();
                for (ValueAnalysisState state : toStrengthen) {
                    super.setInfo(element, precision, cfaEdge);
                    ret = this.strengthen((RTTState)ae);
                    if (ret == null) {
                        result.add(state);
                        continue;
                    }
                    result.addAll(ret);
                }
                toStrengthen.clear();
                toStrengthen.addAll(result);
                continue;
            }
            if (ae instanceof SMGState) {
                result.clear();
                for (ValueAnalysisState state : toStrengthen) {
                    super.setInfo(element, precision, cfaEdge);
                    ret = this.strengthen((SMGState)ae);
                    if (ret == null) {
                        result.add(state);
                        continue;
                    }
                    result.addAll(ret);
                }
                toStrengthen.clear();
                toStrengthen.addAll(result);
                continue;
            }
            if (!(ae instanceof AutomatonState)) continue;
            result.clear();
            for (ValueAnalysisState state : toStrengthen) {
                Collection<ValueAnalysisState> ret2;
                super.setInfo(element, precision, cfaEdge);
                AutomatonState autoState = (AutomatonState)ae;
                Collection<ValueAnalysisState> collection = ret2 = this.automatonAssumesAsStatements ? this.strengthenAutomatonStatement(autoState, state, cfaEdge) : this.strengthenAutomatonAssume(autoState, state, cfaEdge);
                if (ret2 == null) {
                    result.add(state);
                    continue;
                }
                result.addAll(ret2);
            }
            toStrengthen.clear();
            toStrengthen.addAll(result);
        }
        ArrayList<AbstractState> postProcessedResult = new ArrayList<AbstractState>(result.size());
        for (ValueAnalysisState rawResult : result) {
            if (rawResult == element) {
                postProcessedResult.add(element);
                continue;
            }
            postProcessedResult.addAll(this.postProcessing(rawResult));
        }
        super.resetInfo();
        this.oldState = null;
        return postProcessedResult;
    }

    private Collection<ValueAnalysisState> strengthenAutomatonStatement(AutomatonState pAutomatonState, ValueAnalysisState pState, CFAEdge pCfaEdge) throws CPATransferException {
        CStatementEdge stmtEdge;
        List<CStatementEdge> statementEdges = pAutomatonState.getAsStatementEdges(pCfaEdge.getPredecessor().getFunctionName());
        ValueAnalysisState state = pState;
        Iterator<CStatementEdge> i$ = statementEdges.iterator();
        while (i$.hasNext() && (state = this.handleStatementEdge((AStatementEdge)(stmtEdge = i$.next()), (AStatement)stmtEdge.getStatement())) != null) {
            this.setInfo(state, this.precision, pCfaEdge);
        }
        if (state == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(state);
    }

    private Collection<ValueAnalysisState> strengthenAutomatonAssume(AutomatonState pAutomatonState, ValueAnalysisState pState, CFAEdge pCfaEdge) throws CPATransferException {
        AssumeEdge assumeEdge;
        List<AssumeEdge> assumeEdges = pAutomatonState.getAsAssumeEdges(pCfaEdge.getPredecessor().getFunctionName());
        ValueAnalysisState state = pState;
        Iterator<AssumeEdge> i$ = assumeEdges.iterator();
        while (i$.hasNext() && (state = this.handleAssumption(assumeEdge = i$.next(), assumeEdge.getExpression(), assumeEdge.getTruthAssumption())) != null) {
            this.setInfo(state, this.precision, pCfaEdge);
        }
        if (state == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(state);
    }

    private Collection<ValueAnalysisState> strengthen(SMGState smgState) throws UnrecognizedCCodeException {
        ValueAnalysisState newElement = ValueAnalysisState.copyOf((ValueAnalysisState)this.state);
        for (MissingInformation missingInformation : this.missingInformationList) {
            if (missingInformation.isMissingAssumption()) {
                newElement = this.resolvingAssumption(newElement, smgState, missingInformation);
                continue;
            }
            if (missingInformation.isMissingAssignment()) {
                if (this.isRelevant(missingInformation)) {
                    newElement = this.resolvingAssignment(newElement, smgState, missingInformation);
                    continue;
                }
                newElement = this.forgetMemLoc(newElement, missingInformation, smgState);
                continue;
            }
            if (!missingInformation.isFreeInvocation()) continue;
            newElement = this.resolveFree(newElement, smgState, missingInformation);
        }
        this.missingInformationList.clear();
        if (newElement == null) {
            return new HashSet<ValueAnalysisState>();
        }
        return ((ValueAnalysisState)this.state).equals(newElement) ? null : Collections.singleton(newElement);
    }

    private ValueAnalysisState resolveFree(ValueAnalysisState pNewElement, SMGState pSmgState, MissingInformation pMissingInformation) throws UnrecognizedCCodeException {
        SMGTransferRelation.SMGAddressValue address;
        CExpression pointerExp;
        CFunctionCallExpression functionCall = pMissingInformation.getMissingFreeInvocation();
        try {
            pointerExp = functionCall.getParameterExpressions().get(0);
        }
        catch (IndexOutOfBoundsException e) {
            this.logger.logDebugException((Throwable)e);
            throw new UnrecognizedCCodeException("Bulit in function free has no parameter", this.edge, functionCall);
        }
        ValueAnalysisSMGCommunicator cc = new ValueAnalysisSMGCommunicator(pNewElement, this.functionName, pSmgState, this.machineModel, this.logger, this.edge);
        try {
            address = cc.evaluateSMGAddressExpression(pointerExp);
        }
        catch (CPATransferException e) {
            this.logger.logDebugException((Throwable)e);
            throw new UnrecognizedCCodeException("Error while evaluating free pointer exception.", this.edge, functionCall);
        }
        if (address.isUnknown()) {
            return pNewElement;
        }
        pNewElement.forgetValuesWithIdentifier(address.getObject().getLabel());
        return pNewElement;
    }

    private ValueAnalysisState forgetMemLoc(ValueAnalysisState pNewElement, MissingInformation pMissingInformation, SMGState pSmgState) throws UnrecognizedCCodeException {
        ValueAnalysisState.MemoryLocation memoryLocation = null;
        if (pMissingInformation.hasKnownMemoryLocation()) {
            memoryLocation = pMissingInformation.getcLeftMemoryLocation();
        } else if (pMissingInformation.hasUnknownMemoryLocation()) {
            memoryLocation = this.resolveMemoryLocation(pSmgState, pMissingInformation.getMissingCLeftMemoryLocation());
        }
        if (memoryLocation == null) {
            return pNewElement;
        }
        pNewElement.forget(memoryLocation);
        return pNewElement;
    }

    private boolean isRelevant(MissingInformation missingInformation) {
        CExpression value;
        if (missingInformation.hasUnknownMemoryLocation()) {
            value = missingInformation.getMissingCLeftMemoryLocation();
        } else if (missingInformation.hasUnknownValue()) {
            value = missingInformation.getMissingCExpressionInformation();
        } else {
            return false;
        }
        CType type = value.getExpressionType().getCanonicalType();
        return !(type instanceof CPointerType);
    }

    private ValueAnalysisState resolvingAssignment(ValueAnalysisState pNewElement, SMGState pSmgState, MissingInformation pMissingInformation) throws UnrecognizedCCodeException {
        ValueAnalysisState.MemoryLocation memoryLocation = null;
        if (pMissingInformation.hasKnownMemoryLocation()) {
            memoryLocation = pMissingInformation.getcLeftMemoryLocation();
        } else if (pMissingInformation.hasUnknownMemoryLocation()) {
            memoryLocation = this.resolveMemoryLocation(pSmgState, pMissingInformation.getMissingCLeftMemoryLocation());
        }
        if (memoryLocation == null) {
            return pNewElement;
        }
        Value value = Value.UnknownValue.getInstance();
        if (pMissingInformation.hasKnownValue()) {
            value = pMissingInformation.getcExpressionValue();
        } else if (pMissingInformation.hasUnknownValue()) {
            value = this.resolveValue(pSmgState, pMissingInformation.getMissingCExpressionInformation());
        }
        if (value.isUnknown()) {
            if (pNewElement.contains(memoryLocation)) {
                pNewElement.forget(memoryLocation);
            }
            return pNewElement;
        }
        pNewElement.assignConstant(memoryLocation, value, pNewElement.getTypeForMemoryLocation(memoryLocation));
        return pNewElement;
    }

    private Value resolveValue(SMGState pSmgState, CExpression rValue) throws UnrecognizedCCodeException {
        ValueAnalysisSMGCommunicator cc = new ValueAnalysisSMGCommunicator(this.oldState, this.functionName, pSmgState, this.machineModel, this.logger, this.edge);
        return cc.evaluateExpression(rValue);
    }

    private ValueAnalysisState.MemoryLocation resolveMemoryLocation(SMGState pSmgState, CExpression lValue) throws UnrecognizedCCodeException {
        ValueAnalysisSMGCommunicator cc = new ValueAnalysisSMGCommunicator(this.oldState, this.functionName, pSmgState, this.machineModel, this.logger, this.edge);
        return cc.evaluateLeftHandSide(lValue);
    }

    private ValueAnalysisState resolvingAssumption(ValueAnalysisState pNewElement, SMGState pSmgState, MissingInformation pMissingInformation) throws UnrecognizedCCodeException {
        Boolean bTruthValue = pMissingInformation.getTruthAssumption();
        long truthValue = bTruthValue != false ? 1L : 0L;
        Value value = this.resolveValue(pSmgState, pMissingInformation.getMissingCExpressionInformation());
        if (value.isExplicitlyKnown() && !value.equals(new NumericValue(truthValue))) {
            return null;
        }
        if (!value.isExplicitlyKnown()) {
            ValueAnalysisState element = ValueAnalysisState.copyOf(pNewElement);
            SMGAssigningValueVisitor avv = new SMGAssigningValueVisitor(element, bTruthValue, this.booleanVariables, pSmgState);
            pMissingInformation.getMissingCExpressionInformation().accept(avv);
            return element;
        }
        return pNewElement;
    }

    private Collection<ValueAnalysisState> strengthen(RTTState rttState) throws UnrecognizedCCodeException {
        ValueAnalysisState newElement = ValueAnalysisState.copyOf((ValueAnalysisState)this.state);
        if (this.missingFieldVariableObject) {
            newElement.assignConstant(this.getRTTScopedVariableName((String)this.fieldNameAndInitialValue.getFirst(), rttState.getKeywordThisUniqueObject()), (Value)this.fieldNameAndInitialValue.getSecond());
            this.missingFieldVariableObject = false;
            this.fieldNameAndInitialValue = null;
            return Collections.singleton(newElement);
        }
        if (this.missingScopedFieldName) {
            newElement = this.handleNotScopedVariable(rttState, newElement);
            this.missingScopedFieldName = false;
            this.notScopedField = null;
            this.notScopedFieldValue = null;
            this.missingInformationRightJExpression = null;
            if (newElement != null) {
                return Collections.singleton(newElement);
            }
            return null;
        }
        if (this.missingAssumeInformation && this.missingInformationRightJExpression != null) {
            Value value = this.handleMissingInformationRightJExpression(rttState);
            this.missingAssumeInformation = false;
            this.missingInformationRightJExpression = null;
            boolean truthAssumption = ((AssumeEdge)this.edge).getTruthAssumption();
            if (value == null || !value.isExplicitlyKnown()) {
                return null;
            }
            if (this.representsBoolean(value, truthAssumption)) {
                return Collections.singleton(newElement);
            }
            return new HashSet<ValueAnalysisState>();
        }
        if (this.missingInformationRightJExpression != null) {
            Value value = this.handleMissingInformationRightJExpression(rttState);
            if (!value.isUnknown()) {
                newElement.assignConstant(this.missingInformationLeftJVariable, value);
                this.missingInformationRightJExpression = null;
                this.missingInformationLeftJVariable = null;
                return Collections.singleton(newElement);
            }
            if (this.missingInformationLeftJVariable != null) {
                newElement.forget(this.missingInformationLeftJVariable);
            }
            this.missingInformationRightJExpression = null;
            this.missingInformationLeftJVariable = null;
            return Collections.singleton(newElement);
        }
        return null;
    }

    private String getRTTScopedVariableName(String fieldName, String uniqueObject) {
        return uniqueObject + "::" + fieldName;
    }

    private Value handleMissingInformationRightJExpression(RTTState pJortState) throws UnrecognizedCCodeException {
        return this.missingInformationRightJExpression.accept(new FieldAccessExpressionValueVisitor(pJortState));
    }

    private ValueAnalysisState handleNotScopedVariable(RTTState rttState, ValueAnalysisState newElement) throws UnrecognizedCCodeException {
        String objectScope = NameProvider.getInstance().getObjectScope(rttState, this.functionName, this.notScopedField);
        if (objectScope != null) {
            String scopedFieldName = this.getRTTScopedVariableName(this.notScopedField.getName(), objectScope);
            Value value = this.notScopedFieldValue;
            if (this.missingInformationRightJExpression != null) {
                value = this.handleMissingInformationRightJExpression(rttState);
            }
            if (!value.isUnknown()) {
                newElement.assignConstant(scopedFieldName, value);
                return newElement;
            }
            newElement.forget(scopedFieldName);
            return newElement;
        }
        return null;
    }

    private ExpressionValueVisitor getVisitor() {
        return new ExpressionValueVisitor((ValueAnalysisState)this.state, this.functionName, this.machineModel, this.logger, this.symbolicValues);
    }

    private static class MissingInformation {
        private final CExpression missingCLeftMemoryLocation;
        private final ValueAnalysisState.MemoryLocation cLeftMemoryLocation;
        private final CExpression missingCExpressionInformation;
        private final Value cExpressionValue;
        private final Boolean truthAssumption;
        private CFunctionCallExpression missingFreeInvocation = null;

        public MissingInformation(CExpression pMissingCLeftMemoryLocation, CExpression pMissingCExpressionInformation) {
            this.missingCExpressionInformation = pMissingCExpressionInformation;
            this.missingCLeftMemoryLocation = pMissingCLeftMemoryLocation;
            this.cExpressionValue = null;
            this.cLeftMemoryLocation = null;
            this.truthAssumption = null;
        }

        public boolean hasUnknownValue() {
            return this.missingCExpressionInformation != null;
        }

        public boolean hasKnownValue() {
            return this.cExpressionValue != null;
        }

        public boolean hasUnknownMemoryLocation() {
            return this.missingCLeftMemoryLocation != null;
        }

        public boolean hasKnownMemoryLocation() {
            return this.cLeftMemoryLocation != null;
        }

        public boolean isMissingAssignment() {
            return (this.missingCExpressionInformation != null || this.missingCLeftMemoryLocation != null) && this.truthAssumption == null;
        }

        public boolean isMissingAssumption() {
            return this.truthAssumption != null && this.missingCExpressionInformation != null;
        }

        public MissingInformation(CExpression pMissingCLeftMemoryLocation, Value pCExpressionValue) {
            this.missingCExpressionInformation = null;
            this.missingCLeftMemoryLocation = pMissingCLeftMemoryLocation;
            this.cExpressionValue = pCExpressionValue;
            this.cLeftMemoryLocation = null;
            this.truthAssumption = null;
        }

        public MissingInformation(ValueAnalysisState.MemoryLocation pCLeftMemoryLocation, CExpression pMissingCExpressionInformation) {
            this.missingCExpressionInformation = pMissingCExpressionInformation;
            this.missingCLeftMemoryLocation = null;
            this.cExpressionValue = null;
            this.cLeftMemoryLocation = pCLeftMemoryLocation;
            this.truthAssumption = null;
        }

        public MissingInformation(AExpression pMissingCLeftMemoryLocation, ARightHandSide pMissingCExpressionInformation) {
            this.missingCExpressionInformation = (CExpression)pMissingCExpressionInformation;
            this.missingCLeftMemoryLocation = (CExpression)pMissingCLeftMemoryLocation;
            this.cExpressionValue = null;
            this.cLeftMemoryLocation = null;
            this.truthAssumption = null;
        }

        public MissingInformation(Boolean pTruthAssumption, ARightHandSide pMissingCExpressionInformation) {
            this.missingCExpressionInformation = (CExpression)pMissingCExpressionInformation;
            this.missingCLeftMemoryLocation = null;
            this.cExpressionValue = null;
            this.cLeftMemoryLocation = null;
            this.truthAssumption = pTruthAssumption;
        }

        public MissingInformation(CFunctionCallExpression pFunctionCallExpression) {
            this.missingFreeInvocation = pFunctionCallExpression;
            this.missingCExpressionInformation = null;
            this.missingCLeftMemoryLocation = null;
            this.cExpressionValue = null;
            this.cLeftMemoryLocation = null;
            this.truthAssumption = null;
        }

        public boolean isFreeInvocation() {
            return this.missingFreeInvocation != null;
        }

        public Value getcExpressionValue() {
            Preconditions.checkNotNull((Object)this.cExpressionValue);
            return this.cExpressionValue;
        }

        public ValueAnalysisState.MemoryLocation getcLeftMemoryLocation() {
            Preconditions.checkNotNull((Object)this.cLeftMemoryLocation);
            return this.cLeftMemoryLocation;
        }

        public CExpression getMissingCExpressionInformation() {
            Preconditions.checkNotNull((Object)this.missingCExpressionInformation);
            return this.missingCExpressionInformation;
        }

        public CExpression getMissingCLeftMemoryLocation() {
            Preconditions.checkNotNull((Object)this.missingCLeftMemoryLocation);
            return this.missingCLeftMemoryLocation;
        }

        public Boolean getTruthAssumption() {
            Preconditions.checkNotNull((Object)this.truthAssumption);
            return this.truthAssumption;
        }

        public CFunctionCallExpression getMissingFreeInvocation() {
            return this.missingFreeInvocation;
        }
    }

    private class FieldAccessExpressionValueVisitor
    extends ExpressionValueVisitor {
        private final RTTState jortState;

        public FieldAccessExpressionValueVisitor(RTTState pJortState) {
            super((ValueAnalysisState)ValueAnalysisTransferRelation.this.state, ValueAnalysisTransferRelation.this.functionName, ValueAnalysisTransferRelation.this.machineModel, ValueAnalysisTransferRelation.this.logger, ValueAnalysisTransferRelation.this.symbolicValues);
            this.jortState = pJortState;
        }

        @Override
        public Value visit(JBinaryExpression binaryExpression) {
            return super.visit(binaryExpression);
        }

        private String handleIdExpression(JIdExpression expr) {
            JSimpleDeclaration decl = expr.getDeclaration();
            if (decl == null) {
                return null;
            }
            NameProvider nameProvider = NameProvider.getInstance();
            String objectScope = nameProvider.getObjectScope(this.jortState, ValueAnalysisTransferRelation.this.functionName, expr);
            return nameProvider.getScopedVariableName(decl, ValueAnalysisTransferRelation.this.functionName, objectScope);
        }

        @Override
        public Value visit(JIdExpression idExp) {
            String varName = this.handleIdExpression(idExp);
            if (((ValueAnalysisState)ValueAnalysisTransferRelation.this.state).contains(varName)) {
                return ((ValueAnalysisState)ValueAnalysisTransferRelation.this.state).getValueFor(varName);
            }
            return Value.UnknownValue.getInstance();
        }
    }

    private class SMGAssigningValueVisitor
    extends AssigningValueVisitor {
        private final ValueAnalysisSMGCommunicator expressionEvaluator;
        private final SMGState smgState;

        public SMGAssigningValueVisitor(ValueAnalysisState pAssignableState, boolean pTruthValue, Collection<String> booleanVariables, SMGState pSmgState) {
            super(pAssignableState, pTruthValue, booleanVariables);
            Preconditions.checkNotNull((Object)pSmgState);
            this.expressionEvaluator = new ValueAnalysisSMGCommunicator(pAssignableState, ValueAnalysisTransferRelation.this.functionName, pSmgState, ValueAnalysisTransferRelation.this.machineModel, ValueAnalysisTransferRelation.this.logger, ValueAnalysisTransferRelation.this.edge);
            this.smgState = pSmgState;
        }

        @Override
        protected boolean isAssignable(CExpression pExpression) throws UnrecognizedCCodeException {
            if (pExpression instanceof CLeftHandSide) {
                ValueAnalysisState.MemoryLocation memLoc = this.expressionEvaluator.evaluateLeftHandSide(pExpression);
                return memLoc != null;
            }
            return false;
        }

        @Override
        protected ValueAnalysisState.MemoryLocation getMemoryLocation(CExpression pLValue) throws UnrecognizedCCodeException {
            return this.expressionEvaluator.evaluateLeftHandSide(pLValue);
        }
    }

    private class AssigningValueVisitor
    extends ExpressionValueVisitor {
        private ValueAnalysisState assignableState;
        private Collection<String> booleans;
        protected boolean truthValue;

        public AssigningValueVisitor(ValueAnalysisState assignableState, boolean truthValue, Collection<String> booleanVariables) {
            super((ValueAnalysisState)ValueAnalysisTransferRelation.this.state, ValueAnalysisTransferRelation.this.functionName, ValueAnalysisTransferRelation.this.machineModel, ValueAnalysisTransferRelation.this.logger, ValueAnalysisTransferRelation.this.symbolicValues);
            this.truthValue = false;
            this.assignableState = assignableState;
            this.booleans = booleanVariables;
            this.truthValue = truthValue;
        }

        private AExpression unwrap(AExpression expression) {
            if (expression instanceof CCastExpression) {
                CCastExpression exp = (CCastExpression)expression;
                expression = exp.getOperand();
                expression = this.unwrap(expression);
            }
            return expression;
        }

        @Override
        public Value visit(CBinaryExpression pE) throws UnrecognizedCCodeException {
            CBinaryExpression.BinaryOperator binaryOperator = pE.getOperator();
            CExpression lVarInBinaryExp = (CExpression)this.unwrap(pE.getOperand1());
            CExpression rVarInBinaryExp = pE.getOperand2();
            Value leftValue = lVarInBinaryExp.accept(this);
            Value rightValue = rVarInBinaryExp.accept(this);
            if (this.isEqualityAssumption(binaryOperator)) {
                if (leftValue.isUnknown() && !rightValue.isUnknown() && this.isAssignable(lVarInBinaryExp)) {
                    this.assignableState.assignConstant(this.getMemoryLocation(lVarInBinaryExp), rightValue, pE.getExpressionType());
                } else if (rightValue.isUnknown() && !leftValue.isUnknown() && this.isAssignable(rVarInBinaryExp)) {
                    this.assignableState.assignConstant(this.getMemoryLocation(rVarInBinaryExp), leftValue, pE.getExpressionType());
                }
            }
            if (this.isNonEqualityAssumption(binaryOperator)) {
                ValueAnalysisState.MemoryLocation rightMemLoc;
                if (this.assumingUnknownToBeZero(leftValue, rightValue) && this.isAssignable(lVarInBinaryExp)) {
                    ValueAnalysisState.MemoryLocation leftMemLoc = this.getMemoryLocation(lVarInBinaryExp);
                    if (ValueAnalysisTransferRelation.this.optimizeBooleanVariables && (this.booleans.contains(leftMemLoc.getAsSimpleString()) || ValueAnalysisTransferRelation.this.initAssumptionVars)) {
                        this.assignableState.assignConstant(leftMemLoc, new NumericValue(1L), pE.getExpressionType());
                    }
                } else if (ValueAnalysisTransferRelation.this.optimizeBooleanVariables && this.assumingUnknownToBeZero(rightValue, leftValue) && this.isAssignable(rVarInBinaryExp) && (this.booleans.contains((rightMemLoc = this.getMemoryLocation(rVarInBinaryExp)).getAsSimpleString()) || ValueAnalysisTransferRelation.this.initAssumptionVars)) {
                    this.assignableState.assignConstant(rightMemLoc, new NumericValue(1L), pE.getExpressionType());
                }
            }
            return super.visit(pE);
        }

        private boolean assumingUnknownToBeZero(Value value1, Value value2) {
            return value1.isUnknown() && value2.equals(new NumericValue(BigInteger.ZERO));
        }

        private boolean isEqualityAssumption(CBinaryExpression.BinaryOperator binaryOperator) {
            return binaryOperator == CBinaryExpression.BinaryOperator.EQUALS && this.truthValue || binaryOperator == CBinaryExpression.BinaryOperator.NOT_EQUALS && !this.truthValue;
        }

        private boolean isNonEqualityAssumption(CBinaryExpression.BinaryOperator binaryOperator) {
            return binaryOperator == CBinaryExpression.BinaryOperator.EQUALS && !this.truthValue || binaryOperator == CBinaryExpression.BinaryOperator.NOT_EQUALS && this.truthValue;
        }

        @Override
        public Value visit(JBinaryExpression pE) {
            JBinaryExpression.BinaryOperator binaryOperator = pE.getOperator();
            JExpression lVarInBinaryExp = pE.getOperand1();
            lVarInBinaryExp = (JExpression)this.unwrap(lVarInBinaryExp);
            JExpression rVarInBinaryExp = pE.getOperand2();
            Value leftValueV = lVarInBinaryExp.accept(this);
            Value rightValueV = rVarInBinaryExp.accept(this);
            if (binaryOperator == JBinaryExpression.BinaryOperator.EQUALS && this.truthValue || binaryOperator == JBinaryExpression.BinaryOperator.NOT_EQUALS && !this.truthValue) {
                if (leftValueV.isUnknown() && rightValueV.isExplicitlyKnown() && this.isAssignableVariable(lVarInBinaryExp)) {
                    this.assignValueToState((AIdExpression)((Object)lVarInBinaryExp), rightValueV);
                } else if (rightValueV.isUnknown() && leftValueV.isExplicitlyKnown() && this.isAssignableVariable(rVarInBinaryExp)) {
                    this.assignValueToState((AIdExpression)((Object)rVarInBinaryExp), leftValueV);
                }
            }
            if (ValueAnalysisTransferRelation.this.initAssumptionVars && (binaryOperator == JBinaryExpression.BinaryOperator.NOT_EQUALS && this.truthValue || binaryOperator == JBinaryExpression.BinaryOperator.EQUALS && !this.truthValue)) {
                if (leftValueV.isUnknown() && rightValueV.isExplicitlyKnown() && this.isAssignableVariable(lVarInBinaryExp)) {
                    assert (rightValueV instanceof BooleanValue);
                    BooleanValue booleanValueRight = (BooleanValue)BooleanValue.valueOf(rightValueV).get();
                    if (!booleanValueRight.isTrue()) {
                        this.assignValueToState((AIdExpression)((Object)lVarInBinaryExp), BooleanValue.valueOf(true));
                    }
                } else if (rightValueV.isUnknown() && leftValueV.isExplicitlyKnown() && this.isAssignableVariable(rVarInBinaryExp)) {
                    assert (leftValueV instanceof BooleanValue);
                    BooleanValue booleanValueLeft = (BooleanValue)BooleanValue.valueOf(leftValueV).get();
                    if (!booleanValueLeft.isTrue()) {
                        this.assignValueToState((AIdExpression)((Object)rVarInBinaryExp), BooleanValue.valueOf(true));
                    }
                }
            }
            return super.visit(pE);
        }

        private void assignValueToState(AIdExpression pIdExpression, Value pValue) {
            ASimpleDeclaration declaration = pIdExpression.getDeclaration();
            if (declaration != null) {
                this.assignableState.assignConstant(declaration.getQualifiedName(), pValue);
            } else {
                ValueAnalysisState.MemoryLocation memLoc = ValueAnalysisState.MemoryLocation.valueOf(this.getFunctionName(), pIdExpression.getName(), 0L);
                this.assignableState.assignConstant(memLoc, pValue, pIdExpression.getExpressionType());
            }
        }

        protected ValueAnalysisState.MemoryLocation getMemoryLocation(CExpression pLValue) throws UnrecognizedCCodeException {
            ExpressionValueVisitor v = ValueAnalysisTransferRelation.this.getVisitor();
            assert (pLValue instanceof CLeftHandSide);
            return (ValueAnalysisState.MemoryLocation)Preconditions.checkNotNull((Object)v.evaluateMemoryLocation(pLValue));
        }

        protected boolean isAssignableVariable(JExpression expression) {
            boolean result = false;
            if (expression instanceof JIdExpression) {
                JSimpleDeclaration decl = ((JIdExpression)expression).getDeclaration();
                result = decl == null ? false : (decl instanceof JFieldDeclaration ? ((JFieldDeclaration)decl).isStatic() : true);
            }
            return result;
        }

        protected boolean isAssignable(CExpression expression) throws UnrecognizedCCodeException {
            if (expression instanceof CIdExpression) {
                return true;
            }
            if (expression instanceof CFieldReference || expression instanceof CArraySubscriptExpression) {
                ExpressionValueVisitor evv = ValueAnalysisTransferRelation.this.getVisitor();
                return evv.canBeEvaluated(expression);
            }
            return false;
        }
    }
}

