/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.refiner;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.UnmodifiableListIterator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.counterexample.Address;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteState;
import org.sosy_lab.cpachecker.core.counterexample.ConcreteStatePath;
import org.sosy_lab.cpachecker.core.counterexample.IDExpression;
import org.sosy_lab.cpachecker.core.counterexample.LeftHandSide;
import org.sosy_lab.cpachecker.core.counterexample.Memory;
import org.sosy_lab.cpachecker.core.counterexample.MemoryName;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class ValueAnalysisConcreteErrorPathAllocator {
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private MemoryName memoryName = new MemoryName(){

        @Override
        public String getMemoryName(CRightHandSide pExp, Address pAddress) {
            return "Value_Analysis_Heap";
        }
    };

    public ValueAnalysisConcreteErrorPathAllocator(LogManager pLogger, ShutdownNotifier pShutdownNotifier) {
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
    }

    public ConcreteStatePath allocateAssignmentsToPath(ARGPath pPath) {
        ArrayList<Pair<ValueAnalysisState, CFAEdge>> path = new ArrayList<Pair<ValueAnalysisState, CFAEdge>>(pPath.size());
        ARGPath.PathIterator it = pPath.pathIterator();
        while (it.hasNext()) {
            it.advance();
            ValueAnalysisState state = AbstractStates.extractStateByType(it.getAbstractState(), ValueAnalysisState.class);
            CFAEdge edge = it.getIncomingEdge();
            if (state == null) {
                return null;
            }
            path.add((Pair<ValueAnalysisState, CFAEdge>)Pair.of((Object)state, (Object)edge));
        }
        return this.createConcreteStatePath(path);
    }

    public Model allocateAssignmentsToPath(List<Pair<ValueAnalysisState, CFAEdge>> pPath, MachineModel pMachineModel) throws InterruptedException {
        pPath.remove(pPath.size() - 1);
        ConcreteStatePath concreteStatePath = this.createConcreteStatePath(pPath);
        CFAPathWithAssumptions pathWithAssignments = CFAPathWithAssumptions.of(concreteStatePath, this.logger, pMachineModel);
        Model model = Model.empty();
        return model.withAssignmentInformation(pathWithAssignments);
    }

    private ConcreteStatePath createConcreteStatePath(List<Pair<ValueAnalysisState, CFAEdge>> pPath) {
        ArrayList<ConcreteStatePath.ConcerteStatePathNode> result = new ArrayList<ConcreteStatePath.ConcerteStatePathNode>(pPath.size());
        Map<LeftHandSide, Address> variableAddresses = this.generateVariableAddresses(pPath);
        for (Pair<ValueAnalysisState, CFAEdge> edgeStatePair : pPath) {
            ConcreteStatePath.ConcerteStatePathNode node;
            ValueAnalysisState valueState = (ValueAnalysisState)edgeStatePair.getFirst();
            CFAEdge edge = (CFAEdge)edgeStatePair.getSecond();
            if (edge.getEdgeType() == CFAEdgeType.MultiEdge) {
                node = this.createMultiEdge(valueState, (MultiEdge)edge, variableAddresses);
            } else {
                ConcreteState concreteState = this.createConcreteState(valueState, variableAddresses);
                node = ConcreteStatePath.valueOfPathNode(concreteState, edge);
            }
            result.add(node);
        }
        return new ConcreteStatePath(result);
    }

    private ConcreteStatePath.ConcerteStatePathNode createMultiEdge(ValueAnalysisState pValueState, MultiEdge multiEdge, Map<LeftHandSide, Address> pVariableAddresses) {
        int size = multiEdge.getEdges().size();
        ConcreteState[] singleConcreteStates = new ConcreteState[size];
        UnmodifiableListIterator iterator = multiEdge.getEdges().listIterator(size);
        HashSet<CLeftHandSide> alreadyAssigned = new HashSet<CLeftHandSide>();
        int index = size - 1;
        while (iterator.hasPrevious()) {
            CFAEdge cfaEdge = (CFAEdge)iterator.previous();
            ConcreteState state = this.allValuesForLeftHandSideKnown(cfaEdge, alreadyAssigned) ? this.createConcreteState(pValueState, pVariableAddresses) : ConcreteState.empty();
            singleConcreteStates[index] = state;
            this.addLeftHandSide(cfaEdge, alreadyAssigned);
            --index;
        }
        return ConcreteStatePath.valueOfPathNode(Arrays.asList(singleConcreteStates), multiEdge);
    }

    private boolean allValuesForLeftHandSideKnown(CFAEdge pCfaEdge, Set<CLeftHandSide> pAlreadyAssigned) {
        if (pCfaEdge.getEdgeType() == CFAEdgeType.DeclarationEdge) {
            return this.isDeclarationValueKnown((CDeclarationEdge)pCfaEdge, pAlreadyAssigned);
        }
        if (pCfaEdge.getEdgeType() == CFAEdgeType.StatementEdge) {
            return this.isStatementValueKnown((CStatementEdge)pCfaEdge, pAlreadyAssigned);
        }
        return false;
    }

    private void addLeftHandSide(CFAEdge pCfaEdge, Set<CLeftHandSide> pAlreadyAssigned) {
        CStatement stmt;
        if (pCfaEdge.getEdgeType() == CFAEdgeType.StatementEdge && (stmt = ((CStatementEdge)pCfaEdge).getStatement()) instanceof CAssignment) {
            CLeftHandSide lhs = ((CAssignment)stmt).getLeftHandSide();
            pAlreadyAssigned.add(lhs);
        }
    }

    private boolean isStatementValueKnown(CStatementEdge pCfaEdge, Set<CLeftHandSide> pAlreadyAssigned) {
        CStatement stmt = pCfaEdge.getStatement();
        if (stmt instanceof CAssignment) {
            CLeftHandSide leftHandSide = ((CAssignment)stmt).getLeftHandSide();
            return this.isLeftHandSideValueKnown(leftHandSide, pAlreadyAssigned);
        }
        return false;
    }

    private boolean isLeftHandSideValueKnown(CLeftHandSide pLHS, Set<CLeftHandSide> pAlreadyAssigned) {
        ValueKnownVisitor v = new ValueKnownVisitor(pAlreadyAssigned);
        return pLHS.accept(v);
    }

    private boolean isDeclarationValueKnown(CDeclarationEdge pCfaEdge, Set<CLeftHandSide> pAlreadyAssigned) {
        CDeclaration dcl = pCfaEdge.getDeclaration();
        if (dcl instanceof CVariableDeclaration) {
            CIdExpression idExp = new CIdExpression(dcl.getFileLocation(), dcl);
            return this.isLeftHandSideValueKnown(idExp, pAlreadyAssigned);
        }
        return false;
    }

    private Map<LeftHandSide, Address> generateVariableAddresses(List<Pair<ValueAnalysisState, CFAEdge>> pPath) {
        Multimap<IDExpression, ValueAnalysisState.MemoryLocation> memoryLocationsInPath = this.getAllMemoryLocationInPath(pPath);
        return this.generateVariableAddresses(memoryLocationsInPath);
    }

    private Map<LeftHandSide, Address> generateVariableAddresses(Multimap<IDExpression, ValueAnalysisState.MemoryLocation> pMemoryLocationsInPath) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)pMemoryLocationsInPath.size());
        Address nextAddressToBeAssigned = Address.valueOf(BigInteger.ZERO);
        for (IDExpression variable : pMemoryLocationsInPath.keySet()) {
            result.put(variable, nextAddressToBeAssigned);
            nextAddressToBeAssigned = this.generateNextAddresses(pMemoryLocationsInPath.get((Object)variable), nextAddressToBeAssigned);
        }
        return result;
    }

    private Address generateNextAddresses(Collection<ValueAnalysisState.MemoryLocation> pCollection, Address pNextAddressToBeAssigned) {
        long biggestStoredOffsetInPath = 0L;
        for (ValueAnalysisState.MemoryLocation loc : pCollection) {
            if (loc.getOffset() <= biggestStoredOffsetInPath) continue;
            biggestStoredOffsetInPath = loc.getOffset();
        }
        long spaceForLastValue = 64L;
        BigInteger offset = BigInteger.valueOf(biggestStoredOffsetInPath + spaceForLastValue);
        return pNextAddressToBeAssigned.addOffset(offset);
    }

    private Multimap<IDExpression, ValueAnalysisState.MemoryLocation> getAllMemoryLocationInPath(List<Pair<ValueAnalysisState, CFAEdge>> pPath) {
        HashMultimap result = HashMultimap.create();
        for (Pair<ValueAnalysisState, CFAEdge> edgeStatePair : pPath) {
            ValueAnalysisState valueState = (ValueAnalysisState)edgeStatePair.getFirst();
            for (ValueAnalysisState.MemoryLocation loc : valueState.getConstantsMapView().keySet()) {
                IDExpression idExp = this.createBaseIdExpresssion(loc);
                if (result.containsEntry((Object)idExp, (Object)loc)) continue;
                result.put((Object)idExp, (Object)loc);
            }
        }
        return result;
    }

    private IDExpression createBaseIdExpresssion(ValueAnalysisState.MemoryLocation pLoc) {
        if (!pLoc.isOnFunctionStack()) {
            return new IDExpression(pLoc.getIdentifier());
        }
        return new IDExpression(pLoc.getIdentifier(), pLoc.getFunctionName());
    }

    private ConcreteState createConcreteState(ValueAnalysisState pValueState, Map<LeftHandSide, Address> pVariableAddressMap) {
        ImmutableMap variables = ImmutableMap.of();
        Map<String, Memory> allocatedMemory = this.allocateAddresses(pValueState, pVariableAddressMap);
        return new ConcreteState((Map<LeftHandSide, Object>)variables, allocatedMemory, pVariableAddressMap, this.memoryName);
    }

    private Map<String, Memory> allocateAddresses(ValueAnalysisState pValueState, Map<LeftHandSide, Address> pVariableAddressMap) {
        Map<Address, Object> values = this.createHeapValues(pValueState, pVariableAddressMap);
        Memory heap = new Memory(this.memoryName.getMemoryName(null, null), values);
        HashMap<String, Memory> result = new HashMap<String, Memory>();
        result.put(heap.getName(), heap);
        return result;
    }

    private Map<Address, Object> createHeapValues(ValueAnalysisState pValueState, Map<LeftHandSide, Address> pVariableAddressMap) {
        Map<ValueAnalysisState.MemoryLocation, Value> valueView = pValueState.getConstantsMapView();
        HashMap<Address, Object> result = new HashMap<Address, Object>();
        for (Map.Entry<ValueAnalysisState.MemoryLocation, Value> entry : valueView.entrySet()) {
            ValueAnalysisState.MemoryLocation heapLoc = entry.getKey();
            Value valueAsValue = entry.getValue();
            if (!valueAsValue.isNumericValue()) continue;
            Number value = valueAsValue.asNumericValue().getNumber();
            IDExpression lhs = this.createBaseIdExpresssion(heapLoc);
            assert (pVariableAddressMap.containsKey(lhs));
            Address baseAddress = pVariableAddressMap.get(lhs);
            Address address = baseAddress.addOffset(BigInteger.valueOf(heapLoc.getOffset()));
            result.put(address, value);
        }
        return result;
    }

    private static class ValueKnownVisitor
    extends DefaultCExpressionVisitor<Boolean, RuntimeException> {
        private final Set<CLeftHandSide> alreadyAssigned;

        public ValueKnownVisitor(Set<CLeftHandSide> pAlreadyAssigned) {
            this.alreadyAssigned = pAlreadyAssigned;
        }

        @Override
        protected Boolean visitDefault(CExpression pExp) {
            return true;
        }

        @Override
        public Boolean visit(CArraySubscriptExpression pE) {
            return !this.alreadyAssigned.contains(pE);
        }

        @Override
        public Boolean visit(CBinaryExpression pE) {
            return pE.getOperand1().accept(this) != false && pE.getOperand2().accept(this) != false;
        }

        @Override
        public Boolean visit(CCastExpression pE) {
            return pE.getOperand().accept(this);
        }

        @Override
        public Boolean visit(CFieldReference pE) {
            return !this.alreadyAssigned.contains(pE);
        }

        @Override
        public Boolean visit(CIdExpression pE) {
            return !this.alreadyAssigned.contains(pE);
        }

        @Override
        public Boolean visit(CPointerExpression pE) {
            return !this.alreadyAssigned.contains(pE);
        }

        @Override
        public Boolean visit(CUnaryExpression pE) {
            return pE.getOperand().accept(this);
        }
    }
}

