/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.refiner;

import java.util.Collection;
import javax.annotation.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.counterexample.Model;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.AbstractARGBasedRefiner;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractionRefinementStrategy;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPARefiner;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateStaticRefiner;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPA;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisConcreteErrorPathAllocator;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisRefiner;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisStaticRefiner;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.ValueAnalysisFeasibilityChecker;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.predicates.PathChecker;
import org.sosy_lab.cpachecker.util.predicates.Solver;
import org.sosy_lab.cpachecker.util.predicates.interfaces.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.interpolation.InterpolationManager;

@Options(prefix="cpa.value.refiner")
public class ValueAnalysisDelegatingRefiner
extends AbstractARGBasedRefiner
implements StatisticsProvider {
    private ShutdownNotifier shutDownNotifier;
    private ValueAnalysisStaticRefiner staticRefiner;
    private ValueAnalysisRefiner valueRefiner;
    private PredicateCPARefiner predicatingRefiner;
    @Option(secure=true, description="whether or not to check for repeated refinements, to then reset the refinement root")
    private boolean checkForRepeatedRefinements = true;
    private final CFA cfa;
    private final LogManager logger;
    private final Configuration config;

    public static ValueAnalysisDelegatingRefiner create(ConfigurableProgramAnalysis cpa) throws CPAException, InvalidConfigurationException {
        if (!(cpa instanceof WrapperCPA)) {
            throw new InvalidConfigurationException(ValueAnalysisDelegatingRefiner.class.getSimpleName() + " could not find the ValueAnalysisCPA");
        }
        WrapperCPA wrapperCpa = (WrapperCPA)((Object)cpa);
        ValueAnalysisCPA valueAnalysisCpa = wrapperCpa.retrieveWrappedCpa(ValueAnalysisCPA.class);
        if (valueAnalysisCpa == null) {
            throw new InvalidConfigurationException(ValueAnalysisDelegatingRefiner.class.getSimpleName() + " needs a ValueAnalysisCPA");
        }
        ValueAnalysisDelegatingRefiner refiner = ValueAnalysisDelegatingRefiner.initialiseValueAnalysisRefiner(cpa, valueAnalysisCpa);
        valueAnalysisCpa.getStats().addRefiner(refiner);
        return refiner;
    }

    private static PredicateCPARefiner createBackupRefiner(Configuration config, LogManager logger, ConfigurableProgramAnalysis cpa) throws CPAException, InvalidConfigurationException {
        PredicateCPA predicateCpa = ((WrapperCPA)((Object)cpa)).retrieveWrappedCpa(PredicateCPA.class);
        if (predicateCpa == null) {
            return null;
        }
        Solver solver = predicateCpa.getSolver();
        PathFormulaManager pathFormulaManager = predicateCpa.getPathFormulaManager();
        PredicateStaticRefiner extractor = predicateCpa.getStaticRefiner();
        MachineModel machineModel = predicateCpa.getMachineModel();
        InterpolationManager manager = new InterpolationManager(pathFormulaManager, solver, config, predicateCpa.getShutdownNotifier(), logger);
        PathChecker pathChecker = new PathChecker(logger, predicateCpa.getShutdownNotifier(), pathFormulaManager, solver, machineModel);
        PredicateAbstractionRefinementStrategy backupRefinementStrategy = new PredicateAbstractionRefinementStrategy(config, logger, predicateCpa.getShutdownNotifier(), predicateCpa.getPredicateManager(), extractor, solver);
        return new PredicateCPARefiner(config, logger, cpa, manager, pathChecker, pathFormulaManager, backupRefinementStrategy, solver, predicateCpa.getAssumesStore(), predicateCpa.getCfa());
    }

    private static ValueAnalysisDelegatingRefiner initialiseValueAnalysisRefiner(ConfigurableProgramAnalysis cpa, ValueAnalysisCPA pValueAnalysisCpa) throws CPAException, InvalidConfigurationException {
        Configuration config = pValueAnalysisCpa.getConfiguration();
        LogManager logger = pValueAnalysisCpa.getLogger();
        PredicateCPARefiner backupRefiner = ValueAnalysisDelegatingRefiner.createBackupRefiner(config, logger, cpa);
        pValueAnalysisCpa.injectRefinablePrecision();
        return new ValueAnalysisDelegatingRefiner(config, logger, pValueAnalysisCpa.getShutdownNotifier(), cpa, backupRefiner, pValueAnalysisCpa.getCFA());
    }

    protected ValueAnalysisDelegatingRefiner(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, ConfigurableProgramAnalysis pCpa, @Nullable PredicateCPARefiner pBackupRefiner, CFA pCfa) throws CPAException, InvalidConfigurationException {
        super(pCpa);
        pConfig.inject((Object)this);
        this.config = pConfig;
        this.logger = pLogger;
        this.shutDownNotifier = pShutdownNotifier;
        this.cfa = pCfa;
        this.valueRefiner = new ValueAnalysisRefiner(pConfig, pLogger, pShutdownNotifier, pCfa);
        this.staticRefiner = new ValueAnalysisStaticRefiner(pConfig, pLogger);
        this.predicatingRefiner = pBackupRefiner;
    }

    @Override
    protected CounterexampleInfo performRefinement(ARGReachedSet reached, ARGPath pErrorPath) throws CPAException, InterruptedException {
        boolean isRefined;
        boolean bl = isRefined = this.staticRefiner.performRefinement(reached, pErrorPath) || this.valueRefiner.performRefinement(reached);
        if (isRefined) {
            return CounterexampleInfo.spurious();
        }
        if (this.predicatingRefiner != null) {
            return this.predicatingRefiner.performRefinement(reached, pErrorPath);
        }
        try {
            return CounterexampleInfo.feasible(pErrorPath, this.createModel(pErrorPath));
        }
        catch (InvalidConfigurationException e) {
            throw new CPAException("Failed to configure feasbility checker", e);
        }
    }

    private Model createModel(ARGPath errorPath) throws InvalidConfigurationException, InterruptedException, CPAException {
        ValueAnalysisFeasibilityChecker evaluator = new ValueAnalysisFeasibilityChecker(this.logger, this.cfa, this.config);
        ValueAnalysisConcreteErrorPathAllocator va = new ValueAnalysisConcreteErrorPathAllocator(this.logger, this.shutDownNotifier);
        return va.allocateAssignmentsToPath(evaluator.evaluate(errorPath), this.cfa.getMachineModel());
    }

    boolean isPathFeasable(ARGPath path) throws CPAException {
        try {
            ValueAnalysisFeasibilityChecker checker = new ValueAnalysisFeasibilityChecker(this.logger, this.cfa, this.config);
            return checker.isFeasible(path);
        }
        catch (InterruptedException | InvalidConfigurationException e) {
            throw new CPAException("counterexample-check failed: ", e);
        }
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        this.valueRefiner.collectStatistics(pStatsCollection);
        if (this.predicatingRefiner != null) {
            this.predicatingRefiner.collectStatistics(pStatsCollection);
        }
    }
}

