/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.refiner;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.defaults.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.WrapperCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPA;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.refiner.UnsoundRefiner;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisInterpolant;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisInterpolationTree;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisPathInterpolator;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisRefiner;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.ValueAnalysisFeasibilityChecker;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.Precisions;

@Options(prefix="cpa.value.refinement")
public class ValueAnalysisImpactRefiner
implements UnsoundRefiner,
StatisticsProvider {
    @Option(secure=true, description="whether or not to do lazy-abstraction", name="restart", toUppercase=true)
    private ValueAnalysisRefiner.RestartStrategy restartStrategy = ValueAnalysisRefiner.RestartStrategy.TOP;
    @Option(secure=true, description="whether to use the top-down interpolation strategy or the bottom-up interpolation strategy")
    private boolean useTopDownInterpolationStrategy = true;
    @Option(secure=true, description="globalPrec")
    private boolean useGlobalPrecision = false;
    @Option(secure=true, description="when to export the interpolation tree\nNEVER:   never export the interpolation tree\nFINAL:   export the interpolation tree once after each refinement\nALWAYD:  export the interpolation tree once after each interpolation, i.e. multiple times per refinmenet", values={"NEVER", "FINAL", "ALWAYS"})
    private String exportInterpolationTree = "NEVER";
    @Option(secure=true, description="export interpolation trees to this file template")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate interpolationTreeExportFile = PathTemplate.ofFormatString((String)"interpolationTree.%d-%d.dot");
    ValueAnalysisPathInterpolator interpolatingRefiner;
    ValueAnalysisFeasibilityChecker checker;
    private VariableTrackingPrecision globalPrecision = null;
    private final LogManager logger;
    private int refinementCounter = 0;
    private int targetCounter = 0;
    private final Timer totalTime = new Timer();
    private final ARGCPA argCpa;

    public static ValueAnalysisImpactRefiner create(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        ValueAnalysisCPA valueAnalysisCpa = CPAs.retrieveCPA(pCpa, ValueAnalysisCPA.class);
        if (valueAnalysisCpa == null) {
            throw new InvalidConfigurationException(ValueAnalysisImpactRefiner.class.getSimpleName() + " needs a ValueAnalysisCPA");
        }
        valueAnalysisCpa.injectRefinablePrecision();
        ARGCPA argCpa = null;
        if (!(pCpa instanceof WrapperCPA)) {
            throw new InvalidConfigurationException("ARG CPA needed for refinement");
        }
        argCpa = ((WrapperCPA)((Object)pCpa)).retrieveWrappedCpa(ARGCPA.class);
        if (argCpa == null) {
            throw new InvalidConfigurationException("ARG CPA needed for refinement");
        }
        ValueAnalysisImpactRefiner refiner = new ValueAnalysisImpactRefiner(valueAnalysisCpa.getConfiguration(), valueAnalysisCpa.getLogger(), valueAnalysisCpa.getShutdownNotifier(), valueAnalysisCpa.getCFA(), argCpa);
        valueAnalysisCpa.getStats().addRefiner(refiner);
        return refiner;
    }

    private ValueAnalysisImpactRefiner(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa, ARGCPA pArgCpa) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = pLogger;
        this.argCpa = pArgCpa;
        this.interpolatingRefiner = new ValueAnalysisPathInterpolator(pConfig, pLogger, pShutdownNotifier, pCfa);
        this.checker = new ValueAnalysisFeasibilityChecker(pLogger, pCfa, pConfig);
    }

    @Override
    public boolean performRefinement(ReachedSet pReached) throws CPAException, InterruptedException {
        this.logger.log(Level.FINEST, new Object[]{"performing global refinement ..."});
        this.totalTime.start();
        ++this.refinementCounter;
        List<ARGState> targets = this.getErrorStates(pReached);
        this.targetCounter += targets.size();
        if (this.isAnyPathFeasible(new ARGReachedSet(pReached), this.getTargetPaths(targets))) {
            this.totalTime.stop();
            return false;
        }
        ValueAnalysisInterpolationTree interpolationTree = new ValueAnalysisInterpolationTree(this.logger, targets, this.useTopDownInterpolationStrategy);
        HashSet<ARGState> interpolatedTargets = new HashSet<ARGState>();
        while (interpolationTree.hasNextPathForInterpolation()) {
            ARGPath errorPath = interpolationTree.getNextPathForInterpolation();
            if (errorPath == null) {
                this.logger.log(Level.FINEST, new Object[]{"skipping interpolation, error path is empty, because initial interpolant is already false"});
                continue;
            }
            ValueAnalysisInterpolant initialItp = interpolationTree.getInitialInterpolantForPath(errorPath);
            if (this.initialInterpolantIsTooWeak(interpolationTree.getRoot(), initialItp, errorPath)) {
                errorPath = ARGUtils.getOnePathTo(errorPath.getLastState());
                initialItp = ValueAnalysisInterpolant.createInitial();
            }
            this.logger.log(Level.FINEST, new Object[]{"performing interpolation, starting at ", errorPath.getFirstState().getStateId(), ", using interpolant ", initialItp});
            interpolatedTargets.add(errorPath.getLastState());
            interpolationTree.addInterpolants(this.interpolatingRefiner.performInterpolation(errorPath, initialItp));
            if (this.interpolationTreeExportFile != null && this.exportInterpolationTree.equals("ALWAYS")) {
                interpolationTree.exportToDot(this.interpolationTreeExportFile, this.refinementCounter);
            }
            this.logger.log(Level.FINEST, new Object[]{"finished interpolation #"});
        }
        if (this.interpolationTreeExportFile != null && this.exportInterpolationTree.equals("FINAL") && !this.exportInterpolationTree.equals("ALWAYS")) {
            interpolationTree.exportToDot(this.interpolationTreeExportFile, this.refinementCounter);
        }
        this.createGlobalPrecision(pReached, interpolationTree);
        Set<ARGState> strengthenedStates = this.strengthenStates(interpolationTree);
        ARGReachedSet argReachedSet = new ARGReachedSet(pReached, this.argCpa);
        for (ARGState interpolatedTarget : interpolatedTargets) {
            this.tryToCoverArg(strengthenedStates, argReachedSet, interpolatedTarget);
        }
        HashSet<ARGState> weakStates = new HashSet<ARGState>();
        for (Map.Entry<ARGState, ValueAnalysisInterpolant> itp : interpolationTree.getInterpolantMapping()) {
            ARGState currentState = itp.getKey();
            if (interpolationTree.hasInterpolantForState(currentState) && interpolationTree.getInterpolantForState(currentState).isTrivial() || !strengthenedStates.contains(currentState) || currentState.getChildren().size() <= 1) continue;
            VariableTrackingPrecision currentPrecision = this.extractPrecision(pReached, currentState);
            HashMultimap increment = HashMultimap.create();
            for (ValueAnalysisState.MemoryLocation memoryLocation : interpolationTree.getInterpolantForState(currentState).getMemoryLocations()) {
                increment.put((Object)new CFANode("dummy"), (Object)memoryLocation);
            }
            if (!currentState.isCovered()) {
                if (this.useGlobalPrecision) {
                    argReachedSet.readdToWaitlist(currentState, this.globalPrecision, VariableTrackingPrecision.isMatchingCPAClass(ValueAnalysisCPA.class));
                } else {
                    argReachedSet.readdToWaitlist(currentState, currentPrecision.withIncrement((Multimap<CFANode, ValueAnalysisState.MemoryLocation>)increment), VariableTrackingPrecision.isMatchingCPAClass(ValueAnalysisCPA.class));
                }
            }
            weakStates.addAll(currentState.getChildren());
        }
        this.removeInfeasiblePartsOfArg(interpolationTree, argReachedSet);
        weakStates.removeAll(strengthenedStates);
        for (ARGState leave : weakStates) {
            if (leave.isDestroyed()) continue;
            argReachedSet.cutOffSubtree(leave);
        }
        this.totalTime.stop();
        return true;
    }

    private void createGlobalPrecision(ReachedSet pReached, ValueAnalysisInterpolationTree interpolationTree) {
        for (ARGState root : interpolationTree.obtainRefinementRoots(ValueAnalysisRefiner.RestartStrategy.BOTTOM)) {
            Collection<ARGState> targetsReachableFromRoot = interpolationTree.getTargetsInSubtree(root);
            VariableTrackingPrecision subTreePrecision = this.joinSubtreePrecisions(pReached, targetsReachableFromRoot);
            Multimap<CFANode, ValueAnalysisState.MemoryLocation> extractPrecisionIncrement = interpolationTree.extractPrecisionIncrement(root);
            VariableTrackingPrecision currentPrecision = subTreePrecision.withIncrement(extractPrecisionIncrement);
            if (this.globalPrecision != null) {
                currentPrecision = currentPrecision.join(this.globalPrecision);
            }
            this.globalPrecision = currentPrecision;
        }
    }

    @Override
    public void forceRestart(ReachedSet reached) {
        ARGState firstChild = (ARGState)Iterables.getOnlyElement(((ARGState)reached.getFirstState()).getChildren());
        new ARGReachedSet(reached).removeSubtree(firstChild, this.globalPrecision, VariableTrackingPrecision.isMatchingCPAClass(ValueAnalysisCPA.class));
    }

    private Set<ARGState> strengthenStates(ValueAnalysisInterpolationTree interpolationTree) {
        HashSet<ARGState> strengthenedStates = new HashSet<ARGState>();
        for (Map.Entry<ARGState, ValueAnalysisInterpolant> entry : interpolationTree.getInterpolantMapping()) {
            ValueAnalysisState valueState;
            if (entry.getValue().isTrivial()) continue;
            ARGState state = entry.getKey();
            ValueAnalysisInterpolant itp = entry.getValue();
            if (!itp.strengthen(valueState = AbstractStates.extractStateByType(state, ValueAnalysisState.class), state)) continue;
            strengthenedStates.add(state);
        }
        return strengthenedStates;
    }

    private void tryToCoverArg(Set<ARGState> strengthenedStates, ARGReachedSet reached, ARGState lastState) {
        ARGState coverageRoot = null;
        ARGPath errorPath = ARGUtils.getOnePathTo(lastState);
        for (ARGState state : errorPath.asStatesList()) {
            if (!strengthenedStates.contains(state)) continue;
            try {
                if (!state.isCovered() && !reached.tryToCover(state, true)) continue;
                coverageRoot = state;
                break;
            }
            catch (InterruptedException | CPAException e) {
                throw new Error();
            }
        }
        if (coverageRoot != null) {
            for (ARGState children : coverageRoot.getSubgraph()) {
                if (children.isCovered()) continue;
                children.setCovered(coverageRoot);
            }
        }
    }

    private void removeInfeasiblePartsOfArg(ValueAnalysisInterpolationTree interpolationTree, ARGReachedSet reached) {
        for (ARGState root : interpolationTree.obtainCutOffRoots()) {
            reached.cutOffSubtree(root);
        }
    }

    private boolean initialInterpolantIsTooWeak(ARGState root, ValueAnalysisInterpolant initialItp, ARGPath errorPath) throws CPAException, InterruptedException {
        if (errorPath.getFirstState() == root) {
            return false;
        }
        return this.checker.isFeasible(errorPath, initialItp.createValueAnalysisState());
    }

    private VariableTrackingPrecision joinSubtreePrecisions(ReachedSet pReached, Collection<ARGState> targetsReachableFromRoot) {
        VariableTrackingPrecision precision = this.extractPrecision(pReached, (ARGState)Iterables.getLast(targetsReachableFromRoot));
        for (ARGState target : targetsReachableFromRoot) {
            VariableTrackingPrecision precisionOfTarget = this.extractPrecision(pReached, target);
            precision = precision.join(precisionOfTarget);
        }
        return precision;
    }

    private VariableTrackingPrecision extractPrecision(ReachedSet pReached, ARGState state) {
        return (VariableTrackingPrecision)Precisions.asIterable(pReached.getPrecision(state)).filter(VariableTrackingPrecision.isMatchingCPAClass(ValueAnalysisCPA.class)).get(0);
    }

    private boolean isAnyPathFeasible(ARGReachedSet pReached, Collection<ARGPath> errorPaths) throws CPAException, InterruptedException {
        ARGPath feasiblePath = null;
        for (ARGPath currentPath : errorPaths) {
            if (!this.isErrorPathFeasible(currentPath)) continue;
            feasiblePath = currentPath;
        }
        if (feasiblePath != null) {
            for (ARGPath others : errorPaths) {
                if (others == feasiblePath) continue;
                pReached.removeSubtree(others.getLastState());
            }
            return true;
        }
        return false;
    }

    private boolean isErrorPathFeasible(ARGPath errorPath) throws CPAException, InterruptedException {
        if (this.checker.isFeasible(errorPath)) {
            this.logger.log(Level.FINEST, new Object[]{"found a feasible cex - returning from refinement"});
            return true;
        }
        return false;
    }

    private List<ARGPath> getTargetPaths(Collection<ARGState> targetStates) {
        ArrayList<ARGPath> errorPaths = new ArrayList<ARGPath>(targetStates.size());
        for (ARGState target : targetStates) {
            errorPaths.add(ARGUtils.getOnePathTo(target));
        }
        Collections.sort(errorPaths, new Comparator<ARGPath>(){

            @Override
            public int compare(ARGPath path1, ARGPath path2) {
                return path1.size() - path2.size();
            }
        });
        return errorPaths;
    }

    private List<ARGState> getErrorStates(ReachedSet pReached) {
        ImmutableList targets = FluentIterable.from((Iterable)pReached).transform(AbstractStates.toState(ARGState.class)).filter(AbstractStates.IS_TARGET_STATE).toList();
        assert (!targets.isEmpty());
        this.logger.log(Level.FINEST, new Object[]{"number of targets found: " + targets.size()});
        return targets;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(new Statistics(){

            @Override
            public String getName() {
                return "ValueAnalysisGlobalRefiner";
            }

            @Override
            public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, ReachedSet pReached) {
                ValueAnalysisImpactRefiner.this.printStatistics(pOut, pResult, pReached);
            }
        });
    }

    private void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
        if (this.refinementCounter > 0) {
            out.println("Total number of refinements:      " + String.format(Locale.US, "%9d", this.refinementCounter));
            out.println("Total number of targets found:    " + String.format(Locale.US, "%9d", this.targetCounter));
            out.println("Total time for global refinement:     " + this.totalTime);
            this.interpolatingRefiner.printStatistics(out, pResult, pReached);
        }
    }
}

