/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.refiner;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.type.Value;

public class ValueAnalysisInterpolant {
    @Nullable
    private final Map<ValueAnalysisState.MemoryLocation, Value> assignment;
    @Nullable
    private final Map<ValueAnalysisState.MemoryLocation, Type> assignmentTypes;
    public static final ValueAnalysisInterpolant TRUE = new ValueAnalysisInterpolant();
    public static final ValueAnalysisInterpolant FALSE = new ValueAnalysisInterpolant(null, null);

    private ValueAnalysisInterpolant() {
        this.assignment = new HashMap<ValueAnalysisState.MemoryLocation, Value>();
        this.assignmentTypes = new HashMap<ValueAnalysisState.MemoryLocation, Type>();
    }

    public ValueAnalysisInterpolant(Map<ValueAnalysisState.MemoryLocation, Value> pAssignment, Map<ValueAnalysisState.MemoryLocation, Type> pAssignmentToType) {
        this.assignment = pAssignment;
        this.assignmentTypes = pAssignmentToType;
    }

    public static ValueAnalysisInterpolant createInitial() {
        return new ValueAnalysisInterpolant();
    }

    public Set<ValueAnalysisState.MemoryLocation> getMemoryLocations() {
        return this.isFalse() ? Collections.emptySet() : Collections.unmodifiableSet(this.assignment.keySet());
    }

    public ValueAnalysisInterpolant join(ValueAnalysisInterpolant other) {
        if (this.assignment == null || other.assignment == null) {
            return FALSE;
        }
        HashMap<ValueAnalysisState.MemoryLocation, Value> newAssignment = new HashMap<ValueAnalysisState.MemoryLocation, Value>(this.assignment);
        for (Map.Entry<ValueAnalysisState.MemoryLocation, Value> entry : other.assignment.entrySet()) {
            if (newAssignment.containsKey(entry.getKey())) assert (entry.getValue().equals(other.assignment.get(entry.getKey()))) : "interpolants mismatch in " + entry.getKey();
            newAssignment.put(entry.getKey(), entry.getValue());
        }
        HashMap<ValueAnalysisState.MemoryLocation, Type> newAssignmentTypes = new HashMap<ValueAnalysisState.MemoryLocation, Type>();
        for (ValueAnalysisState.MemoryLocation loc : newAssignment.keySet()) {
            if (this.assignmentTypes.containsKey(loc)) {
                newAssignmentTypes.put(loc, this.assignmentTypes.get(loc));
                continue;
            }
            newAssignmentTypes.put(loc, other.assignmentTypes.get(loc));
        }
        return new ValueAnalysisInterpolant(newAssignment, newAssignmentTypes);
    }

    public int hashCode() {
        return Objects.hashCode(this.assignment) + Objects.hashCode(this.assignmentTypes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueAnalysisInterpolant other = (ValueAnalysisInterpolant)obj;
        return Objects.equals(this.assignment, other.assignment) && Objects.equals(this.assignmentTypes, other.assignmentTypes);
    }

    public boolean isTrue() {
        return !this.isFalse() && this.assignment.isEmpty();
    }

    public boolean isFalse() {
        return this.assignment == null;
    }

    public boolean isTrivial() {
        return this.isFalse() || this.isTrue();
    }

    public ValueAnalysisState createValueAnalysisState() {
        return new ValueAnalysisState((PersistentMap<ValueAnalysisState.MemoryLocation, Value>)PathCopyingPersistentTreeMap.copyOf(this.assignment), (PersistentMap<ValueAnalysisState.MemoryLocation, Type>)PathCopyingPersistentTreeMap.copyOf(this.assignmentTypes));
    }

    public String toString() {
        if (this.isFalse()) {
            return "FALSE";
        }
        if (this.isTrue()) {
            return "TRUE";
        }
        return this.assignment.toString();
    }

    public boolean strengthen(ValueAnalysisState valueState, ARGState argState) {
        if (this.isTrivial()) {
            return false;
        }
        boolean strengthened = false;
        for (Map.Entry<ValueAnalysisState.MemoryLocation, Value> itp : this.assignment.entrySet()) {
            if (!valueState.contains(itp.getKey())) {
                valueState.assignConstant(itp.getKey(), itp.getValue(), this.assignmentTypes.get(itp.getKey()));
                strengthened = true;
                continue;
            }
            if (valueState.contains(itp.getKey()) && valueState.getValueFor(itp.getKey()).asNumericValue().longValue() != itp.getValue().asNumericValue().longValue()) assert (false) : "state and interpolant do not match in value for variable " + itp.getKey() + "[state = " + valueState.getValueFor(itp.getKey()).asNumericValue().longValue() + " != " + itp.getValue() + " = itp] for state " + argState.getStateId();
        }
        return strengthened;
    }

    public ValueAnalysisInterpolant weaken(Set<String> toRetain) {
        if (this.isTrivial()) {
            return this;
        }
        ValueAnalysisInterpolant weakenedItp = new ValueAnalysisInterpolant(new HashMap<ValueAnalysisState.MemoryLocation, Value>(this.assignment), new HashMap<ValueAnalysisState.MemoryLocation, Type>(this.assignmentTypes));
        Iterator<ValueAnalysisState.MemoryLocation> it = weakenedItp.assignment.keySet().iterator();
        while (it.hasNext()) {
            ValueAnalysisState.MemoryLocation current = it.next();
            if (toRetain.contains(current.getAsSimpleString())) continue;
            it.remove();
        }
        return weakenedItp;
    }

    public int getSize() {
        return this.isTrivial() ? 0 : this.assignment.size();
    }
}

