/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.refiner;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.io.FileWriteMode;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.MutableARGPath;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisInterpolant;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisRefiner;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;

class ValueAnalysisInterpolationTree {
    private final LogManager logger;
    private int interpolationCounter = 0;
    private final Map<ARGState, ARGState> predecessorRelation = Maps.newLinkedHashMap();
    private final ListMultimap<ARGState, ARGState> successorRelation = ArrayListMultimap.create();
    private final Map<ARGState, ValueAnalysisInterpolant> interpolants = new LinkedHashMap<ARGState, ValueAnalysisInterpolant>();
    private final ARGState root;
    private final Collection<ARGState> targets;
    private final InterpolationStrategy strategy;
    public static final ARGPath EMPTY_PATH = null;

    ValueAnalysisInterpolationTree(LogManager pLogger, Collection<ARGState> pTargets, boolean useTopDownInterpolationStrategy) {
        this.logger = pLogger;
        this.targets = pTargets;
        this.root = this.buildTree();
        this.strategy = useTopDownInterpolationStrategy ? new TopDownInterpolationStrategy() : new BottomUpInterpolationStrategy();
    }

    ARGState getRoot() {
        return this.root;
    }

    public boolean hasNextPathForInterpolation() {
        ++this.interpolationCounter;
        return this.strategy.hasNextPathForInterpolation();
    }

    private ARGState buildTree() {
        ArrayDeque<ARGState> todo = new ArrayDeque<ARGState>(this.targets);
        ARGState itpTreeRoot = null;
        while (!todo.isEmpty()) {
            ARGState currentState = (ARGState)todo.removeFirst();
            if (currentState.getParents().iterator().hasNext()) {
                if (this.predecessorRelation.containsKey(currentState)) continue;
                ARGState parentState = currentState.getParents().iterator().next();
                this.predecessorRelation.put(currentState, parentState);
                this.successorRelation.put((Object)parentState, (Object)currentState);
                todo.addFirst(parentState);
                continue;
            }
            if (itpTreeRoot != null) continue;
            itpTreeRoot = currentState;
        }
        return itpTreeRoot;
    }

    void exportToDot(PathTemplate file, int refinementCounter) {
        StringBuilder result = new StringBuilder().append("digraph tree {\n");
        for (Map.Entry current : this.successorRelation.entries()) {
            if (this.interpolants.containsKey(current.getKey())) {
                StringBuilder sb = new StringBuilder();
                sb.append("itp is " + this.interpolants.get(current.getKey()));
                result.append(((ARGState)current.getKey()).getStateId() + " [label=\"" + ((ARGState)current.getKey()).getStateId() + " / " + AbstractStates.extractLocation((AbstractState)current.getKey()) + " has itp " + sb.toString() + "\"]" + "\n");
                result.append(((ARGState)current.getKey()).getStateId() + " -> " + ((ARGState)current.getValue()).getStateId() + "\n");
            } else {
                result.append(((ARGState)current.getKey()).getStateId() + " [label=\"" + ((ARGState)current.getKey()).getStateId() + " has itp NA\"]" + "\n");
                result.append(((ARGState)current.getKey()).getStateId() + " -> " + ((ARGState)current.getValue()).getStateId() + "\n");
            }
            if (((ARGState)current.getValue()).isTarget()) {
                result.append(((ARGState)current.getValue()).getStateId() + " [style=filled, fillcolor=\"red\"]" + "\n");
            }
            assert (!((ARGState)current.getKey()).isTarget());
        }
        result.append("}");
        try (Writer w = Files.openOutputFile((Path)file.getPath(new Object[]{refinementCounter, this.interpolationCounter}), (FileWriteMode[])new FileWriteMode[0]);){
            w.write(result.toString());
        }
        catch (IOException e) {
            this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write interpolation tree to file");
        }
    }

    ARGPath getNextPathForInterpolation() {
        return this.strategy.getNextPathForInterpolation();
    }

    ValueAnalysisInterpolant getInitialInterpolantForPath(ARGPath errorPath) {
        return this.strategy.getInitialInterpolantForRoot(errorPath.getFirstState());
    }

    void addInterpolants(Map<ARGState, ValueAnalysisInterpolant> interpolantsToAdd) {
        for (Map.Entry<ARGState, ValueAnalysisInterpolant> entry : interpolantsToAdd.entrySet()) {
            ARGState state = entry.getKey();
            ValueAnalysisInterpolant itp = entry.getValue();
            if (this.interpolants.containsKey(state)) {
                this.interpolants.put(state, this.interpolants.get(state).join(itp));
                continue;
            }
            this.interpolants.put(state, itp);
        }
    }

    Multimap<CFANode, ValueAnalysisState.MemoryLocation> extractPrecisionIncrement(ARGState refinmentRoot) {
        HashMultimap increment = HashMultimap.create();
        ArrayDeque<ARGState> todo = new ArrayDeque<ARGState>(Collections.singleton(this.predecessorRelation.get(refinmentRoot)));
        while (!todo.isEmpty()) {
            ARGState currentState = (ARGState)todo.removeFirst();
            if (this.stateHasNonTrivialInterpolant(currentState) && !currentState.isTarget()) {
                ValueAnalysisInterpolant itp = this.interpolants.get(currentState);
                for (ValueAnalysisState.MemoryLocation memoryLocation : itp.getMemoryLocations()) {
                    increment.put((Object)AbstractStates.extractLocation(currentState), (Object)memoryLocation);
                }
            }
            List successors = this.successorRelation.get((Object)currentState);
            todo.addAll(successors);
        }
        return increment;
    }

    Collection<ARGState> obtainRefinementRoots(ValueAnalysisRefiner.RestartStrategy strategy) {
        if (strategy == ValueAnalysisRefiner.RestartStrategy.TOP) {
            assert (this.successorRelation.get((Object)this.root).size() == 1) : "ARG root has more than one successor";
            return new HashSet<ARGState>(Collections.singleton(this.successorRelation.get((Object)this.root).iterator().next()));
        }
        ARGState commonRoot = null;
        HashSet<ARGState> refinementRoots = new HashSet<ARGState>();
        ArrayDeque<ARGState> todo = new ArrayDeque<ARGState>(Collections.singleton(this.root));
        while (!todo.isEmpty()) {
            ARGState currentState = (ARGState)todo.removeFirst();
            if (commonRoot == null && this.successorRelation.get((Object)currentState).size() > 1) {
                commonRoot = currentState;
            }
            if (this.stateHasNonTrivialInterpolant(currentState)) {
                refinementRoots.add(currentState);
                if (strategy != ValueAnalysisRefiner.RestartStrategy.COMMON || refinementRoots.size() <= 2) continue;
                assert (commonRoot != null) : "common root not yet set";
                return new HashSet<ARGState>(Collections.singleton(commonRoot));
            }
            List successors = this.successorRelation.get((Object)currentState);
            todo.addAll(successors);
        }
        return refinementRoots;
    }

    Collection<ARGState> obtainCutOffRoots() {
        HashSet<ARGState> refinementRoots = new HashSet<ARGState>();
        ArrayDeque<ARGState> todo = new ArrayDeque<ARGState>(Collections.singleton(this.root));
        while (!todo.isEmpty()) {
            ARGState currentState = (ARGState)todo.removeFirst();
            if (this.stateHasFalseInterpolant(currentState)) {
                refinementRoots.add(currentState);
                continue;
            }
            List successors = this.successorRelation.get((Object)currentState);
            todo.addAll(successors);
        }
        return refinementRoots;
    }

    Collection<ARGState> getTargetsInSubtree(ARGState state) {
        HashSet<ARGState> targetStates = new HashSet<ARGState>();
        ArrayDeque<ARGState> todo = new ArrayDeque<ARGState>(Collections.singleton(state));
        while (!todo.isEmpty()) {
            ARGState currentState = (ARGState)todo.removeFirst();
            if (currentState.isTarget()) {
                targetStates.add(currentState);
                continue;
            }
            List successors = this.successorRelation.get((Object)currentState);
            todo.addAll(successors);
        }
        return targetStates;
    }

    private boolean stateHasNonTrivialInterpolant(ARGState currentState) {
        return this.interpolants.containsKey(currentState) && !this.interpolants.get(currentState).isTrivial();
    }

    private boolean stateHasFalseInterpolant(ARGState currentState) {
        return this.interpolants.containsKey(currentState) && this.interpolants.get(currentState).isFalse();
    }

    boolean hasInterpolantForState(ARGState currentState) {
        return this.interpolants.containsKey(currentState);
    }

    Set<Map.Entry<ARGState, ValueAnalysisInterpolant>> getInterpolantMapping() {
        return this.interpolants.entrySet();
    }

    ValueAnalysisInterpolant getInterpolantForState(ARGState currentState) {
        return this.interpolants.get(currentState);
    }

    private class BottomUpInterpolationStrategy
    implements InterpolationStrategy {
        private List<ARGState> sources;

        private BottomUpInterpolationStrategy() {
            this.sources = new ArrayList<ARGState>(ValueAnalysisInterpolationTree.this.targets);
        }

        @Override
        public ARGPath getNextPathForInterpolation() {
            ARGState current = this.sources.remove(0);
            assert (current.isTarget()) : "current element is not a target";
            MutableARGPath errorPath = new MutableARGPath();
            errorPath.addFirst(Pair.of((Object)current, (Object)CFAUtils.leavingEdges(AbstractStates.extractLocation(current)).first().orNull()));
            while (ValueAnalysisInterpolationTree.this.predecessorRelation.get(current) != null) {
                ARGState parent = (ARGState)ValueAnalysisInterpolationTree.this.predecessorRelation.get(current);
                if (ValueAnalysisInterpolationTree.this.stateHasFalseInterpolant(parent)) {
                    ValueAnalysisInterpolationTree.this.logger.log(Level.FINEST, new Object[]{"interpolant on path, namely for state ", parent.getStateId(), " is already false, so return empty path"});
                    return EMPTY_PATH;
                }
                errorPath.addFirst(Pair.of((Object)parent, (Object)parent.getEdgeToChild(current)));
                current = parent;
            }
            return errorPath.immutableCopy();
        }

        @Override
        public ValueAnalysisInterpolant getInitialInterpolantForRoot(ARGState root) {
            return ValueAnalysisInterpolant.createInitial();
        }

        @Override
        public boolean hasNextPathForInterpolation() {
            return !this.sources.isEmpty();
        }
    }

    private class TopDownInterpolationStrategy
    implements InterpolationStrategy {
        private Deque<ARGState> sources;

        private TopDownInterpolationStrategy() {
            this.sources = new ArrayDeque<ARGState>(Collections.singleton(ValueAnalysisInterpolationTree.this.root));
        }

        @Override
        public ARGPath getNextPathForInterpolation() {
            MutableARGPath errorPath = new MutableARGPath();
            ARGState current = this.sources.pop();
            if (!this.isValidInterpolationRoot((ARGState)ValueAnalysisInterpolationTree.this.predecessorRelation.get(current))) {
                ValueAnalysisInterpolationTree.this.logger.log(Level.FINEST, new Object[]{"interpolant of predecessor of ", current.getStateId(), " is already false, so return empty path"});
                return EMPTY_PATH;
            }
            if (current != ValueAnalysisInterpolationTree.this.root) {
                errorPath.add(Pair.of(ValueAnalysisInterpolationTree.this.predecessorRelation.get(current), (Object)((ARGState)ValueAnalysisInterpolationTree.this.predecessorRelation.get(current)).getEdgeToChild(current)));
            }
            while (ValueAnalysisInterpolationTree.this.successorRelation.get((Object)current).iterator().hasNext()) {
                Iterator children = ValueAnalysisInterpolationTree.this.successorRelation.get((Object)current).iterator();
                ARGState child = (ARGState)children.next();
                errorPath.add(Pair.of((Object)current, (Object)current.getEdgeToChild(child)));
                int size = 1;
                while (children.hasNext()) {
                    ++size;
                    ARGState sibling = (ARGState)children.next();
                    ValueAnalysisInterpolationTree.this.logger.log(Level.FINEST, new Object[]{"\tpush new root ", sibling.getStateId(), " onto stack for parent ", ((ARGState)ValueAnalysisInterpolationTree.this.predecessorRelation.get(sibling)).getStateId()});
                    this.sources.push(sibling);
                }
                assert (size <= 2);
                current = child;
                if (ValueAnalysisInterpolationTree.this.successorRelation.get((Object)current).iterator().hasNext()) continue;
                errorPath.add(Pair.of((Object)current, (Object)CFAUtils.leavingEdges(AbstractStates.extractLocation(current)).first().orNull()));
            }
            return errorPath.immutableCopy();
        }

        private boolean isValidInterpolationRoot(ARGState root) {
            if (!ValueAnalysisInterpolationTree.this.interpolants.containsKey(root)) {
                return true;
            }
            return !((ValueAnalysisInterpolant)ValueAnalysisInterpolationTree.this.interpolants.get(root)).isFalse();
        }

        @Override
        public ValueAnalysisInterpolant getInitialInterpolantForRoot(ARGState root) {
            ValueAnalysisInterpolant initialInterpolant = (ValueAnalysisInterpolant)ValueAnalysisInterpolationTree.this.interpolants.get(root);
            if (initialInterpolant == null) {
                initialInterpolant = ValueAnalysisInterpolant.createInitial();
                assert (ValueAnalysisInterpolationTree.this.interpolants.size() == 0) : "initial interpolant was null after initial interpolation!";
            }
            return initialInterpolant;
        }

        @Override
        public boolean hasNextPathForInterpolation() {
            return !this.sources.isEmpty();
        }
    }

    private static interface InterpolationStrategy {
        public ARGPath getNextPathForInterpolation();

        public boolean hasNextPathForInterpolation();

        public ValueAnalysisInterpolant getInitialInterpolantForRoot(ARGState var1);
    }
}

