/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.refiner;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.MutableARGPath;
import org.sosy_lab.cpachecker.cpa.conditions.path.AssignmentsInPathCondition;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisInterpolant;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.AssumptionUseDefinitionCollector;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.ErrorPathClassifier;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.InitialAssumptionUseDefinitionCollector;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.ValueAnalysisEdgeInterpolator;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.ValueAnalysisFeasibilityChecker;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.statistics.StatCounter;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;
import org.sosy_lab.cpachecker.util.statistics.StatisticsWriter;

@Options(prefix="cpa.value.refiner")
public class ValueAnalysisPathInterpolator
implements Statistics {
    @Option(secure=true, description="whether or not to do lazy-abstraction")
    private boolean doLazyAbstraction = true;
    @Option(secure=true, description="whether to perform (more precise) edge-based interpolation or (more efficient) path-based interpolation")
    private boolean performEdgeBasedInterpolation = true;
    @Option(secure=true, description="which prefix of an actual counterexample trace should be used for interpolation")
    private ErrorPathClassifier.ErrorPathPrefixPreference prefixPreference = ErrorPathClassifier.ErrorPathPrefixPreference.DOMAIN_BEST_SHALLOW;
    private int interpolationOffset = -1;
    private AssignmentsInPathCondition.UniqueAssignmentsInPathConditionState assignments = null;
    private StatCounter totalInterpolations = new StatCounter("Number of interpolations");
    private StatInt totalInterpolationQueries = new StatInt(StatKind.SUM, "Number of interpolation queries");
    private StatInt sizeOfInterpolant = new StatInt(StatKind.AVG, "Size of interpolant");
    private StatTimer timerInterpolation = new StatTimer("Time for interpolation");
    private StatInt totalPrefixes = new StatInt(StatKind.SUM, "Number of sliced prefixes");
    private final CFA cfa;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final Configuration config;
    private final ValueAnalysisEdgeInterpolator interpolator;

    public ValueAnalysisPathInterpolator(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.config = pConfig;
        this.logger = pLogger;
        this.cfa = pCfa;
        this.shutdownNotifier = pShutdownNotifier;
        this.interpolator = new ValueAnalysisEdgeInterpolator(pConfig, this.logger, this.shutdownNotifier, this.cfa);
    }

    protected Map<ARGState, ValueAnalysisInterpolant> performInterpolation(ARGPath errorPath, ValueAnalysisInterpolant interpolant) throws CPAException, InterruptedException {
        this.totalInterpolations.inc();
        this.timerInterpolation.start();
        this.interpolationOffset = -1;
        ARGPath errorPathPrefix = this.obtainErrorPathPrefix(errorPath, interpolant);
        Map<ARGState, ValueAnalysisInterpolant> pathInterpolants = this.performEdgeBasedInterpolation ? this.performEdgeBasedInterpolation(errorPathPrefix, interpolant) : this.performPathBasedInterpolation(errorPathPrefix);
        this.timerInterpolation.stop();
        return pathInterpolants;
    }

    private Map<ARGState, ValueAnalysisInterpolant> performEdgeBasedInterpolation(ARGPath errorPathPrefix, ValueAnalysisInterpolant interpolant) throws InterruptedException, CPAException {
        HashSet<ValueAnalysisState.MemoryLocation> useDefRelation = new HashSet<ValueAnalysisState.MemoryLocation>();
        LinkedHashMap<ARGState, ValueAnalysisInterpolant> pathInterpolants = new LinkedHashMap<ARGState, ValueAnalysisInterpolant>(errorPathPrefix.size());
        ARGPath.PathIterator pathIterator = errorPathPrefix.pathIterator();
        while (pathIterator.hasNext()) {
            this.shutdownNotifier.shutdownIfNecessary();
            if (!interpolant.isFalse()) {
                interpolant = this.interpolator.deriveInterpolant(errorPathPrefix, pathIterator.getOutgoingEdge(), pathIterator.getIndex(), interpolant, useDefRelation);
            }
            this.totalInterpolationQueries.setNextValue(this.interpolator.getNumberOfInterpolationQueries());
            if (!interpolant.isTrivial() && this.interpolationOffset == -1) {
                this.interpolationOffset = pathIterator.getIndex();
            }
            this.sizeOfInterpolant.setNextValue(interpolant.getSize());
            pathIterator.advance();
            pathInterpolants.put(pathIterator.getAbstractState(), interpolant);
            if (!pathIterator.hasNext()) assert (interpolant.isFalse()) : "final interpolant is not false";
        }
        return pathInterpolants;
    }

    private Map<ARGState, ValueAnalysisInterpolant> performPathBasedInterpolation(ARGPath errorPathPrefix) {
        assert (errorPathPrefix.getFirstState().getParents().isEmpty()) : "static interpolation requires cpa.value.refinement.useTopDownInterpolationStrategy to be set to 'true'";
        AssumptionUseDefinitionCollector useDefinitionCollector = this.prefixPreference == ErrorPathClassifier.ErrorPathPrefixPreference.DEFAULT ? new AssumptionUseDefinitionCollector() : new InitialAssumptionUseDefinitionCollector();
        Multimap<ARGState, ValueAnalysisState.MemoryLocation> fakeInterpolants = useDefinitionCollector.obtainFakeInterpolants(errorPathPrefix);
        LinkedHashMap<ARGState, ValueAnalysisInterpolant> pathInterpolants = new LinkedHashMap<ARGState, ValueAnalysisInterpolant>(errorPathPrefix.size());
        for (ARGState state : Iterables.skip(errorPathPrefix.asStatesList(), (int)1)) {
            ValueAnalysisInterpolant fakeItp = this.createFakeInterpolant(fakeInterpolants.get((Object)state));
            pathInterpolants.put(state, fakeItp);
        }
        this.totalInterpolationQueries.setNextValue(1);
        this.sizeOfInterpolant.setNextValue(fakeInterpolants.size());
        return pathInterpolants;
    }

    private ValueAnalysisInterpolant createFakeInterpolant(Collection<ValueAnalysisState.MemoryLocation> relevantVariables) {
        HashMap<ValueAnalysisState.MemoryLocation, Value> values = new HashMap<ValueAnalysisState.MemoryLocation, Value>();
        for (ValueAnalysisState.MemoryLocation relevantVariable : relevantVariables) {
            values.put(ValueAnalysisState.MemoryLocation.valueOf(relevantVariable.getAsSimpleString()), Value.UnknownValue.getInstance());
        }
        return new ValueAnalysisInterpolant(values, Collections.emptyMap());
    }

    public Multimap<CFANode, ValueAnalysisState.MemoryLocation> determinePrecisionIncrement(MutableARGPath errorPath) throws CPAException, InterruptedException {
        this.assignments = AbstractStates.extractStateByType((AbstractState)((Pair)errorPath.getLast()).getFirst(), AssignmentsInPathCondition.UniqueAssignmentsInPathConditionState.class);
        HashMultimap increment = HashMultimap.create();
        Map<ARGState, ValueAnalysisInterpolant> itps = this.performInterpolation(errorPath.immutableCopy(), ValueAnalysisInterpolant.createInitial());
        for (Map.Entry<ARGState, ValueAnalysisInterpolant> itp : itps.entrySet()) {
            this.addToPrecisionIncrement((Multimap<CFANode, ValueAnalysisState.MemoryLocation>)increment, AbstractStates.extractLocation(itp.getKey()), itp.getValue());
        }
        return increment;
    }

    private void addToPrecisionIncrement(Multimap<CFANode, ValueAnalysisState.MemoryLocation> increment, CFANode currentNode, ValueAnalysisInterpolant itp) {
        for (ValueAnalysisState.MemoryLocation memoryLocation : itp.getMemoryLocations()) {
            if (this.assignments != null && this.assignments.exceedsHardThreshold(memoryLocation)) continue;
            increment.put((Object)currentNode, (Object)memoryLocation);
        }
    }

    public Pair<ARGState, CFAEdge> determineRefinementRoot(MutableARGPath errorPath, Multimap<CFANode, ValueAnalysisState.MemoryLocation> increment, boolean isRepeatedRefinement) throws RefinementFailedException {
        if (this.interpolationOffset == -1) {
            throw new RefinementFailedException(RefinementFailedException.Reason.InterpolationFailed, errorPath.immutableCopy());
        }
        if (this.doLazyAbstraction) {
            return (Pair)errorPath.get(this.interpolationOffset);
        }
        return (Pair)errorPath.get(1);
    }

    private ARGPath obtainErrorPathPrefix(ARGPath errorPath, ValueAnalysisInterpolant interpolant) throws CPAException, InterruptedException {
        try {
            ValueAnalysisFeasibilityChecker checker = new ValueAnalysisFeasibilityChecker(this.logger, this.cfa, this.config);
            List<ARGPath> prefixes = checker.getInfeasilbePrefixes(errorPath);
            this.totalPrefixes.setNextValue(prefixes.size());
            ErrorPathClassifier classifier = new ErrorPathClassifier(this.cfa.getVarClassification(), this.cfa.getLoopStructure());
            errorPath = classifier.obtainPrefix(this.prefixPreference, errorPath, prefixes);
        }
        catch (InvalidConfigurationException e) {
            throw new CPAException("Configuring ValueAnalysisFeasibilityChecker failed: " + e.getMessage(), e);
        }
        return errorPath;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result result, ReachedSet reached) {
        StatisticsWriter writer = StatisticsWriter.writingStatisticsTo(out).beginLevel();
        writer.put(this.timerInterpolation);
        writer.put(this.totalInterpolations);
        writer.put(this.totalInterpolationQueries);
        writer.put(this.sizeOfInterpolant);
        writer.put(this.totalPrefixes);
    }

    public int getInterpolationOffset() {
        return this.interpolationOffset;
    }
}

