/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.refiner;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.defaults.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.predicate.PredicatePrecision;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPA;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisInterpolant;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisInterpolationTree;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisPathInterpolator;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.ErrorPathClassifier;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.ValueAnalysisFeasibilityChecker;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.RefinementFailedException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.Precisions;

@Options(prefix="cpa.value.refinement")
public class ValueAnalysisRefiner
implements Refiner,
StatisticsProvider {
    @Option(secure=true, description="whether or not to do lazy-abstraction", name="restart", toUppercase=true)
    private RestartStrategy restartStrategy = RestartStrategy.BOTTOM;
    @Option(secure=true, description="whether to use the top-down interpolation strategy or the bottom-up interpolation strategy")
    private boolean useTopDownInterpolationStrategy = true;
    @Option(secure=true, description="heuristic to sort targets based on the quality of interpolants deriveable from them")
    private boolean itpSortedTargets = false;
    @Option(secure=true, description="when to export the interpolation tree\nNEVER:   never export the interpolation tree\nFINAL:   export the interpolation tree once after each refinement\nALWAYD:  export the interpolation tree once after each interpolation, i.e. multiple times per refinmenet", values={"NEVER", "FINAL", "ALWAYS"})
    private String exportInterpolationTree = "NEVER";
    @Option(secure=true, description="export interpolation trees to this file template")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate interpolationTreeExportFile = PathTemplate.ofFormatString((String)"interpolationTree.%d-%d.dot");
    private ValueAnalysisPathInterpolator pathInterpolator;
    private ValueAnalysisFeasibilityChecker checker;
    private final LogManager logger;
    private int previousErrorPathId = -1;
    private ErrorPathClassifier classifier;
    private final Set<ARGState> feasibleTargets = new HashSet<ARGState>();
    private final Set<Integer> previousRefinementIds = new HashSet<Integer>();
    private int refinementCounter = 0;
    private int targetCounter = 0;
    private final Timer totalTime = new Timer();
    private int timesRootRelocated = 0;
    private int timesRepeatedRefinements = 0;

    public static ValueAnalysisRefiner create(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        ValueAnalysisCPA valueAnalysisCpa = CPAs.retrieveCPA(pCpa, ValueAnalysisCPA.class);
        if (valueAnalysisCpa == null) {
            throw new InvalidConfigurationException(ValueAnalysisRefiner.class.getSimpleName() + " needs a ValueAnalysisCPA");
        }
        valueAnalysisCpa.injectRefinablePrecision();
        ValueAnalysisRefiner refiner = new ValueAnalysisRefiner(valueAnalysisCpa.getConfiguration(), valueAnalysisCpa.getLogger(), valueAnalysisCpa.getShutdownNotifier(), valueAnalysisCpa.getCFA());
        valueAnalysisCpa.getStats().addRefiner(refiner);
        return refiner;
    }

    ValueAnalysisRefiner(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.logger = pLogger;
        this.pathInterpolator = new ValueAnalysisPathInterpolator(pConfig, pLogger, pShutdownNotifier, pCfa);
        this.checker = new ValueAnalysisFeasibilityChecker(pLogger, pCfa, pConfig);
        this.classifier = new ErrorPathClassifier(pCfa.getVarClassification(), pCfa.getLoopStructure());
    }

    private boolean madeProgress(ARGPath path) {
        boolean progress = this.previousErrorPathId == -1 || this.previousErrorPathId != this.obtainErrorPathId(path);
        this.previousErrorPathId = this.obtainErrorPathId(path);
        return progress;
    }

    @Override
    public boolean performRefinement(ReachedSet pReached) throws CPAException, InterruptedException {
        return this.performRefinement(new ARGReachedSet(pReached));
    }

    public boolean performRefinement(ARGReachedSet pReached) throws CPAException, InterruptedException {
        this.logger.log(Level.FINEST, new Object[]{"performing global refinement ..."});
        this.totalTime.start();
        ++this.refinementCounter;
        Collection<ARGState> targets = this.getTargetStates(pReached);
        List<ARGPath> targetPaths = this.getTargetPaths(targets);
        if (!this.madeProgress(targetPaths.get(0))) {
            throw new RefinementFailedException(RefinementFailedException.Reason.RepeatedCounterexample, targetPaths.get(0));
        }
        if (this.isAnyPathFeasible(pReached, targetPaths)) {
            this.totalTime.stop();
            return false;
        }
        ValueAnalysisInterpolationTree interpolationTree = this.obtainInterpolants(targets);
        this.refineUsingInterpolants(pReached, interpolationTree);
        this.totalTime.stop();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void refineUsingInterpolants(ARGReachedSet pReached, ValueAnalysisInterpolationTree interpolationTree) {
        boolean predicatePrecisionIsAvailable = this.isPredicatePrecisionAvailable(pReached);
        HashMap refinementInformation = new HashMap();
        Collection<ARGState> refinementRoots = interpolationTree.obtainRefinementRoots(this.restartStrategy);
        for (ARGState aRGState : refinementRoots) {
            void var7_7;
            ARGState aRGState2 = this.relocateRefinementRoot(aRGState, predicatePrecisionIsAvailable);
            if (refinementRoots.size() == 1 && this.isSimilarRepeatedRefinement(interpolationTree.extractPrecisionIncrement(aRGState2).values())) {
                ARGState aRGState3 = this.relocateRepeatedRefinementRoot(aRGState2);
            }
            ArrayList<Precision> precisions = new ArrayList<Precision>(2);
            precisions.add(this.mergeValuePrecisionsForSubgraph((ARGState)var7_7, pReached).withIncrement(interpolationTree.extractPrecisionIncrement((ARGState)var7_7)));
            if (predicatePrecisionIsAvailable) {
                precisions.add(this.mergePredictePrecisionsForSubgraph((ARGState)var7_7, pReached));
            }
            refinementInformation.put(var7_7, precisions);
        }
        for (Map.Entry entry : refinementInformation.entrySet()) {
            ArrayList<Predicate<? super Precision>> precisionTypes = new ArrayList<Predicate<? super Precision>>(2);
            precisionTypes.add(VariableTrackingPrecision.isMatchingCPAClass(ValueAnalysisCPA.class));
            if (predicatePrecisionIsAvailable) {
                precisionTypes.add(Predicates.instanceOf(PredicatePrecision.class));
            }
            pReached.removeSubtree((ARGState)entry.getKey(), (List)entry.getValue(), precisionTypes);
        }
    }

    private ValueAnalysisInterpolationTree obtainInterpolants(Collection<ARGState> targets) throws CPAException, InterruptedException {
        ValueAnalysisInterpolationTree interpolationTree = new ValueAnalysisInterpolationTree(this.logger, targets, this.useTopDownInterpolationStrategy);
        while (interpolationTree.hasNextPathForInterpolation()) {
            this.performPathInterpolation(interpolationTree);
        }
        if (this.interpolationTreeExportFile != null && this.exportInterpolationTree.equals("FINAL") && !this.exportInterpolationTree.equals("ALWAYS")) {
            interpolationTree.exportToDot(this.interpolationTreeExportFile, this.refinementCounter);
        }
        return interpolationTree;
    }

    private boolean isPredicatePrecisionAvailable(ARGReachedSet pReached) {
        return Precisions.extractPrecisionByType(pReached.asReachedSet().getPrecision(pReached.asReachedSet().getFirstState()), PredicatePrecision.class) != null;
    }

    private void performPathInterpolation(ValueAnalysisInterpolationTree interpolationTree) throws CPAException, InterruptedException {
        ARGPath errorPath = interpolationTree.getNextPathForInterpolation();
        if (errorPath == ValueAnalysisInterpolationTree.EMPTY_PATH) {
            this.logger.log(Level.FINEST, new Object[]{"skipping interpolation, because false interpolant on path to target state"});
            return;
        }
        ValueAnalysisInterpolant initialItp = interpolationTree.getInitialInterpolantForPath(errorPath);
        if (this.isInitialInterpolantTooWeak(interpolationTree.getRoot(), initialItp, errorPath)) {
            errorPath = ARGUtils.getOnePathTo(errorPath.getLastState());
            initialItp = ValueAnalysisInterpolant.createInitial();
        }
        this.logger.log(Level.FINEST, new Object[]{"performing interpolation, starting at ", errorPath.getFirstState().getStateId(), ", using interpolant ", initialItp});
        interpolationTree.addInterpolants(this.pathInterpolator.performInterpolation(errorPath, initialItp));
        if (this.interpolationTreeExportFile != null && this.exportInterpolationTree.equals("ALWAYS")) {
            interpolationTree.exportToDot(this.interpolationTreeExportFile, this.refinementCounter);
        }
    }

    private boolean isInitialInterpolantTooWeak(ARGState root, ValueAnalysisInterpolant initialItp, ARGPath errorPath) throws CPAException, InterruptedException {
        if (errorPath.getFirstState() == root) {
            return false;
        }
        return this.checker.isFeasible(errorPath, initialItp.createValueAnalysisState());
    }

    private VariableTrackingPrecision mergeValuePrecisionsForSubgraph(ARGState pRefinementRoot, ARGReachedSet pReached) {
        Set uniquePrecisions = Sets.newIdentityHashSet();
        for (ARGState descendant : this.getNonCoveredStatesInSubgraph(pRefinementRoot)) {
            uniquePrecisions.add(this.extractValuePrecision(pReached, descendant));
        }
        VariableTrackingPrecision mergedPrecision = (VariableTrackingPrecision)Iterables.getLast((Iterable)uniquePrecisions);
        for (VariableTrackingPrecision precision : uniquePrecisions) {
            mergedPrecision = mergedPrecision.join(precision);
        }
        return mergedPrecision;
    }

    private PredicatePrecision mergePredictePrecisionsForSubgraph(ARGState pRefinementRoot, ARGReachedSet pReached) {
        PredicatePrecision mergedPrecision = PredicatePrecision.empty();
        Set uniquePrecisions = Sets.newIdentityHashSet();
        for (ARGState descendant : this.getNonCoveredStatesInSubgraph(pRefinementRoot)) {
            uniquePrecisions.add(this.extractPredicatePrecision(pReached, descendant));
        }
        for (PredicatePrecision precision : uniquePrecisions) {
            mergedPrecision = mergedPrecision.mergeWith(precision);
        }
        return mergedPrecision;
    }

    private VariableTrackingPrecision extractValuePrecision(ARGReachedSet pReached, ARGState state) {
        return (VariableTrackingPrecision)Precisions.asIterable(pReached.asReachedSet().getPrecision(state)).filter(VariableTrackingPrecision.isMatchingCPAClass(ValueAnalysisCPA.class)).get(0);
    }

    protected final PredicatePrecision extractPredicatePrecision(ARGReachedSet pReached, ARGState state) {
        return (PredicatePrecision)Precisions.asIterable(pReached.asReachedSet().getPrecision(state)).filter(Predicates.instanceOf(PredicatePrecision.class)).get(0);
    }

    private Collection<ARGState> getNonCoveredStatesInSubgraph(ARGState pRoot) {
        HashSet<ARGState> subgraph = new HashSet<ARGState>();
        for (ARGState state : pRoot.getSubgraph()) {
            if (state.isCovered()) continue;
            subgraph.add(state);
        }
        return subgraph;
    }

    private boolean isSimilarRepeatedRefinement(Collection<ValueAnalysisState.MemoryLocation> currentIncrement) {
        return !this.previousRefinementIds.add(new TreeSet<ValueAnalysisState.MemoryLocation>(currentIncrement).hashCode());
    }

    private ARGState relocateRepeatedRefinementRoot(ARGState currentRoot) {
        ++this.timesRepeatedRefinements;
        int currentRootNumber = AbstractStates.extractLocation(currentRoot).getNodeNumber();
        ARGPath path = ARGUtils.getOnePathTo(currentRoot);
        for (ARGState currentState : path.asStatesList().reverse()) {
            if (currentState == currentRoot || currentRootNumber != AbstractStates.extractLocation(currentState).getNodeNumber()) continue;
            return currentState;
        }
        return (ARGState)Iterables.getOnlyElement(path.getFirstState().getChildren());
    }

    private ARGState relocateRefinementRoot(ARGState pRefinementRoot, boolean predicatePrecisionIsAvailable) {
        if (!predicatePrecisionIsAvailable) {
            return pRefinementRoot;
        }
        if (this.restartStrategy == RestartStrategy.TOP) {
            return pRefinementRoot;
        }
        Set<ARGState> descendants = pRefinementRoot.getSubgraph();
        HashSet<ARGState> coveredStates = new HashSet<ARGState>();
        for (ARGState descendant : descendants) {
            coveredStates.addAll(descendant.getCoveredByThis());
        }
        coveredStates.add(pRefinementRoot);
        if (descendants.containsAll(coveredStates)) {
            return pRefinementRoot;
        }
        HashMap predecessorRelation = Maps.newHashMap();
        LinkedHashMultimap successorRelation = LinkedHashMultimap.create();
        ArrayDeque<ARGState> todo = new ArrayDeque<ARGState>(coveredStates);
        ARGState coverageTreeRoot = null;
        while (!todo.isEmpty()) {
            ARGState currentState = (ARGState)todo.removeFirst();
            if (currentState.getParents().iterator().hasNext()) {
                ARGState parentState = currentState.getParents().iterator().next();
                todo.add(parentState);
                predecessorRelation.put(currentState, parentState);
                successorRelation.put((Object)parentState, (Object)currentState);
                continue;
            }
            if (coverageTreeRoot != null) continue;
            coverageTreeRoot = currentState;
        }
        ARGState newRefinementRoot = coverageTreeRoot;
        while (successorRelation.get(newRefinementRoot).size() == 1 && newRefinementRoot != pRefinementRoot) {
            newRefinementRoot = (ARGState)Iterables.getOnlyElement((Iterable)successorRelation.get((Object)newRefinementRoot));
        }
        ++this.timesRootRelocated;
        return newRefinementRoot;
    }

    private boolean isAnyPathFeasible(ARGReachedSet pReached, Collection<ARGPath> errorPaths) throws CPAException, InterruptedException {
        ARGPath feasiblePath = null;
        for (ARGPath currentPath : errorPaths) {
            if (!this.isErrorPathFeasible(currentPath)) continue;
            if (feasiblePath == null) {
                this.previousErrorPathId = this.obtainErrorPathId(currentPath);
                feasiblePath = currentPath;
            }
            this.feasibleTargets.add(currentPath.getLastState());
        }
        if (feasiblePath != null) {
            for (ARGPath others : errorPaths) {
                if (others == feasiblePath) continue;
                pReached.removeSubtree(others.getLastState());
            }
            return true;
        }
        return false;
    }

    private boolean isErrorPathFeasible(ARGPath errorPath) throws CPAException, InterruptedException {
        if (this.checker.isFeasible(errorPath)) {
            this.logger.log(Level.FINEST, new Object[]{"found a feasible cex - returning from refinement"});
            return true;
        }
        return false;
    }

    private List<ARGPath> getTargetPaths(Collection<ARGState> targetStates) {
        ArrayList<ARGPath> errorPaths = new ArrayList<ARGPath>(targetStates.size());
        for (ARGState target : targetStates) {
            errorPaths.add(ARGUtils.getOnePathTo(target));
        }
        return errorPaths;
    }

    private Collection<ARGState> getTargetStates(ARGReachedSet pReached) {
        Comparator<ARGState> comparator = new Comparator<ARGState>(){

            @Override
            public int compare(ARGState target1, ARGState target2) {
                try {
                    ARGPath path1 = ARGUtils.getOnePathTo(target1);
                    ARGPath path2 = ARGUtils.getOnePathTo(target2);
                    if (ValueAnalysisRefiner.this.itpSortedTargets) {
                        Long score2;
                        List<ARGPath> prefixes1 = ValueAnalysisRefiner.this.checker.getInfeasilbePrefixes(path1);
                        List<ARGPath> prefixes2 = ValueAnalysisRefiner.this.checker.getInfeasilbePrefixes(path2);
                        Long score1 = ValueAnalysisRefiner.this.classifier.obtainScoreForPrefixes(prefixes1, ErrorPathClassifier.ErrorPathPrefixPreference.DOMAIN_BEST_BOUNDED);
                        if (score1.equals(score2 = Long.valueOf(ValueAnalysisRefiner.this.classifier.obtainScoreForPrefixes(prefixes2, ErrorPathClassifier.ErrorPathPrefixPreference.DOMAIN_BEST_BOUNDED)))) {
                            return 0;
                        }
                        if (score1 < score2) {
                            return -1;
                        }
                        return 1;
                    }
                    return path1.size() - path2.size();
                }
                catch (InterruptedException | CPAException e) {
                    throw new AssertionError((Object)e);
                }
            }
        };
        ImmutableList targets = FluentIterable.from((Iterable)pReached.asReachedSet()).transform(AbstractStates.toState(ARGState.class)).filter(AbstractStates.IS_TARGET_STATE).filter(Predicates.not((Predicate)Predicates.in(this.feasibleTargets))).toSortedList((Comparator)comparator);
        assert (!targets.isEmpty());
        this.logger.log(Level.FINEST, new Object[]{"number of targets found: " + targets.size()});
        this.targetCounter += targets.size();
        return targets;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(new Statistics(){

            @Override
            public String getName() {
                return ValueAnalysisRefiner.class.getSimpleName();
            }

            @Override
            public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, ReachedSet pReached) {
                ValueAnalysisRefiner.this.printStatistics(pOut, pResult, pReached);
            }
        });
    }

    private void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, ReachedSet pReached) {
        if (this.refinementCounter > 0) {
            out.println("Total number of refinements:      " + String.format(Locale.US, "%9d", this.refinementCounter));
            out.println("Total number of targets found:    " + String.format(Locale.US, "%9d", this.targetCounter));
            out.println("Time for completing refinement:       " + this.totalTime);
            this.pathInterpolator.printStatistics(out, pResult, pReached);
            out.println("Total number of root relocations: " + String.format(Locale.US, "%9d", this.timesRootRelocated));
            out.println("Total number of similar, repeated refinements: " + String.format(Locale.US, "%9d", this.timesRepeatedRefinements));
        }
    }

    private int obtainErrorPathId(ARGPath path) {
        return path.toString().hashCode();
    }

    public static enum RestartStrategy {
        TOP,
        BOTTOM,
        COMMON;

    }
}

