/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.refiner;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPA;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.StaticRefiner;

@Options(prefix="cpa.value.refiner")
public class ValueAnalysisStaticRefiner
extends StaticRefiner {
    @Option(secure=true, description="use heuristic to extract a precision from the CFA statically on first refinement")
    private boolean performStaticRefinement = false;

    public ValueAnalysisStaticRefiner(Configuration pConfig, LogManager pLogger) throws InvalidConfigurationException {
        super(pConfig, pLogger);
        pConfig.inject((Object)this);
    }

    public boolean performRefinement(ARGReachedSet pReached, ARGPath pErrorPath) throws CPAException {
        if (this.performStaticRefinement) {
            this.logger.log(Level.INFO, new Object[]{"Performing a single static refinement for path based on CFA."});
            VariableTrackingPrecision targetStatePrecision = this.extractTargetStatePrecision(pReached, pErrorPath);
            VariableTrackingPrecision refinedPrecision = targetStatePrecision.withIncrement((Multimap<CFANode, ValueAnalysisState.MemoryLocation>)HashMultimap.create(this.extractIncrementForPathFromCfa(pErrorPath)));
            for (ARGState childOfRoot : Sets.newHashSet(pErrorPath.getFirstState().getChildren())) {
                pReached.removeSubtree(childOfRoot, refinedPrecision, VariableTrackingPrecision.isMatchingCPAClass(ValueAnalysisCPA.class));
            }
            this.performStaticRefinement = false;
            return true;
        }
        return false;
    }

    private VariableTrackingPrecision extractTargetStatePrecision(ARGReachedSet pReached, ARGPath pErrorPath) {
        Precision compositePrecision = pReached.asReachedSet().getPrecision(pErrorPath.getLastState());
        FluentIterable<Precision> precisions = Precisions.asIterable(compositePrecision);
        return (VariableTrackingPrecision)precisions.filter(VariableTrackingPrecision.isMatchingCPAClass(ValueAnalysisCPA.class)).get(0);
    }

    private Multimap<CFANode, ValueAnalysisState.MemoryLocation> extractIncrementForPathFromCfa(ARGPath pPath) throws CPATransferException {
        ARGState targetState = pPath.getLastState();
        assert (AbstractStates.isTargetState(targetState));
        HashMultimap pathIncrement = HashMultimap.create();
        for (AssumeEdge assume : this.getTargetLocationAssumes(targetState)) {
            for (CIdExpression identifier : this.getVariablesOfAssume(assume)) {
                pathIncrement.put((Object)assume.getSuccessor(), (Object)ValueAnalysisState.MemoryLocation.valueOf(identifier.getDeclaration().getQualifiedName()));
            }
        }
        return pathIncrement;
    }

    private Set<AssumeEdge> getTargetLocationAssumes(ARGState targetState) {
        ImmutableList targetNodes = ImmutableList.of((Object)AbstractStates.extractLocation(targetState));
        return new HashSet<AssumeEdge>(this.getTargetLocationAssumes((Collection<CFANode>)targetNodes).values());
    }
}

