/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.refiner.utils;

import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.MultiEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.MutableARGPath;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;

public class AssumptionUseDefinitionCollector {
    private final Set<String> collectedVariables = new HashSet<String>();
    private final Set<String> dependingVariables = new HashSet<String>();
    private HashMultimap<ARGState, ValueAnalysisState.MemoryLocation> fakeInterpolants = HashMultimap.create();
    private int dependenciesResolvedOffset = 0;
    private FunctionReturnEdge previousFunctionReturnEdge = null;

    public Set<String> obtainUseDefInformation(List<CFAEdge> path) {
        this.dependingVariables.clear();
        this.collectedVariables.clear();
        for (int i = path.size() - 1; i >= 0; --i) {
            CFAEdge edge = path.get(i);
            this.collectVariables(null, edge, this.collectedVariables);
            if (((CFAEdge)Iterables.getLast(path)).getEdgeType() != CFAEdgeType.AssumeEdge || !this.dependingVariables.isEmpty()) continue;
            this.dependenciesResolvedOffset = i;
            return this.collectedVariables;
        }
        this.collectedVariables.addAll(this.dependingVariables);
        return this.collectedVariables;
    }

    public Multimap<ARGState, ValueAnalysisState.MemoryLocation> obtainFakeInterpolants(ARGPath path) {
        this.dependingVariables.clear();
        this.collectedVariables.clear();
        this.fakeInterpolants.clear();
        List<CFAEdge> edgesList = path.asEdgesList();
        ImmutableList<ARGState> statesList = path.asStatesList();
        for (int i = path.size() - 1; i >= 0; --i) {
            this.collectVariables((ARGState)statesList.get(i), edgesList.get(i), this.collectedVariables);
            if (((CFAEdge)Iterables.getLast(edgesList)).getEdgeType() != CFAEdgeType.AssumeEdge || !this.dependingVariables.isEmpty()) continue;
            this.dependenciesResolvedOffset = i;
            return this.fakeInterpolants;
        }
        return this.fakeInterpolants;
    }

    public Set<String> obtainUseDefInformation(MutableARGPath pFullArgPath) {
        return this.obtainUseDefInformation((List<CFAEdge>)FluentIterable.from((Iterable)pFullArgPath).transform(Pair.getProjectionToSecond()).toList());
    }

    public int getDependenciesResolvedOffset() {
        return this.dependenciesResolvedOffset;
    }

    private boolean isIncompletePath(List<CFAEdge> path) {
        return path.get(0).getPredecessor().getNumEnteringEdges() > 0;
    }

    private void collectVariables(ARGState state, CFAEdge edge, Set<String> collectedVariables) {
        switch (edge.getEdgeType()) {
            case BlankEdge: 
            case CallToReturnEdge: {
                break;
            }
            case FunctionReturnEdge: {
                this.previousFunctionReturnEdge = (FunctionReturnEdge)edge;
                this.fakeInterpolants.put((Object)state, (Object)ValueAnalysisState.MemoryLocation.valueOf(edge.getPredecessor().getFunctionName() + "::__retval__"));
                break;
            }
            case DeclarationEdge: {
                CInitializerExpression initializer;
                String variableName;
                CDeclaration declaration = ((CDeclarationEdge)edge).getDeclaration();
                if (!(declaration instanceof CVariableDeclaration) || declaration.getName() == null || !this.dependingVariables.contains(variableName = declaration.getQualifiedName())) break;
                this.dependingVariables.remove(variableName);
                collectedVariables.add(variableName);
                if (!(((CVariableDeclaration)declaration).getInitializer() instanceof CInitializerExpression) || (initializer = (CInitializerExpression)((CVariableDeclaration)declaration).getInitializer()) == null) break;
                this.collectVariables(edge, initializer.getExpression());
                break;
            }
            case ReturnStatementEdge: {
                String assignedVariable;
                CFunctionCallAssignmentStatement funcAssign;
                CReturnStatementEdge returnStatementEdge = (CReturnStatementEdge)edge;
                if (this.previousFunctionReturnEdge == null) break;
                CFunctionSummaryEdge cFunctionSummaryEdge = (CFunctionSummaryEdge)this.previousFunctionReturnEdge.getSummaryEdge();
                CFunctionCall functionCall = cFunctionSummaryEdge.getExpression();
                if (functionCall instanceof CFunctionCallAssignmentStatement && (funcAssign = (CFunctionCallAssignmentStatement)functionCall).getLeftHandSide() instanceof CIdExpression && this.dependingVariables.contains(assignedVariable = ((CIdExpression)funcAssign.getLeftHandSide()).getDeclaration().getQualifiedName())) {
                    this.dependingVariables.remove(assignedVariable);
                    collectedVariables.add(assignedVariable);
                    Optional<? extends AVariableDeclaration> returnVarName = returnStatementEdge.getSuccessor().getEntryNode().getReturnVariable();
                    if (returnVarName.isPresent()) {
                        collectedVariables.add(((AVariableDeclaration)returnVarName.get()).getQualifiedName());
                        this.fakeInterpolants.put((Object)state, (Object)ValueAnalysisState.MemoryLocation.valueOf(((AVariableDeclaration)returnVarName.get()).getQualifiedName()));
                    }
                    if (returnStatementEdge.getExpression().isPresent()) {
                        this.collectVariables(returnStatementEdge, (CRightHandSide)returnStatementEdge.getExpression().get());
                    }
                }
                this.previousFunctionReturnEdge = null;
                break;
            }
            case FunctionCallEdge: {
                CFunctionCallEdge functionCallEdge = (CFunctionCallEdge)edge;
                CFunctionDeclaration functionDefinition = functionCallEdge.getSuccessor().getFunctionDefinition();
                int j = 0;
                for (CParameterDeclaration parameter : functionDefinition.getParameters()) {
                    if (this.dependingVariables.contains(parameter.getQualifiedName())) {
                        this.dependingVariables.remove(parameter.getQualifiedName());
                        collectedVariables.add(parameter.getQualifiedName());
                        this.collectVariables(functionCallEdge, functionCallEdge.getArguments().get(j));
                    }
                    ++j;
                }
                break;
            }
            case AssumeEdge: {
                this.handleAssumption(edge);
                break;
            }
            case StatementEdge: {
                String assignedVariable;
                CAssignment assignment;
                CStatementEdge statementEdge = (CStatementEdge)edge;
                if (!(statementEdge.getStatement() instanceof CAssignment) || !((assignment = (CAssignment)statementEdge.getStatement()).getLeftHandSide() instanceof CIdExpression) || !this.dependingVariables.contains(assignedVariable = ((CIdExpression)assignment.getLeftHandSide()).getDeclaration().getQualifiedName())) break;
                this.dependingVariables.remove(assignedVariable);
                collectedVariables.add(assignedVariable);
                this.collectVariables(statementEdge, assignment.getRightHandSide());
                break;
            }
            case MultiEdge: {
                ImmutableList<CFAEdge> edges = ((MultiEdge)edge).getEdges();
                for (int i = edges.size() - 1; i >= 0; --i) {
                    this.collectVariables(state, (CFAEdge)edges.get(i), collectedVariables);
                }
                break;
            }
        }
        for (String var : this.dependingVariables) {
            this.fakeInterpolants.put((Object)state, (Object)ValueAnalysisState.MemoryLocation.valueOf(var));
        }
    }

    protected void handleAssumption(CFAEdge edge) {
        CAssumeEdge assumeEdge = (CAssumeEdge)edge;
        this.collectVariables(assumeEdge, assumeEdge.getExpression());
    }

    protected void collectVariables(CFAEdge edge, CRightHandSide rightHandSide) {
        rightHandSide.accept(new CollectVariablesVisitor(edge));
    }

    private class CollectVariablesVisitor
    extends DefaultCExpressionVisitor<Void, RuntimeException>
    implements CRightHandSideVisitor<Void, RuntimeException> {
        public CollectVariablesVisitor(CFAEdge currentEdge) {
        }

        private void collectVariables(String variableName) {
            AssumptionUseDefinitionCollector.this.dependingVariables.add(variableName);
        }

        @Override
        public Void visit(CIdExpression pE) {
            this.collectVariables(pE.getDeclaration().getQualifiedName());
            return null;
        }

        @Override
        public Void visit(CArraySubscriptExpression pE) {
            this.collectVariables(pE.toASTString());
            pE.getArrayExpression().accept(this);
            pE.getSubscriptExpression().accept(this);
            return null;
        }

        @Override
        public Void visit(CBinaryExpression pE) {
            pE.getOperand1().accept(this);
            pE.getOperand2().accept(this);
            return null;
        }

        @Override
        public Void visit(CCastExpression pE) {
            pE.getOperand().accept(this);
            return null;
        }

        @Override
        public Void visit(CFieldReference pE) {
            this.collectVariables(pE.toASTString());
            pE.getFieldOwner().accept(this);
            return null;
        }

        @Override
        public Void visit(CFunctionCallExpression pE) {
            for (CExpression param : pE.getParameterExpressions()) {
                param.accept(this);
            }
            return null;
        }

        @Override
        @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"}, justification="bug in FindBugs")
        public Void visit(CUnaryExpression pE) {
            CUnaryExpression.UnaryOperator op = pE.getOperator();
            switch (op) {
                case AMPER: {
                    this.collectVariables(pE.toASTString());
                }
            }
            pE.getOperand().accept(this);
            return null;
        }

        @Override
        protected Void visitDefault(CExpression pExp) {
            return null;
        }
    }
}

