/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.refiner.utils;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.Triple;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.io.Files;
import org.sosy_lab.common.io.Path;
import org.sosy_lab.common.io.Paths;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.MutableARGPath;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.InitialAssumptionUseDefinitionCollector;
import org.sosy_lab.cpachecker.util.LoopStructure;
import org.sosy_lab.cpachecker.util.VariableClassification;

public class ErrorPathClassifier {
    private static final int BOOLEAN_VAR = 2;
    private static final int INTEQUAL_VAR = 4;
    private static final int UNKNOWN_VAR = 16;
    private static final int MAX_PREFIX_LENGTH = 1000;
    private static final String PREFIX_REPLACEMENT = ErrorPathClassifier.class.getSimpleName() + " replaced this assume edge in prefix";
    private static final String SUFFIX_REPLACEMENT = ErrorPathClassifier.class.getSimpleName() + " replaced this assume edge in suffix";
    private static final String INBTWN_REPLACEMENT = ErrorPathClassifier.class.getSimpleName() + " replaced this assume edge inbetween";
    private static int invocationCounter = 0;
    private final Optional<VariableClassification> classification;
    private final Optional<LoopStructure> loopStructure;
    private static final Function<Triple<Long, Long, Integer>, Boolean> INDIFFERENT_SCOREKEEPER = new Function<Triple<Long, Long, Integer>, Boolean>(){

        public Boolean apply(Triple<Long, Long, Integer> prefixParameters) {
            return Boolean.TRUE;
        }
    };
    private static final Function<Triple<Long, Long, Integer>, Boolean> FIRST_HIGHEST_SCORE = new Function<Triple<Long, Long, Integer>, Boolean>(){

        public Boolean apply(Triple<Long, Long, Integer> prefixParameters) {
            return prefixParameters.getSecond() == null || (Long)prefixParameters.getFirst() > (Long)prefixParameters.getSecond();
        }
    };
    private static final Function<Triple<Long, Long, Integer>, Boolean> FINAL_HIGHEST_SCORE = new Function<Triple<Long, Long, Integer>, Boolean>(){

        public Boolean apply(Triple<Long, Long, Integer> prefixParameters) {
            return prefixParameters.getSecond() == null || (Long)prefixParameters.getFirst() >= (Long)prefixParameters.getSecond();
        }
    };
    private static final Function<Triple<Long, Long, Integer>, Boolean> FIRST_LOWEST_SCORE = new Function<Triple<Long, Long, Integer>, Boolean>(){

        public Boolean apply(Triple<Long, Long, Integer> prefixParameters) {
            return prefixParameters.getSecond() == null || (Long)prefixParameters.getFirst() < (Long)prefixParameters.getSecond();
        }
    };
    private static final Function<Triple<Long, Long, Integer>, Boolean> FINAL_LOWEST_SCORE = new Function<Triple<Long, Long, Integer>, Boolean>(){

        public Boolean apply(Triple<Long, Long, Integer> prefixParameters) {
            return prefixParameters.getSecond() == null || (Long)prefixParameters.getFirst() <= (Long)prefixParameters.getSecond();
        }
    };
    private static final Function<Triple<Long, Long, Integer>, Boolean> FINAL_LOWEST_SCORE_BOUNDED = new Function<Triple<Long, Long, Integer>, Boolean>(){

        public Boolean apply(Triple<Long, Long, Integer> prefixParameters) {
            if (prefixParameters.getSecond() == null) {
                return true;
            }
            if ((Integer)prefixParameters.getThird() < 1000) {
                return (Long)prefixParameters.getFirst() <= (Long)prefixParameters.getSecond();
            }
            return (Long)prefixParameters.getFirst() < (Long)prefixParameters.getSecond();
        }
    };

    public ErrorPathClassifier(Optional<VariableClassification> pClassification, Optional<LoopStructure> pLoopStructure) throws InvalidConfigurationException {
        this.classification = pClassification;
        this.loopStructure = pLoopStructure;
    }

    public ARGPath obtainPrefix(ErrorPathPrefixPreference preference, ARGPath errorPath, List<ARGPath> pPrefixes) {
        switch (preference) {
            case SHORTEST: {
                return this.obtainShortestPrefix(pPrefixes, errorPath);
            }
            case LONGEST: {
                return this.obtainLongestPrefix(pPrefixes, errorPath);
            }
            case DOMAIN_BEST_SHALLOW: 
            case DOMAIN_BEST_BOUNDED: 
            case DOMAIN_BEST_DEEP: 
            case DOMAIN_WORST_SHALLOW: 
            case DOMAIN_WORST_DEEP: {
                return this.obtainDomainTypeHeuristicBasedPrefix(pPrefixes, preference, errorPath);
            }
            case REFINE_SHALLOW: 
            case REFINE_DEEP: {
                return this.obtainRefinementRootHeuristicBasedPrefix(pPrefixes, preference, errorPath);
            }
            case RANDOM: {
                return this.obtainRandomPrefix(pPrefixes, errorPath);
            }
            case MEDIAN: {
                return this.obtainMedianPrefix(pPrefixes, errorPath);
            }
            case MIDDLE: {
                return this.obtainMiddlePrefix(pPrefixes, errorPath);
            }
        }
        return errorPath;
    }

    private ARGPath obtainShortestPrefix(List<ARGPath> pPrefixes, ARGPath originalErrorPath) {
        return this.buildPath(0, pPrefixes, originalErrorPath);
    }

    private ARGPath obtainLongestPrefix(List<ARGPath> pPrefixes, ARGPath originalErrorPath) {
        return this.buildPath(pPrefixes.size() - 1, pPrefixes, originalErrorPath);
    }

    private ARGPath obtainDomainTypeHeuristicBasedPrefix(List<ARGPath> pPrefixes, ErrorPathPrefixPreference preference, ARGPath originalErrorPath) {
        if (!this.classification.isPresent()) {
            return this.concatPrefixes(pPrefixes);
        }
        MutableARGPath currentErrorPath = new MutableARGPath();
        Long bestScore = null;
        int bestIndex = 0;
        for (ARGPath currentPrefix : pPrefixes) {
            assert (((CFAEdge)Iterables.getLast(currentPrefix.asEdgesList())).getEdgeType() == CFAEdgeType.AssumeEdge);
            currentErrorPath.addAll(ErrorPathClassifier.pathToList(currentPrefix));
            Set<String> useDefinitionInformation = this.obtainUseDefInformationOfErrorPath(currentErrorPath);
            Long score = this.obtainDomainTypeScoreForVariables(useDefinitionInformation);
            if (!((Boolean)preference.scorer.apply((Object)Triple.of((Object)score, bestScore, (Object)currentErrorPath.size()))).booleanValue()) continue;
            bestScore = score;
            bestIndex = pPrefixes.indexOf(currentPrefix);
        }
        return this.buildPath(bestIndex, pPrefixes, originalErrorPath);
    }

    private ARGPath obtainRefinementRootHeuristicBasedPrefix(List<ARGPath> pPrefixes, ErrorPathPrefixPreference preference, ARGPath originalErrorPath) {
        if (!this.classification.isPresent()) {
            return this.concatPrefixes(pPrefixes);
        }
        MutableARGPath currentErrorPath = new MutableARGPath();
        Long bestScore = null;
        int bestIndex = 0;
        for (ARGPath currentPrefix : pPrefixes) {
            assert (((CFAEdge)Iterables.getLast(currentPrefix.asEdgesList())).getEdgeType() == CFAEdgeType.AssumeEdge);
            currentErrorPath.addAll(ErrorPathClassifier.pathToList(currentPrefix));
            InitialAssumptionUseDefinitionCollector collector = new InitialAssumptionUseDefinitionCollector();
            collector.obtainUseDefInformation(currentErrorPath);
            Long score = collector.getDependenciesResolvedOffset() * -1;
            if (!((Boolean)preference.scorer.apply((Object)Triple.of((Object)score, bestScore, (Object)currentErrorPath.size()))).booleanValue()) continue;
            bestScore = score;
            bestIndex = pPrefixes.indexOf(currentPrefix);
        }
        return this.buildPath(bestIndex, pPrefixes, originalErrorPath);
    }

    private ARGPath obtainRandomPrefix(List<ARGPath> pPrefixes, ARGPath originalErrorPath) {
        return this.buildPath(new Random().nextInt(pPrefixes.size()), pPrefixes, originalErrorPath);
    }

    private ARGPath obtainMedianPrefix(List<ARGPath> pPrefixes, ARGPath originalErrorPath) {
        return this.buildPath(pPrefixes.size() / 2, pPrefixes, originalErrorPath);
    }

    private ARGPath obtainMiddlePrefix(List<ARGPath> pPrefixes, ARGPath originalErrorPath) {
        int totalLength = 0;
        for (ARGPath p : pPrefixes) {
            totalLength += p.size();
        }
        int length = 0;
        int index = 0;
        for (ARGPath p : pPrefixes) {
            if ((length += p.size()) > totalLength / 2) break;
            ++index;
        }
        return this.buildPath(index, pPrefixes, originalErrorPath);
    }

    private Set<String> obtainUseDefInformationOfErrorPath(MutableARGPath currentErrorPath) {
        return new InitialAssumptionUseDefinitionCollector().obtainUseDefInformation(currentErrorPath);
    }

    public Long obtainDomainTypeScoreForVariables(Set<String> useDefinitionInformation) {
        Long currentScore;
        if (useDefinitionInformation.isEmpty()) {
            return 16L;
        }
        Long previousScore = currentScore = Long.valueOf(1L);
        for (String variableName : useDefinitionInformation) {
            int factor = 16;
            if (((VariableClassification)this.classification.get()).getIntBoolVars().contains(variableName)) {
                factor = 2;
            } else if (((VariableClassification)this.classification.get()).getIntEqualVars().contains(variableName)) {
                factor = 4;
            }
            currentScore = currentScore * (long)factor;
            if (this.loopStructure.isPresent() && ((LoopStructure)this.loopStructure.get()).getLoopIncDecVariables().contains(variableName)) {
                return Long.MAX_VALUE;
            }
            if (currentScore < previousScore) {
                return 0x7FFFFFFFFFFFFFFEL;
            }
            previousScore = currentScore;
        }
        return currentScore;
    }

    private ARGPath buildPath(int bestIndex, List<ARGPath> pPrefixes, ARGPath originalErrorPath) {
        MutableARGPath errorPath = new MutableARGPath();
        for (int j = 0; j <= bestIndex; ++j) {
            List<Pair<ARGState, CFAEdge>> list = ErrorPathClassifier.pathToList(pPrefixes.get(j));
            errorPath.addAll(list);
            if (j == bestIndex) continue;
            this.replaceAssumeEdgeWithBlankEdge(errorPath);
        }
        for (Pair element : Iterables.skip(ErrorPathClassifier.pathToList(originalErrorPath), (int)errorPath.size())) {
            if (((CFAEdge)element.getSecond()).getEdgeType() == CFAEdgeType.AssumeEdge && element.getFirst() != originalErrorPath.getLastState()) {
                errorPath.add(Pair.of((Object)element.getFirst(), (Object)new BlankEdge("", FileLocation.DUMMY, ((CFAEdge)element.getSecond()).getPredecessor(), ((CFAEdge)element.getSecond()).getSuccessor(), SUFFIX_REPLACEMENT)));
                continue;
            }
            errorPath.add(element);
        }
        return errorPath.immutableCopy();
    }

    private List<Pair<ARGState, CFAEdge>> replaceAssumeEdgesWithBlankEdges(List<Pair<ARGState, CFAEdge>> pList) {
        ArrayDeque<Object> newList = new ArrayDeque<Object>();
        for (int i = 0; i < pList.size(); ++i) {
            Pair<ARGState, CFAEdge> elem = pList.get(i);
            if (i < pList.size() - 1 && ((CFAEdge)elem.getSecond()).getEdgeType() == CFAEdgeType.AssumeEdge) {
                newList.addLast(Pair.of((Object)elem.getFirst(), (Object)new BlankEdge("", FileLocation.DUMMY, ((CFAEdge)elem.getSecond()).getPredecessor(), ((CFAEdge)elem.getSecond()).getSuccessor(), INBTWN_REPLACEMENT)));
                continue;
            }
            newList.addLast(elem);
        }
        return new ArrayList<Pair<ARGState, CFAEdge>>(newList);
    }

    private static List<Pair<ARGState, CFAEdge>> pathToList(ARGPath path) {
        return Pair.zipList(path.asStatesList(), path.asEdgesList());
    }

    private void replaceAssumeEdgeWithBlankEdge(MutableARGPath pErrorPath) {
        Pair assumeState = (Pair)pErrorPath.removeLast();
        assert (((CFAEdge)assumeState.getSecond()).getEdgeType() == CFAEdgeType.AssumeEdge);
        pErrorPath.add(Pair.of((Object)assumeState.getFirst(), (Object)new BlankEdge("", FileLocation.DUMMY, ((CFAEdge)assumeState.getSecond()).getPredecessor(), ((CFAEdge)assumeState.getSecond()).getSuccessor(), PREFIX_REPLACEMENT)));
    }

    private ARGPath concatPrefixes(List<ARGPath> pPrefixes) {
        MutableARGPath errorPath = new MutableARGPath();
        for (ARGPath currentPrefix : pPrefixes) {
            errorPath.addAll(ErrorPathClassifier.pathToList(currentPrefix));
        }
        return errorPath.immutableCopy();
    }

    private void exportToDot(MutableARGPath errorPath, List<MutableARGPath> pPrefixes) {
        SetMultimap<ARGState, ARGState> successorRelation = this.buildSuccessorRelation((ARGState)((Pair)errorPath.getLast()).getFirst());
        HashSet<Object> failingStates = new HashSet<Object>();
        for (MutableARGPath path : pPrefixes) {
            failingStates.add(((Pair)path.getLast()).getFirst());
        }
        int assertFailCnt = failingStates.size();
        StringBuilder result = new StringBuilder().append("digraph tree {\n");
        for (Map.Entry current : successorRelation.entries()) {
            result.append(((ARGState)current.getKey()).getStateId() + " [label=\"" + ((ARGState)current.getKey()).getStateId() + "\"]" + "\n");
            result.append(((ARGState)current.getKey()).getStateId() + " -> " + ((ARGState)current.getValue()).getStateId() + "\n");
            CFAEdge edge = ((ARGState)current.getKey()).getEdgeToChild((ARGState)current.getValue());
            if (failingStates.contains(current.getValue())) {
                result.append(((ARGState)current.getKey()).getStateId() + " [shape=diamond, style=filled, fillcolor=\"red\"]" + "\n");
                result.append(((ARGState)current.getKey()).getStateId() + " -> stop" + assertFailCnt + "\n");
                result.append("stop" + assertFailCnt + " [shape=point]\n");
                --assertFailCnt;
            } else if (edge.getEdgeType() == CFAEdgeType.AssumeEdge) {
                result.append(((ARGState)current.getKey()).getStateId() + " [shape=diamond]" + "\n");
            }
            assert (!((ARGState)current.getKey()).isTarget());
        }
        result.append("}");
        try {
            Files.writeFile((Path)Paths.get((String)("output/itpPaths" + invocationCounter++ + ".dot"), (String[])new String[0]), (Object)result.toString());
        }
        catch (IOException e) {
            throw new IllegalArgumentException();
        }
    }

    private SetMultimap<ARGState, ARGState> buildSuccessorRelation(ARGState target) {
        ArrayDeque<ARGState> todo = new ArrayDeque<ARGState>();
        todo.add(target);
        ARGState itpTreeRoot = null;
        LinkedHashMultimap successorRelation = LinkedHashMultimap.create();
        while (!todo.isEmpty()) {
            ARGState currentState = (ARGState)todo.removeFirst();
            if (currentState.getParents().iterator().hasNext()) {
                ARGState parentState = currentState.getParents().iterator().next();
                todo.add(parentState);
                successorRelation.put((Object)parentState, (Object)currentState);
                continue;
            }
            if (itpTreeRoot != null) continue;
            itpTreeRoot = currentState;
        }
        return successorRelation;
    }

    public long obtainScoreForPrefixes(List<ARGPath> pPrefixes, ErrorPathPrefixPreference preference) {
        if (!this.classification.isPresent()) {
            return Long.MAX_VALUE;
        }
        MutableARGPath currentErrorPath = new MutableARGPath();
        Long bestScore = Long.MAX_VALUE;
        for (ARGPath currentPrefix : pPrefixes) {
            currentErrorPath.addAll(ErrorPathClassifier.pathToList(currentPrefix));
            Set<String> useDefinitionInformation = this.obtainUseDefInformationOfErrorPath(currentErrorPath);
            Long score = this.obtainDomainTypeScoreForVariables(useDefinitionInformation);
            if (!((Boolean)preference.scorer.apply((Object)Triple.of((Object)score, (Object)bestScore, (Object)currentErrorPath.size()))).booleanValue()) continue;
            bestScore = score;
        }
        return bestScore;
    }

    static /* synthetic */ Function access$000() {
        return FIRST_LOWEST_SCORE;
    }

    static /* synthetic */ Function access$100() {
        return FINAL_LOWEST_SCORE_BOUNDED;
    }

    static /* synthetic */ Function access$200() {
        return FINAL_LOWEST_SCORE;
    }

    static /* synthetic */ Function access$300() {
        return FIRST_HIGHEST_SCORE;
    }

    static /* synthetic */ Function access$400() {
        return FINAL_HIGHEST_SCORE;
    }

    static /* synthetic */ Function access$500() {
        return INDIFFERENT_SCOREKEEPER;
    }

    public static enum ErrorPathPrefixPreference {
        DEFAULT,
        SHORTEST,
        LONGEST,
        DOMAIN_BEST_SHALLOW((Function<Triple<Long, Long, Integer>, Boolean>)ErrorPathClassifier.access$000()),
        DOMAIN_BEST_BOUNDED((Function<Triple<Long, Long, Integer>, Boolean>)ErrorPathClassifier.access$100()),
        DOMAIN_BEST_DEEP((Function<Triple<Long, Long, Integer>, Boolean>)ErrorPathClassifier.access$200()),
        REFINE_SHALLOW((Function<Triple<Long, Long, Integer>, Boolean>)ErrorPathClassifier.access$300()),
        REFINE_DEEP((Function<Triple<Long, Long, Integer>, Boolean>)ErrorPathClassifier.access$200()),
        RANDOM,
        MEDIAN,
        MIDDLE,
        DOMAIN_WORST_SHALLOW((Function<Triple<Long, Long, Integer>, Boolean>)ErrorPathClassifier.access$300()),
        DOMAIN_WORST_DEEP((Function<Triple<Long, Long, Integer>, Boolean>)ErrorPathClassifier.access$400());

        private Function<Triple<Long, Long, Integer>, Boolean> scorer = ErrorPathClassifier.access$500();

        private ErrorPathPrefixPreference() {
        }

        private ErrorPathPrefixPreference(Function<Triple<Long, Long, Integer>, Boolean> scorer) {
            this.scorer = scorer;
        }
    }
}

