/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.refiner.utils;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Set;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.core.ShutdownNotifier;
import org.sosy_lab.cpachecker.core.defaults.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPA;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisTransferRelation;
import org.sosy_lab.cpachecker.cpa.value.refiner.ValueAnalysisInterpolant;
import org.sosy_lab.cpachecker.cpa.value.refiner.utils.ValueAnalysisFeasibilityChecker;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class ValueAnalysisEdgeInterpolator {
    private final ShutdownNotifier shutdownNotifier;
    private final ValueAnalysisTransferRelation transfer;
    private final VariableTrackingPrecision precision;
    private int numberOfInterpolationQueries = 0;
    private final ValueAnalysisFeasibilityChecker checker;
    private static final ValueAnalysisState NO_SUCCESSOR = null;

    public ValueAnalysisEdgeInterpolator(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCfa) throws InvalidConfigurationException {
        try {
            this.shutdownNotifier = pShutdownNotifier;
            this.checker = new ValueAnalysisFeasibilityChecker(pLogger, pCfa, pConfig);
            this.transfer = new ValueAnalysisTransferRelation(Configuration.builder().build(), pLogger, pCfa);
            this.precision = VariableTrackingPrecision.createStaticPrecision(pConfig, pCfa.getVarClassification(), ValueAnalysisCPA.class);
        }
        catch (InvalidConfigurationException e) {
            throw new InvalidConfigurationException("Invalid configuration for checking path: " + e.getMessage(), (Throwable)e);
        }
    }

    public ValueAnalysisInterpolant deriveInterpolant(ARGPath pErrorPath, CFAEdge pCurrentEdge, int pOffset, ValueAnalysisInterpolant pInputInterpolant, Set<ValueAnalysisState.MemoryLocation> useDefRelation) throws CPAException, InterruptedException {
        this.numberOfInterpolationQueries = 0;
        ValueAnalysisState initialState = pInputInterpolant.createValueAnalysisState();
        ValueAnalysisState initialSuccessor = this.getInitialSuccessor(initialState, pCurrentEdge);
        if (initialSuccessor == NO_SUCCESSOR) {
            return ValueAnalysisInterpolant.FALSE;
        }
        if (initialState.equals(initialSuccessor)) {
            return pInputInterpolant;
        }
        if (this.isOnlyVariableRenamingEdge(pCurrentEdge)) {
            return initialSuccessor.createInterpolant();
        }
        if (!useDefRelation.isEmpty()) {
            initialSuccessor.retainAll(useDefRelation);
        }
        ARGPath remainingErrorPath = pErrorPath.obtainSuffix(pOffset + 1);
        if (initialSuccessor.getSize() > 1 && this.isSuffixContradicting(remainingErrorPath)) {
            return ValueAnalysisInterpolant.TRUE;
        }
        for (ValueAnalysisState.MemoryLocation currentMemoryLocation : initialSuccessor.getTrackedMemoryLocations()) {
            this.shutdownNotifier.shutdownIfNecessary();
            Pair<Value, Type> value = initialSuccessor.forget(currentMemoryLocation);
            if (!this.isRemainingPathFeasible(remainingErrorPath, initialSuccessor)) continue;
            initialSuccessor.assignConstant(currentMemoryLocation, (Value)value.getFirst(), (Type)value.getSecond());
        }
        return initialSuccessor.createInterpolant();
    }

    private boolean isSuffixContradicting(ARGPath errorPath) throws CPAException, InterruptedException {
        return !this.isRemainingPathFeasible(errorPath, new ValueAnalysisState());
    }

    public int getNumberOfInterpolationQueries() {
        return this.numberOfInterpolationQueries;
    }

    private ValueAnalysisState getInitialSuccessor(ValueAnalysisState initialState, CFAEdge initialEdge) throws CPATransferException {
        Collection successors = this.transfer.getAbstractSuccessorsForEdge(initialState, this.precision, initialEdge);
        return (ValueAnalysisState)Iterables.getOnlyElement(successors, (Object)NO_SUCCESSOR);
    }

    private boolean isRemainingPathFeasible(ARGPath remainingErrorPath, ValueAnalysisState state) throws CPAException, InterruptedException {
        ++this.numberOfInterpolationQueries;
        return this.checker.isFeasible(remainingErrorPath, state);
    }

    private boolean isOnlyVariableRenamingEdge(CFAEdge cfaEdge) {
        return cfaEdge.getEdgeType() == CFAEdgeType.FunctionReturnEdge;
    }
}

