/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.value.refiner.utils;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.Pair;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.defaults.VariableTrackingPrecision;
import org.sosy_lab.cpachecker.cpa.arg.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.MutableARGPath;
import org.sosy_lab.cpachecker.cpa.conditions.path.AssignmentsInPathCondition;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisCPA;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisState;
import org.sosy_lab.cpachecker.cpa.value.ValueAnalysisTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.PrefixProvider;

public class ValueAnalysisFeasibilityChecker
implements PrefixProvider {
    private final LogManager logger;
    private final ValueAnalysisTransferRelation transfer;
    private final VariableTrackingPrecision precision;

    public ValueAnalysisFeasibilityChecker(LogManager pLogger, CFA pCfa, Configuration config) throws InvalidConfigurationException {
        this.logger = pLogger;
        this.transfer = new ValueAnalysisTransferRelation(Configuration.builder().build(), pLogger, pCfa);
        this.precision = VariableTrackingPrecision.createStaticPrecision(config, pCfa.getVarClassification(), ValueAnalysisCPA.class);
    }

    public boolean isFeasible(ARGPath path) throws CPAException, InterruptedException {
        return this.isFeasible(path, new ValueAnalysisState());
    }

    public boolean isFeasible(ARGPath path, ValueAnalysisState pInitial) throws CPAException, InterruptedException {
        return path.size() == this.getInfeasilbePrefixes(path, pInitial).get(0).size();
    }

    @Override
    public List<ARGPath> getInfeasilbePrefixes(ARGPath path) throws CPAException, InterruptedException {
        return this.getInfeasilbePrefixes(path, new ValueAnalysisState());
    }

    public List<ARGPath> getInfeasilbePrefixes(ARGPath path, ValueAnalysisState pInitial) throws CPAException, InterruptedException {
        ArrayList<ARGPath> prefixes = new ArrayList<ARGPath>();
        boolean performAbstraction = this.precision.allowsAbstraction();
        Set<ValueAnalysisState.MemoryLocation> exceedingMemoryLocations = this.obtainExceedingMemoryLocations(path);
        try {
            MutableARGPath currentPrefix = new MutableARGPath();
            ValueAnalysisState next = ValueAnalysisState.copyOf(pInitial);
            ARGPath.PathIterator iterator = path.pathIterator();
            while (iterator.hasNext()) {
                HashSet successors = this.transfer.getAbstractSuccessorsForEdge(next, this.precision, iterator.getOutgoingEdge());
                currentPrefix.addLast(Pair.of((Object)iterator.getAbstractState(), (Object)iterator.getOutgoingEdge()));
                if (successors.isEmpty()) {
                    this.logger.log(Level.FINE, new Object[]{"found infeasible prefix: ", iterator.getOutgoingEdge(), " did not yield a successor"});
                    prefixes.add(currentPrefix.immutableCopy());
                    currentPrefix = new MutableARGPath();
                    successors = Sets.newHashSet((Object[])new ValueAnalysisState[]{next});
                }
                next = (ValueAnalysisState)Iterables.getOnlyElement(successors);
                if (performAbstraction) {
                    for (ValueAnalysisState.MemoryLocation memoryLocation : next.getTrackedMemoryLocations()) {
                        if (this.precision.isTracking(memoryLocation, next.getTypeForMemoryLocation(memoryLocation), iterator.getOutgoingEdge().getSuccessor())) continue;
                        next.forget(memoryLocation);
                    }
                }
                for (ValueAnalysisState.MemoryLocation exceedingMemoryLocation : exceedingMemoryLocations) {
                    next.forget(exceedingMemoryLocation);
                }
                iterator.advance();
            }
            if (prefixes.isEmpty()) {
                this.logger.log(Level.FINE, new Object[]{"no infeasible prefixes found - path is feasible"});
                prefixes.add(path);
            }
            return prefixes;
        }
        catch (CPATransferException e) {
            throw new CPAException("Computation of successor failed for checking path: " + e.getMessage(), e);
        }
    }

    private Set<ValueAnalysisState.MemoryLocation> obtainExceedingMemoryLocations(ARGPath path) {
        AssignmentsInPathCondition.UniqueAssignmentsInPathConditionState assignments = AbstractStates.extractStateByType(path.getLastState(), AssignmentsInPathCondition.UniqueAssignmentsInPathConditionState.class);
        if (assignments == null) {
            return Collections.emptySet();
        }
        return assignments.getMemoryLocationsExceedingHardThreshold();
    }

    public List<Pair<ValueAnalysisState, CFAEdge>> evaluate(ARGPath path) throws CPAException, InterruptedException {
        try {
            ArrayList<Pair<ValueAnalysisState, CFAEdge>> reevaluatedPath = new ArrayList<Pair<ValueAnalysisState, CFAEdge>>();
            ValueAnalysisState next = new ValueAnalysisState();
            ARGPath.PathIterator iterator = path.pathIterator();
            while (iterator.hasNext()) {
                Collection successors = this.transfer.getAbstractSuccessorsForEdge(next, this.precision, iterator.getOutgoingEdge());
                if (successors.isEmpty()) {
                    return reevaluatedPath;
                }
                next = (ValueAnalysisState)Iterables.getOnlyElement(successors);
                reevaluatedPath.add((Pair<ValueAnalysisState, CFAEdge>)Pair.of((Object)next, (Object)iterator.getOutgoingEdge()));
                iterator.advance();
            }
            return reevaluatedPath;
        }
        catch (CPATransferException e) {
            throw new CPAException("Computation of successor failed for checking path: " + e.getMessage(), e);
        }
    }
}

